/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.fonts;

import com.jaspersoft.ireport.designer.fonts.CheckBoxList;
import com.jaspersoft.ireport.designer.fonts.CheckBoxListEntry;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontPathDialog
extends JDialog {
    private int dialogResult = 2;
    private boolean modifiedPath = false;
    private JButton jButtonCancel;
    private JButton jButtonDeselectAll;
    private JButton jButtonSave;
    private JButton jButtonSelectAll;
    private JLabel jLabelClasspath;
    private CheckBoxList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    public FontPathDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public FontPathDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.applyI18n();
        this.jList1.setModel(new DefaultListModel());
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FontPathDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                FontPathDialog.this.modifiedPath = true;
            }
        });
        this.getRootPane().setDefaultButton(this.jButtonSave);
    }

    private void initComponents() {
        this.jLabelClasspath = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new CheckBoxList();
        this.jPanel1 = new JPanel();
        this.jButtonSelectAll = new JButton();
        this.jButtonDeselectAll = new JButton();
        this.jPanel2 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle(I18n.getString("FontPathDialog.Title.fontPaths"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                FontPathDialog.this.formWindowClosed(evt);
            }

            public void windowClosing(WindowEvent evt) {
                FontPathDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabelClasspath.setHorizontalAlignment(2);
        this.jLabelClasspath.setText(I18n.getString("FontPathDialog.Label.FontsPath"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabelClasspath, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(359, 260));
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(120, 10));
        this.jPanel1.setPreferredSize(new Dimension(120, 10));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButtonSelectAll.setText(I18n.getString("Global.Button.SelectAll"));
        this.jButtonSelectAll.setMaximumSize(new Dimension(200, 26));
        this.jButtonSelectAll.setMinimumSize(new Dimension(90, 26));
        this.jButtonSelectAll.setPreferredSize(new Dimension(120, 26));
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontPathDialog.this.jButtonSelectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonSelectAll, gridBagConstraints);
        this.jButtonDeselectAll.setText(I18n.getString("Global.Button.DeselectAll"));
        this.jButtonDeselectAll.setMaximumSize(new Dimension(200, 26));
        this.jButtonDeselectAll.setMinimumSize(new Dimension(90, 26));
        this.jButtonDeselectAll.setPreferredSize(new Dimension(120, 26));
        this.jButtonDeselectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontPathDialog.this.jButtonDeselectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonDeselectAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jButtonSave.setText(I18n.getString("FontPathDialog.Button.SaveFontsPath"));
        this.jButtonSave.setMaximumSize(new Dimension(200, 26));
        this.jButtonSave.setMinimumSize(new Dimension(90, 26));
        this.jButtonSave.setPreferredSize(new Dimension(120, 26));
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontPathDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonCancel.setText(I18n.getString("Global.Button.Cancel"));
        this.jButtonCancel.setMaximumSize(new Dimension(200, 26));
        this.jButtonCancel.setMinimumSize(new Dimension(90, 26));
        this.jButtonCancel.setPreferredSize(new Dimension(120, 26));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontPathDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jButtonDeselectAllActionPerformed(ActionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        for (int i = 0; i < dlm.size(); ++i) {
            Object obj = dlm.getElementAt(i);
            if (!(obj instanceof JCheckBox)) continue;
            JCheckBox checkbox = (JCheckBox)obj;
            checkbox.setSelected(false);
        }
        this.jList1.updateUI();
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        for (int i = 0; i < dlm.size(); ++i) {
            Object obj = dlm.getElementAt(i);
            if (!(obj instanceof JCheckBox)) continue;
            JCheckBox checkbox = (JCheckBox)obj;
            checkbox.setSelected(true);
        }
        this.jList1.updateUI();
    }

    private void formWindowClosed(WindowEvent evt) {
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.modifiedPath) {
            int ret = JOptionPane.showConfirmDialog(this, I18n.getString("FontPathDialog.Message.Confirm"));
            if (ret == 2) {
                return;
            }
            this.jButtonSaveActionPerformed(null);
        } else {
            this.setVisible(false);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.setDialogResult(0);
        this.setVisible(false);
    }

    public void setFontspath(List<String> fontsPaths, List<String> cp) {
        ArrayList<String> newcp = new ArrayList<String>();
        newcp.addAll(cp);
        ArrayList cp_old = new ArrayList();
        for (String s : fontsPaths) {
            if (newcp.contains(s)) continue;
            newcp.add(s);
        }
        Object[] allStrings = new Object[newcp.size()];
        allStrings = newcp.toArray(allStrings);
        Arrays.sort(allStrings);
        for (int i = 0; i < allStrings.length; ++i) {
            String s = "" + allStrings[i];
            if (s.trim().length() == 0) continue;
            CheckBoxListEntry cble = new CheckBoxListEntry((Object)s, fontsPaths.contains(s));
            if (!cp.contains(s) && !cp_old.contains(s)) {
                cble.setRed(true);
            }
            ((DefaultListModel)this.jList1.getModel()).addElement(cble);
        }
    }

    public List<String> getFontspath() {
        ArrayList<String> cp = new ArrayList<String>();
        List list = this.jList1.getCheckedItems();
        for (int i = 0; i < list.size(); ++i) {
            CheckBoxListEntry cble = (CheckBoxListEntry)list.get(i);
            cp.add(cble.getValue() + "");
        }
        return cp;
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
    }
}

