/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.options.export;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.options.export.AbstractExportParametersPanel;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jasperreports.engine.util.JRProperties;
import org.jdesktop.layout.GroupLayout;

public class XlsExportParametersPanel
extends AbstractExportParametersPanel {
    private JCheckBox jCheckBoxAutoDetectCellType;
    private JCheckBox jCheckBoxCollapseRowSpan;
    private JCheckBox jCheckBoxCreateCustomPalette;
    private JCheckBox jCheckBoxFontSizeFixEnabled;
    private JCheckBox jCheckBoxIgnoreCellBackground;
    private JCheckBox jCheckBoxIgnoreCellBorder;
    private JCheckBox jCheckBoxIgnoreGraphics;
    private JCheckBox jCheckBoxImageBorderFixEnabled;
    private JCheckBox jCheckBoxOnePagePerSheet;
    private JCheckBox jCheckBoxRemoveEmptySpaceBetweenColumns;
    private JCheckBox jCheckBoxRemoveEmptySpaceBetweenRows;
    private JCheckBox jCheckBoxUseSheetNames;
    private JCheckBox jCheckBoxWhitePageBackground;
    private JLabel jLabelList;
    private JLabel jLabelMaximumRowsPerSheet;
    private JLabel jLabelPassword;
    private JLabel jLabelTitle;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerMaximumRowsPerSheet;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextArea1;
    private JTextField jTextFieldPassword;

    public XlsExportParametersPanel() {
        this.initComponents();
        SpinnerNumberModel snm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        this.jSpinnerMaximumRowsPerSheet.setModel(snm);
        snm.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                XlsExportParametersPanel.this.notifyChange();
            }
        });
        this.applyI18n();
    }

    public void applyI18n() {
        this.jLabelTitle.setText(I18n.getString("XlsExportParametersPanel.jLabelTitle.text"));
        this.jCheckBoxOnePagePerSheet.setText(I18n.getString("XlsExportParametersPanel.jCheckBoxOnePagePerSheet.text"));
        this.jCheckBoxRemoveEmptySpaceBetweenRows.setText(I18n.getString("XlsExportParametersPanel.jCheckBoxRemoveEmptySpaceBetweenRows.text"));
        this.jCheckBoxRemoveEmptySpaceBetweenColumns.setText(I18n.getString("XlsExportParametersPanel.jCheckBoxRemoveEmptySpaceBetweenColumns.text"));
        this.jCheckBoxWhitePageBackground.setText(I18n.getString("XlsExportParametersPanel.jCheckBoxWhitePageBackground.text"));
        this.jCheckBoxAutoDetectCellType.setText(I18n.getString("XlsExportParametersPanel.jCheckBoxAutoDetectCellType.text"));
        this.jCheckBoxFontSizeFixEnabled.setText(I18n.getString("XlsExportParametersPanel.jCheckBoxFontSizeFixEnabled.text"));
        this.jCheckBoxImageBorderFixEnabled.setText(I18n.getString("XlsExportParametersPanel.jCheckBoxImageBorderFixEnabled.text"));
        this.jLabelMaximumRowsPerSheet.setText(I18n.getString("XlsExportParametersPanel.jLabelMaximumRowsPerSheet.text"));
        this.jCheckBoxIgnoreGraphics.setText(I18n.getString("XlsExportParametersPanel.jCheckBoxIgnoreGraphics.text"));
        this.jCheckBoxCollapseRowSpan.setText(I18n.getString("XlsExportParametersPanel.jCheckBoxCollapseRowSpan.text"));
        this.jCheckBoxIgnoreCellBorder.setText(I18n.getString("XlsExportParametersPanel.jCheckBoxIgnoreCellBorder.text"));
        this.jTabbedPane1.setTitleAt(0, I18n.getString("XlsExportParametersPanel.jPanel1.TabConstraints.tabTitle"));
        this.jCheckBoxUseSheetNames.setText(I18n.getString("XlsExportParametersPanel.jCheckBoxUseSheetNames.text"));
        this.jLabelList.setText(I18n.getString("XlsExportParametersPanel.jLabelList.text"));
        this.jTabbedPane1.setTitleAt(1, I18n.getString("XlsExportParametersPanel.jPanel2.TabConstraints.tabTitle"));
        this.jCheckBoxCreateCustomPalette.setText(I18n.getString("XlsExportParametersPanel.jCheckBoxCreateCustomPalette.text"));
        this.jLabelPassword.setText(I18n.getString("XlsExportParametersPanel.jLabelPassword.text"));
        this.jTabbedPane1.setTitleAt(2, I18n.getString("XlsExportParametersPanel.jPanel3.TabConstraints.tabTitle"));
        this.jCheckBoxIgnoreCellBackground.setText(I18n.getString("XlsExportParametersPanel.jCheckBoxIgnoreCellBackground.text"));
    }

    private void initComponents() {
        this.jLabelTitle = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jCheckBoxOnePagePerSheet = new JCheckBox();
        this.jCheckBoxRemoveEmptySpaceBetweenRows = new JCheckBox();
        this.jCheckBoxRemoveEmptySpaceBetweenColumns = new JCheckBox();
        this.jCheckBoxWhitePageBackground = new JCheckBox();
        this.jCheckBoxAutoDetectCellType = new JCheckBox();
        this.jCheckBoxFontSizeFixEnabled = new JCheckBox();
        this.jCheckBoxImageBorderFixEnabled = new JCheckBox();
        this.jLabelMaximumRowsPerSheet = new JLabel();
        this.jSpinnerMaximumRowsPerSheet = new JSpinner();
        this.jCheckBoxIgnoreGraphics = new JCheckBox();
        this.jCheckBoxCollapseRowSpan = new JCheckBox();
        this.jCheckBoxIgnoreCellBorder = new JCheckBox();
        this.jCheckBoxIgnoreCellBackground = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jCheckBoxUseSheetNames = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabelList = new JLabel();
        this.jPanel3 = new JPanel();
        this.jCheckBoxCreateCustomPalette = new JCheckBox();
        this.jLabelPassword = new JLabel();
        this.jTextFieldPassword = new JTextField();
        this.jLabelTitle.setFont(new Font("Tahoma", 1, 12));
        this.jLabelTitle.setText("CSV Export parameters");
        this.jCheckBoxOnePagePerSheet.setText("One Page per Sheet");
        this.jCheckBoxOnePagePerSheet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsExportParametersPanel.this.jCheckBoxOnePagePerSheetActionPerformed(evt);
            }
        });
        this.jCheckBoxRemoveEmptySpaceBetweenRows.setText("Remove Empty Space Between Rows");
        this.jCheckBoxRemoveEmptySpaceBetweenRows.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsExportParametersPanel.this.jCheckBoxRemoveEmptySpaceBetweenRowsActionPerformed(evt);
            }
        });
        this.jCheckBoxRemoveEmptySpaceBetweenColumns.setText("Remove Empty Space Between Columns");
        this.jCheckBoxRemoveEmptySpaceBetweenColumns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsExportParametersPanel.this.jCheckBoxRemoveEmptySpaceBetweenColumnsActionPerformed(evt);
            }
        });
        this.jCheckBoxWhitePageBackground.setText("White Page Background");
        this.jCheckBoxWhitePageBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsExportParametersPanel.this.jCheckBoxWhitePageBackgroundActionPerformed(evt);
            }
        });
        this.jCheckBoxAutoDetectCellType.setText("Auto Detect Cell Type");
        this.jCheckBoxAutoDetectCellType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsExportParametersPanel.this.jCheckBoxAutoDetectCellTypeActionPerformed(evt);
            }
        });
        this.jCheckBoxFontSizeFixEnabled.setText("Font Size Fix Enabled");
        this.jCheckBoxFontSizeFixEnabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsExportParametersPanel.this.jCheckBoxFontSizeFixEnabledActionPerformed(evt);
            }
        });
        this.jCheckBoxImageBorderFixEnabled.setText("Image Border Fix Enabled");
        this.jCheckBoxImageBorderFixEnabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsExportParametersPanel.this.jCheckBoxImageBorderFixEnabledActionPerformed(evt);
            }
        });
        this.jLabelMaximumRowsPerSheet.setText("Maximum Rows Per Sheet (0 means no maximum)");
        this.jCheckBoxIgnoreGraphics.setText("Ignore Graphics");
        this.jCheckBoxIgnoreGraphics.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsExportParametersPanel.this.jCheckBoxIgnoreGraphicsActionPerformed(evt);
            }
        });
        this.jCheckBoxCollapseRowSpan.setText("Collapse Row Span");
        this.jCheckBoxCollapseRowSpan.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsExportParametersPanel.this.jCheckBoxCollapseRowSpanActionPerformed(evt);
            }
        });
        this.jCheckBoxIgnoreCellBorder.setText("Ignore Cell Border");
        this.jCheckBoxIgnoreCellBorder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsExportParametersPanel.this.jCheckBoxIgnoreCellBorderActionPerformed(evt);
            }
        });
        this.jCheckBoxIgnoreCellBackground.setText("Ignore Cell Background");
        this.jCheckBoxIgnoreCellBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsExportParametersPanel.this.jCheckBoxIgnoreCellBackgroundActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jCheckBoxIgnoreCellBackground).add((Component)this.jCheckBoxOnePagePerSheet).add((Component)this.jCheckBoxRemoveEmptySpaceBetweenRows).add((Component)this.jCheckBoxRemoveEmptySpaceBetweenColumns).add((Component)this.jCheckBoxWhitePageBackground).add((Component)this.jCheckBoxAutoDetectCellType).add((Component)this.jCheckBoxFontSizeFixEnabled).add((Component)this.jCheckBoxImageBorderFixEnabled).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabelMaximumRowsPerSheet).addPreferredGap(0).add((Component)this.jSpinnerMaximumRowsPerSheet, -2, 67, -2)).add((Component)this.jCheckBoxIgnoreGraphics).add((Component)this.jCheckBoxCollapseRowSpan).add((Component)this.jCheckBoxIgnoreCellBorder)).addContainerGap(96, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jCheckBoxOnePagePerSheet).addPreferredGap(0).add((Component)this.jCheckBoxRemoveEmptySpaceBetweenRows).addPreferredGap(0).add((Component)this.jCheckBoxRemoveEmptySpaceBetweenColumns).addPreferredGap(0).add((Component)this.jCheckBoxWhitePageBackground).addPreferredGap(0).add((Component)this.jCheckBoxAutoDetectCellType).addPreferredGap(0).add((Component)this.jCheckBoxFontSizeFixEnabled).addPreferredGap(0).add((Component)this.jCheckBoxImageBorderFixEnabled).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabelMaximumRowsPerSheet).add((Component)this.jSpinnerMaximumRowsPerSheet, -2, -1, -2)).addPreferredGap(0).add((Component)this.jCheckBoxIgnoreGraphics).addPreferredGap(0).add((Component)this.jCheckBoxCollapseRowSpan).addPreferredGap(0).add((Component)this.jCheckBoxIgnoreCellBorder).addPreferredGap(0).add((Component)this.jCheckBoxIgnoreCellBackground).addContainerGap(18, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Common", this.jPanel1);
        this.jCheckBoxUseSheetNames.setText("Use Sheet Names");
        this.jCheckBoxUseSheetNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsExportParametersPanel.this.jCheckBoxUseSheetNamesActionPerformed(evt);
            }
        });
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jLabelList.setText("Sheet names. Each row corresponds to one sheet name.");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jCheckBoxUseSheetNames).add((Component)this.jLabelList).add(2, (Component)this.jScrollPane1, -1, 393, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jCheckBoxUseSheetNames).addPreferredGap(1).add((Component)this.jLabelList).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 228, Short.MAX_VALUE).add(17, 17, 17)));
        this.jTabbedPane1.addTab("Sheet Names", this.jPanel2);
        this.jCheckBoxCreateCustomPalette.setText("Create Custom Palette");
        this.jCheckBoxCreateCustomPalette.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsExportParametersPanel.this.jCheckBoxCreateCustomPaletteActionPerformed(evt);
            }
        });
        this.jLabelPassword.setText("Password");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jCheckBoxCreateCustomPalette).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabelPassword).addPreferredGap(0).add((Component)this.jTextFieldPassword, -2, 141, -2))).addContainerGap(212, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jCheckBoxCreateCustomPalette).addPreferredGap(1).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabelPassword).add((Component)this.jTextFieldPassword, -2, -1, -2)).addContainerGap(245, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("JExcelAPI options", this.jPanel3);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addContainerGap(276, Short.MAX_VALUE)).add((Component)this.jSeparator1, -1, 418, Short.MAX_VALUE).add((Component)this.jTabbedPane1, -1, 418, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.jTabbedPane1, -1, 330, Short.MAX_VALUE)));
    }

    private void jCheckBoxOnePagePerSheetActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxRemoveEmptySpaceBetweenRowsActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxRemoveEmptySpaceBetweenColumnsActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxWhitePageBackgroundActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxAutoDetectCellTypeActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxFontSizeFixEnabledActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxImageBorderFixEnabledActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxIgnoreGraphicsActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxCollapseRowSpanActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxIgnoreCellBorderActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxUseSheetNamesActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxCreateCustomPaletteActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxIgnoreCellBackgroundActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    public void load() {
        this.setInit(true);
        Preferences pref = IReportManager.getPreferences();
        this.jCheckBoxCreateCustomPalette.setSelected(pref.getBoolean("net.sf.jasperreports.export.xls.create.custom.palette", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.create.custom.palette")));
        this.jTextFieldPassword.setText(pref.get("net.sf.jasperreports.export.xls.password", JRProperties.getProperty((String)"net.sf.jasperreports.export.xls.password")));
        this.jCheckBoxCollapseRowSpan.setSelected(pref.getBoolean("net.sf.jasperreports.export.xls.collapse.row.span", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.collapse.row.span")));
        this.jCheckBoxAutoDetectCellType.setSelected(pref.getBoolean("net.sf.jasperreports.export.xls.detect.cell.type", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.collapse.row.span")));
        this.jCheckBoxFontSizeFixEnabled.setSelected(pref.getBoolean("net.sf.jasperreports.export.xls.font.size.fix.enabled", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.collapse.row.span")));
        this.jCheckBoxIgnoreCellBorder.setSelected(pref.getBoolean("net.sf.jasperreports.export.xls.ignore.cell.border", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.collapse.row.span")));
        this.jCheckBoxIgnoreCellBackground.setSelected(pref.getBoolean("net.sf.jasperreports.export.xls.ignore.cell.background", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.ignore.cell.background")));
        this.jCheckBoxIgnoreGraphics.setSelected(pref.getBoolean("net.sf.jasperreports.export.xls.ignore.graphics", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.ignore.graphics")));
        this.jCheckBoxImageBorderFixEnabled.setSelected(pref.getBoolean("net.sf.jasperreports.export.xls.image.border.fix.enabled", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.collapse.row.span")));
        this.jCheckBoxOnePagePerSheet.setSelected(pref.getBoolean("net.sf.jasperreports.export.xls.one.page.per.sheet", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.collapse.row.span")));
        this.jCheckBoxRemoveEmptySpaceBetweenColumns.setSelected(pref.getBoolean("net.sf.jasperreports.export.xls.remove.empty.space.between.columns", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.collapse.row.span")));
        this.jCheckBoxRemoveEmptySpaceBetweenRows.setSelected(pref.getBoolean("net.sf.jasperreports.export.xls.remove.empty.space.between.rows", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.collapse.row.span")));
        this.jCheckBoxWhitePageBackground.setSelected(pref.getBoolean("net.sf.jasperreports.export.xls.white.page.background", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.collapse.row.span")));
        SpinnerNumberModel model = (SpinnerNumberModel)this.jSpinnerMaximumRowsPerSheet.getModel();
        model.setValue(pref.getInt("net.sf.jasperreports.export.xls.max.rows.per.sheet", JRProperties.getIntegerProperty((String)"net.sf.jasperreports.export.xls.max.rows.per.sheet")));
        this.jCheckBoxUseSheetNames.setSelected(pref.getBoolean("net.sf.jasperreports.export.xls.useSheetNames", false));
        this.jTextArea1.setText(pref.get("net.sf.jasperreports.export.xls.sheetNames", ""));
        this.setInit(false);
    }

    public void store() {
        Preferences pref = IReportManager.getPreferences();
        pref.putBoolean("net.sf.jasperreports.export.xls.create.custom.palette", this.jCheckBoxCreateCustomPalette.isSelected());
        pref.put("net.sf.jasperreports.export.xls.password", this.jTextFieldPassword.getText());
        pref.putBoolean("net.sf.jasperreports.export.xls.collapse.row.span", this.jCheckBoxCollapseRowSpan.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.xls.detect.cell.type", this.jCheckBoxAutoDetectCellType.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.xls.font.size.fix.enabled", this.jCheckBoxFontSizeFixEnabled.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.xls.ignore.cell.border", this.jCheckBoxIgnoreCellBorder.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.xls.ignore.cell.background", this.jCheckBoxIgnoreCellBackground.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.xls.ignore.graphics", this.jCheckBoxIgnoreGraphics.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.xls.image.border.fix.enabled", this.jCheckBoxImageBorderFixEnabled.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.xls.one.page.per.sheet", this.jCheckBoxOnePagePerSheet.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.xls.remove.empty.space.between.columns", this.jCheckBoxRemoveEmptySpaceBetweenColumns.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.xls.remove.empty.space.between.rows", this.jCheckBoxRemoveEmptySpaceBetweenRows.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.xls.white.page.background", this.jCheckBoxWhitePageBackground.isSelected());
        SpinnerNumberModel model = (SpinnerNumberModel)this.jSpinnerMaximumRowsPerSheet.getModel();
        pref.putInt("net.sf.jasperreports.export.xls.max.rows.per.sheet", model.getNumber().intValue());
        pref.putBoolean("net.sf.jasperreports.export.xls.useSheetNames", this.jCheckBoxUseSheetNames.isSelected());
        pref.put("net.sf.jasperreports.export.xls.sheetNames", this.jTextArea1.getText().trim());
    }

    public boolean valid() {
        return true;
    }

    public String getDisplayName() {
        return I18n.getString("XlsExportParametersPanel.title");
    }
}

