/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.resources;

import com.jaspersoft.ireport.JrxmlDataObject;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.fonts.TTFFontsLoader;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryFile;
import com.jaspersoft.ireport.jasperserver.RepositoryFolder;
import com.jaspersoft.ireport.jasperserver.ui.AntialiasedEditorPane;
import com.jaspersoft.ireport.jasperserver.ui.ValidationUtils;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class ObjectPropertiesDialog
extends JDialog {
    private RepositoryFolder resource;
    private int dialogResult = 2;
    private AntialiasedEditorPane jEditorPane1 = null;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButtonClose;
    private JButton jButtonCurrentReport;
    private JButton jButtonSave;
    private JCheckBox jCheckBoxChangeFile;
    private JEditorPane jEditorPaneDescription;
    private JLabel jLabelDescription;
    private JLabel jLabelLabel;
    private JLabel jLabelName;
    private JLabel jLabelPreview;
    private JLabel jLabelUriString;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelDescriptor;
    private JPanel jPanelResourceFile;
    private JPanel jPanelSpacer;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldFile;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldName;
    private JTextField jTextFieldUriString;
    private JTextPane jTextPaneDescriptor;

    public ObjectPropertiesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.jTextFieldLabel.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                ObjectPropertiesDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                ObjectPropertiesDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                ObjectPropertiesDialog.this.updateSaveButton();
            }
        });
        this.jEditorPaneDescription.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                ObjectPropertiesDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                ObjectPropertiesDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                ObjectPropertiesDialog.this.updateSaveButton();
            }
        });
        this.jEditorPane1 = new AntialiasedEditorPane();
        this.jEditorPane1.setContentType("text/html");
        this.jEditorPane1.setVisible(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.jPanelResourceFile.add((Component)this.jEditorPane1, gridBagConstraints);
        this.jEditorPane1.setEditable(false);
        this.applyI18n();
        this.jPanelSpacer.setVisible(false);
        JrxmlVisualView view = IReportManager.getInstance().getActiveVisualView();
        this.jButtonCurrentReport.setEnabled(view != null);
    }

    public void applyI18n() {
        this.jButtonClose.setText(JasperServerManager.getString("objectPropertiesDialog.buttonCancel", "Cancel"));
        this.jButtonSave.setText(JasperServerManager.getString("objectPropertiesDialog.buttonSave", "Save"));
        this.jButtonCurrentReport.setText(JasperServerManager.getString("reportUnitDialog.buttonGetCurrentReport", "Current Report"));
        this.jLabelDescription.setText(JasperServerManager.getString("objectPropertiesDialog.labelDescription", "Description"));
        this.jLabelLabel.setText(JasperServerManager.getString("objectPropertiesDialog.labelLabel", "Label"));
        this.jLabelName.setText(JasperServerManager.getString("objectPropertiesDialog.labelName", "Name"));
        this.jLabelUriString.setText(JasperServerManager.getString("objectPropertiesDialog.labelParentFolder", "Parent folder"));
        this.jButton1.setText(JasperServerManager.getString("objectPropertiesDialog.buttonBrowse", "Browse"));
        this.jButton2.setText(JasperServerManager.getString("objectPropertiesDialog.buttonExportFile", "Export file"));
        this.jCheckBoxChangeFile.setText(JasperServerManager.getString("objectPropertiesDialog.checkBoxChangeFile", "Replace resource with this file:"));
        this.jTabbedPane1.setTitleAt(0, JasperServerManager.getString("objectPropertiesDialog.tabGeneral", "General"));
        this.jTabbedPane1.setTitleAt(1, JasperServerManager.getString("objectPropertiesDialog.tabResource", "Resource"));
        this.jTabbedPane1.setTitleAt(2, JasperServerManager.getString("objectPropertiesDialog.tabDescriptor", "XML descriptor"));
    }

    public void updateSaveButton() {
        if (this.jTextFieldLabel.getText().length() > 0) {
            this.jButtonSave.setEnabled(true);
        } else {
            this.jButtonSave.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabelUriString = new JLabel();
        this.jTextFieldUriString = new JTextField();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jLabelLabel = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jLabelDescription = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPaneDescription = new JEditorPane();
        this.jPanelResourceFile = new JPanel();
        this.jLabelPreview = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jCheckBoxChangeFile = new JCheckBox();
        this.jTextFieldFile = new JTextField();
        this.jButton1 = new JButton();
        this.jButtonCurrentReport = new JButton();
        this.jSeparator4 = new JSeparator();
        this.jButton2 = new JButton();
        this.jPanelSpacer = new JPanel();
        this.jPanelDescriptor = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextPaneDescriptor = new JTextPane();
        this.jPanel2 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ObjectPropertiesDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setPreferredSize(new Dimension(350, 250));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelUriString.setText("Location (URI)");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabelUriString, gridBagConstraints);
        this.jTextFieldUriString.setEditable(false);
        this.jTextFieldUriString.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldUriString.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jTextFieldUriString, gridBagConstraints);
        this.jLabelName.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabelName, gridBagConstraints);
        this.jTextFieldName.setEditable(false);
        this.jTextFieldName.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldName.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabelLabel.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jTextFieldLabel, gridBagConstraints);
        this.jLabelDescription.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel1.add((Component)this.jLabelDescription, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jEditorPaneDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jTabbedPane1.addTab("General", this.jPanel1);
        this.jPanelResourceFile.setLayout(new GridBagLayout());
        this.jLabelPreview.setHorizontalAlignment(0);
        this.jLabelPreview.setText("  ");
        this.jLabelPreview.setVerticalAlignment(3);
        this.jLabelPreview.setHorizontalTextPosition(0);
        this.jLabelPreview.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.jPanelResourceFile.add((Component)this.jLabelPreview, gridBagConstraints);
        this.jSeparator3.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanelResourceFile.add((Component)this.jSeparator3, gridBagConstraints);
        this.jCheckBoxChangeFile.setText("Replace resource with this file:");
        this.jCheckBoxChangeFile.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxChangeFile.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxChangeFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectPropertiesDialog.this.jCheckBoxChangeFileActionPerformed(evt);
            }
        });
        this.jCheckBoxChangeFile.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ObjectPropertiesDialog.this.jCheckBoxChangeFileStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 0, 0);
        this.jPanelResourceFile.add((Component)this.jCheckBoxChangeFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        this.jPanelResourceFile.add((Component)this.jTextFieldFile, gridBagConstraints);
        this.jButton1.setText("Browse");
        this.jButton1.setMinimumSize(new Dimension(73, 19));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectPropertiesDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanelResourceFile.add((Component)this.jButton1, gridBagConstraints);
        this.jButtonCurrentReport.setText("Current Report");
        this.jButtonCurrentReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectPropertiesDialog.this.jButtonCurrentReportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        this.jPanelResourceFile.add((Component)this.jButtonCurrentReport, gridBagConstraints);
        this.jSeparator4.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanelResourceFile.add((Component)this.jSeparator4, gridBagConstraints);
        this.jButton2.setText("Export file");
        this.jButton2.setMinimumSize(new Dimension(73, 23));
        this.jButton2.setPreferredSize(new Dimension(100, 23));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectPropertiesDialog.this.jButton1ActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelResourceFile.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelResourceFile.add((Component)this.jPanelSpacer, gridBagConstraints);
        this.jTabbedPane1.addTab("Resource", this.jPanelResourceFile);
        this.jPanelDescriptor.setLayout(new GridBagLayout());
        this.jTextPaneDescriptor.setEditable(false);
        this.jScrollPane2.setViewportView(this.jTextPaneDescriptor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelDescriptor.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jTabbedPane1.addTab("Descriptor", this.jPanelDescriptor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jPanel2.setMinimumSize(new Dimension(10, 30));
        this.jPanel2.setPreferredSize(new Dimension(10, 30));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jButtonSave.setText("Save");
        this.jButtonSave.setEnabled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectPropertiesDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel2.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectPropertiesDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.jButtonClose, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void jButton1ActionPerformed1(ActionEvent evt) {
        String fileName = "";
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.setDialogTitle(JasperServerManager.getString("objectPropertiesDialog.pickAFile", "Pick a file...."));
        String resType = this.getResource().getDescriptor().getWsType();
        if (resType.equals("jrxml")) {
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".xml") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
                }

                public String getDescription() {
                    return "JasperReports XML *.xml, *.jrxml";
                }
            });
        } else if (resType.equals("font")) {
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".ttf") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
                }

                public String getDescription() {
                    return "TrueType font *.TTF";
                }
            });
        } else if (resType.equals("prop")) {
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".properties") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
                }

                public String getDescription() {
                    return "ResourceBundle *.properties";
                }
            });
        } else if (resType.equals("jar")) {
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".jar") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
                }

                public String getDescription() {
                    return "Java Archive *.jar";
                }
            });
        } else if (resType.equals("jrtx")) {
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".jrtx") || file.isDirectory() || filename.toLowerCase().endsWith(".jrtx");
                }

                public String getDescription() {
                    return "Style Template *.jrtx";
                }
            });
        }
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(1);
        if (jfc.showOpenDialog(this) == 0) {
            try {
                this.copyFile(new File(((RepositoryFile)this.getResource()).getFile()), jfc.getSelectedFile());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
                ex.printStackTrace();
                return;
            }
        }
    }

    private void jCheckBoxChangeFileStateChanged(ChangeEvent evt) {
    }

    private void jCheckBoxChangeFileActionPerformed(ActionEvent evt) {
        this.updateSaveButton();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String fileName = "";
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.setDialogTitle("Pick a file....");
        String resType = this.getResource().getDescriptor().getWsType();
        if (resType.equals("jrxml")) {
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".xml") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
                }

                public String getDescription() {
                    return "JasperReports XML *.xml, *.jrxml";
                }
            });
        } else if (resType.equals("font")) {
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".ttf") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
                }

                public String getDescription() {
                    return "TrueType font *.TTF";
                }
            });
        } else if (resType.equals("prop")) {
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".properties") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
                }

                public String getDescription() {
                    return "ResourceBundle *.properties";
                }
            });
        } else if (resType.equals("jar")) {
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".jar") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
                }

                public String getDescription() {
                    return "Java Archive *.jar";
                }
            });
        } else if (resType.equals("jrtx")) {
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".jrtx") || file.isDirectory() || filename.toLowerCase().endsWith(".jrtx");
                }

                public String getDescription() {
                    return "Style Template *.jrtx";
                }
            });
        }
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            this.jTextFieldFile.setText(jfc.getSelectedFile() + "");
            this.updateSaveButton();
            if (this.getResource().getDescriptor().getWsType().equals("img")) {
                try {
                    ImageIcon ii = new ImageIcon(jfc.getSelectedFile() + "");
                    this.jLabelPreview.setText(ii.getIconWidth() + "x" + ii.getIconHeight());
                    this.doLayout();
                    ii.setImage(this.resampleImage(ii.getImage(), this.jLabelPreview.getWidth(), Math.max(1, this.jLabelPreview.getHeight() - 20)));
                    this.jLabelPreview.setIcon(ii);
                }
                catch (Exception ex) {
                    this.jLabelPreview.setText(" ");
                    this.jLabelPreview.setIcon(null);
                }
            }
        }
        this.jCheckBoxChangeFile.setSelected(true);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCloseActionPerformed(null);
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        if (this.jButtonSave.isEnabled() && JOptionPane.showConfirmDialog(this, JasperServerManager.getString("objectPropertiesDialog.message.resourceChanged", "The resource was changed.\n\nDo you want save the changes?")) == 0) {
            this.jButtonSaveActionPerformed(null);
            if (this.jButtonSave.isEnabled()) {
                return;
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        File newFile = null;
        if (this.jCheckBoxChangeFile.isSelected() && !(newFile = new File(this.jTextFieldFile.getText())).exists()) {
            JOptionPane.showMessageDialog(this, JasperServerManager.getFormattedString("objectPropertiesDialog.message.fileNotFound", "The file {0}\ndoes not exist.\n\nPlease provide a correct file name.", new Object[]{this.jTextFieldFile.getText()}));
            return;
        }
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setWsType(this.getResource().getDescriptor().getWsType());
        rd.setName(this.getResource().getDescriptor().getName());
        rd.setUriString(this.getResource().getDescriptor().getUriString());
        rd.setCreationDate(this.getResource().getDescriptor().getCreationDate());
        rd.setConnectionUrl(this.getResource().getDescriptor().getConnectionUrl());
        rd.setDataSourceType(this.getResource().getDescriptor().getDataSourceType());
        rd.setDescription(this.jEditorPaneDescription.getText().trim());
        rd.setDriverClass(this.getResource().getDescriptor().getDriverClass());
        rd.setHasData(newFile != null);
        rd.setIsNew(false);
        rd.setIsReference(this.getResource().getDescriptor().getIsReference());
        rd.setJndiName(this.getResource().getDescriptor().getJndiName());
        rd.setLabel(this.jTextFieldLabel.getText().trim());
        rd.setParentFolder(this.getResource().getDescriptor().getParentFolder());
        rd.setPassword(this.getResource().getDescriptor().getPassword());
        rd.setReferenceUri(this.getResource().getDescriptor().getReferenceUri());
        rd.setResourceType(this.getResource().getDescriptor().getResourceType());
        rd.setUsername(this.getResource().getDescriptor().getUsername());
        rd.setVersion(this.getResource().getDescriptor().getVersion());
        try {
            this.validate(rd);
            ResourceDescriptor newrd = this.getResource().getServer().getWSClient().addOrModifyResource(rd, newFile);
            this.setDialogResult(0);
            this.jButtonSave.setEnabled(false);
            this.getResource().setDescriptor(newrd);
            if (this.jCheckBoxChangeFile.isSelected() && this.getResource() instanceof RepositoryFile) {
                RepositoryFile fileRep = (RepositoryFile)this.getResource();
                if (this.getResource().getDescriptor().getWsType().equals("img")) {
                    try {
                        String s = fileRep.getFile();
                        fileRep.resetFileCache();
                        this.copyFile(new File(s), newFile);
                    }
                    catch (Exception ex) {}
                } else {
                    fileRep.resetFileCache();
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
            ex.printStackTrace();
            return;
        }
    }

    private void jButtonCurrentReportActionPerformed(ActionEvent evt) {
        JrxmlDataObject dobject;
        JrxmlVisualView view = IReportManager.getInstance().getActiveVisualView();
        if (view != null && view.getLookup() != null && (dobject = (JrxmlDataObject)view.getLookup().lookup(JrxmlDataObject.class)) != null) {
            this.jCheckBoxChangeFile.setSelected(true);
            this.jTextFieldFile.setText(dobject.getPrimaryFile().getPath());
        }
        this.updateSaveButton();
    }

    public void setResource(RepositoryFolder resource) {
        block18: {
            block17: {
                this.resource = resource;
                ResourceDescriptor resourceDescriptor = resource.getDescriptor();
                this.setTitle(JasperServerManager.getFormattedString("properties.title", "{0} - Properties", new Object[]{resourceDescriptor.getName()}));
                this.jTextFieldName.setText(resourceDescriptor.getName());
                this.jTextFieldLabel.setText(resourceDescriptor.getLabel());
                this.jTextFieldUriString.setText(resourceDescriptor.getUriString());
                this.jEditorPaneDescription.setText(resourceDescriptor.getDescription());
                this.jCheckBoxChangeFile.setSelected(false);
                this.jTabbedPane1.removeAll();
                this.jTabbedPane1.add("General", this.jPanel1);
                this.jTabbedPane1.setTitleAt(0, JasperServerManager.getString("objectPropertiesDialog.tabGeneral", "General"));
                if (resourceDescriptor.getWsType().equals("img")) break block17;
                if (resourceDescriptor.getWsType().equals("jrxml")) break block17;
                if (resourceDescriptor.getWsType().equals("jar")) break block17;
                if (resourceDescriptor.getWsType().equals("font")) break block17;
                if (resourceDescriptor.getWsType().equals("prop")) break block17;
                if (!resourceDescriptor.getWsType().equals("jrtx")) break block18;
            }
            this.jTabbedPane1.add("Resource", this.jPanelResourceFile);
            this.jTabbedPane1.setTitleAt(1, JasperServerManager.getString("objectPropertiesDialog.tabResource", "Resource"));
        }
        if (this.getResource().getDescriptor().getWsType().equals("img")) {
            try {
                if (this.getResource() instanceof RepositoryFile) {
                    RepositoryFile res = (RepositoryFile)this.getResource();
                    String s = res.getFile();
                    ImageIcon ii = new ImageIcon(s);
                    this.jLabelPreview.setText(ii.getIconWidth() + "x" + ii.getIconHeight());
                    ii.setImage(this.resampleImage(ii.getImage(), 300, 115));
                    this.jLabelPreview.setIcon(ii);
                }
            }
            catch (Exception ex) {
                this.jLabelPreview.setText(" ");
                this.jLabelPreview.setIcon(null);
            }
        } else if (this.getResource().getDescriptor().getWsType().equals("font")) {
            try {
                RepositoryFile res;
                String s;
                Font f;
                if (this.getResource() instanceof RepositoryFile && (f = TTFFontsLoader.loadFont((String)(s = (res = (RepositoryFile)this.getResource()).getFile()))) != null) {
                    this.jEditorPane1.setVisible(true);
                    this.jLabelPreview.setVisible(false);
                    String text = "";
                    for (int dim = 1; dim <= 8; ++dim) {
                        text = text + "<font face=\"" + f.getName() + "\" size=\"" + dim + "\">" + JasperServerManager.getString("objectPropertiesDialog.sampleFontText", "Nel mezzo del cammin di nostra vita...") + "<br></font>";
                    }
                    this.jEditorPane1.setText(text);
                }
            }
            catch (Exception ex) {
                this.jLabelPreview.setText(" ");
                this.jLabelPreview.setIcon(null);
            }
        } else {
            this.jEditorPane1.setVisible(false);
            this.jLabelPreview.setVisible(false);
            this.jSeparator3.setVisible(false);
            this.jPanelSpacer.setVisible(true);
        }
        this.jButtonSave.setEnabled(false);
    }

    public RepositoryFolder getResource() {
        return this.resource;
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public Image resampleImage(Image inImage, int maxX, int maxY) {
        double scale2;
        double scale1 = (double)maxY / (double)inImage.getHeight(null);
        double scale = scale1 < (scale2 = (double)maxX / (double)inImage.getWidth(null)) ? scale1 : scale2;
        int scaledW = (int)(scale * (double)inImage.getWidth(null));
        int scaledH = (int)(scale * (double)inImage.getHeight(null));
        return inImage.getScaledInstance(scaledW, scaledH, 4);
    }

    public void validate(ResourceDescriptor dataType) throws Exception {
        ValidationUtils.validateName(dataType.getName());
        ValidationUtils.validateLabel(dataType.getLabel());
        ValidationUtils.validateDesc(dataType.getDescription());
    }

    public void copyFile(File in, File out) throws IOException {
        FileInputStream is = new FileInputStream(in);
        FileOutputStream os = new FileOutputStream(out);
        byte[] buffer = new byte[1024];
        int bCount = 0;
        while ((bCount = is.read(buffer)) > 0) {
            os.write(buffer, 0, bCount);
        }
        is.close();
        os.close();
    }
}

