/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.ResourceTransactionManager;

public abstract class AbstractPollingMessageListenerContainer
extends AbstractMessageListenerContainer
implements BeanNameAware {
    public static final long DEFAULT_RECEIVE_TIMEOUT = 1000L;
    private final MessageListenerContainerResourceFactory transactionalResourceFactory = new MessageListenerContainerResourceFactory();
    private boolean sessionTransactedCalled = false;
    private boolean pubSubNoLocal = false;
    private PlatformTransactionManager transactionManager;
    private DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
    private long receiveTimeout = 1000L;

    public void setSessionTransacted(boolean sessionTransacted) {
        super.setSessionTransacted(sessionTransacted);
        this.sessionTransactedCalled = true;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    protected boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected final PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionName(String transactionName) {
        this.transactionDefinition.setName(transactionName);
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionDefinition.setTimeout(transactionTimeout);
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void initialize() {
        if (!this.sessionTransactedCalled && this.transactionManager instanceof ResourceTransactionManager && ((ResourceTransactionManager)this.transactionManager).getResourceFactory() != this.getConnectionFactory()) {
            super.setSessionTransacted(true);
        }
        if (this.transactionDefinition.getName() == null) {
            this.transactionDefinition.setName(this.getBeanName());
        }
        super.initialize();
    }

    protected MessageConsumer createListenerConsumer(Session session) throws JMSException {
        Destination destination = this.getDestination();
        if (destination == null) {
            destination = this.resolveDestinationName(session, this.getDestinationName());
        }
        return this.createConsumer(session, destination);
    }

    protected boolean receiveAndExecute(Session session, MessageConsumer consumer) throws JMSException {
        if (this.transactionManager != null) {
            TransactionStatus status = this.transactionManager.getTransaction(this.transactionDefinition);
            boolean messageReceived = true;
            try {
                messageReceived = this.doReceiveAndExecute(session, consumer, status);
            }
            catch (JMSException ex) {
                this.rollbackOnException(status, ex);
                throw ex;
            }
            catch (RuntimeException ex) {
                this.rollbackOnException(status, ex);
                throw ex;
            }
            catch (Error err) {
                this.rollbackOnException(status, err);
                throw err;
            }
            this.transactionManager.commit(status);
            return messageReceived;
        }
        return this.doReceiveAndExecute(session, consumer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doReceiveAndExecute(Session session, MessageConsumer consumer, TransactionStatus status) throws JMSException {
        MessageConsumer consumerToUse;
        boolean transactional;
        Session sessionToUse;
        MessageConsumer consumerToClose;
        Session sessionToClose;
        Connection conToClose;
        block14: {
            boolean bl;
            conToClose = null;
            sessionToClose = null;
            consumerToClose = null;
            try {
                Message message;
                sessionToUse = session;
                transactional = false;
                if (sessionToUse == null) {
                    sessionToUse = ConnectionFactoryUtils.doGetTransactionalSession(this.getConnectionFactory(), this.transactionalResourceFactory, true);
                    boolean bl2 = transactional = sessionToUse != null;
                }
                if (sessionToUse == null) {
                    Connection conToUse = null;
                    if (this.sharedConnectionEnabled()) {
                        conToUse = this.getSharedConnection();
                    } else {
                        conToClose = conToUse = this.createConnection();
                        conToUse.start();
                    }
                    sessionToClose = sessionToUse = this.createSession(conToUse);
                }
                if ((consumerToUse = consumer) == null) {
                    consumerToClose = consumerToUse = this.createListenerConsumer(sessionToUse);
                }
                if ((message = this.receiveMessage(consumerToUse)) == null) break block14;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Received message of type [" + message.getClass() + "] from consumer [" + consumerToUse + "] of " + (transactional ? "transactional " : "") + "session [" + sessionToUse + "]"));
                }
                this.messageReceived(message, session);
                try {
                    this.doExecuteListener(sessionToUse, message);
                }
                catch (Throwable ex) {
                    if (status != null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Rolling back transaction because of listener exception thrown: " + ex));
                        }
                        status.setRollbackOnly();
                    }
                    this.handleListenerException(ex);
                }
                bl = true;
            }
            catch (Throwable throwable) {
                JmsUtils.closeMessageConsumer(consumerToClose);
                JmsUtils.closeSession(sessionToClose);
                ConnectionFactoryUtils.releaseConnection(conToClose, this.getConnectionFactory(), true);
                throw throwable;
            }
            JmsUtils.closeMessageConsumer(consumerToClose);
            JmsUtils.closeSession(sessionToClose);
            ConnectionFactoryUtils.releaseConnection(conToClose, this.getConnectionFactory(), true);
            return bl;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Consumer [" + consumerToUse + "] of " + (transactional ? "transactional " : "") + "session [" + sessionToUse + "] did not receive a message"));
        }
        boolean bl = false;
        JmsUtils.closeMessageConsumer(consumerToClose);
        JmsUtils.closeSession(sessionToClose);
        ConnectionFactoryUtils.releaseConnection(conToClose, this.getConnectionFactory(), true);
        return bl;
    }

    protected boolean isSessionLocallyTransacted(Session session) {
        return super.isSessionLocallyTransacted(session) && !ConnectionFactoryUtils.isSessionTransactional(session, this.getConnectionFactory());
    }

    private void rollbackOnException(TransactionStatus status, Throwable ex) {
        this.logger.debug((Object)"Initiating transaction rollback on listener exception", ex);
        try {
            this.transactionManager.rollback(status);
        }
        catch (RuntimeException ex2) {
            this.logger.error((Object)"Listener exception overridden by rollback exception", ex);
            throw ex2;
        }
        catch (Error err) {
            this.logger.error((Object)"Listener exception overridden by rollback error", ex);
            throw err;
        }
    }

    protected Message receiveMessage(MessageConsumer consumer) throws JMSException {
        return this.receiveTimeout < 0L ? consumer.receive() : consumer.receive(this.receiveTimeout);
    }

    protected void messageReceived(Message message, Session session) {
    }

    protected Connection getConnection(JmsResourceHolder holder) {
        return holder.getConnection();
    }

    protected Session getSession(JmsResourceHolder holder) {
        return holder.getSession();
    }

    protected MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        if (this.isPubSubDomain()) {
            if (this.isSubscriptionDurable() && destination instanceof Topic) {
                return session.createDurableSubscriber((Topic)destination, this.getDurableSubscriptionName(), this.getMessageSelector(), this.isPubSubNoLocal());
            }
            return session.createConsumer(destination, this.getMessageSelector(), this.isPubSubNoLocal());
        }
        return session.createConsumer(destination, this.getMessageSelector());
    }

    private class MessageListenerContainerResourceFactory
    implements ConnectionFactoryUtils.ResourceFactory {
        private MessageListenerContainerResourceFactory() {
        }

        public Connection getConnection(JmsResourceHolder holder) {
            return AbstractPollingMessageListenerContainer.this.getConnection(holder);
        }

        public Session getSession(JmsResourceHolder holder) {
            return AbstractPollingMessageListenerContainer.this.getSession(holder);
        }

        public Connection createConnection() throws JMSException {
            if (AbstractPollingMessageListenerContainer.this.sharedConnectionEnabled()) {
                return AbstractPollingMessageListenerContainer.this.getSharedConnection();
            }
            return AbstractPollingMessageListenerContainer.this.createConnection();
        }

        public Session createSession(Connection con) throws JMSException {
            return AbstractPollingMessageListenerContainer.this.createSession(con);
        }

        public boolean isSynchedLocalTransactionAllowed() {
            return AbstractPollingMessageListenerContainer.this.isSessionTransacted();
        }
    }
}

