/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZip;

public class XlsxZip
extends FileBufferedZip {
    private ExportZipEntry workbookEntry = null;
    private ExportZipEntry stylesEntry = null;
    private ExportZipEntry relsEntry = null;
    private ExportZipEntry contentTypesEntry = null;

    public XlsxZip() throws IOException {
        this(1);
    }

    public XlsxZip(byte openDocumentNature) throws IOException {
        this.exportZipEntries = new ArrayList();
        this.workbookEntry = this.createEntry("xl/workbook.xml");
        this.exportZipEntries.add(this.workbookEntry);
        this.stylesEntry = this.createEntry("xl/styles.xml");
        this.exportZipEntries.add(this.stylesEntry);
        this.relsEntry = this.createEntry("xl/_rels/workbook.xml.rels");
        this.exportZipEntries.add(this.relsEntry);
        this.contentTypesEntry = this.createEntry("[Content_Types].xml");
        this.exportZipEntries.add(this.contentTypesEntry);
        this.createRelsEntry();
    }

    public ExportZipEntry getWorkbookEntry() {
        return this.workbookEntry;
    }

    public ExportZipEntry getStylesEntry() {
        return this.stylesEntry;
    }

    public ExportZipEntry getRelsEntry() {
        return this.relsEntry;
    }

    public ExportZipEntry getContentTypesEntry() {
        return this.contentTypesEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRelsEntry() throws IOException {
        ExportZipEntry relsEntry = this.createEntry("_rels/.rels");
        Writer relsWriter = null;
        try {
            relsWriter = relsEntry.getWriter();
            relsWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            relsWriter.write("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">\n");
            relsWriter.write(" <Relationship Id=\"rId1\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument\" Target=\"xl/workbook.xml\"/>\n");
            relsWriter.write("</Relationships>\n");
            relsWriter.flush();
            this.exportZipEntries.add(relsEntry);
        }
        finally {
            if (relsWriter != null) {
                try {
                    relsWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createContentTypesEntry() throws IOException {
        ExportZipEntry contentTypesEntry = this.createEntry("[Content_Types].xml");
        Writer ctWriter = null;
        try {
            ctWriter = contentTypesEntry.getWriter();
            ctWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            ctWriter.write("<Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\">\n");
            ctWriter.write("  <Default Extension=\"gif\" ContentType=\"image/gif\"/>\n");
            ctWriter.write("  <Default Extension=\"jpeg\" ContentType=\"image/jpeg\"/>\n");
            ctWriter.write("  <Default Extension=\"png\" ContentType=\"image/png\"/>\n");
            ctWriter.write("  <Default Extension=\"tiff\" ContentType=\"image/tiff\"/>\n");
            ctWriter.write("  <Default Extension=\"rels\" ContentType=\"application/vnd.openxmlformats-package.relationships+xml\"/>\n");
            ctWriter.write("  <Default Extension=\"xml\" ContentType=\"application/xml\"/>\n");
            ctWriter.write("  <Override PartName=\"/xl/styles.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml\"/>\n");
            ctWriter.write("  <Override PartName=\"/xl/workbook.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml\"/>\n");
            ctWriter.write("  <Override PartName=\"/xl/worksheets/sheet1.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml\"/>\n");
            ctWriter.write("  <Override PartName=\"/xl/worksheets/sheet2.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml\"/>\n");
            ctWriter.write("  <Override PartName=\"/xl/worksheets/sheet3.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml\"/>\n");
            ctWriter.write("</Types>\n");
            ctWriter.flush();
            this.exportZipEntries.add(contentTypesEntry);
        }
        finally {
            if (ctWriter != null) {
                try {
                    ctWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ExportZipEntry addSheet(int index) {
        ExportZipEntry sheetEntry = this.createEntry("xl/worksheets/sheet" + index + ".xml");
        this.exportZipEntries.add(sheetEntry);
        return sheetEntry;
    }
}

