/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lexer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.TokenChange;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.lexer.LanguageManager;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenIdSet;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.inc.TokenChangeInfo;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.spi.lexer.LanguageHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Language<T extends TokenId> {
    private final LanguageHierarchy<T> languageHierarchy;
    private final LanguageOperation<T> languageOperation;
    private final String mimeType;
    private final int maxOrdinal;
    private final Set<T> ids;
    private TokenIdSet<T> indexedIds;
    private final Map<String, T> idName2id;
    private final Map<String, Set<T>> cat2ids;
    private List<String>[] id2cats;
    private List<String>[] id2nonPrimaryCats;

    public static Language<? extends TokenId> find(String string) {
        return LanguageManager.getInstance().findLanguage(string);
    }

    Language(LanguageHierarchy<T> languageHierarchy) {
        Object object;
        Object object2;
        this.languageHierarchy = languageHierarchy;
        this.languageOperation = new LanguageOperation<T>(languageHierarchy, this);
        this.mimeType = LexerSpiPackageAccessor.get().mimeType(languageHierarchy);
        Language.checkMimeTypeValid(this.mimeType);
        Collection<T> collection = LexerSpiPackageAccessor.get().createTokenIds(languageHierarchy);
        if (collection == null) {
            throw new IllegalArgumentException("Ids cannot be null");
        }
        this.maxOrdinal = TokenIdSet.findMaxOrdinal(collection);
        this.ids = collection instanceof EnumSet ? (Set<Object>)collection : new TokenIdSet<T>(collection, this.maxOrdinal, true);
        Map<String, Collection<Object>> map = LexerSpiPackageAccessor.get().createTokenCategories(languageHierarchy);
        if (map == null) {
            map = Collections.emptyMap();
        }
        this.cat2ids = new HashMap<String, Set<T>>((int)((float)map.size() / 0.73f));
        for (Map.Entry<String, Collection<Object>> object3 : map.entrySet()) {
            object2 = object3.getValue();
            TokenIdSet.checkIdsFromLanguage(object2, this.ids);
            object = new TokenIdSet<Object>((Collection<Object>)object2, this.maxOrdinal, false);
            this.cat2ids.put(object3.getKey(), (Set<T>)object);
        }
        this.idName2id = new HashMap<String, T>((int)((float)this.ids.size() / 0.73f));
        for (TokenId tokenId : this.ids) {
            object2 = this.idName2id.put(tokenId.name(), tokenId);
            if (object2 != null && object2 != tokenId) {
                throw new IllegalArgumentException(tokenId + " has duplicate name with " + object2);
            }
            object = tokenId.primaryCategory();
            if (object == null) continue;
            Set<T> set = this.cat2ids.get(object);
            if (set == null) {
                set = new TokenIdSet(null, this.maxOrdinal, false);
                this.cat2ids.put((String)object, set);
            }
            set.add(tokenId);
        }
    }

    public Set<T> tokenIds() {
        return this.ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T tokenId(int n) {
        Map<String, T> map = this.idName2id;
        synchronized (map) {
            if (this.indexedIds == null) {
                this.indexedIds = this.ids instanceof EnumSet ? new TokenIdSet<T>(this.ids, this.maxOrdinal, false) : (TokenIdSet)this.ids;
            }
            return (T)this.indexedIds.indexedIds()[n];
        }
    }

    public T validTokenId(int n) {
        T t = this.tokenId(n);
        if (t == null) {
            throw new IndexOutOfBoundsException("No tokenId for ordinal=" + n + " in language " + this);
        }
        return t;
    }

    public T tokenId(String string) {
        return (T)((TokenId)this.idName2id.get(string));
    }

    public T validTokenId(String string) {
        T t = this.tokenId(string);
        if (t == null) {
            throw new IllegalArgumentException("No tokenId for name=\"" + string + "\" in language " + this);
        }
        return t;
    }

    public int maxOrdinal() {
        return this.maxOrdinal;
    }

    public Set<String> tokenCategories() {
        return Collections.unmodifiableSet(this.cat2ids.keySet());
    }

    public Set<T> tokenCategoryMembers(String string) {
        return Collections.unmodifiableSet(this.cat2ids.get(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> tokenCategories(T t) {
        this.checkMemberId(t);
        Map<String, T> map = this.idName2id;
        synchronized (map) {
            if (this.id2cats == null) {
                this.buildTokenIdCategories();
            }
            return this.id2cats[t.ordinal()];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> nonPrimaryTokenCategories(T t) {
        this.checkMemberId(t);
        Map<String, T> map = this.idName2id;
        synchronized (map) {
            if (this.id2nonPrimaryCats == null) {
                this.buildTokenIdCategories();
            }
            return this.id2nonPrimaryCats[t.ordinal()];
        }
    }

    public Set<T> merge(Collection<T> collection, Collection<T> collection2) {
        TokenIdSet.checkIdsFromLanguage(collection, this.ids);
        TokenIdSet<T> tokenIdSet = new TokenIdSet<T>(collection, this.maxOrdinal, false);
        if (collection2 != null) {
            TokenIdSet.checkIdsFromLanguage(collection2, this.ids);
            tokenIdSet.addAll(collection2);
        }
        return tokenIdSet;
    }

    public String mimeType() {
        return this.mimeType;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void buildTokenIdCategories() {
        this.assignCatArrays();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>(4);
        ArrayList<String> arrayList2 = new ArrayList<String>(4);
        for (TokenId tokenId : this.ids) {
            for (Map.Entry<String, Set<T>> entry : this.cat2ids.entrySet()) {
                if (!entry.getValue().contains(tokenId)) continue;
                arrayList2.add(entry.getKey());
            }
            this.id2cats[tokenId.ordinal()] = Language.findCatList(arrayList, arrayList2, 0);
            this.id2nonPrimaryCats[tokenId.ordinal()] = Language.findCatList(arrayList, arrayList2, 1);
            arrayList2.clear();
        }
    }

    private static List<String> findCatList(List<Map<String, Object>> list, List<String> list2, int n) {
        int n2 = list2.size() - n;
        if (n2 <= 0) {
            return Collections.emptyList();
        }
        while (list.size() < n2) {
            list.add(new HashMap());
        }
        HashMap<String, Cloneable> hashMap = list.get(--n2);
        for (int i = n; i < n2; ++i) {
            HashMap<String, Cloneable> hashMap2 = (HashMap<String, Cloneable>)hashMap.get(list2.get(i));
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, Cloneable>();
                hashMap.put(list2.get(i), hashMap2);
            }
            hashMap = hashMap2;
        }
        ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(list2.get(n2));
        if (arrayList == null) {
            arrayList = new ArrayList<String>(list2.size() - n);
            arrayList.addAll(n > 0 ? list2.subList(n, list2.size()) : list2);
            hashMap.put(list2.get(n2), arrayList);
        }
        return arrayList;
    }

    private void assignCatArrays() {
        this.id2cats = new List[this.maxOrdinal + 1];
        this.id2nonPrimaryCats = new List[this.maxOrdinal + 1];
    }

    public String dumpInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TokenId tokenId : this.ids) {
            stringBuilder.append(tokenId);
            List<String> list = this.tokenCategories(tokenId);
            if (list.size() <= 0) continue;
            stringBuilder.append(": ");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                String string = list.get(i);
                stringBuilder.append('\"');
                stringBuilder.append(string);
                stringBuilder.append('\"');
            }
        }
        return this.ids.toString();
    }

    public String toString() {
        return this.mimeType + ", LH: " + this.languageHierarchy;
    }

    private void checkMemberId(T t) {
        if (!this.ids.contains(t)) {
            throw new IllegalArgumentException(t + " does not belong to language " + this);
        }
    }

    private static void checkMimeTypeValid(String string) {
        if (string == null) {
            throw new IllegalStateException("mimeType cannot be null");
        }
        int n = string.indexOf(47);
        if (n == -1) {
            throw new IllegalStateException("mimeType=" + string + " does not contain '/'");
        }
        if (string.indexOf(47, n + 1) != -1) {
            throw new IllegalStateException("mimeType=" + string + " contains more than one '/'");
        }
    }

    LanguageHierarchy<T> languageHierarchy() {
        return this.languageHierarchy;
    }

    LanguageOperation<T> languageOperation() {
        return this.languageOperation;
    }

    static {
        LexerApiPackageAccessor.register(new Accessor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Accessor
    extends LexerApiPackageAccessor {
        private Accessor() {
        }

        @Override
        public <T extends TokenId> Language<T> createLanguage(LanguageHierarchy<T> languageHierarchy) {
            return new Language<T>(languageHierarchy);
        }

        @Override
        public <T extends TokenId> LanguageHierarchy<T> languageHierarchy(Language<T> language) {
            return language.languageHierarchy();
        }

        @Override
        public <T extends TokenId> LanguageOperation<T> languageOperation(Language<T> language) {
            return language.languageOperation();
        }

        @Override
        public <I> TokenHierarchy<I> createTokenHierarchy(TokenHierarchyOperation<I, ?> tokenHierarchyOperation) {
            return new TokenHierarchy<I>(tokenHierarchyOperation);
        }

        @Override
        public TokenHierarchyEvent createTokenChangeEvent(TokenHierarchyEventInfo tokenHierarchyEventInfo) {
            return new TokenHierarchyEvent(tokenHierarchyEventInfo);
        }

        @Override
        public <T extends TokenId> TokenChange<T> createTokenChange(TokenChangeInfo<T> tokenChangeInfo) {
            return new TokenChange<T>(tokenChangeInfo);
        }

        @Override
        public <T extends TokenId> TokenChangeInfo<T> tokenChangeInfo(TokenChange<T> tokenChange) {
            return tokenChange.info();
        }

        @Override
        public <I> TokenHierarchyOperation<I, ?> tokenHierarchyOperation(TokenHierarchy<I> tokenHierarchy) {
            return tokenHierarchy.operation();
        }

        @Override
        public <T extends TokenId> TokenSequence<T> createTokenSequence(TokenList<T> tokenList) {
            return new TokenSequence<T>(tokenList);
        }
    }
}

