/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc.oracle;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCCatalog;
import org.netbeans.modules.db.metadata.model.jdbc.oracle.OracleMetadata;
import org.netbeans.modules.db.metadata.model.jdbc.oracle.OracleSchema;

public class OracleCatalog
extends JDBCCatalog {
    private static final Logger LOGGER = Logger.getLogger(OracleCatalog.class.getName());

    public OracleCatalog(OracleMetadata oracleMetadata, String string, boolean bl, String string2) {
        super(oracleMetadata, string, bl, string2);
    }

    public String toString() {
        return "OracleCatalog[name='" + this.getName() + "']";
    }

    protected OracleSchema createJDBCSchema(String string, boolean bl, boolean bl2) {
        return new OracleSchema(this, string, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSchemas() {
        LinkedHashMap<String, Schema> linkedHashMap = new LinkedHashMap<String, Schema>();
        try {
            ResultSet resultSet = this.getJDBCMetadata().getDmd().getSchemas();
            try {
                while (resultSet.next()) {
                    String string = resultSet.getString("TABLE_SCHEM");
                    LOGGER.log(Level.FINE, "Read schema ''{0}''", string);
                    if (this.defaultSchemaName != null && MetadataUtilities.equals(string, this.defaultSchemaName)) {
                        this.defaultSchema = this.createJDBCSchema(this.defaultSchemaName, true, false).getSchema();
                        linkedHashMap.put(this.defaultSchema.getName(), this.defaultSchema);
                        LOGGER.log(Level.FINE, "Created default schema {0}", this.defaultSchema);
                        continue;
                    }
                    Schema schema = this.createJDBCSchema(string, false, false).getSchema();
                    linkedHashMap.put(string, schema);
                    LOGGER.log(Level.FINE, "Created schema {0}", schema);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new MetadataException(sQLException);
        }
        this.schemas = Collections.unmodifiableMap(linkedHashMap);
    }
}

