/*
 * Decompiled with CFR 0.152.
 */
package mondrian.mdx;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ResultStyle;
import mondrian.calc.impl.AbstractMemberIterCalc;
import mondrian.calc.impl.AbstractTupleIterCalc;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Member;
import mondrian.olap.NamedSet;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;

public class NamedSetExpr
extends ExpBase
implements Exp {
    private final NamedSet namedSet;

    public NamedSetExpr(NamedSet namedSet) {
        Util.assertPrecondition(namedSet != null, "namedSet != null");
        this.namedSet = namedSet;
    }

    public NamedSet getNamedSet() {
        return this.namedSet;
    }

    public String toString() {
        return this.namedSet.getUniqueName();
    }

    public NamedSetExpr clone() {
        return new NamedSetExpr(this.namedSet);
    }

    public int getCategory() {
        return 8;
    }

    public Exp accept(Validator validator) {
        NamedSet namedSet2 = this.namedSet.validate(validator);
        if (namedSet2 == this.namedSet) {
            return this;
        }
        return new NamedSetExpr(namedSet2);
    }

    public Calc accept(ExpCompiler compiler) {
        List<ResultStyle> styleList = compiler.getAcceptableResultStyles();
        if (!styleList.contains((Object)ResultStyle.ITERABLE) && !styleList.contains((Object)ResultStyle.ANY)) {
            return null;
        }
        if (((SetType)this.getType()).getArity() != 1) {
            return new AbstractTupleIterCalc(this, new Calc[0]){

                @Override
                public Iterable<Member[]> evaluateTupleIterable(Evaluator evaluator) {
                    Evaluator.NamedSetEvaluator eval = NamedSetExpr.this.getEval(evaluator);
                    return eval.evaluateTupleIterable();
                }

                @Override
                public boolean dependsOn(Dimension dimension) {
                    return false;
                }
            };
        }
        return new AbstractMemberIterCalc(this, new Calc[0]){

            @Override
            public Iterable<Member> evaluateMemberIterable(Evaluator evaluator) {
                Evaluator.NamedSetEvaluator eval = NamedSetExpr.this.getEval(evaluator);
                return eval.evaluateMemberIterable();
            }

            @Override
            public boolean dependsOn(Dimension dimension) {
                return false;
            }
        };
    }

    public Evaluator.NamedSetEvaluator getEval(Evaluator evaluator) {
        return evaluator.getNamedSetEvaluator(this.namedSet.getName(), this.namedSet.getExp());
    }

    public Object accept(MdxVisitor visitor) {
        Object o = visitor.visit(this);
        this.namedSet.getExp().accept(visitor);
        return o;
    }

    public Type getType() {
        return this.namedSet.getType();
    }
}

