/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.datasourcetree.elements;

import javax.swing.ImageIcon;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rex.graphics.datasourcetree.elements.DataSourceTreeElement;
import rex.metadata.ServerMetadata;
import rex.utils.DOM;
import rex.utils.I18n;
import rex.utils.S;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;
import rex.xmla.XMLAObjectsFactory;

public class CatalogElement
implements DataSourceTreeElement {
    private String dataSourceInfo;
    private String catalogName;
    private String description;
    private String roles;
    private String dateModified;
    private ServerMetadata parent;
    static ImageIcon icon = S.getAppIcon("catalog.gif");

    public CatalogElement(ServerMetadata svm, Node rowNode, String myDataSourceInfo) {
        this.parent = svm;
        this.dataSourceInfo = myDataSourceInfo;
        NodeList nl = rowNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            if (nl.item(i).getNodeName().equals("CATALOG_NAME")) {
                this.catalogName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DESCRIPTION")) {
                this.description = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("ROLES")) {
                this.roles = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (!nl.item(i).getNodeName().equals("DATE_MODIFIED")) continue;
            this.dateModified = DOM.getTextFromDOMElement(nl.item(i));
        }
    }

    public DataSourceTreeElement[] getChildren() {
        XMLADiscoverRestrictions restrictions = XMLAObjectsFactory.newXMLADiscoverRestrictions();
        XMLADiscoverProperties properties = XMLAObjectsFactory.newXMLADiscoverProperties();
        properties.setDataSourceInfo(this.dataSourceInfo);
        properties.setCatalog(this.catalogName);
        properties.setFormat("Tabular");
        properties.setContent("SchemaData");
        return this.parent.getCubeList(restrictions, properties);
    }

    public String toString() {
        if (this.catalogName == null) {
            return I18n.getString("toolTip.notInitialized");
        }
        return "" + this.catalogName;
    }

    public ImageIcon getIcon() {
        return icon;
    }

    public String getToolTip() {
        if (this.catalogName == null) {
            return I18n.getString("toolTip.notInitialized");
        }
        return "" + this.catalogName + I18n.getString("toolTip.dateModified") + this.dateModified + I18n.getString("toolTip.desc") + this.description;
    }

    public String[] getPopUpActionList() {
        return null;
    }

    public ServerMetadata getServerMetaData() {
        return this.parent;
    }

    public String getDataSourceInfo() {
        return this.dataSourceInfo;
    }
}

