/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.editor.AnnotationType;
import org.netbeans.modules.editor.options.AnnotationTypeActionsFolder;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.XMLDataObject;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class AnnotationTypeProcessor
implements XMLDataObject.Processor,
InstanceCookie {
    static final String DTD_PUBLIC_ID = "-//NetBeans//DTD annotation type 1.0//EN";
    static final String DTD_SYSTEM_ID = "http://www.netbeans.org/dtds/annotation-type-1_0.dtd";
    static final String DTD_PUBLIC_ID11 = "-//NetBeans//DTD annotation type 1.1//EN";
    static final String DTD_SYSTEM_ID11 = "http://www.netbeans.org/dtds/annotation-type-1_1.dtd";
    static final String TAG_TYPE = "type";
    static final String ATTR_TYPE_NAME = "name";
    static final String ATTR_TYPE_LOCALIZING_BUNDLE = "localizing_bundle";
    static final String ATTR_TYPE_DESCRIPTION_KEY = "description_key";
    static final String ATTR_TYPE_VISIBLE = "visible";
    static final String ATTR_TYPE_GLYPH = "glyph";
    static final String ATTR_TYPE_HIGHLIGHT = "highlight";
    static final String ATTR_TYPE_FOREGROUND = "foreground";
    static final String ATTR_TYPE_WAVEUNDERLINE = "waveunderline";
    static final String ATTR_TYPE_TYPE = "type";
    static final String ATTR_TYPE_CONTENTTYPE = "contenttype";
    static final String ATTR_TYPE_ACTIONS = "actions";
    static final String ATTR_ACTION_NAME = "name";
    static final String TAG_COMBINATION = "combination";
    static final String ATTR_COMBINATION_TIPTEXT_KEY = "tiptext_key";
    static final String ATTR_COMBINATION_ORDER = "order";
    static final String ATTR_COMBINATION_MIN_OPTIONALS = "min_optionals";
    static final String TAG_COMBINE = "combine";
    static final String ATTR_COMBINE_ANNOTATIONTYPE = "annotationtype";
    static final String ATTR_COMBINE_ABSORBALL = "absorb_all";
    static final String ATTR_COMBINE_OPTIONAL = "optional";
    static final String ATTR_COMBINE_MIN = "min";
    static final String ATTR_USE_HIHGLIGHT_COLOR = "use_highlight_color";
    static final String ATTR_USE_WAVE_UNDERLINE_COLOR = "use_wave_underline_color";
    static final String ATTR_INHERIT_FOREGROUND_COLOR = "inherit_foreground_color";
    static final String ATTR_USE_CUSTOM_SIDEBAR_COLOR = "use_custom_sidebar_color";
    static final String ATTR_CUSTOM_SIDEBAR_COLOR = "custom_sidebar_color";
    static final String ATTR_SEVERITY = "severity";
    static final String ATTR_BROWSEABLE = "browseable";
    static final String ATTR_PRIORITY = "priority";
    private FileObject xmlDataObject;
    private AnnotationType annotationType;

    public void attachTo(XMLDataObject xMLDataObject) {
        this.xmlDataObject = xMLDataObject.getPrimaryFile();
    }

    public void attachTo(FileObject fileObject) {
        this.xmlDataObject = fileObject;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        this.annotationType = null;
        this.parse();
        return this.annotationType;
    }

    public Class instanceClass() {
        return AnnotationType.class;
    }

    public String instanceName() {
        return this.instanceClass().getName();
    }

    private synchronized AnnotationType parse() {
        if (this.annotationType == null) {
            AnnotationType annotationType = new AnnotationType();
            Handler handler = new Handler(annotationType);
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setValidating(false);
                sAXParserFactory.setNamespaceAware(false);
                Parser parser = sAXParserFactory.newSAXParser().getParser();
                parser.setEntityResolver(handler);
                parser.setDocumentHandler(handler);
                parser.setErrorHandler(handler);
                parser.parse(new InputSource(this.xmlDataObject.getInputStream()));
                annotationType.putProp((Object)"file", (Object)this.xmlDataObject);
                this.annotationType = annotationType;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        return this.annotationType;
    }

    private static class Handler
    extends HandlerBase {
        private AnnotationType at;
        private int depth = 0;
        private List combinations;

        Handler(AnnotationType annotationType) {
            this.at = annotationType;
        }

        private void rethrow(Exception exception) throws SAXException {
            throw new SAXException(exception);
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            switch (this.depth++) {
                case 0: {
                    String string2;
                    String string3;
                    String string4;
                    if (!"type".equals(string)) {
                        throw new SAXException("malformed AnnotationType xml file");
                    }
                    this.at.setName(attributeList.getValue("name"));
                    if (attributeList.getValue("type") == null) {
                        this.at.setWholeLine(true);
                    } else {
                        this.at.setWholeLine("line".equals(attributeList.getValue("type")));
                    }
                    if (attributeList.getValue(AnnotationTypeProcessor.ATTR_TYPE_VISIBLE) == null) {
                        this.at.setVisible(true);
                    } else {
                        this.at.setVisible(attributeList.getValue(AnnotationTypeProcessor.ATTR_TYPE_VISIBLE));
                    }
                    if (this.at.isVisible()) {
                        string4 = attributeList.getValue(AnnotationTypeProcessor.ATTR_TYPE_LOCALIZING_BUNDLE);
                        string3 = attributeList.getValue(AnnotationTypeProcessor.ATTR_TYPE_DESCRIPTION_KEY);
                        this.at.putProp((Object)"bundle", (Object)string4);
                        this.at.putProp((Object)"desciptionKey", (Object)string3);
                    }
                    string4 = attributeList.getValue(AnnotationTypeProcessor.ATTR_USE_HIHGLIGHT_COLOR);
                    string3 = attributeList.getValue(AnnotationTypeProcessor.ATTR_USE_WAVE_UNDERLINE_COLOR);
                    String string5 = attributeList.getValue(AnnotationTypeProcessor.ATTR_INHERIT_FOREGROUND_COLOR);
                    String string6 = attributeList.getValue(AnnotationTypeProcessor.ATTR_USE_CUSTOM_SIDEBAR_COLOR);
                    this.at.setUseHighlightColor(Boolean.valueOf(string4).booleanValue());
                    this.at.setUseWaveUnderlineColor(Boolean.valueOf(string3).booleanValue());
                    this.at.setInheritForegroundColor(Boolean.valueOf(string5).booleanValue());
                    this.at.setUseCustomSidebarColor(Boolean.valueOf(string6).booleanValue());
                    try {
                        string2 = attributeList.getValue(AnnotationTypeProcessor.ATTR_TYPE_HIGHLIGHT);
                        if (string2 != null) {
                            this.at.setHighlight(Color.decode(string2));
                            if (string4 == null) {
                                this.at.setUseHighlightColor(true);
                            }
                        } else if (string4 == null) {
                            this.at.setUseHighlightColor(false);
                        }
                        if ((string2 = attributeList.getValue(AnnotationTypeProcessor.ATTR_TYPE_FOREGROUND)) != null) {
                            this.at.setForegroundColor(Color.decode(string2));
                            if (string5 == null) {
                                this.at.setInheritForegroundColor(false);
                            }
                        } else if (string5 == null) {
                            this.at.setInheritForegroundColor(true);
                        }
                        if ((string2 = attributeList.getValue(AnnotationTypeProcessor.ATTR_TYPE_WAVEUNDERLINE)) != null) {
                            this.at.setWaveUnderlineColor(Color.decode(string2));
                            if (string3 == null) {
                                this.at.setUseWaveUnderlineColor(true);
                            }
                        } else if (string3 == null) {
                            this.at.setUseWaveUnderlineColor(false);
                        }
                        if ((string2 = attributeList.getValue(AnnotationTypeProcessor.ATTR_CUSTOM_SIDEBAR_COLOR)) != null) {
                            this.at.setCustomSidebarColor(Color.decode(string2));
                            if (string6 == null) {
                                this.at.setUseCustomSidebarColor(true);
                            }
                        } else if (string6 == null) {
                            this.at.setUseCustomSidebarColor(false);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.rethrow(numberFormatException);
                    }
                    try {
                        string2 = attributeList.getValue(AnnotationTypeProcessor.ATTR_TYPE_GLYPH);
                        if (string2 != null) {
                            this.at.setGlyph(new URL(string2));
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.rethrow(malformedURLException);
                    }
                    string2 = attributeList.getValue(AnnotationTypeProcessor.ATTR_TYPE_ACTIONS);
                    if (string2 != null) {
                        AnnotationTypeActionsFolder.readActions(this.at, string2);
                        this.at.putProp((Object)"actionsFolder", (Object)string2);
                    }
                    this.at.setSeverity(AnnotationType.Severity.valueOf((String)attributeList.getValue(AnnotationTypeProcessor.ATTR_SEVERITY)));
                    this.at.setBrowseable(Boolean.valueOf(attributeList.getValue(AnnotationTypeProcessor.ATTR_BROWSEABLE)).booleanValue());
                    String string7 = attributeList.getValue(AnnotationTypeProcessor.ATTR_PRIORITY);
                    int n = 0;
                    if (string7 != null) {
                        try {
                            n = Integer.parseInt(string7);
                        }
                        catch (NumberFormatException numberFormatException) {
                            ErrorManager.getDefault().notify(1, (Throwable)numberFormatException);
                        }
                    }
                    this.at.setPriority(n);
                    break;
                }
                case 1: {
                    String string8;
                    String string9;
                    if (!AnnotationTypeProcessor.TAG_COMBINATION.equals(string)) {
                        throw new SAXException("malformed AnnotationType xml file");
                    }
                    this.combinations = new ArrayList();
                    String string10 = attributeList.getValue(AnnotationTypeProcessor.ATTR_COMBINATION_TIPTEXT_KEY);
                    if (string10 != null) {
                        this.at.putProp((Object)"tooltipTextKey", (Object)string10);
                    }
                    if ((string9 = attributeList.getValue(AnnotationTypeProcessor.ATTR_COMBINATION_ORDER)) != null) {
                        this.at.setCombinationOrder(string9);
                    }
                    if ((string8 = attributeList.getValue(AnnotationTypeProcessor.ATTR_COMBINATION_MIN_OPTIONALS)) == null) break;
                    this.at.setMinimumOptionals(string8);
                    break;
                }
                case 2: {
                    this.combinations.add(new AnnotationType.CombinationMember(attributeList.getValue(AnnotationTypeProcessor.ATTR_COMBINE_ANNOTATIONTYPE), attributeList.getValue(AnnotationTypeProcessor.ATTR_COMBINE_ABSORBALL) == null ? false : "true".equals(attributeList.getValue(AnnotationTypeProcessor.ATTR_COMBINE_ABSORBALL)), attributeList.getValue(AnnotationTypeProcessor.ATTR_COMBINE_OPTIONAL) == null ? false : "true".equals(attributeList.getValue(AnnotationTypeProcessor.ATTR_COMBINE_OPTIONAL)), attributeList.getValue(AnnotationTypeProcessor.ATTR_COMBINE_MIN)));
                    break;
                }
                default: {
                    throw new SAXException("malformed AnnotationType xml file");
                }
            }
        }

        public void endElement(String string) throws SAXException {
            if (--this.depth == 1) {
                AnnotationType.CombinationMember[] combinationMemberArray = new AnnotationType.CombinationMember[this.combinations.size()];
                this.combinations.toArray(combinationMemberArray);
                this.at.setCombinations(combinationMemberArray);
            }
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (AnnotationTypeProcessor.DTD_PUBLIC_ID.equals(string)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            if (AnnotationTypeProcessor.DTD_PUBLIC_ID11.equals(string)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return new InputSource(string2);
        }
    }
}

