/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.samples;

import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.filesystems.FileObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class OpenSampleAction
extends AbstractAction {
    private String key = null;

    public static Action createAction(FileObject fo) {
        OpenSampleAction action = new OpenSampleAction();
        String s = (String)fo.getAttribute("key");
        action.putValue("Name", NbBundle.getMessage(OpenSampleAction.class, (String)s));
        action.setKey(s);
        return action;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void actionPerformed(ActionEvent e) {
        File sampleDir = InstalledFileLocator.getDefault().locate("samples", null, false);
        if (sampleDir != null && sampleDir.exists()) {
            if ((sampleDir = new File(sampleDir, this.key)).exists()) {
                final File[] jrxmls = sampleDir.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".jrxml");
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        for (File f : jrxmls) {
                            Misc.openFile((File)f);
                        }
                    }
                });
            } else {
                JOptionPane.showMessageDialog(Misc.getMainFrame(), "Unable to locate the directory " + sampleDir.getPath());
            }
        } else {
            JOptionPane.showMessageDialog(Misc.getMainFrame(), "Unable to locate the directory samples/" + this.key);
        }
    }
}

