/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.compatibility;

import com.jaspersoft.ireport.designer.ModelUtils;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentXmlWriter;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import net.sf.jasperreports.engine.xml.XmlWriterVisitor;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.time.Day;

public class JRXmlWriter_3_5_1
extends JRXmlWriter {
    public static final XmlNamespace JASPERREPORTS_NAMESPACE = new XmlNamespace("http://jasperreports.sourceforge.net/jasperreports", null, "http://jasperreports.sourceforge.net/xsd/jasperreport.xsd");
    private JRReport report = null;
    private String encoding = null;
    private Map fontsMap = new HashMap();
    private XmlWriterVisitor xmlWriterVisitor = new XmlWriterVisitor((JRXmlWriter)this);

    protected JRXmlWriter_3_5_1(JRReport report, String encoding) {
        super(report, encoding);
        this.report = report;
        this.encoding = encoding;
    }

    public static String writeReport(JRReport report, String encoding) {
        JRXmlWriter_3_5_1 writer = new JRXmlWriter_3_5_1(report, encoding);
        StringWriter buffer = new StringWriter();
        try {
            writer.writeReport(buffer);
        }
        catch (IOException e) {
            throw new JRRuntimeException("Error writing report design.", (Throwable)e);
        }
        return buffer.toString();
    }

    public static void writeReport(JRReport report, String destFileName, String encoding) throws JRException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(destFileName);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, encoding);
            JRXmlWriter_3_5_1 writer = new JRXmlWriter_3_5_1(report, encoding);
            writer.writeReport(out);
        }
        catch (IOException e) {
            throw new JRException("Error writing to file : " + destFileName, (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void writeReport(JRReport report, OutputStream outputStream, String encoding) throws JRException {
        try {
            OutputStreamWriter out = new OutputStreamWriter(outputStream, encoding);
            JRXmlWriter_3_5_1 writer = new JRXmlWriter_3_5_1(report, encoding);
            writer.writeReport(out);
        }
        catch (Exception e) {
            throw new JRException("Error writing to OutputStream : " + report.getName(), (Throwable)e);
        }
    }

    protected void writeReport(Writer out) throws IOException {
        JRDataset[] datasets;
        JRStyle[] styles;
        this.useWriter(new JRXmlWriteHelper(out));
        this.writer.writeProlog(this.encoding);
        this.writer.startElement("jasperReport", this.getNamespace());
        this.writer.addEncodedAttribute("name", this.report.getName());
        this.writer.addEncodedAttribute("language", this.report.getLanguage(), "java");
        this.writer.addAttribute("columnCount", this.report.getColumnCount(), 1);
        this.writer.addAttribute("printOrder", this.report.getPrintOrder(), JRXmlConstants.getPrintOrderMap(), (byte)1);
        this.writer.addAttribute("pageWidth", this.report.getPageWidth());
        this.writer.addAttribute("pageHeight", this.report.getPageHeight());
        this.writer.addAttribute("orientation", this.report.getOrientation(), JRXmlConstants.getOrientationMap(), (byte)1);
        this.writer.addAttribute("whenNoDataType", this.report.getWhenNoDataType(), JRXmlConstants.getWhenNoDataTypeMap(), (byte)1);
        this.writer.addAttribute("columnWidth", this.report.getColumnWidth());
        this.writer.addAttribute("columnSpacing", this.report.getColumnSpacing(), 0);
        this.writer.addAttribute("leftMargin", this.report.getLeftMargin());
        this.writer.addAttribute("rightMargin", this.report.getRightMargin());
        this.writer.addAttribute("topMargin", this.report.getTopMargin());
        this.writer.addAttribute("bottomMargin", this.report.getBottomMargin());
        this.writer.addAttribute("isTitleNewPage", this.report.isTitleNewPage(), false);
        this.writer.addAttribute("isSummaryNewPage", this.report.isSummaryNewPage(), false);
        this.writer.addAttribute("isFloatColumnFooter", this.report.isFloatColumnFooter(), false);
        this.writer.addAttribute("scriptletClass", this.report.getScriptletClass());
        this.writer.addAttribute("formatFactoryClass", this.report.getFormatFactoryClass());
        this.writer.addEncodedAttribute("resourceBundle", this.report.getResourceBundle());
        this.writer.addAttribute("whenResourceMissingType", this.report.getWhenResourceMissingType(), JRXmlConstants.getWhenResourceMissingTypeMap(), (byte)1);
        this.writer.addAttribute("isIgnorePagination", this.report.isIgnorePagination(), false);
        this.writeProperties((JRPropertiesHolder)this.report);
        String[] imports = this.report.getImports();
        if (imports != null && imports.length > 0) {
            for (int i = 0; i < imports.length; ++i) {
                String value = imports[i];
                if (value == null) continue;
                this.writer.startElement("import");
                this.writer.addEncodedAttribute("value", value);
                this.writer.closeElement();
            }
        }
        this.writeTemplates();
        JRReportFont[] fonts = this.report.getFonts();
        if (fonts != null && fonts.length > 0) {
            for (int i = 0; i < fonts.length; ++i) {
                this.fontsMap.put(fonts[i].getName(), fonts[i]);
                this.writeReportFont(fonts[i]);
            }
        }
        if ((styles = this.report.getStyles()) != null && styles.length > 0) {
            for (int i = 0; i < styles.length; ++i) {
                this.writeStyle(styles[i]);
            }
        }
        if ((datasets = this.report.getDatasets()) != null && datasets.length > 0) {
            for (int i = 0; i < datasets.length; ++i) {
                this.writeDataset(datasets[i]);
            }
        }
        this.writeDatasetContents(this.report.getMainDataset());
        if (this.report.getBackground() != null) {
            this.writer.startElement("background");
            this.writeBand(this.report.getBackground());
            this.writer.closeElement();
        }
        if (this.report.getTitle() != null) {
            this.writer.startElement("title");
            this.writeBand(this.report.getTitle());
            this.writer.closeElement();
        }
        if (this.report.getPageHeader() != null) {
            this.writer.startElement("pageHeader");
            this.writeBand(this.report.getPageHeader());
            this.writer.closeElement();
        }
        if (this.report.getColumnHeader() != null) {
            this.writer.startElement("columnHeader");
            this.writeBand(this.report.getColumnHeader());
            this.writer.closeElement();
        }
        if (this.report.getDetail() != null) {
            this.writer.startElement("detail");
            this.writeBand(this.report.getDetail());
            this.writer.closeElement();
        }
        if (this.report.getColumnFooter() != null) {
            this.writer.startElement("columnFooter");
            this.writeBand(this.report.getColumnFooter());
            this.writer.closeElement();
        }
        if (this.report.getPageFooter() != null) {
            this.writer.startElement("pageFooter");
            this.writeBand(this.report.getPageFooter());
            this.writer.closeElement();
        }
        if (this.report.getLastPageFooter() != null) {
            this.writer.startElement("lastPageFooter");
            this.writeBand(this.report.getLastPageFooter());
            this.writer.closeElement();
        }
        if (this.report.getSummary() != null) {
            this.writer.startElement("summary");
            this.writeBand(this.report.getSummary());
            this.writer.closeElement();
        }
        if (this.report.getNoData() != null) {
            this.writer.startElement("noData");
            this.writeBand(this.report.getNoData());
            this.writer.closeElement();
        }
        this.writer.closeElement();
        out.flush();
    }

    private void writeProperties(JRPropertiesHolder propertiesHolder) throws IOException {
        JRPropertiesMap propertiesMap;
        String[] propertyNames;
        if (propertiesHolder.hasProperties() && (propertyNames = (propertiesMap = propertiesHolder.getPropertiesMap()).getPropertyNames()) != null && propertyNames.length > 0) {
            for (int i = 0; i < propertyNames.length; ++i) {
                this.writer.startElement("property");
                this.writer.addEncodedAttribute("name", propertyNames[i]);
                String value = propertiesMap.getProperty(propertyNames[i]);
                if (value != null) {
                    this.writer.addEncodedAttribute("value", value);
                }
                this.writer.closeElement();
            }
        }
    }

    protected void writeTemplates() throws IOException {
        JRReportTemplate[] templates = this.report.getTemplates();
        if (templates != null) {
            for (int i = 0; i < templates.length; ++i) {
                JRReportTemplate template = templates[i];
                this.writeTemplate(template);
            }
        }
    }

    protected void writeTemplate(JRReportTemplate template) throws IOException {
        this.writer.writeExpression("template", template.getSourceExpression(), true, String.class.getName());
    }

    private void writeReportFont(JRReportFont font) throws IOException {
        this.writer.startElement("reportFont");
        this.writer.addEncodedAttribute("name", font.getName());
        this.writer.addAttribute("isDefault", font.isDefault());
        this.writer.addEncodedAttribute("fontName", font.getOwnFontName());
        this.writer.addAttribute("size", (Object)font.getOwnFontSize());
        this.writer.addAttribute("isBold", (Object)font.isOwnBold());
        this.writer.addAttribute("isItalic", (Object)font.isOwnItalic());
        this.writer.addAttribute("isUnderline", (Object)font.isOwnUnderline());
        this.writer.addAttribute("isStrikeThrough", (Object)font.isOwnStrikeThrough());
        this.writer.addEncodedAttribute("pdfFontName", font.getOwnPdfFontName());
        this.writer.addEncodedAttribute("pdfEncoding", font.getOwnPdfEncoding());
        this.writer.addAttribute("isPdfEmbedded", (Object)font.isOwnPdfEmbedded());
        this.writer.closeElement();
    }

    private void writeScriptlet(JRScriptlet scriptlet) throws IOException {
        this.writer.startElement("scriptlet");
        this.writer.addEncodedAttribute("name", scriptlet.getName());
        this.writer.addAttribute("class", scriptlet.getValueClassName());
        this.writeProperties((JRPropertiesHolder)scriptlet);
        this.writer.writeCDATAElement("scriptletDescription", scriptlet.getDescription());
        this.writer.closeElement();
    }

    private void writeParameter(JRParameter parameter) throws IOException {
        this.writer.startElement("parameter");
        this.writer.addEncodedAttribute("name", parameter.getName());
        this.writer.addAttribute("class", parameter.getValueClassName());
        this.writer.addAttribute("nestedType", parameter.getNestedTypeName());
        this.writer.addAttribute("isForPrompting", parameter.isForPrompting(), true);
        this.writeProperties((JRPropertiesHolder)parameter);
        this.writer.writeCDATAElement("parameterDescription", parameter.getDescription());
        this.writer.writeExpression("defaultValueExpression", parameter.getDefaultValueExpression(), false);
        this.writer.closeElement();
    }

    private void writeQuery(JRQuery query) throws IOException {
        this.writer.startElement("queryString");
        this.writer.addEncodedAttribute("language", query.getLanguage(), "sql");
        this.writer.writeCDATA(query.getText());
        this.writer.closeElement();
    }

    private void writeField(JRField field) throws IOException {
        this.writer.startElement("field");
        this.writer.addEncodedAttribute("name", field.getName());
        this.writer.addAttribute("class", field.getValueClassName());
        this.writeProperties((JRPropertiesHolder)field);
        this.writer.writeCDATAElement("fieldDescription", field.getDescription());
        this.writer.closeElement();
    }

    private void writeSortField(JRSortField sortField) throws IOException {
        this.writer.startElement("sortField");
        this.writer.addEncodedAttribute("name", sortField.getName());
        this.writer.addAttribute("order", sortField.getOrder(), JRXmlConstants.getSortOrderMap(), (byte)0);
        this.writer.closeElement();
    }

    private void writeVariable(JRVariable variable) throws IOException {
        this.writer.startElement("variable");
        this.writer.addEncodedAttribute("name", variable.getName());
        this.writer.addAttribute("class", variable.getValueClassName());
        this.writer.addAttribute("resetType", variable.getResetType(), JRXmlConstants.getResetTypeMap(), (byte)1);
        if (variable.getResetGroup() != null) {
            this.writer.addEncodedAttribute("resetGroup", variable.getResetGroup().getName());
        }
        this.writer.addAttribute("incrementType", variable.getIncrementType(), JRXmlConstants.getResetTypeMap(), (byte)5);
        if (variable.getIncrementGroup() != null) {
            this.writer.addEncodedAttribute("incrementGroup", variable.getIncrementGroup().getName());
        }
        this.writer.addAttribute("calculation", variable.getCalculation(), JRXmlConstants.getCalculationMap(), (byte)0);
        this.writer.addAttribute("incrementerFactoryClass", variable.getIncrementerFactoryClassName());
        this.writer.writeExpression("variableExpression", variable.getExpression(), false);
        this.writer.writeExpression("initialValueExpression", variable.getInitialValueExpression(), false);
        this.writer.closeElement();
    }

    private void writeGroup(JRGroup group) throws IOException {
        this.writer.startElement("group");
        this.writer.addEncodedAttribute("name", group.getName());
        this.writer.addAttribute("isStartNewColumn", group.isStartNewColumn(), false);
        this.writer.addAttribute("isStartNewPage", group.isStartNewPage(), false);
        this.writer.addAttribute("isResetPageNumber", group.isResetPageNumber(), false);
        this.writer.addAttribute("isReprintHeaderOnEachPage", group.isReprintHeaderOnEachPage(), false);
        this.writer.addAttributePositive("minHeightToStartNewPage", group.getMinHeightToStartNewPage());
        this.writer.writeExpression("groupExpression", group.getExpression(), false);
        if (group.getGroupHeader() != null) {
            this.writer.startElement("groupHeader");
            this.writeBand(group.getGroupHeader());
            this.writer.closeElement();
        }
        if (ModelUtils.getGroupFooter(group) != null) {
            this.writer.startElement("groupFooter");
            this.writeBand(ModelUtils.getGroupFooter(group));
            this.writer.closeElement();
        }
        this.writer.closeElement();
    }

    private void writeBand(JRBand band) throws IOException {
        this.writer.startElement("band");
        this.writer.addAttributePositive("height", band.getHeight());
        this.writer.addAttribute("isSplitAllowed", band.isSplitAllowed(), true);
        this.writer.writeExpression("printWhenExpression", band.getPrintWhenExpression(), false);
        this.writeChildElements((JRElementGroup)band);
        this.writer.closeElement();
    }

    public void writeChildElements(JRElementGroup elementContainer) {
        List children = elementContainer.getChildren();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                ((JRChild)children.get(i)).visit((JRVisitor)this.xmlWriterVisitor);
            }
        }
    }

    public void writeElementGroup(JRElementGroup elementGroup) throws IOException {
        this.writer.startElement("elementGroup", this.getNamespace());
        this.writeChildElements(elementGroup);
        this.writer.closeElement();
    }

    public void writeBreak(JRBreak breakElement) throws IOException {
        this.writer.startElement("break", this.getNamespace());
        this.writer.addAttribute("type", breakElement.getType(), JRXmlConstants.getBreakTypeMap(), (byte)1);
        this.writeReportElement((JRElement)breakElement);
        this.writer.closeElement();
    }

    public void writeLine(JRLine line) throws IOException {
        this.writer.startElement("line", this.getNamespace());
        this.writer.addAttribute("direction", line.getDirection(), JRXmlConstants.getDirectionMap(), (byte)1);
        this.writeReportElement((JRElement)line);
        this.writeGraphicElement((JRGraphicElement)line);
        this.writer.closeElement();
    }

    private void writeReportElement(JRElement element) throws IOException {
        this.writer.startElement("reportElement");
        this.writer.addEncodedAttribute("key", element.getKey());
        this.writeStyleReferenceAttr((JRStyleContainer)element);
        this.writer.addAttribute("positionType", element.getPositionType(), JRXmlConstants.getPositionTypeMap(), (byte)2);
        this.writer.addAttribute("stretchType", element.getStretchType(), JRXmlConstants.getStretchTypeMap(), (byte)0);
        this.writer.addAttribute("isPrintRepeatedValues", element.isPrintRepeatedValues(), true);
        this.writer.addAttribute("mode", (Object)element.getOwnMode(), JRXmlConstants.getModeMap());
        this.writer.addAttribute("x", element.getX());
        this.writer.addAttribute("y", element.getY());
        this.writer.addAttribute("width", element.getWidth());
        this.writer.addAttribute("height", element.getHeight());
        this.writer.addAttribute("isRemoveLineWhenBlank", element.isRemoveLineWhenBlank(), false);
        this.writer.addAttribute("isPrintInFirstWholeBand", element.isPrintInFirstWholeBand(), false);
        this.writer.addAttribute("isPrintWhenDetailOverflows", element.isPrintWhenDetailOverflows(), false);
        if (element.getPrintWhenGroupChanges() != null) {
            this.writer.addEncodedAttribute("printWhenGroupChanges", element.getPrintWhenGroupChanges().getName());
        }
        this.writer.addAttribute("forecolor", element.getOwnForecolor());
        this.writer.addAttribute("backcolor", element.getOwnBackcolor());
        this.writeProperties((JRPropertiesHolder)element);
        this.writePropertyExpressions(element.getPropertyExpressions());
        this.writer.writeExpression("printWhenExpression", element.getPrintWhenExpression(), false);
        this.writer.closeElement();
    }

    protected void writePropertyExpressions(JRPropertyExpression[] propertyExpressions) throws IOException {
        if (propertyExpressions != null) {
            for (int i = 0; i < propertyExpressions.length; ++i) {
                this.writePropertyExpression(propertyExpressions[i]);
            }
        }
    }

    protected void writePropertyExpression(JRPropertyExpression propertyExpression) throws IOException {
        String expressionText = propertyExpression.getValueExpression().getText();
        this.writer.writeCDATAElement("propertyExpression", expressionText, "name", propertyExpression.getName());
    }

    private void writeGraphicElement(JRGraphicElement element) throws IOException {
        this.writer.startElement("graphicElement");
        this.writer.addAttribute("fill", (Object)element.getOwnFill(), JRXmlConstants.getFillMap());
        this.writePen(element.getLinePen());
        this.writer.closeElement(true);
    }

    public void writeRectangle(JRRectangle rectangle) throws IOException {
        this.writer.startElement("rectangle", this.getNamespace());
        this.writer.addAttribute("radius", (Object)rectangle.getOwnRadius());
        this.writeReportElement((JRElement)rectangle);
        this.writeGraphicElement((JRGraphicElement)rectangle);
        this.writer.closeElement();
    }

    public void writeEllipse(JREllipse ellipse) throws IOException {
        this.writer.startElement("ellipse", this.getNamespace());
        this.writeReportElement((JRElement)ellipse);
        this.writeGraphicElement((JRGraphicElement)ellipse);
        this.writer.closeElement();
    }

    public void writeImage(JRImage image) throws IOException {
        this.writer.startElement("image", this.getNamespace());
        this.writer.addAttribute("scaleImage", (Object)image.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.writer.addAttribute("hAlign", (Object)image.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.writer.addAttribute("vAlign", (Object)image.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.writer.addAttribute("isUsingCache", (Object)image.isOwnUsingCache());
        this.writer.addAttribute("isLazy", image.isLazy(), false);
        this.writer.addAttribute("onErrorType", image.getOnErrorType(), JRXmlConstants.getOnErrorTypeMap(), (byte)1);
        this.writer.addAttribute("evaluationTime", image.getEvaluationTime(), JRXmlConstants.getEvaluationTimeMap(), (byte)1);
        if (image.getEvaluationGroup() != null) {
            this.writer.addEncodedAttribute("evaluationGroup", image.getEvaluationGroup().getName());
        }
        this.writer.addEncodedAttribute("hyperlinkType", image.getLinkType(), "None");
        this.writer.addEncodedAttribute("hyperlinkTarget", image.getLinkTarget(), "Self");
        this.writer.addAttribute("bookmarkLevel", image.getBookmarkLevel(), 0);
        this.writeReportElement((JRElement)image);
        this.writeBox(image.getLineBox());
        this.writeGraphicElement((JRGraphicElement)image);
        this.writer.writeExpression("imageExpression", image.getExpression(), true);
        this.writer.writeExpression("anchorNameExpression", image.getAnchorNameExpression(), false);
        this.writer.writeExpression("hyperlinkReferenceExpression", image.getHyperlinkReferenceExpression(), false);
        this.writer.writeExpression("hyperlinkAnchorExpression", image.getHyperlinkAnchorExpression(), false);
        this.writer.writeExpression("hyperlinkPageExpression", image.getHyperlinkPageExpression(), false);
        this.writer.writeExpression("hyperlinkTooltipExpression", image.getHyperlinkTooltipExpression(), false);
        this.writeHyperlinkParameters(image.getHyperlinkParameters());
        this.writer.closeElement();
    }

    public void writeStaticText(JRStaticText staticText) throws IOException {
        this.writer.startElement("staticText", this.getNamespace());
        this.writeReportElement((JRElement)staticText);
        this.writeBox(staticText.getLineBox());
        this.writeTextElement((JRTextElement)staticText);
        this.writer.writeCDATAElement("text", staticText.getText());
        this.writer.closeElement();
    }

    private void writeTextElement(JRTextElement textElement) throws IOException {
        this.writer.startElement("textElement");
        this.writer.addAttribute("textAlignment", (Object)textElement.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.writer.addAttribute("verticalAlignment", (Object)textElement.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.writer.addAttribute("rotation", (Object)textElement.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.writer.addAttribute("lineSpacing", (Object)textElement.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.writer.addAttribute("markup", textElement.getOwnMarkup());
        this.writeFont((JRFont)textElement);
        this.writer.closeElement();
    }

    private void writeFont(JRFont font) throws IOException {
        if (font != null) {
            this.writer.startElement("font");
            if (font.getReportFont() != null) {
                JRFont baseFont = (JRFont)this.fontsMap.get(font.getReportFont().getName());
                if (baseFont != null) {
                    this.writer.addEncodedAttribute("reportFont", font.getReportFont().getName());
                } else {
                    throw new JRRuntimeException("Referenced report font not found : " + font.getReportFont().getName());
                }
            }
            this.writer.addEncodedAttribute("fontName", font.getOwnFontName());
            this.writer.addAttribute("size", (Object)font.getOwnFontSize());
            this.writer.addAttribute("isBold", (Object)font.isOwnBold());
            this.writer.addAttribute("isItalic", (Object)font.isOwnItalic());
            this.writer.addAttribute("isUnderline", (Object)font.isOwnUnderline());
            this.writer.addAttribute("isStrikeThrough", (Object)font.isOwnStrikeThrough());
            this.writer.addEncodedAttribute("pdfFontName", font.getOwnPdfFontName());
            this.writer.addEncodedAttribute("pdfEncoding", font.getOwnPdfEncoding());
            this.writer.addAttribute("isPdfEmbedded", (Object)font.isOwnPdfEmbedded());
            this.writer.closeElement(true);
        }
    }

    public void writeTextField(JRTextField textField) throws IOException {
        this.writer.startElement("textField", this.getNamespace());
        this.writer.addAttribute("isStretchWithOverflow", textField.isStretchWithOverflow(), false);
        this.writer.addAttribute("evaluationTime", textField.getEvaluationTime(), JRXmlConstants.getEvaluationTimeMap(), (byte)1);
        if (textField.getEvaluationGroup() != null) {
            this.writer.addEncodedAttribute("evaluationGroup", textField.getEvaluationGroup().getName());
        }
        this.writer.addEncodedAttribute("pattern", textField.getOwnPattern());
        this.writer.addAttribute("isBlankWhenNull", (Object)textField.isOwnBlankWhenNull());
        this.writer.addEncodedAttribute("hyperlinkType", textField.getLinkType(), "None");
        this.writer.addEncodedAttribute("hyperlinkTarget", textField.getLinkTarget(), "Self");
        this.writer.addAttribute("bookmarkLevel", textField.getBookmarkLevel(), 0);
        this.writeReportElement((JRElement)textField);
        this.writeBox(textField.getLineBox());
        this.writeTextElement((JRTextElement)textField);
        this.writer.writeExpression("textFieldExpression", textField.getExpression(), true);
        this.writer.writeExpression("anchorNameExpression", textField.getAnchorNameExpression(), false);
        this.writer.writeExpression("hyperlinkReferenceExpression", textField.getHyperlinkReferenceExpression(), false);
        this.writer.writeExpression("hyperlinkAnchorExpression", textField.getHyperlinkAnchorExpression(), false);
        this.writer.writeExpression("hyperlinkPageExpression", textField.getHyperlinkPageExpression(), false);
        this.writer.writeExpression("hyperlinkTooltipExpression", textField.getHyperlinkTooltipExpression(), false);
        this.writeHyperlinkParameters(textField.getHyperlinkParameters());
        this.writer.closeElement();
    }

    public void writeSubreport(JRSubreport subreport) throws IOException {
        this.writer.startElement("subreport", this.getNamespace());
        this.writer.addAttribute("isUsingCache", (Object)subreport.isOwnUsingCache());
        this.writer.addAttribute("runToBottom", (Object)subreport.isRunToBottom());
        this.writeReportElement((JRElement)subreport);
        this.writer.writeExpression("parametersMapExpression", subreport.getParametersMapExpression(), false);
        JRSubreportParameter[] parameters = subreport.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                this.writeSubreportParameter(parameters[i]);
            }
        }
        this.writer.writeExpression("connectionExpression", subreport.getConnectionExpression(), false);
        this.writer.writeExpression("dataSourceExpression", subreport.getDataSourceExpression(), false);
        JRSubreportReturnValue[] returnValues = subreport.getReturnValues();
        if (returnValues != null && returnValues.length > 0) {
            for (int i = 0; i < returnValues.length; ++i) {
                this.writeSubreportReturnValue(returnValues[i]);
            }
        }
        this.writer.writeExpression("subreportExpression", subreport.getExpression(), true);
        this.writer.closeElement();
    }

    private void writeSubreportParameter(JRSubreportParameter subreportParameter) throws IOException {
        this.writer.startElement("subreportParameter");
        this.writer.addEncodedAttribute("name", subreportParameter.getName());
        this.writer.writeExpression("subreportParameterExpression", subreportParameter.getExpression(), false);
        this.writer.closeElement();
    }

    private void writeDatasetParameter(JRDatasetParameter datasetParameter) throws IOException {
        this.writer.startElement("datasetParameter");
        this.writer.addEncodedAttribute("name", datasetParameter.getName());
        this.writer.writeExpression("datasetParameterExpression", datasetParameter.getExpression(), false);
        this.writer.closeElement();
    }

    private void writeChart(JRChart chart) throws IOException {
        this.writer.startElement("chart");
        this.writer.addAttribute("isShowLegend", (Object)chart.getShowLegend());
        this.writer.addAttribute("evaluationTime", chart.getEvaluationTime(), JRXmlConstants.getEvaluationTimeMap(), (byte)1);
        if (chart.getEvaluationTime() == 5) {
            this.writer.addEncodedAttribute("evaluationGroup", chart.getEvaluationGroup().getName());
        }
        this.writer.addEncodedAttribute("hyperlinkType", chart.getLinkType(), "None");
        this.writer.addEncodedAttribute("hyperlinkTarget", chart.getLinkTarget(), "Self");
        this.writer.addAttribute("bookmarkLevel", chart.getBookmarkLevel(), 0);
        this.writer.addAttribute("customizerClass", chart.getCustomizerClass());
        this.writer.addEncodedAttribute("renderType", chart.getRenderType());
        this.writer.addEncodedAttribute("theme", chart.getTheme());
        this.writeReportElement((JRElement)chart);
        this.writeBox(chart.getLineBox());
        this.writer.startElement("chartTitle");
        this.writer.addAttribute("position", (Object)chart.getTitlePositionByte(), JRXmlConstants.getChartEdgeMap());
        this.writer.addAttribute("color", chart.getOwnTitleColor());
        this.writeFont(chart.getTitleFont());
        if (chart.getTitleExpression() != null) {
            this.writer.writeExpression("titleExpression", chart.getTitleExpression(), false);
        }
        this.writer.closeElement();
        this.writer.startElement("chartSubtitle");
        this.writer.addAttribute("color", chart.getOwnSubtitleColor());
        this.writeFont(chart.getSubtitleFont());
        if (chart.getSubtitleExpression() != null) {
            this.writer.writeExpression("subtitleExpression", chart.getSubtitleExpression(), false);
        }
        this.writer.closeElement();
        this.writer.startElement("chartLegend");
        if (chart.getOwnLegendColor() != null) {
            this.writer.addAttribute("textColor", chart.getOwnLegendColor());
        }
        if (chart.getOwnLegendBackgroundColor() != null) {
            this.writer.addAttribute("backgroundColor", chart.getOwnLegendBackgroundColor());
        }
        this.writer.addAttribute("position", (Object)chart.getLegendPositionByte(), JRXmlConstants.getChartEdgeMap());
        this.writeFont(chart.getLegendFont());
        this.writer.closeElement();
        this.writer.writeExpression("anchorNameExpression", chart.getAnchorNameExpression(), false);
        this.writer.writeExpression("hyperlinkReferenceExpression", chart.getHyperlinkReferenceExpression(), false);
        this.writer.writeExpression("hyperlinkAnchorExpression", chart.getHyperlinkAnchorExpression(), false);
        this.writer.writeExpression("hyperlinkPageExpression", chart.getHyperlinkPageExpression(), false);
        this.writer.writeExpression("hyperlinkTooltipExpression", chart.getHyperlinkTooltipExpression(), false);
        this.writeHyperlinkParameters(chart.getHyperlinkParameters());
        this.writer.closeElement();
    }

    public void writeElementDataset(JRElementDataset dataset) throws IOException {
        this.writeElementDataset(dataset, true);
    }

    public void writeElementDataset(JRElementDataset dataset, boolean skipIfEmpty) throws IOException {
        this.writer.startElement("dataset", this.getNamespace());
        this.writer.addAttribute("resetType", dataset.getResetType(), JRXmlConstants.getResetTypeMap(), (byte)1);
        if (dataset.getResetType() == 4) {
            this.writer.addEncodedAttribute("resetGroup", dataset.getResetGroup().getName());
        }
        this.writer.addAttribute("incrementType", dataset.getIncrementType(), JRXmlConstants.getResetTypeMap(), (byte)5);
        if (dataset.getIncrementType() == 4) {
            this.writer.addEncodedAttribute("incrementGroup", dataset.getIncrementGroup().getName());
        }
        this.writer.writeExpression("incrementWhenExpression", dataset.getIncrementWhenExpression(), false);
        JRDatasetRun datasetRun = dataset.getDatasetRun();
        if (datasetRun != null) {
            this.writeDatasetRun(datasetRun);
        }
        this.writer.closeElement(skipIfEmpty);
    }

    private void writeCategoryDataSet(JRCategoryDataset dataset) throws IOException {
        this.writer.startElement("categoryDataset");
        this.writeElementDataset((JRElementDataset)dataset);
        JRCategorySeries[] categorySeries = dataset.getSeries();
        if (categorySeries != null && categorySeries.length > 0) {
            for (int i = 0; i < categorySeries.length; ++i) {
                this.writeCategorySeries(categorySeries[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeTimeSeriesDataset(JRTimeSeriesDataset dataset) throws IOException {
        this.writer.startElement("timeSeriesDataset");
        if (dataset.getTimePeriod() != null && !Day.class.getName().equals(dataset.getTimePeriod().getName())) {
            this.writer.addAttribute("timePeriod", JRXmlConstants.getTimePeriodName((Class)dataset.getTimePeriod()));
        }
        this.writeElementDataset((JRElementDataset)dataset);
        JRTimeSeries[] timeSeries = dataset.getSeries();
        if (timeSeries != null && timeSeries.length > 0) {
            for (int i = 0; i < timeSeries.length; ++i) {
                this.writeTimeSeries(timeSeries[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeGanttDataset(JRGanttDataset dataset) throws IOException {
        this.writer.startElement("ganttDataset");
        this.writeElementDataset((JRElementDataset)dataset);
        JRGanttSeries[] ganttSeries = dataset.getSeries();
        if (ganttSeries != null && ganttSeries.length > 0) {
            for (int i = 0; i < ganttSeries.length; ++i) {
                this.writeGanttSeries(ganttSeries[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeTimePeriodDataset(JRTimePeriodDataset dataset) throws IOException {
        this.writer.startElement("timePeriodDataset");
        this.writeElementDataset((JRElementDataset)dataset);
        JRTimePeriodSeries[] timePeriodSeries = dataset.getSeries();
        if (timePeriodSeries != null && timePeriodSeries.length > 0) {
            for (int i = 0; i < timePeriodSeries.length; ++i) {
                this.writeTimePeriodSeries(timePeriodSeries[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writePieSeries(JRPieSeries pieSeries) throws IOException {
        this.writer.startElement("pieSeries");
        this.writer.writeExpression("keyExpression", pieSeries.getKeyExpression(), false);
        this.writer.writeExpression("valueExpression", pieSeries.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", pieSeries.getLabelExpression(), false);
        this.writeHyperlink("sectionHyperlink", pieSeries.getSectionHyperlink());
        this.writer.closeElement();
    }

    private void writeCategorySeries(JRCategorySeries categorySeries) throws IOException {
        this.writer.startElement("categorySeries");
        this.writer.writeExpression("seriesExpression", categorySeries.getSeriesExpression(), false);
        this.writer.writeExpression("categoryExpression", categorySeries.getCategoryExpression(), false);
        this.writer.writeExpression("valueExpression", categorySeries.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", categorySeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", categorySeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeXyzDataset(JRXyzDataset dataset) throws IOException {
        this.writer.startElement("xyzDataset");
        this.writeElementDataset((JRElementDataset)dataset);
        JRXyzSeries[] series = dataset.getSeries();
        if (series != null && series.length > 0) {
            for (int i = 0; i < series.length; ++i) {
                this.writeXyzSeries(series[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeXyzSeries(JRXyzSeries series) throws IOException {
        this.writer.startElement("xyzSeries");
        this.writer.writeExpression("seriesExpression", series.getSeriesExpression(), false);
        this.writer.writeExpression("xValueExpression", series.getXValueExpression(), false);
        this.writer.writeExpression("yValueExpression", series.getYValueExpression(), false);
        this.writer.writeExpression("zValueExpression", series.getZValueExpression(), false);
        this.writeHyperlink("itemHyperlink", series.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeXySeries(JRXySeries xySeries) throws IOException {
        this.writer.startElement("xySeries");
        this.writer.writeExpression("seriesExpression", xySeries.getSeriesExpression(), false);
        this.writer.writeExpression("xValueExpression", xySeries.getXValueExpression(), false);
        this.writer.writeExpression("yValueExpression", xySeries.getYValueExpression(), false);
        this.writer.writeExpression("labelExpression", xySeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", xySeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeXyDataset(JRXyDataset dataset) throws IOException {
        this.writer.startElement("xyDataset");
        this.writeElementDataset((JRElementDataset)dataset);
        JRXySeries[] xySeries = dataset.getSeries();
        if (xySeries != null && xySeries.length > 0) {
            for (int i = 0; i < xySeries.length; ++i) {
                this.writeXySeries(xySeries[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeTimeSeries(JRTimeSeries timeSeries) throws IOException {
        this.writer.startElement("timeSeries");
        this.writer.writeExpression("seriesExpression", timeSeries.getSeriesExpression(), false);
        this.writer.writeExpression("timePeriodExpression", timeSeries.getTimePeriodExpression(), false);
        this.writer.writeExpression("valueExpression", timeSeries.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", timeSeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", timeSeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeGanttSeries(JRGanttSeries ganttSeries) throws IOException {
        this.writer.startElement("ganttSeries");
        this.writer.writeExpression("seriesExpression", ganttSeries.getSeriesExpression(), false);
        this.writer.writeExpression("taskExpression", ganttSeries.getTaskExpression(), false);
        this.writer.writeExpression("subtaskExpression", ganttSeries.getSubtaskExpression(), false);
        this.writer.writeExpression("startDateExpression", ganttSeries.getStartDateExpression(), false);
        this.writer.writeExpression("endDateExpression", ganttSeries.getEndDateExpression(), false);
        this.writer.writeExpression("percentExpression", ganttSeries.getPercentExpression(), false);
        this.writer.writeExpression("labelExpression", ganttSeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", ganttSeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeTimePeriodSeries(JRTimePeriodSeries timePeriodSeries) throws IOException {
        this.writer.startElement("timePeriodSeries");
        this.writer.writeExpression("seriesExpression", timePeriodSeries.getSeriesExpression(), false);
        this.writer.writeExpression("startDateExpression", timePeriodSeries.getStartDateExpression(), false);
        this.writer.writeExpression("endDateExpression", timePeriodSeries.getEndDateExpression(), false);
        this.writer.writeExpression("valueExpression", timePeriodSeries.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", timePeriodSeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", timePeriodSeries.getItemHyperlink());
        this.writer.closeElement();
    }

    public void writePieDataset(JRPieDataset dataset) throws IOException {
        this.writer.startElement("pieDataset", this.getNamespace());
        this.writer.addAttribute("maxCount", (Object)dataset.getMaxCount());
        this.writer.addAttribute("minPercentage", (Object)dataset.getMinPercentage());
        this.writeElementDataset((JRElementDataset)dataset);
        JRPieSeries[] pieSeries = dataset.getSeries();
        if (pieSeries != null) {
            if (pieSeries.length > 1) {
                for (int i = 0; i < pieSeries.length; ++i) {
                    this.writePieSeries(pieSeries[i]);
                }
            } else {
                JRPieSeries ps = pieSeries[0];
                this.writer.writeExpression("keyExpression", ps.getKeyExpression(), false);
                this.writer.writeExpression("valueExpression", ps.getValueExpression(), false);
                this.writer.writeExpression("labelExpression", ps.getLabelExpression(), false);
                this.writeHyperlink("sectionHyperlink", ps.getSectionHyperlink());
            }
        }
        this.writer.writeExpression("otherKeyExpression", dataset.getOtherKeyExpression(), false);
        this.writer.writeExpression("otherLabelExpression", dataset.getOtherLabelExpression(), false);
        this.writeHyperlink("otherSectionHyperlink", dataset.getOtherSectionHyperlink());
        this.writer.closeElement();
    }

    public void writeValueDataset(JRValueDataset dataset) throws IOException {
        this.writer.startElement("valueDataset", this.getNamespace());
        this.writeElementDataset((JRElementDataset)dataset);
        this.writer.writeExpression("valueExpression", dataset.getValueExpression(), false);
        this.writer.closeElement();
    }

    public void writeValueDisplay(JRValueDisplay valueDisplay) throws IOException {
        this.writer.startElement("valueDisplay", this.getNamespace());
        this.writer.addAttribute("color", valueDisplay.getColor());
        this.writer.addAttribute("mask", valueDisplay.getMask());
        this.writeFont(valueDisplay.getFont());
        this.writer.closeElement();
    }

    public void writeDataRange(JRDataRange dataRange) throws IOException {
        this.writer.startElement("dataRange", this.getNamespace());
        this.writer.writeExpression("lowExpression", dataRange.getLowExpression(), false);
        this.writer.writeExpression("highExpression", dataRange.getHighExpression(), false);
        this.writer.closeElement();
    }

    private void writeMeterInterval(JRMeterInterval interval) throws IOException {
        this.writer.startElement("meterInterval");
        this.writer.addAttribute("label", interval.getLabel());
        this.writer.addAttribute("color", interval.getBackgroundColor());
        this.writer.addAttribute("alpha", (Object)interval.getAlphaDouble());
        this.writeDataRange(interval.getDataRange());
        this.writer.closeElement();
    }

    private void writeSeriesColors(SortedSet seriesColors) throws IOException {
        if (seriesColors == null || seriesColors.size() == 0) {
            return;
        }
        JRChartPlot.JRSeriesColor[] colors = seriesColors.toArray(new JRChartPlot.JRSeriesColor[0]);
        for (int i = 0; i < colors.length; ++i) {
            this.writer.startElement("seriesColor");
            this.writer.addAttribute("seriesOrder", colors[i].getSeriesOrder());
            this.writer.addAttribute("color", colors[i].getColor());
            this.writer.closeElement();
        }
    }

    private void writeChartAxis(JRChartAxis chartAxis) throws IOException {
        this.writer.startElement("axis");
        this.writer.addAttribute("position", (Object)chartAxis.getPositionByte(), JRXmlConstants.getAxisPositionMap());
        this.writeChartTag(chartAxis.getChart());
        this.writer.closeElement();
    }

    private void writePlot(JRChartPlot plot) throws IOException {
        this.writer.startElement("plot");
        this.writer.addAttribute("backcolor", plot.getOwnBackcolor());
        this.writer.addAttribute("orientation", (Object)plot.getOrientation(), JRXmlConstants.getPlotOrientationMap(), (Object)PlotOrientation.VERTICAL);
        this.writer.addAttribute("backgroundAlpha", (Object)plot.getBackgroundAlphaFloat());
        this.writer.addAttribute("foregroundAlpha", (Object)plot.getForegroundAlphaFloat());
        this.writer.addAttribute("labelRotation", (Object)plot.getLabelRotationDouble());
        this.writeSeriesColors(plot.getSeriesColors());
        this.writer.closeElement();
    }

    public void writePieChart(JRChart chart) throws IOException {
        this.writer.startElement("pieChart", this.getNamespace());
        this.writeChart(chart);
        this.writePieDataset((JRPieDataset)chart.getDataset());
        JRPiePlot plot = (JRPiePlot)chart.getPlot();
        this.writer.startElement("piePlot");
        this.writer.addAttribute("isCircular", (Object)plot.getCircular());
        this.writer.addAttribute("labelFormat", plot.getLabelFormat());
        this.writer.addAttribute("legendLabelFormat", plot.getLegendLabelFormat());
        this.writePlot(chart.getPlot());
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writePie3DChart(JRChart chart) throws IOException {
        this.writer.startElement("pie3DChart", this.getNamespace());
        this.writeChart(chart);
        this.writePieDataset((JRPieDataset)chart.getDataset());
        JRPie3DPlot plot = (JRPie3DPlot)chart.getPlot();
        this.writer.startElement("pie3DPlot");
        this.writer.addAttribute("depthFactor", (Object)plot.getDepthFactorDouble());
        this.writer.addAttribute("isCircular", (Object)plot.getCircular());
        this.writer.addAttribute("labelFormat", plot.getLabelFormat());
        this.writer.addAttribute("legendLabelFormat", plot.getLegendLabelFormat());
        this.writePlot(chart.getPlot());
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeAxisFormat(String axisFormatElementName, JRFont axisLabelFont, Color axisLabelColor, JRFont axisTickLabelFont, Color axisTickLabelColor, String axisTickLabelMask, Color axisLineColor) throws IOException {
        if (axisLabelFont == null && axisLabelColor == null && axisTickLabelFont == null && axisTickLabelColor == null && axisLineColor == null) {
            return;
        }
        this.writer.startElement(axisFormatElementName, this.getNamespace());
        this.writer.startElement("axisFormat");
        this.writer.addAttribute("labelColor", axisLabelColor);
        this.writer.addAttribute("tickLabelColor", axisTickLabelColor);
        this.writer.addAttribute("tickLabelMask", axisTickLabelMask);
        this.writer.addAttribute("axisLineColor", axisLineColor);
        if (axisLabelFont != null) {
            this.writer.startElement("labelFont");
            this.writeFont(axisLabelFont);
            this.writer.closeElement();
        }
        if (axisTickLabelFont != null) {
            this.writer.startElement("tickLabelFont");
            this.writeFont(axisTickLabelFont);
            this.writer.closeElement();
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    private void writeBarPlot(JRBarPlot plot) throws IOException {
        this.writer.startElement("barPlot");
        this.writer.addAttribute("isShowLabels", (Object)plot.getShowLabels());
        this.writer.addAttribute("isShowTickLabels", (Object)plot.getShowTickLabels());
        this.writer.addAttribute("isShowTickMarks", (Object)plot.getShowTickMarks());
        this.writePlot((JRChartPlot)plot);
        this.writer.writeExpression("categoryAxisLabelExpression", plot.getCategoryAxisLabelExpression(), false);
        this.writeAxisFormat("categoryAxisFormat", plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getOwnCategoryAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getOwnValueAxisLineColor());
        this.writer.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
        this.writer.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
        this.writer.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
        this.writer.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        this.writer.closeElement();
    }

    private void writeBubblePlot(JRBubblePlot plot) throws IOException {
        this.writer.startElement("bubblePlot");
        this.writer.addAttribute("scaleType", (Object)plot.getScaleTypeInteger(), JRXmlConstants.getScaleTypeMap());
        this.writePlot((JRChartPlot)plot);
        this.writer.writeExpression("xAxisLabelExpression", plot.getXAxisLabelExpression(), false);
        this.writeAxisFormat("xAxisFormat", plot.getXAxisLabelFont(), plot.getOwnXAxisLabelColor(), plot.getXAxisTickLabelFont(), plot.getOwnXAxisTickLabelColor(), plot.getXAxisTickLabelMask(), plot.getOwnXAxisLineColor());
        this.writer.writeExpression("yAxisLabelExpression", plot.getYAxisLabelExpression(), false);
        this.writeAxisFormat("yAxisFormat", plot.getYAxisLabelFont(), plot.getOwnYAxisLabelColor(), plot.getYAxisTickLabelFont(), plot.getOwnYAxisTickLabelColor(), plot.getYAxisTickLabelMask(), plot.getOwnYAxisLineColor());
        this.writer.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
        this.writer.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
        this.writer.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
        this.writer.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        this.writer.closeElement();
    }

    private void writeLinePlot(JRLinePlot plot) throws IOException {
        this.writer.startElement("linePlot");
        this.writer.addAttribute("isShowLines", (Object)plot.getShowLines());
        this.writer.addAttribute("isShowShapes", (Object)plot.getShowShapes());
        this.writePlot((JRChartPlot)plot);
        this.writer.writeExpression("categoryAxisLabelExpression", plot.getCategoryAxisLabelExpression(), false);
        this.writeAxisFormat("categoryAxisFormat", plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getOwnCategoryAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getOwnValueAxisLineColor());
        this.writer.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
        this.writer.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
        this.writer.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
        this.writer.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        this.writer.closeElement();
    }

    private void writeTimeSeriesPlot(JRTimeSeriesPlot plot) throws IOException {
        this.writer.startElement("timeSeriesPlot");
        this.writer.addAttribute("isShowLines", (Object)plot.getShowLines());
        this.writer.addAttribute("isShowShapes", (Object)plot.getShowShapes());
        this.writePlot((JRChartPlot)plot);
        this.writer.writeExpression("timeAxisLabelExpression", plot.getTimeAxisLabelExpression(), false);
        this.writeAxisFormat("timeAxisFormat", plot.getTimeAxisLabelFont(), plot.getOwnTimeAxisLabelColor(), plot.getTimeAxisTickLabelFont(), plot.getOwnTimeAxisTickLabelColor(), plot.getTimeAxisTickLabelMask(), plot.getOwnTimeAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getOwnValueAxisLineColor());
        this.writer.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
        this.writer.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
        this.writer.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
        this.writer.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        this.writer.closeElement();
    }

    public void writeBar3DPlot(JRBar3DPlot plot) throws IOException {
        this.writer.startElement("bar3DPlot", this.getNamespace());
        this.writer.addAttribute("isShowLabels", (Object)plot.getShowLabels());
        this.writer.addAttribute("xOffset", (Object)plot.getXOffsetDouble());
        this.writer.addAttribute("yOffset", (Object)plot.getYOffsetDouble());
        this.writePlot((JRChartPlot)plot);
        this.writer.writeExpression("categoryAxisLabelExpression", plot.getCategoryAxisLabelExpression(), false);
        this.writeAxisFormat("categoryAxisFormat", plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getOwnCategoryAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getOwnValueAxisLineColor());
        this.writer.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
        this.writer.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
        this.writer.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
        this.writer.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        this.writer.closeElement();
    }

    public void writeBarChart(JRChart chart) throws IOException {
        this.writer.startElement("barChart", this.getNamespace());
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBarPlot((JRBarPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeBar3DChart(JRChart chart) throws IOException {
        this.writer.startElement("bar3DChart", this.getNamespace());
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBar3DPlot((JRBar3DPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeBubbleChart(JRChart chart) throws IOException {
        this.writer.startElement("bubbleChart", this.getNamespace());
        this.writeChart(chart);
        this.writeXyzDataset((JRXyzDataset)chart.getDataset());
        this.writeBubblePlot((JRBubblePlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeStackedBarChart(JRChart chart) throws IOException {
        this.writer.startElement("stackedBarChart", this.getNamespace());
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBarPlot((JRBarPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeStackedBar3DChart(JRChart chart) throws IOException {
        this.writer.startElement("stackedBar3DChart", this.getNamespace());
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBar3DPlot((JRBar3DPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeLineChart(JRChart chart) throws IOException {
        this.writer.startElement("lineChart", this.getNamespace());
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeLinePlot((JRLinePlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeTimeSeriesChart(JRChart chart) throws IOException {
        this.writer.startElement("timeSeriesChart", this.getNamespace());
        this.writeChart(chart);
        this.writeTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset());
        this.writeTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeHighLowDataset(JRHighLowDataset dataset) throws IOException {
        this.writer.startElement("highLowDataset", this.getNamespace());
        this.writeElementDataset((JRElementDataset)dataset);
        this.writer.writeExpression("seriesExpression", dataset.getSeriesExpression(), false);
        this.writer.writeExpression("dateExpression", dataset.getDateExpression(), false);
        this.writer.writeExpression("highExpression", dataset.getHighExpression(), false);
        this.writer.writeExpression("lowExpression", dataset.getLowExpression(), false);
        this.writer.writeExpression("openExpression", dataset.getOpenExpression(), false);
        this.writer.writeExpression("closeExpression", dataset.getCloseExpression(), false);
        this.writer.writeExpression("volumeExpression", dataset.getVolumeExpression(), false);
        this.writeHyperlink("itemHyperlink", dataset.getItemHyperlink());
        this.writer.closeElement();
    }

    public void writeHighLowChart(JRChart chart) throws IOException {
        this.writer.startElement("highLowChart", this.getNamespace());
        this.writeChart(chart);
        this.writeHighLowDataset((JRHighLowDataset)chart.getDataset());
        JRHighLowPlot plot = (JRHighLowPlot)chart.getPlot();
        this.writer.startElement("highLowPlot");
        this.writer.addAttribute("isShowOpenTicks", (Object)plot.getShowOpenTicks());
        this.writer.addAttribute("isShowCloseTicks", (Object)plot.getShowCloseTicks());
        this.writePlot((JRChartPlot)plot);
        this.writer.writeExpression("timeAxisLabelExpression", plot.getTimeAxisLabelExpression(), false);
        this.writeAxisFormat("timeAxisFormat", plot.getTimeAxisLabelFont(), plot.getOwnTimeAxisLabelColor(), plot.getTimeAxisTickLabelFont(), plot.getOwnTimeAxisTickLabelColor(), plot.getTimeAxisTickLabelMask(), plot.getOwnTimeAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getOwnValueAxisLineColor());
        this.writer.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
        this.writer.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
        this.writer.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
        this.writer.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeGanttChart(JRChart chart) throws IOException {
        this.writer.startElement("ganttChart", this.getNamespace());
        this.writeChart(chart);
        this.writeGanttDataset((JRGanttDataset)chart.getDataset());
        this.writeBarPlot((JRBarPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeCandlestickChart(JRChart chart) throws IOException {
        this.writer.startElement("candlestickChart", this.getNamespace());
        this.writeChart(chart);
        this.writeHighLowDataset((JRHighLowDataset)chart.getDataset());
        JRCandlestickPlot plot = (JRCandlestickPlot)chart.getPlot();
        this.writer.startElement("candlestickPlot");
        this.writer.addAttribute("isShowVolume", (Object)plot.getShowVolume());
        this.writePlot((JRChartPlot)plot);
        this.writer.writeExpression("timeAxisLabelExpression", plot.getTimeAxisLabelExpression(), false);
        this.writeAxisFormat("timeAxisFormat", plot.getTimeAxisLabelFont(), plot.getOwnTimeAxisLabelColor(), plot.getTimeAxisTickLabelFont(), plot.getOwnTimeAxisTickLabelColor(), plot.getTimeAxisTickLabelMask(), plot.getOwnTimeAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getOwnValueAxisLineColor());
        this.writer.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
        this.writer.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
        this.writer.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
        this.writer.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        this.writer.closeElement();
        this.writer.closeElement();
    }

    private void writeAreaPlot(JRAreaPlot plot) throws IOException {
        this.writer.startElement("areaPlot");
        this.writePlot((JRChartPlot)plot);
        this.writer.writeExpression("categoryAxisLabelExpression", plot.getCategoryAxisLabelExpression(), false);
        this.writeAxisFormat("categoryAxisFormat", plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getOwnCategoryAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getOwnValueAxisLineColor());
        this.writer.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
        this.writer.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
        this.writer.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
        this.writer.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        this.writer.closeElement();
    }

    public void writeAreaChart(JRChart chart) throws IOException {
        this.writer.startElement("areaChart", this.getNamespace());
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeAreaPlot((JRAreaPlot)chart.getPlot());
        this.writer.closeElement();
    }

    private void writeScatterPlot(JRScatterPlot plot) throws IOException {
        this.writer.startElement("scatterPlot");
        this.writer.addAttribute("isShowLines", (Object)plot.getShowLines());
        this.writer.addAttribute("isShowShapes", (Object)plot.getShowShapes());
        this.writePlot((JRChartPlot)plot);
        this.writer.writeExpression("xAxisLabelExpression", plot.getXAxisLabelExpression(), false);
        this.writeAxisFormat("xAxisFormat", plot.getXAxisLabelFont(), plot.getOwnXAxisLabelColor(), plot.getXAxisTickLabelFont(), plot.getOwnXAxisTickLabelColor(), plot.getXAxisTickLabelMask(), plot.getOwnXAxisLineColor());
        this.writer.writeExpression("yAxisLabelExpression", plot.getYAxisLabelExpression(), false);
        this.writeAxisFormat("yAxisFormat", plot.getYAxisLabelFont(), plot.getOwnYAxisLabelColor(), plot.getYAxisTickLabelFont(), plot.getOwnYAxisTickLabelColor(), plot.getYAxisTickLabelMask(), plot.getOwnYAxisLineColor());
        this.writer.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
        this.writer.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
        this.writer.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
        this.writer.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        this.writer.closeElement();
    }

    public void writeScatterChart(JRChart chart) throws IOException {
        this.writer.startElement("scatterChart", this.getNamespace());
        this.writeChart(chart);
        this.writeXyDataset((JRXyDataset)chart.getDataset());
        this.writeScatterPlot((JRScatterPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeXyAreaChart(JRChart chart) throws IOException {
        this.writer.startElement("xyAreaChart", this.getNamespace());
        this.writeChart(chart);
        this.writeXyDataset((JRXyDataset)chart.getDataset());
        this.writeAreaPlot((JRAreaPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeXyBarChart(JRChart chart) throws IOException {
        this.writer.startElement("xyBarChart", this.getNamespace());
        this.writeChart(chart);
        JRChartDataset dataset = chart.getDataset();
        if (dataset.getDatasetType() == 6) {
            this.writeTimeSeriesDataset((JRTimeSeriesDataset)dataset);
        } else if (dataset.getDatasetType() == 5) {
            this.writeTimePeriodDataset((JRTimePeriodDataset)dataset);
        } else if (dataset.getDatasetType() == 3) {
            this.writeXyDataset((JRXyDataset)dataset);
        }
        this.writeBarPlot((JRBarPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeXyLineChart(JRChart chart) throws IOException {
        this.writer.startElement("xyLineChart", this.getNamespace());
        this.writeChart(chart);
        this.writeXyDataset((JRXyDataset)chart.getDataset());
        this.writeLinePlot((JRLinePlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeMeterChart(JRChart chart) throws IOException {
        this.writer.startElement("meterChart", this.getNamespace());
        this.writeChart(chart);
        this.writeValueDataset((JRValueDataset)chart.getDataset());
        JRMeterPlot plot = (JRMeterPlot)chart.getPlot();
        this.writer.startElement("meterPlot");
        this.writer.addAttribute("shape", (Object)plot.getShapeByte(), JRXmlConstants.getMeterShapeMap());
        this.writer.addAttribute("angle", (Object)plot.getMeterAngleInteger());
        this.writer.addAttribute("units", plot.getUnits());
        this.writer.addAttribute("tickInterval", (Object)plot.getTickIntervalDouble());
        this.writer.addAttribute("meterColor", plot.getMeterBackgroundColor());
        this.writer.addAttribute("needleColor", plot.getNeedleColor());
        this.writer.addAttribute("tickColor", plot.getTickColor());
        this.writePlot(chart.getPlot());
        if (plot.getTickLabelFont() != null) {
            this.writer.startElement("tickLabelFont");
            this.writeFont(plot.getTickLabelFont());
            this.writer.closeElement();
        }
        this.writeValueDisplay(plot.getValueDisplay());
        this.writeDataRange(plot.getDataRange());
        List intervals = plot.getIntervals();
        if (intervals != null) {
            for (JRMeterInterval meterInterval : intervals) {
                this.writeMeterInterval(meterInterval);
            }
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeThermometerChart(JRChart chart) throws IOException {
        this.writer.startElement("thermometerChart", this.getNamespace());
        this.writeChart(chart);
        this.writeValueDataset((JRValueDataset)chart.getDataset());
        JRThermometerPlot plot = (JRThermometerPlot)chart.getPlot();
        this.writer.startElement("thermometerPlot", this.getNamespace());
        this.writer.addAttribute("valueLocation", (Object)plot.getValueLocationByte(), JRXmlConstants.getThermometerValueLocationMap());
        this.writer.addAttribute("isShowValueLines", plot.isShowValueLines(), false);
        this.writer.addAttribute("mercuryColor", plot.getMercuryColor());
        this.writePlot(chart.getPlot());
        this.writeValueDisplay(plot.getValueDisplay());
        this.writeDataRange(plot.getDataRange());
        if (plot.getLowRange() != null) {
            this.writer.startElement("lowRange");
            this.writeDataRange(plot.getLowRange());
            this.writer.closeElement();
        }
        if (plot.getMediumRange() != null) {
            this.writer.startElement("mediumRange");
            this.writeDataRange(plot.getMediumRange());
            this.writer.closeElement();
        }
        if (plot.getHighRange() != null) {
            this.writer.startElement("highRange");
            this.writeDataRange(plot.getHighRange());
            this.writer.closeElement();
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeMultiAxisChart(JRChart chart) throws IOException {
        this.writer.startElement("multiAxisChart", this.getNamespace());
        this.writeChart(chart);
        JRMultiAxisPlot plot = (JRMultiAxisPlot)chart.getPlot();
        this.writer.startElement("multiAxisPlot");
        this.writePlot(chart.getPlot());
        List axes = plot.getAxes();
        if (axes != null) {
            for (JRChartAxis chartAxis : axes) {
                this.writeChartAxis(chartAxis);
            }
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeStackedAreaChart(JRChart chart) throws IOException {
        this.writer.startElement("stackedAreaChart", this.getNamespace());
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeAreaPlot((JRAreaPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeChartTag(JRChart chart) throws IOException {
        switch (chart.getChartType()) {
            case 1: {
                this.writeAreaChart(chart);
                break;
            }
            case 3: {
                this.writeBarChart(chart);
                break;
            }
            case 2: {
                this.writeBar3DChart(chart);
                break;
            }
            case 4: {
                this.writeBubbleChart(chart);
                break;
            }
            case 5: {
                this.writeCandlestickChart(chart);
                break;
            }
            case 6: {
                this.writeHighLowChart(chart);
                break;
            }
            case 7: {
                this.writeLineChart(chart);
                break;
            }
            case 17: {
                this.writeMeterChart(chart);
                break;
            }
            case 19: {
                this.writeMultiAxisChart(chart);
                break;
            }
            case 9: {
                this.writePieChart(chart);
                break;
            }
            case 8: {
                this.writePie3DChart(chart);
                break;
            }
            case 10: {
                this.writeScatterChart(chart);
                break;
            }
            case 12: {
                this.writeStackedBarChart(chart);
                break;
            }
            case 11: {
                this.writeStackedBar3DChart(chart);
                break;
            }
            case 18: {
                this.writeThermometerChart(chart);
                break;
            }
            case 16: {
                this.writeTimeSeriesChart(chart);
                break;
            }
            case 13: {
                this.writeXyAreaChart(chart);
                break;
            }
            case 14: {
                this.writeXyBarChart(chart);
                break;
            }
            case 15: {
                this.writeXyLineChart(chart);
                break;
            }
            case 20: {
                this.writeStackedAreaChart(chart);
                break;
            }
            case 21: {
                this.writeGanttChart(chart);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
    }

    private void writeSubreportReturnValue(JRSubreportReturnValue returnValue) throws IOException {
        this.writer.startElement("returnValue");
        this.writer.addEncodedAttribute("subreportVariable", returnValue.getSubreportVariable());
        this.writer.addEncodedAttribute("toVariable", returnValue.getToVariable());
        this.writer.addAttribute("calculation", returnValue.getCalculation(), JRXmlConstants.getCalculationMap(), (byte)0);
        this.writer.addAttribute("incrementerFactoryClass", returnValue.getIncrementerFactoryClassName());
        this.writer.closeElement();
    }

    public void writeCrosstab(JRCrosstab crosstab) throws IOException {
        this.writer.startElement("crosstab", this.getNamespace());
        this.writer.addAttribute("isRepeatColumnHeaders", crosstab.isRepeatColumnHeaders(), true);
        this.writer.addAttribute("isRepeatRowHeaders", crosstab.isRepeatRowHeaders(), true);
        this.writer.addAttribute("columnBreakOffset", crosstab.getColumnBreakOffset(), 10);
        this.writer.addAttribute("runDirection", crosstab.getRunDirection(), JRXmlConstants.getRunDirectionMap(), (byte)0);
        this.writeReportElement((JRElement)crosstab);
        JRCrosstabParameter[] parameters = crosstab.getParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].isSystemDefined()) continue;
                this.writeCrosstabParameter(parameters[i]);
            }
        }
        this.writer.writeExpression("parametersMapExpression", crosstab.getParametersMapExpression(), false);
        this.writeCrosstabDataset(crosstab);
        this.writeCrosstabHeaderCell(crosstab);
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        for (int i = 0; i < rowGroups.length; ++i) {
            this.writeCrosstabRowGroup(rowGroups[i]);
        }
        JRCrosstabColumnGroup[] columnGroups = crosstab.getColumnGroups();
        for (int i = 0; i < columnGroups.length; ++i) {
            this.writeCrosstabColumnGroup(columnGroups[i]);
        }
        JRCrosstabMeasure[] measures = crosstab.getMeasures();
        for (int i = 0; i < measures.length; ++i) {
            this.writeCrosstabMeasure(measures[i]);
        }
        if (crosstab instanceof JRDesignCrosstab) {
            List cellsList = ((JRDesignCrosstab)crosstab).getCellsList();
            for (JRCrosstabCell cell : cellsList) {
                this.writeCrosstabCell(cell);
            }
        } else {
            JRCrosstabCell[][] cells = crosstab.getCells();
            HashSet<JRCrosstabCell> cellsSet = new HashSet<JRCrosstabCell>();
            for (int i = cells.length - 1; i >= 0; --i) {
                for (int j = cells[i].length - 1; j >= 0; --j) {
                    JRCrosstabCell cell = cells[i][j];
                    if (cell == null || !cellsSet.add(cell)) continue;
                    this.writeCrosstabCell(cell);
                }
            }
        }
        this.writeCrosstabWhenNoDataCell(crosstab);
        this.writer.closeElement();
    }

    private void writeCrosstabDataset(JRCrosstab crosstab) throws IOException {
        JRCrosstabDataset dataset = crosstab.getDataset();
        this.writer.startElement("crosstabDataset");
        this.writer.addAttribute("isDataPreSorted", dataset.isDataPreSorted(), false);
        this.writeElementDataset((JRElementDataset)dataset);
        this.writer.closeElement(true);
    }

    private void writeCrosstabWhenNoDataCell(JRCrosstab crosstab) throws IOException {
        JRCellContents whenNoDataCell = crosstab.getWhenNoDataCell();
        if (whenNoDataCell != null) {
            this.writer.startElement("whenNoDataCell");
            this.writeCellContents(whenNoDataCell);
            this.writer.closeElement();
        }
    }

    private void writeCrosstabHeaderCell(JRCrosstab crosstab) throws IOException {
        JRCellContents headerCell = crosstab.getHeaderCell();
        if (headerCell != null) {
            this.writer.startElement("crosstabHeaderCell");
            this.writeCellContents(headerCell);
            this.writer.closeElement();
        }
    }

    protected void writeCrosstabRowGroup(JRCrosstabRowGroup group) throws IOException {
        this.writer.startElement("rowGroup");
        this.writer.addEncodedAttribute("name", group.getName());
        this.writer.addAttribute("width", group.getWidth());
        this.writer.addAttribute("totalPosition", group.getTotalPosition(), JRXmlConstants.getCrosstabTotalPositionMap(), (byte)0);
        this.writer.addAttribute("headerPosition", group.getPosition(), JRXmlConstants.getCrosstabRowPositionMap(), (byte)1);
        this.writeBucket(group.getBucket());
        JRCellContents header = group.getHeader();
        this.writer.startElement("crosstabRowHeader");
        this.writeCellContents(header);
        this.writer.closeElement();
        JRCellContents totalHeader = group.getTotalHeader();
        this.writer.startElement("crosstabTotalRowHeader");
        this.writeCellContents(totalHeader);
        this.writer.closeElement();
        this.writer.closeElement();
    }

    protected void writeCrosstabColumnGroup(JRCrosstabColumnGroup group) throws IOException {
        this.writer.startElement("columnGroup");
        this.writer.addEncodedAttribute("name", group.getName());
        this.writer.addAttribute("height", group.getHeight());
        this.writer.addAttribute("totalPosition", group.getTotalPosition(), JRXmlConstants.getCrosstabTotalPositionMap(), (byte)0);
        this.writer.addAttribute("headerPosition", group.getPosition(), JRXmlConstants.getCrosstabColumnPositionMap(), (byte)1);
        this.writeBucket(group.getBucket());
        JRCellContents header = group.getHeader();
        this.writer.startElement("crosstabColumnHeader");
        this.writeCellContents(header);
        this.writer.closeElement();
        JRCellContents totalHeader = group.getTotalHeader();
        this.writer.startElement("crosstabTotalColumnHeader");
        this.writeCellContents(totalHeader);
        this.writer.closeElement();
        this.writer.closeElement();
    }

    protected void writeBucket(JRCrosstabBucket bucket) throws IOException {
        this.writer.startElement("bucket");
        this.writer.addAttribute("order", bucket.getOrder(), JRXmlConstants.getCrosstabBucketOrderMap(), (byte)1);
        this.writer.writeExpression("bucketExpression", bucket.getExpression(), true);
        this.writer.writeExpression("comparatorExpression", bucket.getComparatorExpression(), false);
        this.writer.closeElement();
    }

    protected void writeCrosstabMeasure(JRCrosstabMeasure measure) throws IOException {
        this.writer.startElement("measure");
        this.writer.addEncodedAttribute("name", measure.getName());
        this.writer.addAttribute("class", measure.getValueClassName());
        this.writer.addAttribute("calculation", measure.getCalculation(), JRXmlConstants.getCalculationMap(), (byte)0);
        this.writer.addAttribute("percentageOf", measure.getPercentageOfType(), JRXmlConstants.getCrosstabPercentageMap(), (byte)0);
        this.writer.addAttribute("percentageCalculatorClass", measure.getPercentageCalculatorClassName());
        this.writer.writeExpression("measureExpression", measure.getValueExpression(), false);
        this.writer.closeElement();
    }

    protected void writeCrosstabCell(JRCrosstabCell cell) throws IOException {
        this.writer.startElement("crosstabCell");
        this.writer.addAttribute("width", (Object)cell.getWidth());
        this.writer.addAttribute("height", (Object)cell.getHeight());
        this.writer.addEncodedAttribute("rowTotalGroup", cell.getRowTotalGroup());
        this.writer.addEncodedAttribute("columnTotalGroup", cell.getColumnTotalGroup());
        this.writeCellContents(cell.getContents());
        this.writer.closeElement();
    }

    protected void writeCellContents(JRCellContents contents) throws IOException {
        if (contents != null) {
            this.writer.startElement("cellContents");
            this.writer.addAttribute("backcolor", contents.getBackcolor());
            this.writer.addAttribute("mode", (Object)contents.getMode(), JRXmlConstants.getModeMap());
            this.writeStyleReferenceAttr((JRStyleContainer)contents);
            this.writeBox(contents.getLineBox());
            this.writeChildElements((JRElementGroup)contents);
            this.writer.closeElement();
        }
    }

    protected void writeCrosstabParameter(JRCrosstabParameter parameter) throws IOException {
        this.writer.startElement("crosstabParameter");
        this.writer.addEncodedAttribute("name", parameter.getName());
        this.writer.addAttribute("class", parameter.getValueClassName(), "java.lang.String");
        this.writer.writeExpression("parameterValueExpression", parameter.getExpression(), false);
        this.writer.closeElement();
    }

    public void writeDataset(JRDataset dataset) throws IOException {
        this.writer.startElement("subDataset", this.getNamespace());
        this.writer.addEncodedAttribute("name", dataset.getName());
        this.writer.addAttribute("scriptletClass", dataset.getScriptletClass());
        this.writer.addEncodedAttribute("resourceBundle", dataset.getResourceBundle());
        this.writer.addAttribute("whenResourceMissingType", dataset.getWhenResourceMissingType(), JRXmlConstants.getWhenResourceMissingTypeMap(), (byte)1);
        this.writeProperties((JRPropertiesHolder)dataset);
        this.writeDatasetContents(dataset);
        this.writer.closeElement();
    }

    protected void writeDatasetContents(JRDataset dataset) throws IOException {
        JRVariable[] variables;
        JRSortField[] sortFields;
        JRField[] fields;
        JRParameter[] parameters;
        JRScriptlet[] scriptlets = dataset.getScriptlets();
        if (scriptlets != null && scriptlets.length > 0) {
            for (int i = 0; i < scriptlets.length; ++i) {
                this.writeScriptlet(scriptlets[i]);
            }
        }
        if ((parameters = dataset.getParameters()) != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].isSystemDefined()) continue;
                this.writeParameter(parameters[i]);
            }
        }
        if (dataset.getQuery() != null) {
            this.writeQuery(dataset.getQuery());
        }
        if ((fields = dataset.getFields()) != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                this.writeField(fields[i]);
            }
        }
        if ((sortFields = dataset.getSortFields()) != null && sortFields.length > 0) {
            for (int i = 0; i < sortFields.length; ++i) {
                this.writeSortField(sortFields[i]);
            }
        }
        if ((variables = dataset.getVariables()) != null && variables.length > 0) {
            for (int i = 0; i < variables.length; ++i) {
                if (variables[i].isSystemDefined()) continue;
                this.writeVariable(variables[i]);
            }
        }
        this.writer.writeExpression("filterExpression", dataset.getFilterExpression(), false);
        JRGroup[] groups = dataset.getGroups();
        if (groups != null && groups.length > 0) {
            for (int i = 0; i < groups.length; ++i) {
                this.writeGroup(groups[i]);
            }
        }
    }

    public void writeDatasetRun(JRDatasetRun datasetRun) throws IOException {
        this.writer.startElement("datasetRun", this.getNamespace());
        this.writer.addEncodedAttribute("subDataset", datasetRun.getDatasetName());
        this.writer.writeExpression("parametersMapExpression", datasetRun.getParametersMapExpression(), false);
        JRDatasetParameter[] parameters = datasetRun.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                this.writeDatasetParameter(parameters[i]);
            }
        }
        this.writer.writeExpression("connectionExpression", datasetRun.getConnectionExpression(), false);
        this.writer.writeExpression("dataSourceExpression", datasetRun.getDataSourceExpression(), false);
        this.writer.closeElement();
    }

    public void writeFrame(JRFrame frame) throws IOException {
        this.writer.startElement("frame", this.getNamespace());
        this.writeReportElement((JRElement)frame);
        this.writeBox(frame.getLineBox());
        this.writeChildElements((JRElementGroup)frame);
        this.writer.closeElement();
    }

    protected void writeHyperlinkParameters(JRHyperlinkParameter[] parameters) throws IOException {
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                JRHyperlinkParameter parameter = parameters[i];
                this.writeHyperlinkParameter(parameter);
            }
        }
    }

    protected void writeHyperlinkParameter(JRHyperlinkParameter parameter) throws IOException {
        if (parameter != null) {
            this.writer.startElement("hyperlinkParameter");
            this.writer.addEncodedAttribute("name", parameter.getName());
            this.writer.writeExpression("hyperlinkParameterExpression", parameter.getValueExpression(), true, String.class.getName());
            this.writer.closeElement();
        }
    }

    public void writeHyperlink(String tagName, JRHyperlink hyperlink) throws IOException {
        if (hyperlink != null) {
            this.writer.startElement(tagName);
            this.writer.addEncodedAttribute("hyperlinkType", hyperlink.getLinkType(), "None");
            this.writer.addEncodedAttribute("hyperlinkTarget", hyperlink.getLinkTarget(), "Self");
            this.writer.writeExpression("hyperlinkReferenceExpression", hyperlink.getHyperlinkReferenceExpression(), false);
            this.writer.writeExpression("hyperlinkAnchorExpression", hyperlink.getHyperlinkAnchorExpression(), false);
            this.writer.writeExpression("hyperlinkPageExpression", hyperlink.getHyperlinkPageExpression(), false);
            this.writer.writeExpression("hyperlinkTooltipExpression", hyperlink.getHyperlinkTooltipExpression(), false);
            this.writeHyperlinkParameters(hyperlink.getHyperlinkParameters());
            this.writer.closeElement(true);
        }
    }

    protected boolean toWriteConditionalStyles() {
        return true;
    }

    public JRXmlWriteHelper getXmlWriteHelper() {
        return this.writer;
    }

    public Writer getUnderlyingWriter() {
        return this.writer.getUnderlyingWriter();
    }

    public void writeComponentElement(JRComponentElement componentElement) throws IOException {
        this.writer.startElement("componentElement", this.getNamespace());
        this.writeReportElement((JRElement)componentElement);
        ComponentKey componentKey = componentElement.getComponentKey();
        Component component = componentElement.getComponent();
        ComponentXmlWriter componentXmlWriter = ComponentsEnvironment.getComponentManager((ComponentKey)componentKey).getComponentXmlWriter();
        componentXmlWriter.writeToXml(componentKey, component, (JRXmlWriter)this);
        this.writer.closeElement();
    }

    protected XmlNamespace getNamespace() {
        return JASPERREPORTS_NAMESPACE;
    }

    public void writeGenericElement(JRGenericElement element) throws IOException {
        this.writer.startElement("genericElement", this.getNamespace());
        this.writer.addAttribute("evaluationTime", element.getEvaluationTime(), JRXmlConstants.getEvaluationTimeMap(), (byte)1);
        if (element.getEvaluationGroupName() != null) {
            this.writer.addEncodedAttribute("evaluationGroup", element.getEvaluationGroupName());
        }
        this.writeReportElement((JRElement)element);
        JRGenericElementType printKey = element.getGenericType();
        this.writer.startElement("genericElementType");
        this.writer.addEncodedAttribute("namespace", printKey.getNamespace());
        this.writer.addEncodedAttribute("name", printKey.getName());
        this.writer.closeElement();
        JRGenericElementParameter[] params = element.getParameters();
        for (int i = 0; i < params.length; ++i) {
            JRGenericElementParameter param = params[i];
            this.writer.startElement("genericElementParameter");
            this.writer.addEncodedAttribute("name", param.getName());
            this.writer.addAttribute("skipWhenNull", param.isSkipWhenEmpty(), false);
            JRExpression valueExpression = param.getValueExpression();
            if (valueExpression != null) {
                this.writer.writeExpression("valueExpression", valueExpression, true, Object.class.getName());
            }
            this.writer.closeElement();
        }
        this.writer.closeElement();
    }
}

