/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.editor;

import bsh.ParseException;
import bsh.Parser;
import bsh.Token;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.editor.CrosstabTotalVariable;
import com.jaspersoft.ireport.designer.editor.ExpObject;
import com.jaspersoft.ireport.designer.editor.ExpObjectCellRenderer;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorPane;
import com.jaspersoft.ireport.designer.editor.MethodsListCellRenderer;
import com.jaspersoft.ireport.designer.editor.NamedIconItem;
import com.jaspersoft.ireport.designer.editor.NamedIconItemCellRenderer;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEditor
extends JPanel {
    public static final String USER_DEFINED_EXPRESSIONS = "USER_DEFINED_EXPRESSIONS";
    public static final String PARAMETERS = "PARAMETERS";
    public static final String FIELDS = "FIELDS";
    public static final String VARIABLES = "VARIABLES";
    public static final String RECENT_EXPRESSIONS = "RECENT_EXPRESSIONS";
    public static final String WIZARDS = "WIZARDS";
    private ExpressionContext expressionContext = null;
    private JDialog dialog = null;
    private int dialogResult = 2;
    private static ArrayList<String> recentExpressions = new ArrayList();
    private static ArrayList<String> defaultExpressions = null;
    private JButton jButtonApply;
    private JButton jButtonCancel;
    private JButton jButtonExport;
    private JButton jButtonImport;
    private ExpressionEditorPane jEditorPane1;
    private JLabel jLabelCaretPosition;
    private JLabel jLabelErrors;
    private JList jList1;
    private JList jList2;
    private JList jList3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JSplitPane jSplitPane3;

    public String getExpression() {
        return this.jEditorPane1.getText();
    }

    public void setExpression(String expression) {
        this.jEditorPane1.setText(expression);
        this.checkSyntax();
    }

    public static ArrayList<String> getPredefinedExpressions() {
        ArrayList<String> exps = new ArrayList<String>();
        Preferences pref = IReportManager.getPreferences();
        if (pref.getBoolean("custom_expressions_set", false)) {
            int i = 0;
            while (pref.get("customexpression." + i, null) != null) {
                exps.add(pref.get("customexpression." + i, ""));
                ++i;
            }
        } else {
            exps.addAll(ExpressionEditor.getDefaultPredefinedExpressions());
        }
        return exps;
    }

    public static ArrayList<String> getDefaultPredefinedExpressions() {
        return defaultExpressions;
    }

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public void setExpressionContext(ExpressionContext expressionContext) {
        this.expressionContext = expressionContext;
        this.jEditorPane1.setExpressionContext(expressionContext);
        this.refreshContext();
    }

    public ExpressionEditor() {
        this.initComponents();
        this.jButtonApply.setVisible(false);
        this.jButtonCancel.setVisible(false);
        this.jList1.setCellRenderer(new NamedIconItemCellRenderer());
        this.jList2.setModel(new DefaultListModel());
        this.jList3.setModel(new DefaultListModel());
        this.jList1.setModel(new DefaultListModel());
        this.jList2.setCellRenderer(new ExpObjectCellRenderer(this.jList2));
        this.jList3.setCellRenderer(new MethodsListCellRenderer(this.jList3));
        this.jEditorPane1.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                int y = 0;
                int x = 0;
                try {
                    String text = ExpressionEditor.this.jEditorPane1.getText(0, ExpressionEditor.this.jEditorPane1.getCaretPosition());
                    String[] lines = text.split("[\\r\\n]+");
                    y = lines.length;
                    x = lines[lines.length - 1].length();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ExpressionEditor.this.jLabelCaretPosition.setText("Ln " + y + ", Col " + x);
            }
        });
        this.jEditorPane1.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ExpressionEditor.this.checkSyntax();
            }

            public void removeUpdate(DocumentEvent e) {
                ExpressionEditor.this.checkSyntax();
            }

            public void changedUpdate(DocumentEvent e) {
                ExpressionEditor.this.checkSyntax();
            }
        });
        this.refreshContext();
    }

    public void checkSyntax() {
        this.jLabelErrors.setForeground(Color.BLACK);
        this.jLabelErrors.setText(" ");
        String exp = this.jEditorPane1.getText();
        while (exp.length() > 0 && Character.isWhitespace(exp.charAt(exp.length() - 1))) {
            exp = exp.substring(0, exp.length() - 1);
        }
        if (exp.endsWith(";")) {
            Point p = this.findCaretPosition(exp);
            this.jLabelErrors.setForeground(Color.red.darker());
            this.jLabelErrors.setText("Invalid character ';' at line: " + p.y + ", column: " + p.x);
        }
        String[] patterns = new String[]{"$P{", "$V{", "$F{", "$R{"};
        String[] patternNames = new String[]{"Parameter", "Variable", "Field", "Resource"};
        for (int k = 0; k < patterns.length; ++k) {
            while (exp.indexOf(patterns[k]) >= 0) {
                int initialIndex = exp.indexOf(patterns[k]);
                boolean endFound = false;
                for (int index = initialIndex; index >= 0 && index < exp.length(); ++index) {
                    char c = exp.charAt(index);
                    exp = exp.substring(0, index) + "X" + exp.substring(index + 1);
                    if (c != '}') continue;
                    endFound = true;
                    break;
                }
                if (endFound) continue;
                String text = this.jEditorPane1.getText();
                Point p = this.findCaretPosition(text, initialIndex);
                this.jLabelErrors.setForeground(Color.red.darker());
                this.jLabelErrors.setText("Report " + patternNames[k] + " reference not closed at line: " + p.y + ", column: " + p.x);
                return;
            }
        }
        exp = exp + ";";
        Parser parser = new Parser((Reader)new StringReader(exp));
        try {
            parser.Line();
        }
        catch (ParseException ex) {
            Token errorToken = null;
            Token tmp = parser.getToken(0);
            int i = 1;
            while (tmp != null) {
                errorToken = tmp;
                tmp = tmp.next;
                ++i;
            }
            String message = ex.getMessage() + "\n";
            if (errorToken != null) {
                Point p = this.findCaretPosition(exp);
                if (p.y == errorToken.beginLine && p.x == errorToken.beginColumn) {
                    message = "Incomplete expression.";
                }
            }
            this.jLabelErrors.setForeground(Color.red.darker());
            this.jLabelErrors.setText(message);
        }
        catch (Throwable ex) {
            // empty catch block
        }
    }

    private Point findCaretPosition(String text) {
        Point p = new Point(0, 1);
        String[] lines = text.split("[\\r\\n]+");
        p.y = lines.length;
        p.x = lines[lines.length - 1].length();
        return p;
    }

    private Point findCaretPosition(String text, int position) {
        return this.findCaretPosition(text.substring(0, position));
    }

    public void refreshContext() {
        this.jList2.removeAll();
        this.jList3.removeAll();
        this.jList1.removeAll();
        DefaultListModel dlm1 = (DefaultListModel)this.jList1.getModel();
        dlm1.removeAllElements();
        if (this.getExpressionContext() != null) {
            if (this.getExpressionContext().getDatasets().size() > 0) {
                JRDesignDataset ds = this.getExpressionContext().getDatasets().get(0);
                dlm1.addElement(new NamedIconItem((Object)PARAMETERS, I18n.getString("ExpressionEditor.IconName.Parameters"), "com/jaspersoft/ireport/designer/resources/parameters-16.png"));
                dlm1.addElement(new NamedIconItem((Object)FIELDS, I18n.getString("ExpressionEditor.IconName.Fields"), "com/jaspersoft/ireport/designer/resources/fields-16.png"));
                dlm1.addElement(new NamedIconItem((Object)VARIABLES, I18n.getString("ExpressionEditor.IconName.Variables"), "com/jaspersoft/ireport/designer/resources/variables-16.png"));
            }
            int i = 0;
            for (JRDesignCrosstab crosstab : this.getExpressionContext().getCrosstabs()) {
                ++i;
                String key = crosstab.getKey();
                if (key == null) {
                    key = "";
                }
                dlm1.addElement(new NamedIconItem((Object)crosstab, I18n.getString("ExpressionEditor.IconName.Crosstab") + i + ") " + key, "com/jaspersoft/ireport/designer/resources/crosstab-16.png"));
            }
        }
        dlm1.addElement(new NamedIconItem((Object)USER_DEFINED_EXPRESSIONS, I18n.getString("ExpressionEditor.IconName.UserDefinedExpr"), "com/jaspersoft/ireport/designer/resources/fields-16.png"));
        dlm1.addElement(new NamedIconItem((Object)RECENT_EXPRESSIONS, I18n.getString("ExpressionEditor.IconName.RecentExpr"), "com/jaspersoft/ireport/designer/resources/fields-16.png"));
        dlm1.addElement(new NamedIconItem((Object)WIZARDS, I18n.getString("ExpressionEditor.IconName.ExprWiz"), "com/jaspersoft/ireport/designer/resources/fields-16.png"));
        this.jList1.updateUI();
        try {
            if (dlm1.getSize() > 0) {
                if (((NamedIconItem)dlm1.getElementAt(1)).getItem().equals(FIELDS)) {
                    JRDesignDataset ds = this.getExpressionContext().getDatasets().get(0);
                    if (ds.getFieldsList().size() > 0) {
                        this.jList1.setSelectedIndex(1);
                    } else {
                        this.jList1.setSelectedIndex(0);
                    }
                } else {
                    this.jList1.setSelectedIndex(0);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPrintableTypeName(String type) {
        if (type == null) {
            return "void";
        }
        if (type.endsWith(";")) {
            type = type.substring(0, type.length() - 1);
        }
        while (type.startsWith("[")) {
            if ((type = type.substring(1) + "[]").startsWith("[")) continue;
            if (type.startsWith("L")) {
                type = type.substring(1);
            }
            if (type.startsWith("Z")) {
                type = "boolean" + type.substring(1);
            }
            if (type.startsWith("B")) {
                type = "byte" + type.substring(1);
            }
            if (type.startsWith("C")) {
                type = "char" + type.substring(1);
            }
            if (type.startsWith("D")) {
                type = "double" + type.substring(1);
            }
            if (type.startsWith("F")) {
                type = "float" + type.substring(1);
            }
            if (type.startsWith("I")) {
                type = "int" + type.substring(1);
            }
            if (type.startsWith("J")) {
                type = "long" + type.substring(1);
            }
            if (!type.startsWith("S")) continue;
            type = "short" + type.substring(1);
        }
        if (type.startsWith("java.lang.") && (type = type.substring("java.lang.".length())).indexOf(".") > 0) {
            type = "java.lang." + type;
        }
        return type;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane1 = new ExpressionEditorPane();
        this.jPanel3 = new JPanel();
        this.jLabelErrors = new JLabel();
        this.jLabelCaretPosition = new JLabel();
        this.jPanel1 = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jSplitPane3 = new JSplitPane();
        this.jScrollPane3 = new JScrollPane();
        this.jList2 = new JList();
        this.jScrollPane4 = new JScrollPane();
        this.jList3 = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.jButtonImport = new JButton();
        this.jButtonExport = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonApply = new JButton();
        this.setPreferredSize(new Dimension(550, 450));
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.8);
        this.jPanel2.setLayout(new BorderLayout());
        this.jEditorPane1.addInputMethodListener(new InputMethodListener(){

            public void caretPositionChanged(InputMethodEvent evt) {
                ExpressionEditor.this.jEditorPane1CaretPositionChanged(evt);
            }

            public void inputMethodTextChanged(InputMethodEvent evt) {
            }
        });
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabelErrors.setText(NbBundle.getMessage(ExpressionEditor.class, (String)"ExpressionEditor.jLabelErrors.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jLabelErrors, gridBagConstraints);
        this.jLabelCaretPosition.setText(NbBundle.getMessage(ExpressionEditor.class, (String)"ExpressionEditor.jLabelCaretPosition.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jLabelCaretPosition, gridBagConstraints);
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.jPanel1.setLayout(new BorderLayout());
        this.jSplitPane2.setBorder(null);
        this.jSplitPane2.setResizeWeight(0.3);
        this.jSplitPane3.setBorder(null);
        this.jSplitPane3.setResizeWeight(0.5);
        this.jList2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ExpressionEditor.this.jList2MouseClicked(evt);
            }
        });
        this.jList2.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ExpressionEditor.this.jList2ValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jList2);
        this.jSplitPane3.setLeftComponent(this.jScrollPane3);
        this.jList3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ExpressionEditor.this.jList3MouseClicked(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jList3);
        this.jSplitPane3.setRightComponent(this.jScrollPane4);
        this.jSplitPane2.setRightComponent(this.jSplitPane3);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ExpressionEditor.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList1);
        this.jSplitPane2.setLeftComponent(this.jScrollPane2);
        this.jPanel1.add((Component)this.jSplitPane2, "Center");
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.jButtonImport.setText(NbBundle.getMessage(ExpressionEditor.class, (String)"ExpressionEditor.jButtonImport.text"));
        this.jButtonImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor.this.jButtonImportActionPerformed(evt);
            }
        });
        this.jButtonExport.setText(NbBundle.getMessage(ExpressionEditor.class, (String)"ExpressionEditor.jButtonExport.text"));
        this.jButtonExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor.this.jButtonExportActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText(NbBundle.getMessage(ExpressionEditor.class, (String)"ExpressionEditor.jButtonCancel.text"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonApply.setText(NbBundle.getMessage(ExpressionEditor.class, (String)"ExpressionEditor.jButtonApply.text"));
        this.jButtonApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor.this.jButtonApplyActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSplitPane1, -1, 530, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonImport).addPreferredGap(0).add((Component)this.jButtonExport).addPreferredGap(0, 240, Short.MAX_VALUE).add((Component)this.jButtonApply).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jSplitPane1, -1, 399, Short.MAX_VALUE).add(6, 6, 6).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonImport).add((Component)this.jButtonExport).add((Component)this.jButtonCancel).add((Component)this.jButtonApply)).addContainerGap()));
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        DefaultListModel dlm2 = (DefaultListModel)this.jList2.getModel();
        DefaultListModel dlm3 = (DefaultListModel)this.jList3.getModel();
        dlm2.removeAllElements();
        dlm3.removeAllElements();
        if (this.jList1.getSelectedValue() != null) {
            NamedIconItem item = (NamedIconItem)this.jList1.getSelectedValue();
            if (item.getItem().equals(USER_DEFINED_EXPRESSIONS)) {
                ArrayList<String> exps = ExpressionEditor.getPredefinedExpressions();
                for (String s : exps) {
                    dlm2.addElement(s);
                }
            } else if (item.getItem().equals(RECENT_EXPRESSIONS)) {
                for (String s : recentExpressions) {
                    dlm2.addElement(s);
                }
            } else if (item.getItem().equals(PARAMETERS)) {
                JRDesignDataset ds = this.getExpressionContext().getDatasets().get(0);
                Iterator parameters = ds.getParametersList().iterator();
                while (parameters.hasNext()) {
                    dlm2.addElement(new ExpObject(parameters.next()));
                }
            } else if (item.getItem().equals(FIELDS)) {
                JRDesignDataset ds = this.getExpressionContext().getDatasets().get(0);
                Iterator fields = ds.getFieldsList().iterator();
                while (fields.hasNext()) {
                    dlm2.addElement(new ExpObject(fields.next()));
                }
            } else if (item.getItem().equals(VARIABLES)) {
                JRDesignDataset ds = this.getExpressionContext().getDatasets().get(0);
                Iterator variables = ds.getVariablesList().iterator();
                while (variables.hasNext()) {
                    dlm2.addElement(new ExpObject(variables.next()));
                }
            } else if (item.getItem() instanceof JRDesignCrosstab) {
                int i;
                JRDesignCrosstab crosstab = (JRDesignCrosstab)item.getItem();
                List rowGroups = crosstab.getRowGroupsList();
                List columnGroups = crosstab.getColumnGroupsList();
                for (JRDesignCrosstabMeasure measure : crosstab.getMesuresList()) {
                    dlm2.addElement(new ExpObject(measure.getVariable()));
                    for (int i2 = 0; i2 < rowGroups.size(); ++i2) {
                        JRDesignCrosstabRowGroup rowGroup = (JRDesignCrosstabRowGroup)rowGroups.get(i2);
                        dlm2.addElement(new CrosstabTotalVariable((JRCrosstabMeasure)measure, (JRCrosstabRowGroup)rowGroup, null));
                        for (int j = 0; j < columnGroups.size(); ++j) {
                            JRDesignCrosstabColumnGroup columnGroup = (JRDesignCrosstabColumnGroup)columnGroups.get(j);
                            if (j == 0) {
                                dlm2.addElement(new CrosstabTotalVariable((JRCrosstabMeasure)measure, null, (JRCrosstabColumnGroup)columnGroup));
                            }
                            dlm2.addElement(new CrosstabTotalVariable((JRCrosstabMeasure)measure, (JRCrosstabRowGroup)rowGroup, (JRCrosstabColumnGroup)columnGroup));
                        }
                    }
                }
                for (i = 0; i < rowGroups.size(); ++i) {
                    JRDesignCrosstabRowGroup rowGroup = (JRDesignCrosstabRowGroup)rowGroups.get(i);
                    dlm2.addElement(new ExpObject(rowGroup.getVariable()));
                }
                for (i = 0; i < columnGroups.size(); ++i) {
                    JRDesignCrosstabColumnGroup columnGroup = (JRDesignCrosstabColumnGroup)columnGroups.get(i);
                    dlm2.addElement(new ExpObject(columnGroup.getVariable()));
                }
                List crosstabParameters = crosstab.getParametersList();
                for (int i3 = 0; i3 < crosstabParameters.size(); ++i3) {
                    JRDesignCrosstabParameter parameter = (JRDesignCrosstabParameter)crosstabParameters.get(i3);
                    dlm2.addElement(new ExpObject(parameter));
                }
            }
            if (dlm2.size() > 0) {
                this.jList2.setSelectedIndex(0);
            }
        }
    }

    private void jList2ValueChanged(ListSelectionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.jList3.getModel();
        dlm.removeAllElements();
        Class<?> clazz = null;
        if (this.jList2.getSelectedValue() instanceof ExpObject) {
            try {
                clazz = IReportManager.getReportClassLoader().loadClass(((ExpObject)this.jList2.getSelectedValue()).getClassType());
            }
            catch (NoClassDefFoundError ex) {
            }
            catch (ClassNotFoundException ex2) {
            }
            catch (Throwable ex3) {
                // empty catch block
            }
        }
        if (clazz != null) {
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if ((methods[i].getModifiers() & 1) == 0) continue;
                String method_firm = methods[i].getName() + "(";
                Class<?>[] params = methods[i].getParameterTypes();
                int j = 0;
                for (j = 0; j < params.length; ++j) {
                    method_firm = j > 0 ? method_firm + ", " : method_firm + " ";
                    method_firm = method_firm + this.getPrintableTypeName(params[j].getName());
                }
                if (j > 0) {
                    method_firm = method_firm + " ";
                }
                method_firm = method_firm + ") ";
                String rname = methods[i].getReturnType().getName();
                if (rname.equals("void")) continue;
                method_firm = method_firm + this.getPrintableTypeName(rname);
                dlm.addElement(method_firm);
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if (this.dialog != null && this.dialog.isVisible()) {
            this.dialogResult = 2;
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void jList3MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && this.jList2.getSelectedValue() != null && this.jList3.getSelectedValue() != null) {
            try {
                String objName = "";
                objName = this.jList2.getSelectedValue() instanceof ExpObject ? ((ExpObject)this.jList2.getSelectedValue()).getExpression() : "" + this.jList2.getSelectedValue();
                String method = this.jList3.getSelectedValue() + "";
                method = method.substring(0, method.lastIndexOf(")") + 1);
                this.jEditorPane1.replaceSelection(objName + "." + method);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jList2MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            try {
                String objName = "";
                objName = this.jList2.getSelectedValue() instanceof ExpObject ? ((ExpObject)this.jList2.getSelectedValue()).getExpression() : "" + this.jList2.getSelectedValue();
                this.jEditorPane1.replaceSelection(objName + "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        if (this.dialog != null && this.dialog.isVisible()) {
            String exp = this.getExpression();
            recentExpressions.remove(exp);
            recentExpressions.add(0, exp);
            this.dialogResult = 0;
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void jButtonImportActionPerformed(ActionEvent evt) {
        String expression = Misc.loadExpression(this);
        if (expression != null) {
            this.jEditorPane1.setText(expression);
        }
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        Misc.saveExpression(this.jEditorPane1.getText(), this);
    }

    private void jEditorPane1CaretPositionChanged(InputMethodEvent evt) {
    }

    public int showDialog(Component parent) {
        Window pWin;
        this.jButtonApply.setVisible(true);
        this.jButtonCancel.setVisible(true);
        Window window = pWin = parent != null ? SwingUtilities.windowForComponent(parent) : null;
        this.dialog = pWin instanceof Dialog ? new JDialog((Dialog)pWin) : (pWin instanceof Frame ? new JDialog((Frame)pWin) : new JDialog());
        this.dialog.setModal(true);
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialogResult = 2;
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setTitle(I18n.getString("ExpressionEditor.Title.ExpressionEditor"));
        this.dialog.setVisible(true);
        return this.dialogResult;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.isEnabled() && this.isFocusable()) {
            this.jEditorPane1.requestFocus();
        }
    }

    static {
        defaultExpressions = new ArrayList();
        defaultExpressions.add("( <condition> ? exp1 : exp2 )");
        defaultExpressions.add("msg(<pattern>, <arg0>)");
        defaultExpressions.add("msg(<pattern>, <arg0>, <arg1>)");
        defaultExpressions.add("msg(<pattern>, <arg0>, <arg1>, <arg2>)");
        defaultExpressions.add("str(<key>)");
        defaultExpressions.add("((net.sf.jasperreports.engine.data.JRXmlDataSource)$P{REPORT_DATA_SOURCE}).subDataSource(<select expression>)");
        defaultExpressions.add("((net.sf.jasperreports.engine.data.JRXmlDataSource)$P{REPORT_DATA_SOURCE}).dataSource(<select expression>)");
    }
}

