/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.errorhandler;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditor;
import com.jaspersoft.ireport.designer.errorhandler.ProblemItem;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.outline.nodes.ExpressionHolder;
import com.jaspersoft.ireport.designer.outline.nodes.ReportNode;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.beans.PropertyVetoException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.openide.nodes.Node;

public class ErrorLocator {
    public void locateError(JrxmlVisualView view, ProblemItem item) {
        Node node = IReportManager.getInstance().findNodeOf(item.getProblemReference(), (Node)view.getModel());
        if (node != null) {
            this.focusNode(view, node);
        }
        if (item.getProblemReference() instanceof JRDesignExpression) {
            this.focusExpression(view, (JRDesignExpression)item.getProblemReference());
        }
    }

    public void focusNode(JrxmlVisualView view, Node node) {
        try {
            view.getExplorerManager().setSelectedNodes(new Node[]{node});
            if (node instanceof ElementNode) {
                JRDesignElement element = ((ElementNode)node).getElement();
                AbstractReportObjectScene scene = view.getReportDesignerPanel().getSceneOf(element);
                if (scene != null) {
                    scene.assureVisible(element);
                }
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void focusExpression(JrxmlVisualView view, JRDesignExpression expression) {
        ReportNode root = view.getModel();
        Node node = this.findExpressionNode((Node)root, expression);
        if (node != null) {
            this.focusNode(view, node);
        }
        ExpressionEditor editor = new ExpressionEditor();
        if (node instanceof ExpressionHolder) {
            ExpressionContext context = ((ExpressionHolder)node).getExpressionContext(expression);
            editor.setExpressionContext(context);
        }
        editor.setExpression(Misc.getExpressionText((JRExpression)expression));
        if (editor.showDialog(Misc.getMainFrame()) == 0) {
            expression.setText(editor.getExpression());
            IReportManager.getInstance().notifyReportChange();
        }
    }

    public Node findExpressionNode(Node node, JRDesignExpression expression) {
        if (node instanceof ExpressionHolder && ((ExpressionHolder)node).hasExpression(expression)) {
            return node;
        }
        Node[] nodes = node.getChildren().getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            Node newNode = this.findExpressionNode(nodes[i], expression);
            if (newNode == null) continue;
            return newNode;
        }
        return null;
    }
}

