/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.fonts;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.fonts.SimpleFontFamilyEx;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.xerces.parsers.DOMParser;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IRFontUtils {
    public static List<SimpleFontFamilyEx> loadFonts() {
        ArrayList<SimpleFontFamilyEx> fontsList = new ArrayList<SimpleFontFamilyEx>();
        try {
            File fontsDir = Misc.getFontsDirectory();
            if (fontsDir == null) {
                throw new Exception("I'm unable to find the fonts directory of iReport!!");
            }
            File xmlFile = new File(fontsDir, "irfonts.xml");
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(DOMParser.class.getClassLoader());
            DOMParser parser = new DOMParser();
            FileInputStream fis = new FileInputStream(xmlFile);
            InputSource input_sss = new InputSource(fis);
            parser.parse(input_sss);
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            Document document = parser.getDocument();
            Element node = document.getDocumentElement();
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                Node connectionNode = list_child.item(ck);
                if (connectionNode.getNodeName() == null || !connectionNode.getNodeName().equals("bean")) continue;
                SimpleFontFamilyEx family = new SimpleFontFamilyEx();
                NodeList list_child2 = connectionNode.getChildNodes();
                for (int ck2 = 0; ck2 < list_child2.getLength(); ++ck2) {
                    NamedNodeMap nnm2;
                    Node child_child = list_child2.item(ck2);
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("property") || (nnm2 = child_child.getAttributes()).getNamedItem("name") == null) continue;
                    String att = nnm2.getNamedItem("name").getNodeValue();
                    if (nnm2.getNamedItem("value") != null) {
                        String value = nnm2.getNamedItem("value").getNodeValue();
                        if (att.equals("name")) {
                            family.setName(value);
                        }
                        if (att.equals("normal")) {
                            family.setNormalFont(value);
                        }
                        if (att.equals("bold")) {
                            family.setBoldFont(value);
                        }
                        if (att.equals("italic")) {
                            family.setItalicFont(value);
                        }
                        if (att.equals("boldItalic")) {
                            family.setBoldItalicFont(value);
                        }
                        if (att.equals("pdfEncoding")) {
                            family.setPdfEncoding(value);
                        }
                        if (att.equals("pdfEmbedded")) {
                            family.setPdfEmbedded(value.equals("true"));
                        }
                    }
                    if (att.equals("locales")) {
                        family.setLocales(new HashSet<String>(IRFontUtils.getLocales(child_child)));
                    }
                    if (!att.equals("exportFonts")) continue;
                    family.setExportFonts(IRFontUtils.getMappings(child_child));
                }
                fontsList.add(family);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return fontsList;
    }

    private static List<String> getLocales(Node node) {
        ArrayList<String> locales = new ArrayList<String>();
        Node setNode = IRFontUtils.getSubNode(node, "set");
        if (setNode != null) {
            List<Node> valueNodes = IRFontUtils.getSubNodes(setNode, "value");
            for (Node tmpNode : valueNodes) {
                locales.add(Misc.readPCDATA(tmpNode, true));
            }
        }
        return locales;
    }

    private static List<Node> getSubNodes(Node node, String subNodeName) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list_child = node.getChildNodes();
        for (int ck = 0; ck < list_child.getLength(); ++ck) {
            Node tmpNode = list_child.item(ck);
            if (tmpNode.getNodeName() == null || !tmpNode.getNodeName().equals(subNodeName)) continue;
            nodes.add(tmpNode);
            break;
        }
        return nodes;
    }

    private static Node getSubNode(Node node, String subNodeName) {
        List<Node> nodes = IRFontUtils.getSubNodes(node, subNodeName);
        if (nodes.size() > 0) {
            return nodes.get(0);
        }
        return null;
    }

    private static Map<String, String> getMappings(Node node) {
        HashMap<String, String> map = new HashMap<String, String>();
        Node mapNode = IRFontUtils.getSubNode(node, "map");
        if (mapNode != null) {
            List<Node> entryNodes = IRFontUtils.getSubNodes(mapNode, "entry");
            for (Node tmpNode : entryNodes) {
                String key = tmpNode.getAttributes().getNamedItem("key").getNodeValue();
                String value = "";
                Node valNode = IRFontUtils.getSubNode(tmpNode, "value");
                if (valNode != null) {
                    value = Misc.readPCDATA(valNode, true);
                }
                if (value == null || value.length() <= 0 || key == null || key.length() <= 0) continue;
                map.put(key, value);
            }
        }
        return map;
    }

    public static void saveFonts(List<SimpleFontFamilyEx> fonts) {
        try {
            File fontsDir = Misc.getFontsDirectory();
            if (fontsDir == null) {
                throw new Exception("I'm unable to find the fonts directory of iReport!!");
            }
            File xmlFile = new File(fontsDir, "irfonts.xml");
            PrintWriter pw = new PrintWriter(xmlFile);
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            pw.println("<beans xmlns=\"http://www.springframework.org/schema/beans\"");
            pw.println("       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            pw.println("       xsi:schemaLocation=\"http://www.springframework.org/schema/beans");
            pw.println("           http://www.springframework.org/schema/beans/spring-beans-2.0.xsd\">\n");
            for (SimpleFontFamilyEx font : fonts) {
                pw.print(IRFontUtils.dumpBean(font));
            }
            pw.println("</beans>");
            pw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String dumpBean(SimpleFontFamilyEx font) {
        StringBuffer bean_xml = new StringBuffer("");
        bean_xml.append("   <bean id=\"fontBean" + new Date().getTime() + (long)(Math.random() * 100000.0) + "\" class=\"net.sf.jasperreports.engine.fonts.SimpleFontFamily\">\n");
        bean_xml.append("       <property name=\"name\" value=\"" + Misc.escapeXMLEntity(font.getName()) + "\"/>\n");
        if (font.getNormalFont() != null && font.getNormalFont().length() > 0) {
            bean_xml.append("       <property name=\"normal\" value=\"" + Misc.escapeXMLEntity(font.getNormalFont()) + "\"/>\n");
        }
        if (font.getBoldFont() != null && font.getBoldFont().length() > 0) {
            bean_xml.append("       <property name=\"bold\" value=\"" + Misc.escapeXMLEntity(font.getBoldFont()) + "\"/>\n");
        }
        if (font.getItalicFont() != null && font.getItalicFont().length() > 0) {
            bean_xml.append("       <property name=\"italic\" value=\"" + Misc.escapeXMLEntity(font.getItalicFont()) + "\"/>\n");
        }
        if (font.getBoldItalicFont() != null && font.getBoldItalicFont().length() > 0) {
            bean_xml.append("       <property name=\"boldItalic\" value=\"" + Misc.escapeXMLEntity(font.getBoldItalicFont()) + "\"/>\n");
        }
        if (font.getPdfEncoding() != null && font.getPdfEncoding().length() > 0) {
            bean_xml.append("       <property name=\"pdfEncoding\" value=\"" + Misc.escapeXMLEntity(font.getPdfEncoding()) + "\"/>\n");
        }
        bean_xml.append("       <property name=\"pdfEmbedded\" value=\"" + font.isPdfEmbedded() + "\"/>\n");
        if (font.getExportFonts() != null && font.getExportFonts().size() > 0) {
            bean_xml.append("       <property name=\"exportFonts\">\n");
            bean_xml.append("           <map>\n");
            for (String key : font.getExportFonts().keySet()) {
                bean_xml.append("               <entry key=\"" + Misc.escapeXMLEntity(key) + "\">\n");
                bean_xml.append("                   <value><![CDATA[" + font.getExportFonts().get(key) + "]]></value>\n");
                bean_xml.append("               </entry>\n");
            }
            bean_xml.append("           </map>\n");
            bean_xml.append("       </property>\n");
        }
        if (font.getLocales() != null && font.getLocales().size() > 0) {
            bean_xml.append("       <property name=\"locales\">\n");
            bean_xml.append("           <set>\n");
            for (String key : font.getLocales()) {
                bean_xml.append("               <value><![CDATA[" + key + "]]></value>\n");
            }
            bean_xml.append("           </set>\n");
            bean_xml.append("       </property>\n");
        }
        bean_xml.append("   </bean>\n\n");
        return bean_xml.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export(Object[] fonts) {
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.setDialogTitle(I18n.getString("IReportPanel.Title.Dialog"));
        jfc.setDialogTitle(I18n.getString("IReportPanel.Title.Dialog"));
        jfc.setAcceptAllFileFilterUsed(true);
        jfc.setFileSelectionMode(0);
        jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".jar") || file.isDirectory() || filename.toLowerCase().endsWith(".zip");
            }

            public String getDescription() {
                return "*.jar, *.zip";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(1);
        if (jfc.showSaveDialog(Misc.getMainFrame()) == 0) {
            File jarFile = jfc.getSelectedFile();
            File fontsDir = Misc.getFontsDirectory();
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(jarFile);
                ZipOutputStream zipos = new ZipOutputStream(fos);
                zipos.setMethod(8);
                String fontXmlFile = "fonts" + new Date().getTime() + ".xml";
                ZipEntry propsEntry = new ZipEntry("jasperreports_extension.properties");
                zipos.putNextEntry(propsEntry);
                PrintWriter pw = new PrintWriter(zipos);
                pw.println("net.sf.jasperreports.extension.registry.factory.fonts=net.sf.jasperreports.extensions.SpringExtensionsRegistryFactory");
                pw.println("net.sf.jasperreports.extension.fonts.spring.beans.resource=fonts/" + fontXmlFile);
                pw.flush();
                ZipEntry fontsXmlEntry = new ZipEntry("fonts/" + fontXmlFile);
                zipos.putNextEntry(fontsXmlEntry);
                pw = new PrintWriter(zipos);
                pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                pw.println("<beans xmlns=\"http://www.springframework.org/schema/beans\"");
                pw.println("       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                pw.println("       xsi:schemaLocation=\"http://www.springframework.org/schema/beans");
                pw.println("           http://www.springframework.org/schema/beans/spring-beans-2.0.xsd\">\n");
                ArrayList<File> files = new ArrayList<File>();
                for (Object font : fonts) {
                    if (!(font instanceof SimpleFontFamilyEx)) continue;
                    SimpleFontFamilyEx sff = (SimpleFontFamilyEx)((Object)font);
                    String[] fontNames = new String[]{sff.getNormalFont(), sff.getBoldFont(), sff.getItalicFont(), sff.getBoldItalicFont()};
                    for (int i = 0; i < fontNames.length; ++i) {
                        File fromFile;
                        if (fontNames[i] == null || fontNames[i].length() <= 0 || !(fromFile = new File(fontsDir, fontNames[i])).exists()) continue;
                        files.add(fromFile);
                    }
                    sff = IRFontUtils.convertFontFamily(sff, "fonts/");
                    pw.println(IRFontUtils.dumpBean(sff));
                }
                pw.println("</beans>");
                pw.flush();
                for (File f : files) {
                    ZipEntry ttfZipEntry = new ZipEntry("fonts/" + f.getName());
                    zipos.putNextEntry(ttfZipEntry);
                    FileUtil.copy((InputStream)new FileInputStream(f), (OutputStream)zipos);
                }
                zipos.flush();
                zipos.finish();
                JOptionPane.showMessageDialog(Misc.getMainFrame(), "Extension Jar succesfully created", "Done", 1);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Misc.getMainFrame(), ex.getMessage(), "Error", 0);
                return;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private static SimpleFontFamilyEx convertFontFamily(SimpleFontFamilyEx font, String fontPath) {
        File f;
        SimpleFontFamilyEx newFont = new SimpleFontFamilyEx();
        newFont.setName(font.getName());
        newFont.setLocales(font.getLocales());
        newFont.setExportFonts(font.getExportFonts());
        newFont.setPdfEmbedded(font.isPdfEmbedded());
        newFont.setPdfEncoding(font.getPdfEncoding());
        newFont.setName(font.getName());
        String fname = font.getNormalFont();
        if (fname != null && fname.length() > 0) {
            f = new File(fname);
            newFont.setNormalFont(fontPath + f.getName());
        }
        if ((fname = font.getBoldFont()) != null && fname.length() > 0) {
            f = new File(fname);
            newFont.setBoldFont(fontPath + f.getName());
        }
        if ((fname = font.getItalicFont()) != null && fname.length() > 0) {
            f = new File(fname);
            newFont.setItalicFont(fontPath + f.getName());
        }
        if ((fname = font.getBoldItalicFont()) != null && fname.length() > 0) {
            f = new File(fname);
            newFont.setBoldItalicFont(fontPath + f.getName());
        }
        return newFont;
    }
}

