/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 * 
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 * 
 * This program is part of iReport.
 * 
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.charts.datasets.wizards;

import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public final class PieVisualPanel2 extends JPanel {

    private JRDesignDataset lastDs = null;
    private PieWizardPanel2 wizardPanel = null;

    /** Creates new form PieVisualPanel2 */
    public PieVisualPanel2(PieWizardPanel2 wizardPanel) {
        initComponents();
        this.wizardPanel = wizardPanel;
        
        DocumentListener dl = new DocumentListener() {

            public void insertUpdate(DocumentEvent e) {
                fireChangeEvent();
            }

            public void removeUpdate(DocumentEvent e) {
                fireChangeEvent();
            }

            public void changedUpdate(DocumentEvent e) {
                fireChangeEvent();
            }
        };

        jRTextExpressionKey.getExpressionEditorPane().getDocument().addDocumentListener(dl);
        jRTextExpressionValue.getExpressionEditorPane().getDocument().addDocumentListener(dl);
    }

    private void fireChangeEvent()
    {
        getWizardPanel().fireChangeEvent();
    }


    public void validateForm()
    {
        String key = jRTextExpressionKey.getText();
        if (key.trim().length() == 0)
        {
           throw new IllegalArgumentException(NbBundle.getMessage(PieVisualPanel1.class, "PieVisualPanel2.invalidKeyExpression"));
        }

        String value = jRTextExpressionValue.getText();
        if (value.trim().length() == 0)
        {
           throw new IllegalArgumentException(NbBundle.getMessage(PieVisualPanel1.class, "PieVisualPanel2.invalidValueExpression"));
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(PieVisualPanel1.class, "PieVisualPanel2.name");
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jRTextExpressionKey = new com.jaspersoft.ireport.designer.editor.ExpressionEditorArea();
        jLabel3 = new javax.swing.JLabel();
        jRTextExpressionValue = new com.jaspersoft.ireport.designer.editor.ExpressionEditorArea();

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/charts/datasets/wizards/pie.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(PieVisualPanel2.class, "PieVisualPanel2.jLabel1.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(PieVisualPanel2.class, "PieVisualPanel2.jLabel2.text")); // NOI18N

        jRTextExpressionKey.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jRTextExpressionKey.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionKey.setPreferredSize(new java.awt.Dimension(10, 10));

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(PieVisualPanel2.class, "PieVisualPanel2.jLabel3.text")); // NOI18N

        jRTextExpressionValue.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jRTextExpressionValue.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionValue.setPreferredSize(new java.awt.Dimension(10, 10));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jRTextExpressionValue, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 536, Short.MAX_VALUE)
                    .add(jLabel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 536, Short.MAX_VALUE)
                    .add(jRTextExpressionKey, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 536, Short.MAX_VALUE)
                    .add(jLabel3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 536, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 536, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jRTextExpressionKey, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jRTextExpressionValue, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private com.jaspersoft.ireport.designer.editor.ExpressionEditorArea jRTextExpressionKey;
    private com.jaspersoft.ireport.designer.editor.ExpressionEditorArea jRTextExpressionValue;
    // End of variables declaration//GEN-END:variables


    public void readSettings(Object settings) {

        JRDesignDataset ds = (JRDesignDataset) ((WizardDescriptor)settings).getProperty("dataset");

        if (lastDs != ds)
        {
            jRTextExpressionKey.setExpressionContext(new ExpressionContext(ds));
            jRTextExpressionValue.setExpressionContext(new ExpressionContext(ds));
            jRTextExpressionKey.setText("");
            jRTextExpressionValue.setText("");
            
        }
    }

    public void storeSettings(Object settings) {
        ((WizardDescriptor)settings).putProperty("keyExpression", jRTextExpressionKey.getText());
        ((WizardDescriptor)settings).putProperty("valueExpression", jRTextExpressionValue.getText());
    }

    /**
     * @return the wizardPanel
     */
    public PieWizardPanel2 getWizardPanel() {
        return wizardPanel;
    }

    /**
     * @param wizardPanel the wizardPanel to set
     */
    public void setWizardPanel(PieWizardPanel2 wizardPanel) {
        this.wizardPanel = wizardPanel;
    }
    

}

