/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer.editable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.AttributeSet;
import javax.swing.text.EditorKit;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.builtin.visualizer.editable.DecoratedEditorPane;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffViewManager;
import org.netbeans.modules.diff.builtin.visualizer.editable.EditableDiffView;
import org.netbeans.modules.diff.builtin.visualizer.editable.LineNumbersActionsBar;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;

class DiffContentPanel
extends JPanel
implements HighlightsContainer {
    private final EditableDiffView master;
    private final boolean isFirst;
    private final DecoratedEditorPane editorPane;
    private JScrollPane scrollPane;
    private final LineNumbersActionsBar linesActions;
    private final JScrollPane actionsScrollPane;
    private Difference[] currentDiff;
    private final List<HighlightsChangeListener> listeners = new ArrayList<HighlightsChangeListener>(1);

    public DiffContentPanel(EditableDiffView editableDiffView, boolean bl) {
        this.master = editableDiffView;
        this.isFirst = bl;
        this.setLayout(new BorderLayout());
        this.editorPane = new DecoratedEditorPane(this);
        this.editorPane.setEditable(false);
        this.scrollPane = new JScrollPane(this.editorPane);
        this.add(this.scrollPane);
        this.linesActions = new LineNumbersActionsBar(this, editableDiffView.isActionsEnabled());
        this.actionsScrollPane = new JScrollPane(this.linesActions);
        this.actionsScrollPane.setHorizontalScrollBarPolicy(31);
        this.actionsScrollPane.setVerticalScrollBarPolicy(21);
        this.actionsScrollPane.setBorder(null);
        this.add((Component)this.actionsScrollPane, bl ? "After" : "Before");
        this.editorPane.putClientProperty("org.netbeans.modules.diff.builtin.visualizer.editable.DiffContentPanel", this);
        if (!bl) {
            this.editorPane.putClientProperty("errorStripeOnly", Boolean.TRUE);
            this.editorPane.putClientProperty("code-folding-enable", false);
        }
    }

    void initActions() {
        ActionMap actionMap = this.editorPane.getActionMap();
        ActionMap actionMap2 = this.getActionMap();
        actionMap2.setParent(actionMap);
        actionMap.put("cut-to-clipboard", this.getAction("cut-to-clipboard"));
        actionMap.put("copy-to-clipboard", this.getAction("copy-to-clipboard"));
        actionMap.put("delete", this.getAction("delete-next"));
        actionMap.put("paste-from-clipboard", this.getAction("paste-from-clipboard"));
    }

    private Action getAction(String string) {
        if (string == null) {
            return null;
        }
        EditorKit editorKit = this.editorPane.getEditorKit();
        if (editorKit == null) {
            return null;
        }
        Action[] actionArray = editorKit.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            if (!string.equals(actionArray[i].getValue("Name"))) continue;
            return actionArray[i];
        }
        return null;
    }

    LineNumbersActionsBar getLinesActions() {
        return this.linesActions;
    }

    public JScrollPane getActionsScrollPane() {
        return this.actionsScrollPane;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public Difference[] getCurrentDiff() {
        return this.currentDiff;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public void setCurrentDiff(Difference[] differenceArray) {
        this.currentDiff = differenceArray;
        this.editorPane.setDifferences(differenceArray);
        this.linesActions.onDiffSetChanged();
        this.fireHilitingChanged();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Container container = this.getParent();
        if (container instanceof JViewport && container.getWidth() > dimension.width) {
            dimension = new Dimension(container.getWidth(), dimension.height);
        }
        return dimension;
    }

    public DecoratedEditorPane getEditorPane() {
        return this.editorPane;
    }

    public AccessibleContext getAccessibleContext() {
        return this.editorPane.getAccessibleContext();
    }

    public EditableDiffView getMaster() {
        return this.master;
    }

    HighlightsContainer getHighlightsContainer() {
        return this;
    }

    public HighlightsSequence getHighlights(int n, int n2) {
        return new DiffHighlightsSequence(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHighlightsChangeListener(HighlightsChangeListener highlightsChangeListener) {
        List<HighlightsChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(highlightsChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHighlightsChangeListener(HighlightsChangeListener highlightsChangeListener) {
        List<HighlightsChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(highlightsChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireHilitingChanged() {
        List<HighlightsChangeListener> list = this.listeners;
        synchronized (list) {
            for (HighlightsChangeListener highlightsChangeListener : this.listeners) {
                highlightsChangeListener.highlightChanged(new HighlightsChangeEvent((HighlightsContainer)this, 0, Integer.MAX_VALUE));
            }
        }
    }

    void onUISettingsChanged() {
        this.editorPane.repaint();
        this.linesActions.onUISettingsChanged();
        this.actionsScrollPane.revalidate();
        this.actionsScrollPane.repaint();
        this.revalidate();
        this.repaint();
    }

    public void setCustomEditor(JComponent jComponent) {
        this.remove(this.scrollPane);
        Container container = this.editorPane.getParent();
        if (container instanceof JViewport && (container = container.getParent()) instanceof JScrollPane) {
            this.scrollPane = (JScrollPane)container;
            this.add(jComponent);
        }
    }

    private class DiffHighlightsSequence
    implements HighlightsSequence {
        private final int endOffset;
        private final int startOffset;
        private int currentHiliteIndex = -1;
        private DiffViewManager.HighLight[] hilites;

        public DiffHighlightsSequence(int n, int n2) {
            this.startOffset = n;
            this.endOffset = n2;
            this.lookupHilites();
        }

        private void lookupHilites() {
            DiffViewManager.HighLight[] highLightArray;
            ArrayList<DiffViewManager.HighLight> arrayList = new ArrayList<DiffViewManager.HighLight>();
            for (DiffViewManager.HighLight highLight : highLightArray = DiffContentPanel.this.isFirst ? DiffContentPanel.this.master.getManager().getFirstHighlights() : DiffContentPanel.this.master.getManager().getSecondHighlights()) {
                if (highLight.getEndOffset() < this.startOffset) continue;
                if (highLight.getStartOffset() > this.endOffset) break;
                arrayList.add(highLight);
            }
            this.hilites = arrayList.toArray(new DiffViewManager.HighLight[arrayList.size()]);
        }

        public boolean moveNext() {
            if (this.currentHiliteIndex >= this.hilites.length - 1) {
                return false;
            }
            ++this.currentHiliteIndex;
            return true;
        }

        public int getStartOffset() {
            return this.hilites[this.currentHiliteIndex].getStartOffset();
        }

        public int getEndOffset() {
            return this.hilites[this.currentHiliteIndex].getEndOffset();
        }

        public AttributeSet getAttributes() {
            return this.hilites[this.currentHiliteIndex].getAttrs();
        }
    }
}

