/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.fonts;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.fonts.SimpleFontFamilyEx;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.xerces.parsers.DOMParser;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IRFontUtils {
    public static List<SimpleFontFamilyEx> loadFonts() {
        ArrayList<SimpleFontFamilyEx> fontsList = new ArrayList<SimpleFontFamilyEx>();
        try {
            File fontsDir = Misc.getFontsDirectory();
            if (fontsDir == null) {
                throw new Exception("I'm unable to find the fonts directory of iReport!!");
            }
            File xmlFile = new File(fontsDir, "irfonts.xml");
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(DOMParser.class.getClassLoader());
            DOMParser parser = new DOMParser();
            FileInputStream fis = new FileInputStream(xmlFile);
            InputSource input_sss = new InputSource(fis);
            parser.parse(input_sss);
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            Document document = parser.getDocument();
            Element node = document.getDocumentElement();
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                Node connectionNode = list_child.item(ck);
                if (connectionNode.getNodeName() == null || !connectionNode.getNodeName().equals("fontFamily")) continue;
                SimpleFontFamilyEx family = new SimpleFontFamilyEx();
                NamedNodeMap familyAttributes = connectionNode.getAttributes();
                if (familyAttributes.getNamedItem("name") != null) {
                    family.setName(familyAttributes.getNamedItem("name").getNodeValue());
                }
                NodeList list_child2 = connectionNode.getChildNodes();
                for (int ck2 = 0; ck2 < list_child2.getLength(); ++ck2) {
                    Node child_child = list_child2.item(ck2);
                    if (child_child.getNodeType() != 1) continue;
                    String property = child_child.getNodeName();
                    String value = Misc.readPCDATA(child_child);
                    if (property.equals("normal")) {
                        family.setNormalFont(value);
                    }
                    if (property.equals("bold")) {
                        family.setBoldFont(value);
                    }
                    if (property.equals("italic")) {
                        family.setItalicFont(value);
                    }
                    if (property.equals("boldItalic")) {
                        family.setBoldItalicFont(value);
                    }
                    if (property.equals("pdfEncoding")) {
                        family.setPdfEncoding(value);
                    }
                    if (property.equals("pdfEmbedded")) {
                        family.setPdfEmbedded(value.equals("true"));
                    }
                    if (property.equals("locales")) {
                        family.setLocales(new HashSet<String>(IRFontUtils.getLocales(child_child)));
                    }
                    if (!property.equals("exportFonts")) continue;
                    family.setExportFonts(IRFontUtils.getMappings(child_child));
                }
                fontsList.add(family);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return fontsList;
    }

    private static List<String> getLocales(Node node) {
        ArrayList<String> locales = new ArrayList<String>();
        if (node != null) {
            List<Node> valueNodes = IRFontUtils.getSubNodes(node, "locale");
            for (Node tmpNode : valueNodes) {
                locales.add(Misc.readPCDATA(tmpNode, true));
            }
        }
        return locales;
    }

    private static List<Node> getSubNodes(Node node, String subNodeName) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list_child = node.getChildNodes();
        for (int ck = 0; ck < list_child.getLength(); ++ck) {
            Node tmpNode = list_child.item(ck);
            if (tmpNode.getNodeName() == null || !tmpNode.getNodeName().equals(subNodeName)) continue;
            nodes.add(tmpNode);
            break;
        }
        return nodes;
    }

    private static Node getSubNode(Node node, String subNodeName) {
        List<Node> nodes = IRFontUtils.getSubNodes(node, subNodeName);
        if (nodes.size() > 0) {
            return nodes.get(0);
        }
        return null;
    }

    private static Map<String, String> getMappings(Node node) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (node != null) {
            List<Node> entryNodes = IRFontUtils.getSubNodes(node, "export");
            for (Node tmpNode : entryNodes) {
                String key = tmpNode.getAttributes().getNamedItem("key").getNodeValue();
                String value = Misc.readPCDATA(tmpNode, true);
                if (value == null || value.length() <= 0 || key == null || key.length() <= 0) continue;
                map.put(key, value);
            }
        }
        return map;
    }

    public static void saveFonts(List<SimpleFontFamilyEx> fonts) {
        try {
            File fontsDir = Misc.getFontsDirectory();
            if (fontsDir == null) {
                throw new Exception("I'm unable to find the fonts directory of iReport!!");
            }
            File xmlFile = new File(fontsDir, "irfonts.xml");
            PrintWriter pw = new PrintWriter(xmlFile);
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            pw.println("<fontFamilies>");
            for (SimpleFontFamilyEx font : fonts) {
                pw.print(IRFontUtils.dumpBean(font));
            }
            pw.println("</fontFamilies>");
            pw.close();
            IReportManager.getPreferences().put("fontExtensions", "" + new Date().getTime());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String dumpBean(SimpleFontFamilyEx font) {
        StringBuffer bean_xml = new StringBuffer("");
        bean_xml.append("   <fontFamily name=\"" + Misc.escapeXMLEntity(font.getName()) + "\">\n");
        if (font.getNormalFont() != null && font.getNormalFont().length() > 0) {
            bean_xml.append("       <normal><![CDATA[" + font.getNormalFont() + "]]></normal>\n");
        }
        if (font.getBoldFont() != null && font.getBoldFont().length() > 0) {
            bean_xml.append("       <bold><![CDATA[" + font.getBoldFont() + "]]></bold>\n");
        }
        if (font.getItalicFont() != null && font.getItalicFont().length() > 0) {
            bean_xml.append("       <italic><![CDATA[" + font.getItalicFont() + "]]></italic>\n");
        }
        if (font.getBoldItalicFont() != null && font.getBoldItalicFont().length() > 0) {
            bean_xml.append("       <boldItalic><![CDATA[" + font.getBoldItalicFont() + "]]></boldItalic>\n");
        }
        if (font.getPdfEncoding() != null && font.getPdfEncoding().length() > 0) {
            bean_xml.append("       <pdfEncoding><![CDATA[" + font.getItalicFont() + "]]></pdfEncoding>\n");
        }
        bean_xml.append("       <pdfEmbedded><![CDATA[" + font.isPdfEmbedded() + "]]></pdfEmbedded>\n");
        if (font.getExportFonts() != null && font.getExportFonts().size() > 0) {
            bean_xml.append("       <exportFonts>\n");
            for (String key : font.getExportFonts().keySet()) {
                bean_xml.append("               <export key=\"" + Misc.escapeXMLEntity(key) + "\"><![CDATA[" + font.getExportFonts().get(key) + "]]></export>\n");
            }
            bean_xml.append("       </exportFonts>\n");
        }
        if (font.getLocales() != null && font.getLocales().size() > 0) {
            bean_xml.append("       <locales>\n");
            for (String key : font.getLocales()) {
                bean_xml.append("               <locale><![CDATA[" + key + "]]></locale>\n");
            }
            bean_xml.append("       </locales>\n");
        }
        bean_xml.append("   </fontFamily>\n\n");
        return bean_xml.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export(Object[] fonts) {
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.setDialogTitle(I18n.getString("IReportPanel.Title.Dialog"));
        jfc.setDialogTitle(I18n.getString("IReportPanel.Title.Dialog"));
        jfc.setAcceptAllFileFilterUsed(true);
        jfc.setFileSelectionMode(0);
        jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".jar") || file.isDirectory() || filename.toLowerCase().endsWith(".zip");
            }

            public String getDescription() {
                return "*.jar, *.zip";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(1);
        if (jfc.showSaveDialog(Misc.getMainFrame()) == 0) {
            File jarFile = jfc.getSelectedFile();
            File fontsDir = Misc.getFontsDirectory();
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(jarFile);
                ZipOutputStream zipos = new ZipOutputStream(fos);
                zipos.setMethod(8);
                String prefix = "family" + new Date().getTime();
                String fontXmlFile = "fonts" + prefix + ".xml";
                ZipEntry propsEntry = new ZipEntry("jasperreports_extension.properties");
                zipos.putNextEntry(propsEntry);
                PrintWriter pw = new PrintWriter(zipos);
                pw.println("net.sf.jasperreports.extension.registry.factory.fonts=net.sf.jasperreports.engine.fonts.SimpleFontExtensionsRegistryFactory");
                pw.println("net.sf.jasperreports.extension.simple.font.families.ireport" + prefix + "=fonts/" + fontXmlFile);
                pw.flush();
                ZipEntry fontsXmlEntry = new ZipEntry("fonts/" + fontXmlFile);
                zipos.putNextEntry(fontsXmlEntry);
                pw = new PrintWriter(zipos);
                pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                pw.println("<fontFamilies>\n");
                ArrayList<File> files = new ArrayList<File>();
                for (Object font : fonts) {
                    if (!(font instanceof SimpleFontFamilyEx)) continue;
                    SimpleFontFamilyEx sff = (SimpleFontFamilyEx)((Object)font);
                    String[] fontNames = new String[]{sff.getNormalFont(), sff.getBoldFont(), sff.getItalicFont(), sff.getBoldItalicFont()};
                    for (int i = 0; i < fontNames.length; ++i) {
                        File fromFile;
                        if (fontNames[i] == null || fontNames[i].length() <= 0 || !(fromFile = new File(fontsDir, fontNames[i])).exists()) continue;
                        files.add(fromFile);
                    }
                    sff = IRFontUtils.convertFontFamily(sff, "fonts/");
                    pw.println(IRFontUtils.dumpBean(sff));
                }
                pw.println("</fontFamilies>");
                pw.flush();
                for (File f : files) {
                    ZipEntry ttfZipEntry = new ZipEntry("fonts/" + f.getName());
                    zipos.putNextEntry(ttfZipEntry);
                    FileUtil.copy((InputStream)new FileInputStream(f), (OutputStream)zipos);
                }
                zipos.flush();
                zipos.finish();
                JOptionPane.showMessageDialog(Misc.getMainFrame(), "Extension Jar succesfully created", "Done", 1);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Misc.getMainFrame(), ex.getMessage(), "Error", 0);
                return;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private static SimpleFontFamilyEx convertFontFamily(SimpleFontFamilyEx font, String fontPath) {
        File f;
        SimpleFontFamilyEx newFont = new SimpleFontFamilyEx();
        newFont.setName(font.getName());
        newFont.setLocales(font.getLocales());
        newFont.setExportFonts(font.getExportFonts());
        newFont.setPdfEmbedded(font.isPdfEmbedded());
        newFont.setPdfEncoding(font.getPdfEncoding());
        newFont.setName(font.getName());
        String fname = font.getNormalFont();
        if (fname != null && fname.length() > 0) {
            f = new File(fname);
            newFont.setNormalFont(fontPath + f.getName());
        }
        if ((fname = font.getBoldFont()) != null && fname.length() > 0) {
            f = new File(fname);
            newFont.setBoldFont(fontPath + f.getName());
        }
        if ((fname = font.getItalicFont()) != null && fname.length() > 0) {
            f = new File(fname);
            newFont.setItalicFont(fontPath + f.getName());
        }
        if ((fname = font.getBoldItalicFont()) != null && fname.length() > 0) {
            f = new File(fname);
            newFont.setBoldItalicFont(fontPath + f.getName());
        }
        return newFont;
    }
}

