/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.widgets;

import com.jaspersoft.ireport.components.table.TableCell;
import com.jaspersoft.ireport.components.table.TableMatrix;
import com.jaspersoft.ireport.components.table.TableObjectScene;
import com.jaspersoft.ireport.components.table.actions.TableColumnMoveAction;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.ImageUtilities;

public class IndicatorWidget
extends Widget {
    public static final int COLUMN = 0;
    public static final int ROW = 1;
    public static final int SECTION = 2;
    public static final int COLUMN_GROUP = 3;
    public static TableColumnMoveAction moveAction = null;
    public static Cursor openHandCursor = null;
    public static Cursor closedHandCursor = null;
    private BufferedImage draggedColumnImage = null;
    private Image arrowImage = null;
    private int lastIndicatedIndex = -1;
    private boolean movingColumnMode = false;
    private int type = 0;
    private Object data = null;

    public IndicatorWidget(TableObjectScene scene, Object data, int type) {
        super((Scene)scene);
        this.type = type;
        this.data = data;
        if (type == 0) {
            this.setCursor(IndicatorWidget.getOpenHandCursor());
            this.getActions().addAction((WidgetAction)IndicatorWidget.getMoveAction());
        }
    }

    public static Cursor getOpenHandCursor() {
        if (openHandCursor == null) {
            openHandCursor = IndicatorWidget.createOptimizedCursor("com/jaspersoft/ireport/components/table/hand_open.png", "handOpen");
        }
        return openHandCursor;
    }

    public static Cursor getClosedHandCursor() {
        if (closedHandCursor == null) {
            closedHandCursor = IndicatorWidget.createOptimizedCursor("com/jaspersoft/ireport/components/table/hand_closed.png", "handClosed");
        }
        return closedHandCursor;
    }

    private static Cursor createOptimizedCursor(String imageName, String cursorName) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image image = ImageUtilities.loadImage((String)imageName);
        Dimension size = tk.getBestCursorSize(image.getWidth(null), image.getWidth(null));
        BufferedImage cursorImage = new BufferedImage(size.width, size.height, 2);
        cursorImage.getGraphics().drawImage(image, 0, 0, null);
        return tk.createCustomCursor(cursorImage, new Point(8, 6), cursorName);
    }

    public static TableColumnMoveAction getMoveAction() {
        if (moveAction == null) {
            moveAction = new TableColumnMoveAction();
        }
        return moveAction;
    }

    protected void paintWidget() {
        super.paintWidget();
        Rectangle rect = this.getBounds();
        Paint oldPaint = this.getGraphics().getPaint();
        if (this.getType() == 0) {
            this.getGraphics().setPaint(new Color(136, 104, 176));
            this.getGraphics().fillRect(rect.x, rect.y + 1, rect.width, 4);
            this.getGraphics().fillRect(rect.x, rect.y, 2, 8);
            this.getGraphics().fillRect(rect.x + rect.width - 2, rect.y, 2, 8);
            if (this.isMovingColumnMode()) {
                TableMatrix matrix = ((TableObjectScene)this.getScene()).getTableMatrix();
                if (this.draggedColumnImage != null) {
                    this.getGraphics().drawImage((Image)this.draggedColumnImage, 0, 10, null);
                }
                List<Integer> vertLines = matrix.getVerticalSeparators();
                List<Integer> horizLines = matrix.getHorizontalSeparators();
                int sepIndex = this.getLastIndicatedIndex();
                if (sepIndex != -1) {
                    int minXforArrow = -1;
                    for (TableCell cell : matrix.getCells()) {
                        int height;
                        if (cell.getCol() != sepIndex && cell.getCol() + cell.getColSpan() != sepIndex || (height = horizLines.get(cell.getRow() + cell.getRowSpan()) - horizLines.get(cell.getRow())) <= 0) continue;
                        this.getGraphics().fillRect(vertLines.get(sepIndex) - this.getLocation().x, 10 + horizLines.get(cell.getRow()), 2, height);
                        minXforArrow = minXforArrow == -1 || horizLines.get(cell.getRow()) + 2 < minXforArrow ? horizLines.get(cell.getRow()) + 2 : minXforArrow;
                    }
                    if (this.arrowImage != null && minXforArrow >= 0) {
                        this.getGraphics().drawImage(this.arrowImage, vertLines.get(sepIndex) - this.getLocation().x - 6, minXforArrow, null);
                    }
                }
            }
        } else if (this.getType() == 1) {
            this.getGraphics().setPaint(new Color(136, 104, 176));
            this.getGraphics().fillRect(rect.x + 1, rect.y, 4, rect.height);
            this.getGraphics().fillRect(rect.x, rect.y, rect.width, 2);
            this.getGraphics().fillRect(rect.x, rect.y + rect.height - 2, rect.width, 2);
        } else if (this.getType() == 2) {
            this.getGraphics().setPaint(new Color(176, 104, 122));
            this.getGraphics().fillRect(rect.x + 1, rect.y, 4, rect.height);
            this.getGraphics().fillRect(rect.x, rect.y, rect.width, 2);
            this.getGraphics().fillRect(rect.x, rect.y + rect.height - 2, rect.width, 2);
        } else if (this.getType() == 3) {
            this.getGraphics().setPaint(new Color(176, 158, 104));
            this.getGraphics().fillRect(rect.x + 1, rect.y, 4, rect.height);
            this.getGraphics().fillRect(rect.x, rect.y, rect.width, 2);
            this.getGraphics().fillRect(rect.x, rect.y + rect.height - 2, rect.width, 2);
        }
        this.getGraphics().setPaint(oldPaint);
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public int getType() {
        return this.type;
    }

    public boolean isMovingColumnMode() {
        return this.movingColumnMode;
    }

    public void setMovingColumnMode(boolean movingColumnMode) {
        if (this.type != 0) {
            return;
        }
        if (this.movingColumnMode == movingColumnMode) {
            return;
        }
        if (movingColumnMode) {
            TableMatrix matrix = ((TableObjectScene)this.getScene()).getTableMatrix();
            List<Integer> horisLines = matrix.getHorizontalSeparators();
            int height = horisLines.get(horisLines.size() - 1) - this.getPreferredLocation().y;
            Rectangle newBounds = this.getPreferredBounds();
            newBounds.height = height;
            this.setLastIndicatedIndex(-1);
            this.draggedColumnImage = new BufferedImage(newBounds.width, horisLines.get(horisLines.size() - 1), 2);
            if (this.getData() instanceof BaseColumn) {
                BaseColumn column = (BaseColumn)this.getData();
                Graphics2D gb = (Graphics2D)this.draggedColumnImage.getGraphics();
                gb.translate(this.getScene().getBounds().x - this.getLocation().x, this.getScene().getBounds().y);
                gb.setComposite(AlphaComposite.getInstance(3, 0.25f));
                for (TableCell cell : matrix.getCells()) {
                    if (cell.getColumn() != column && !TableMatrix.isAncestorColumnOf(cell.getColumn(), column)) continue;
                    Rectangle cellBonds = matrix.getCellBounds(cell);
                    gb.setClip(cellBonds.x - this.getScene().getBounds().x, cellBonds.y - this.getScene().getBounds().y, cellBonds.width, cellBonds.height);
                    this.getScene().paint(gb);
                }
            }
            if (this.arrowImage == null) {
                this.arrowImage = ImageUtilities.loadImage((String)"com/jaspersoft/ireport/components/table/arrow.png");
            }
            this.setPreferredBounds(newBounds);
            this.revalidate();
            this.getScene().revalidate();
        } else {
            this.draggedColumnImage = null;
            this.setPreferredBounds(new Rectangle(0, 0, this.getPreferredBounds().width, 8));
        }
        this.movingColumnMode = movingColumnMode;
    }

    public int getLastIndicatedIndex() {
        return this.lastIndicatedIndex;
    }

    public void setLastIndicatedIndex(int lastIndicatedIndex) {
        this.lastIndicatedIndex = lastIndicatedIndex;
    }
}

