/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.SetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DrilldownLevelFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("DrilldownLevel", "DrilldownLevel(<Set>[, <Level>]) or DrilldownLevel(<Set>, , <Index>)", "Drills down the members of a set, at a specified level, to one level below. Alternatively, drills down on a specified dimension in the set.", new String[]{"fxx", "fxxl", "fxxen"}, DrilldownLevelFunDef.class);

    public DrilldownLevelFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        final LevelCalc levelCalc = call.getArgCount() > 1 && call.getArg(1).getType() instanceof LevelType ? compiler.compileLevel(call.getArg(1)) : null;
        final IntegerCalc indexCalc = call.getArgCount() > 2 ? compiler.compileInteger(call.getArg(2)) : null;
        int arity = ((SetType)listCalc.getType()).getArity();
        if (indexCalc == null) {
            return new AbstractListCalc(call, new Calc[]{listCalc, levelCalc}){

                public List evaluateList(Evaluator evaluator) {
                    List list = listCalc.evaluateList(evaluator);
                    if (list.size() == 0) {
                        return list;
                    }
                    int searchDepth = -1;
                    if (levelCalc != null) {
                        Level level = levelCalc.evaluateLevel(evaluator);
                        searchDepth = level.getDepth();
                    }
                    return DrilldownLevelFunDef.this.drill(searchDepth, list, evaluator);
                }
            };
        }
        if (arity == 1) {
            return new AbstractListCalc(call, new Calc[]{listCalc, indexCalc}){

                public List evaluateList(Evaluator evaluator) {
                    List list = listCalc.evaluateList(evaluator);
                    if (list.size() == 0) {
                        return list;
                    }
                    int index = indexCalc.evaluateInteger(evaluator);
                    ArrayList<Member> result = new ArrayList<Member>();
                    SchemaReader schemaReader = evaluator.getSchemaReader();
                    for (Member member : list) {
                        result.add(member);
                        if (index != 0) continue;
                        List<Member> children = schemaReader.getMemberChildren(member);
                        result.addAll(children);
                    }
                    return result;
                }
            };
        }
        return new AbstractListCalc(call, new Calc[]{listCalc, indexCalc}){

            public List evaluateList(Evaluator evaluator) {
                List list = listCalc.evaluateList(evaluator);
                if (list.size() == 0) {
                    return list;
                }
                int index = indexCalc.evaluateInteger(evaluator);
                ArrayList<Member[]> result = new ArrayList<Member[]>();
                SchemaReader schemaReader = evaluator.getSchemaReader();
                for (Member[] tuple : list) {
                    result.add(tuple);
                    if (index < 0 || index >= tuple.length) continue;
                    List<Member> children = schemaReader.getMemberChildren(tuple[index]);
                    for (Member child : children) {
                        Member[] tupleClone = (Member[])tuple.clone();
                        tupleClone[index] = child;
                        result.add(tupleClone);
                    }
                }
                return result;
            }
        };
    }

    List<Member> drill(int searchDepth, List<Member> list, Evaluator evaluator) {
        if (searchDepth == -1) {
            searchDepth = list.get(0).getLevel().getDepth();
            int m = list.size();
            for (int i = 1; i < m; ++i) {
                Member member = list.get(i);
                int memberDepth = member.getLevel().getDepth();
                if (memberDepth <= searchDepth) continue;
                searchDepth = memberDepth;
            }
        }
        ArrayList<Member> drilledSet = new ArrayList<Member>();
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            Member nextMember;
            Member member = list.get(i);
            drilledSet.add(member);
            Member member2 = nextMember = i == m - 1 ? null : list.get(i + 1);
            if (member.getLevel().getDepth() != searchDepth || FunUtil.isAncestorOf(member, nextMember, true)) continue;
            List<Member> childMembers = evaluator.getSchemaReader().getMemberChildren(member);
            for (Member childMember : childMembers) {
                drilledSet.add(childMember);
            }
        }
        return drilledSet;
    }
}

