/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import mondrian.olap.Axis;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.test.DelegatingTestContext;
import mondrian.test.PropertySaver;
import mondrian.test.TestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoodMartTestCase
extends TestCase {
    protected static final String nl = Util.nl;
    protected final PropertySaver propSaver = new PropertySaver();

    public FoodMartTestCase(String name) {
        super(name);
    }

    public FoodMartTestCase() {
    }

    protected void tearDown() throws Exception {
        this.propSaver.reset();
    }

    public TestContext getTestContext() {
        return TestContext.instance();
    }

    public TestContext getTestContext(final Connection connection) {
        return new DelegatingTestContext(this.getTestContext()){

            public Connection getConnection() {
                return connection;
            }
        };
    }

    protected Connection getConnection() {
        return this.getTestContext().getFoodMartConnection();
    }

    protected void assertSize(String queryString, int columnCount, int rowCount) {
        Result result = this.executeQuery(queryString);
        Axis[] axes = result.getAxes();
        Assert.assertTrue((axes.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((axes[0].getPositions().size() == columnCount ? 1 : 0) != 0);
        Assert.assertTrue((axes[1].getPositions().size() == rowCount ? 1 : 0) != 0);
    }

    public void assertThrows(String queryString, String pattern) {
        this.getTestContext().assertThrows(queryString, pattern);
    }

    public Result execute(Connection connection, String queryString) {
        Query query = connection.parseQuery(queryString);
        return connection.execute(query);
    }

    public Member executeSingletonAxis(String expression) {
        return this.getTestContext().executeSingletonAxis(expression);
    }

    public void assertQueryReturns(String query, String desiredResult) {
        this.getTestContext().assertQueryReturns(query, desiredResult);
    }

    public Result executeQuery(String queryString) {
        return this.getTestContext().executeQuery(queryString);
    }

    public void assertAxisThrows(String expression, String pattern) {
        this.getTestContext().assertAxisThrows(expression, pattern);
    }

    public void assertAxisReturns(String expression, String expected) {
        this.getTestContext().assertAxisReturns(expression, expected);
    }

    public String executeExpr(String expression) {
        return this.getTestContext().executeExprRaw(expression).getFormattedValue();
    }

    public void assertBooleanExprReturns(String expression, boolean expected) {
        String iifExpression = "Iif (" + expression + ",\"true\",\"false\")";
        String actual = this.executeExpr(iifExpression);
        String expectedString = expected ? "true" : "false";
        FoodMartTestCase.assertEquals((String)expectedString, (String)actual);
    }

    public void assertExprThrows(String expression, String pattern) {
        this.getTestContext().assertExprThrows(expression, pattern);
    }

    public void assertExprReturns(String expression, String expected) {
        this.getTestContext().assertExprReturns(expression, expected);
    }

    public static String fold(String string) {
        return TestContext.fold(string);
    }

    protected void assertQueriesReturnSimilarResults(String query1, String query2, TestContext testContext) {
        String resultString1 = TestContext.toString(testContext.executeQuery(query1));
        String resultString2 = TestContext.toString(testContext.executeQuery(query2));
        FoodMartTestCase.assertEquals((String)FoodMartTestCase.measureValues(resultString1), (String)FoodMartTestCase.measureValues(resultString2));
    }

    private static String measureValues(String resultString) {
        int index = resultString.indexOf("}");
        return index != -1 ? resultString.substring(index) : resultString;
    }

    protected boolean isGroupingSetsSupported() {
        return MondrianProperties.instance().EnableGroupingSets.get() && this.getTestContext().getDialect().supportsGroupingSets();
    }

    protected boolean isDefaultNullMemberRepresentation() {
        return MondrianProperties.instance().NullMemberRepresentation.get().equals("#null");
    }

    protected Member member(List<Id.Segment> segmentList, SchemaReader salesCubeSchemaReader) {
        return salesCubeSchemaReader.getMemberByUniqueName(segmentList, true);
    }

    protected List<Member> storeMembersCAAndOR(SchemaReader salesCubeSchemaReader) {
        return Arrays.asList(this.member(Id.Segment.toList("Store", "All Stores", "USA", "CA", "Alameda"), salesCubeSchemaReader), this.member(Id.Segment.toList("Store", "All Stores", "USA", "CA", "Alameda", "HQ"), salesCubeSchemaReader), this.member(Id.Segment.toList("Store", "All Stores", "USA", "CA", "Beverly Hills"), salesCubeSchemaReader), this.member(Id.Segment.toList("Store", "All Stores", "USA", "CA", "Beverly Hills", "Store 6"), salesCubeSchemaReader), this.member(Id.Segment.toList("Store", "All Stores", "USA", "CA", "Los Angeles"), salesCubeSchemaReader), this.member(Id.Segment.toList("Store", "All Stores", "USA", "OR", "Portland"), salesCubeSchemaReader), this.member(Id.Segment.toList("Store", "All Stores", "USA", "OR", "Portland", "Store 11"), salesCubeSchemaReader), this.member(Id.Segment.toList("Store", "All Stores", "USA", "OR", "Salem"), salesCubeSchemaReader), this.member(Id.Segment.toList("Store", "All Stores", "USA", "OR", "Salem", "Store 13"), salesCubeSchemaReader));
    }

    protected List<Member> productMembersPotScrubbersPotsAndPans(SchemaReader salesCubeSchemaReader) {
        return Arrays.asList(this.member(Id.Segment.toList("Product", "All Products", "Non-Consumable", "Household", "Kitchen Products", "Pot Scrubbers", "Cormorant"), salesCubeSchemaReader), this.member(Id.Segment.toList("Product", "All Products", "Non-Consumable", "Household", "Kitchen Products", "Pot Scrubbers", "Denny"), salesCubeSchemaReader), this.member(Id.Segment.toList("Product", "All Products", "Non-Consumable", "Household", "Kitchen Products", "Pot Scrubbers", "Red Wing"), salesCubeSchemaReader), this.member(Id.Segment.toList("Product", "All Products", "Non-Consumable", "Household", "Kitchen Products", "Pots and Pans", "Cormorant"), salesCubeSchemaReader), this.member(Id.Segment.toList("Product", "All Products", "Non-Consumable", "Household", "Kitchen Products", "Pots and Pans", "Denny"), salesCubeSchemaReader), this.member(Id.Segment.toList("Product", "All Products", "Non-Consumable", "Household", "Kitchen Products", "Pots and Pans", "High Quality"), salesCubeSchemaReader), this.member(Id.Segment.toList("Product", "All Products", "Non-Consumable", "Household", "Kitchen Products", "Pots and Pans", "Red Wing"), salesCubeSchemaReader), this.member(Id.Segment.toList("Product", "All Products", "Non-Consumable", "Household", "Kitchen Products", "Pots and Pans", "Sunset"), salesCubeSchemaReader));
    }

    protected List<Member> genderMembersIncludingAll(boolean includeAllMember, SchemaReader salesCubeSchemaReader, Cube salesCube) {
        Member maleMember = this.member(Id.Segment.toList("Gender", "All Gender", "M"), salesCubeSchemaReader);
        Member femaleMember = this.member(Id.Segment.toList("Gender", "All Gender", "F"), salesCubeSchemaReader);
        Member[] members = includeAllMember ? new Member[]{this.allMember("Gender", salesCube), maleMember, femaleMember} : new Member[]{maleMember, femaleMember};
        return Arrays.asList(members);
    }

    protected Member allMember(String dimensionName, Cube salesCube) {
        Dimension genderDimension = this.getDimension(dimensionName, salesCube);
        return genderDimension.getHierarchy().getAllMember();
    }

    private Dimension getDimension(String dimensionName, Cube salesCube) {
        return this.getDimensionWithName(dimensionName, salesCube.getDimensions());
    }

    protected Dimension getDimensionWithName(String name, Dimension[] dimensions) {
        Dimension resultDimension = null;
        for (Dimension dimension : dimensions) {
            if (!dimension.getName().equals(name)) continue;
            resultDimension = dimension;
            break;
        }
        return resultDimension;
    }

    protected List<Member> warehouseMembersCanadaMexicoUsa(SchemaReader reader) {
        return Arrays.asList(this.member(Id.Segment.toList("Warehouse", "All Warehouses", "Canada"), reader), this.member(Id.Segment.toList("Warehouse", "All Warehouses", "Mexico"), reader), this.member(Id.Segment.toList("Warehouse", "All Warehouses", "USA"), reader));
    }

    protected Cube cubeByName(Connection connection, String cubeName) {
        SchemaReader reader = connection.getSchemaReader();
        Cube[] cubes = reader.getCubes();
        return this.cubeByName(cubeName, cubes);
    }

    private Cube cubeByName(String cubeName, Cube[] cubes) {
        Cube resultCube = null;
        for (Cube cube : cubes) {
            if (!cubeName.equals(cube.getName())) continue;
            resultCube = cube;
            break;
        }
        return resultCube;
    }

    protected List<Member> storeMembersUsaAndCanada(boolean includeAllMember, SchemaReader salesCubeSchemaReader, Cube salesCube) {
        Member usaMember = this.member(Id.Segment.toList("Store", "All Stores", "USA"), salesCubeSchemaReader);
        Member canadaMember = this.member(Id.Segment.toList("Store", "All Stores", "CANADA"), salesCubeSchemaReader);
        Member[] members = includeAllMember ? new Member[]{this.allMember("Store", salesCube), usaMember, canadaMember} : new Member[]{usaMember, canadaMember};
        return Arrays.asList(members);
    }

    static class QueryAndResult {
        String query;
        String result;

        QueryAndResult(String query, String result) {
            this.query = query;
            this.result = FoodMartTestCase.fold(result);
        }
    }
}

