/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class XlsxFontInfo {
    protected String fontName;
    protected int fontSize;
    protected boolean isBold;
    protected boolean isItalic;
    protected boolean isUnderline;
    protected boolean isStrikeThrough;
    protected String color;
    protected boolean isFontSizeFixEnabled;

    public XlsxFontInfo(JRExporterGridCell gridCell) {
        this(gridCell, false);
    }

    public XlsxFontInfo(JRExporterGridCell gridCell, boolean isFontSizeFixEnabled) {
        JRFont font;
        JRPrintElement element = gridCell.getElement();
        if (element != null) {
            this.color = JRColorUtil.getColorHexa(element.getForecolor());
        }
        JRFont jRFont = font = element instanceof JRFont ? (JRFont)((Object)element) : null;
        if (font != null) {
            this.fontName = font.getFontName();
            this.fontSize = font.getFontSize();
            this.isBold = font.isBold();
            this.isItalic = font.isItalic();
            this.isUnderline = font.isUnderline();
            this.isStrikeThrough = font.isStrikeThrough();
            this.isFontSizeFixEnabled = isFontSizeFixEnabled;
            if (isFontSizeFixEnabled) {
                --this.fontSize;
            }
        }
    }

    public String getId() {
        return this.fontName + "|" + this.fontSize + "|" + this.isBold + "|" + this.isItalic + "|" + this.isUnderline + "|" + this.isStrikeThrough + "|" + this.color + "|" + this.isFontSizeFixEnabled;
    }
}

