/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data;

import com.jaspersoft.ireport.designer.editor.ExpObjectCellRenderer;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;

public class SortFieldDialog
extends JDialog {
    private JRDesignSortField tmpSortField = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxSortBy;
    private JComboBox jComboBoxSortType;
    private JLabel jLabelSortBy;
    private JLabel jLabelSortType;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private int dialogResult;

    public SortFieldDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jComboBoxSortBy.setEditable(false);
        this.jComboBoxSortType.addItem(new Tag(0, "Ascending"));
        this.jComboBoxSortType.addItem(new Tag(1, "Descending"));
        ExpObjectCellRenderer renderer = new ExpObjectCellRenderer();
        renderer.setShowObjectType(true);
        renderer.setShowObjectClass(false);
        this.jComboBoxSortBy.setRenderer(renderer);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SortFieldDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.pack();
    }

    public void setDataset(JRDesignDataset ds) {
        this.jComboBoxSortBy.removeAllItems();
        ArrayList newList = new ArrayList();
        newList.addAll(ds.getFieldsList());
        newList.addAll(ds.getVariablesList());
        Object[] objs = newList.toArray();
        Arrays.sort(objs, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = null;
                String name2 = null;
                if (o1 instanceof JRDesignField && o2 instanceof JRDesignVariable) {
                    return 1;
                }
                if (o2 instanceof JRDesignField && o1 instanceof JRDesignVariable) {
                    return -1;
                }
                if (o1 instanceof JRDesignField) {
                    name1 = ((JRDesignField)o1).getName();
                } else if (o1 instanceof JRDesignVariable) {
                    name1 = ((JRDesignVariable)o1).getName();
                }
                if (o2 instanceof JRDesignField) {
                    name2 = ((JRDesignField)o1).getName();
                }
                if (o2 instanceof JRDesignVariable) {
                    name2 = ((JRDesignVariable)o1).getName();
                }
                if (name1 == null || name2 == null) {
                    return 0;
                }
                return name1.compareToIgnoreCase(name2);
            }
        });
        this.jComboBoxSortBy.setModel(new DefaultComboBoxModel<Object>(objs));
    }

    private void initComponents() {
        this.jLabelSortBy = new JLabel();
        this.jComboBoxSortBy = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabelSortType = new JLabel();
        this.jComboBoxSortType = new JComboBox();
        this.setTitle("Add/modify parameter");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SortFieldDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabelSortBy.setText("Sort by");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabelSortBy, gridBagConstraints);
        this.jComboBoxSortBy.setPreferredSize(new Dimension(250, 22));
        this.jComboBoxSortBy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortFieldDialog.this.jComboBoxSortByActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jComboBoxSortBy, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortFieldDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortFieldDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabelSortType.setText("Sort type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabelSortType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 8, 4);
        this.getContentPane().add((Component)this.jComboBoxSortType, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Object obj = this.jComboBoxSortBy.getSelectedItem();
        if (obj == null) {
            JOptionPane.showMessageDialog(this, I18n.getString("SortFieldDialog.Message.Error"), I18n.getString("SortFieldDialog.Message.Error2"), 2);
            return;
        }
        String fieldName = "";
        this.tmpSortField = new JRDesignSortField();
        if (obj instanceof JRDesignField) {
            fieldName = ((JRDesignField)obj).getName();
            this.tmpSortField.setType(SortFieldTypeEnum.FIELD);
        } else if (obj instanceof JRDesignVariable) {
            fieldName = ((JRDesignVariable)obj).getName();
            this.tmpSortField.setType(SortFieldTypeEnum.VARIABLE);
        }
        this.tmpSortField.setName(fieldName);
        this.tmpSortField.setOrder(this.jComboBoxSortType.getSelectedIndex() == 1 ? (byte)1 : 0);
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    private void jComboBoxSortByActionPerformed(ActionEvent evt) {
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public JRDesignSortField getSortField() {
        return this.tmpSortField;
    }

    public void setSortField(JRDesignSortField sortField) {
        this.tmpSortField = new JRDesignSortField();
        this.tmpSortField.setName(sortField.getName());
        this.tmpSortField.setOrder(sortField.getOrder());
        this.tmpSortField.setType(sortField.getType());
        this.tmpSortField.setName(sortField.getName());
        for (int i = 0; i < this.jComboBoxSortBy.getItemCount(); ++i) {
            Object item = this.jComboBoxSortBy.getItemAt(i);
            if (item instanceof JRDesignField && sortField.getType() == SortFieldTypeEnum.FIELD && ((JRDesignField)item).getName().equals(sortField.getName())) {
                this.jComboBoxSortBy.setSelectedIndex(i);
                break;
            }
            if (!(item instanceof JRDesignVariable) || sortField.getType() != SortFieldTypeEnum.VARIABLE || !((JRDesignVariable)item).getName().equals(sortField.getName())) continue;
            this.jComboBoxSortBy.setSelectedIndex(i);
            break;
        }
        this.jComboBoxSortType.setSelectedIndex(this.tmpSortField.getOrder() == 1 ? 1 : 0);
    }
}

