/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.editor;

import com.jaspersoft.ireport.designer.editor.CrosstabTotalVariable;
import com.jaspersoft.ireport.designer.editor.ExpChunk;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.Identifier;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.netbeans.api.languages.CompletionItem;
import org.netbeans.api.languages.Context;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRSyntaxSupport {
    List<ExpChunk> expChunks = new ArrayList<ExpChunk>();
    Context context = null;
    Token tokenAtPosition = null;
    int currentExpChunkIndex = -1;
    Token previousPositionToken = null;
    String textFromLastValidToked = "";
    TokenHierarchy th = null;
    TokenSequence ts = null;
    int caretPos = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRSyntaxSupport(Context context) {
        this.context = context;
        AbstractDocument document = (AbstractDocument)context.getDocument();
        document.readLock();
        try {
            this.th = TokenHierarchy.get((Document)document);
            this.ts = this.th.tokenSequence();
            this.caretPos = ExpressionContext.activeEditor.getCaretPosition();
            try {
                this.textFromLastValidToked = document.getText(0, this.caretPos);
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
            this.ts.moveStart();
            int pos = 0;
            int indexExpChunk = 0;
            while (this.ts.moveNext()) {
                int t_end;
                Token t = this.ts.token();
                if (t.length() <= 0) continue;
                int t_start = pos;
                pos = t_end = pos + t.length();
                this.expChunks.add(new ExpChunk(t, t_start));
                if (this.caretPos > t_start && this.caretPos <= t_end) {
                    this.tokenAtPosition = t;
                    this.currentExpChunkIndex = indexExpChunk;
                }
                if (this.caretPos > t_end) {
                    this.previousPositionToken = t;
                    try {
                        this.textFromLastValidToked = document.getText(t_end, this.caretPos - t_end);
                    }
                    catch (BadLocationException ex) {
                        // empty catch block
                    }
                }
                ++indexExpChunk;
            }
        }
        finally {
            document.readUnlock();
        }
    }

    public List<CompletionItem> getItems() {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>();
        if (this.currentExpChunkIndex >= 0) {
            List<CompletionItem> methodsAndAttributes;
            ExpChunk prevExpChunk;
            ExpChunk currentExpChunk = this.expChunks.get(this.currentExpChunkIndex);
            List<Identifier> callsPath = null;
            if (this.tokenString(currentExpChunk).equals(".")) {
                callsPath = this.previousIdentifiers(this.previousChunk(currentExpChunk));
            } else if (this.textFromLastValidToked.length() > 0 && currentExpChunk.token.id().name().equals("identifier") && (prevExpChunk = this.previousChunk(currentExpChunk)) != null && this.tokenString(prevExpChunk).equals(".") && (callsPath = this.previousIdentifiers(this.previousChunk(prevExpChunk))) != null) {
                callsPath.add(0, new Identifier(this.textFromLastValidToked, 5));
            }
            if (callsPath != null && (methodsAndAttributes = this.getMethods(callsPath)) != null) {
                result.addAll(methodsAndAttributes);
            }
            if (result.isEmpty() && (this.tokenString(currentExpChunk).equals("$") || currentExpChunk.token.id().name().equals("whitespace") || currentExpChunk.token.id().name().equals("operator") && !this.tokenString(currentExpChunk).equals("."))) {
                result.addAll(this.getExpressionContextFields());
                result.addAll(this.getExpressionContextVariables());
                result.addAll(this.getExpressionContextParameters());
            }
        }
        return result;
    }

    private String tokenString(ExpChunk currentExpChunk) {
        if (currentExpChunk.token != null && currentExpChunk.token.text() != null) {
            return ((Object)currentExpChunk.token.text()).toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CompletionItem> completionItems(Context context) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>();
        ExpressionContext editorContext = ExpressionContext.getGlobalContext();
        if (ExpressionContext.activeEditor != null && ExpressionContext.activeEditor.getDocument() == context.getDocument()) {
            AbstractDocument document = (AbstractDocument)context.getDocument();
            document.readLock();
            try {
                JRSyntaxSupport s = new JRSyntaxSupport(context);
                List<CompletionItem> list = s.getItems();
                return list;
            }
            finally {
                document.readUnlock();
            }
        }
        System.out.println("Active editor not the same as the one in the expression context...");
        System.out.flush();
        if (editorContext == null) {
            return result;
        }
        return result;
    }

    private static Token previousToken(TokenSequence ts) {
        do {
            if (ts.movePrevious()) continue;
            return ts.token();
        } while (ts.token().id().name().endsWith("whitespace") || ts.token().id().name().endsWith("comment"));
        return ts.token();
    }

    private List<CompletionItem> getMethods(List<Identifier> list) {
        ArrayList<CompletionItem> methods = new ArrayList<CompletionItem>();
        if (list.size() == 0) {
            return methods;
        }
        Identifier id = list.get(list.size() - 1);
        if (id.getType() == 6) {
            try {
                ExpressionContext expressionContext = ExpressionContext.getGlobalContext();
                if (expressionContext != null) {
                    String objName = id.getName().substring(3);
                    objName = objName.substring(0, objName.length() - 1);
                    char type = id.getName().charAt(1);
                    String className = expressionContext.findObjectClassName(objName, type);
                    try {
                        Class<?> c = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                        return this.getMethods(c, list.subList(0, list.size() - 1));
                    }
                    catch (Throwable ttt) {}
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return methods;
    }

    private List<CompletionItem> getMethods(Class clazz, List<Identifier> list) throws NoSuchFieldException {
        ArrayList<CompletionItem> listMethods = new ArrayList<CompletionItem>();
        if (list.size() == 0) {
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!Modifier.isPublic(methods[i].getModifiers()) || methods[i].getReturnType().getName().equals("void")) continue;
                listMethods.add(CompletionItem.create((String)this.methodFirm(methods[i]), (String)("<font color=\"#ababab\">" + this.getPrintableTypeName(methods[i].getReturnType().getName())), (String)"", (CompletionItem.Type)CompletionItem.Type.FIELD, (int)0));
            }
            Field[] fields = clazz.getFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!Modifier.isPublic(fields[i].getModifiers())) continue;
                listMethods.add(CompletionItem.create((String)fields[i].getName(), (String)("<font color=\"#ababab\">" + this.getPrintableTypeName(fields[i].getType().getName())), (String)"", (CompletionItem.Type)CompletionItem.Type.FIELD, (int)0));
            }
        } else if (list.size() == 1 && list.get(0).getType() == 5) {
            String identifierName = list.get(0).getName();
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().startsWith(identifierName) || methods[i].getReturnType().getName().equals("void") || !Modifier.isPublic(methods[i].getModifiers())) continue;
                listMethods.add(CompletionItem.create((String)this.methodFirm(methods[i]), (String)("<font color=\"#ababab\">" + this.getPrintableTypeName(methods[i].getReturnType().getName())), (String)"", (CompletionItem.Type)CompletionItem.Type.FIELD, (int)0));
            }
            Field[] fields = clazz.getFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().startsWith(identifierName) || !Modifier.isPublic(fields[i].getModifiers())) continue;
                listMethods.add(CompletionItem.create((String)fields[i].getName(), (String)("<font color=\"#ababab\">" + this.getPrintableTypeName(fields[i].getType().getName())), (String)"", (CompletionItem.Type)CompletionItem.Type.FIELD, (int)1));
            }
        } else if (list.get(list.size() - 1).getType() == 2) {
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(list.get(list.size() - 1).getName()) || methods[i].getReturnType().getName().equals("void") || !Modifier.isPublic(methods[i].getModifiers())) continue;
                return this.getMethods(methods[i].getReturnType(), list.subList(0, list.size() - 1));
            }
        } else {
            Field f = clazz.getDeclaredField(list.get(list.size() - 1).getName());
            if (f == null || !Modifier.isPublic(f.getModifiers())) {
                return null;
            }
            return this.getMethods(f.getType(), list.subList(1, list.size()));
        }
        return listMethods;
    }

    private ExpChunk previousChunk(ExpChunk current) {
        int index = this.expChunks.indexOf(current);
        if (index > 0) {
            ExpChunk chunk = this.expChunks.get(index - 1);
            if (chunk.token.id().name().endsWith("whitespace") || chunk.token.id().name().endsWith("comment")) {
                System.out.println("Skipping whitespace...");
                System.out.flush();
                return this.previousChunk(chunk);
            }
            return chunk;
        }
        return null;
    }

    private List<Identifier> previousIdentifiers(ExpChunk current) {
        if (current == null) {
            return null;
        }
        ArrayList<Identifier> list = new ArrayList<Identifier>();
        if (current.token.id().name().equals("identifier")) {
            Identifier id = new Identifier(this.tokenString(current) + "", 1);
            list.add(id);
            ExpChunk prev = this.previousChunk(current);
            if (prev != null && this.tokenString(prev).equals(".")) {
                List<Identifier> li = this.previousIdentifiers(this.previousChunk(prev));
                if (li != null) {
                    list.addAll(li);
                } else {
                    return null;
                }
            }
            return list;
        }
        if (this.isReportObject(current)) {
            Identifier id = new Identifier(this.tokenString(current) + "", 6);
            list.add(id);
            return list;
        }
        if (this.tokenString(current).equals(")")) {
            int par = 1;
            ExpChunk prev = this.previousChunk(current);
            while (par > 0) {
                if (prev == null) {
                    return null;
                }
                if (this.tokenString(prev).equals(")")) {
                    ++par;
                }
                if (this.tokenString(prev).equals("(")) {
                    --par;
                }
                prev = this.previousChunk(prev);
            }
            if (prev == null) {
                return null;
            }
            if (prev.token.id().name().equals("identifier")) {
                list.add(new Identifier(this.tokenString(prev) + "", 2));
                prev = this.previousChunk(prev);
                if (prev != null && this.tokenString(prev).equals(".")) {
                    List<Identifier> li = this.previousIdentifiers(this.previousChunk(prev));
                    if (li != null) {
                        list.addAll(li);
                    } else {
                        return null;
                    }
                }
                return list;
            }
            if (this.isReportObject(prev)) {
                Identifier id = new Identifier(this.tokenString(current) + "", 6);
                list.add(id);
                return list;
            }
        }
        return null;
    }

    public boolean isReportObject(ExpChunk chunk) {
        return chunk != null && (chunk.token.id().name().equals("object_V") || chunk.token.id().name().equals("object_F") || chunk.token.id().name().equals("object_P"));
    }

    public String methodFirm(Method m) {
        String method_firm = m.getName() + "(";
        Class<?>[] params = m.getParameterTypes();
        int j = 0;
        for (j = 0; j < params.length; ++j) {
            if (j > 0) {
                method_firm = method_firm + ",";
            }
            method_firm = method_firm + this.getPrintableTypeName(params[j].getName());
        }
        method_firm = method_firm + ")";
        return method_firm;
    }

    public String getPrintableTypeName(String type) {
        if (type == null) {
            return "void";
        }
        if (type.endsWith(";")) {
            type = type.substring(0, type.length() - 1);
        }
        while (type.startsWith("[")) {
            if ((type = type.substring(1) + "[]").startsWith("[")) continue;
            if (type.startsWith("L")) {
                type = type.substring(1);
            }
            if (type.startsWith("Z")) {
                type = "boolean" + type.substring(1);
            }
            if (type.startsWith("B")) {
                type = "byte" + type.substring(1);
            }
            if (type.startsWith("C")) {
                type = "char" + type.substring(1);
            }
            if (type.startsWith("D")) {
                type = "double" + type.substring(1);
            }
            if (type.startsWith("F")) {
                type = "float" + type.substring(1);
            }
            if (type.startsWith("I")) {
                type = "int" + type.substring(1);
            }
            if (type.startsWith("J")) {
                type = "long" + type.substring(1);
            }
            if (!type.startsWith("S")) continue;
            type = "short" + type.substring(1);
        }
        if (type.startsWith("java.lang.") && (type = type.substring("java.lang.".length())).indexOf(".") > 0) {
            type = "java.lang." + type;
        }
        return type;
    }

    public List<CompletionItem> getExpressionContextFields() {
        ArrayList<CompletionItem> list = new ArrayList<CompletionItem>();
        ExpressionContext ec = ExpressionContext.getGlobalContext();
        if (ec == null) {
            return list;
        }
        for (JRDesignDataset dataset : ec.getDatasets()) {
            JRField[] fields = dataset.getFields();
            for (int i = 0; i < fields.length; ++i) {
                list.add(CompletionItem.create((String)("$F{" + fields[i].getName() + "}"), (String)("<font color=\"#ababab\">" + this.getPrintableTypeName(fields[i].getValueClassName())), null, (CompletionItem.Type)CompletionItem.Type.CONSTANT, (int)0));
            }
        }
        return list;
    }

    public List<CompletionItem> getExpressionContextVariables() {
        ArrayList<CompletionItem> list = new ArrayList<CompletionItem>();
        ExpressionContext ec = ExpressionContext.getGlobalContext();
        if (ec == null) {
            return list;
        }
        for (JRDesignDataset dataset : ec.getDatasets()) {
            JRVariable[] variables = dataset.getVariables();
            for (int i = 0; i < variables.length; ++i) {
                list.add(CompletionItem.create((String)("$V{" + variables[i].getName() + "}"), (String)("<font color=\"#ababab\">" + this.getPrintableTypeName(variables[i].getValueClassName())), null, (CompletionItem.Type)CompletionItem.Type.CONSTANT, (int)0));
            }
        }
        for (JRDesignCrosstab crosstab : ec.getCrosstabs()) {
            this.addCrosstabVariables(crosstab, list);
        }
        return list;
    }

    public List<CompletionItem> getExpressionContextParameters() {
        ArrayList<CompletionItem> list = new ArrayList<CompletionItem>();
        ExpressionContext ec = ExpressionContext.getGlobalContext();
        if (ec == null) {
            return list;
        }
        for (JRDesignDataset dataset : ec.getDatasets()) {
            JRParameter[] parameters = dataset.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                list.add(CompletionItem.create((String)("$P{" + parameters[i].getName() + "}"), (String)("<font color=\"#ababab\">" + this.getPrintableTypeName(parameters[i].getValueClassName())), null, (CompletionItem.Type)CompletionItem.Type.CONSTANT, (int)0));
            }
        }
        for (JRDesignCrosstab crosstab : ec.getCrosstabs()) {
            this.addCrosstabParameters(crosstab, list);
        }
        return list;
    }

    private void addCrosstabParameters(JRDesignCrosstab crosstab, List<CompletionItem> list) {
        JRCrosstabParameter[] params = crosstab.getParameters();
        for (int i = 0; i < params.length; ++i) {
            list.add(CompletionItem.create((String)("$P{" + params[i].getName() + "}"), (String)("<font color=\"#ababab\">" + this.getPrintableTypeName(params[i].getValueClassName())), null, (CompletionItem.Type)CompletionItem.Type.CONSTANT, (int)0));
        }
    }

    private void addCrosstabVariables(JRDesignCrosstab crosstab, List<CompletionItem> list) {
        int i;
        List rowGroups = crosstab.getRowGroupsList();
        List columnGroups = crosstab.getColumnGroupsList();
        for (JRDesignCrosstabMeasure measure : crosstab.getMesuresList()) {
            list.add(CompletionItem.create((String)("$V{" + measure.getVariable().getName() + "}"), (String)("<font color=\"#ababab\">" + this.getPrintableTypeName(measure.getVariable().getValueClassName())), null, (CompletionItem.Type)CompletionItem.Type.CONSTANT, (int)0));
            for (int i2 = 0; i2 < rowGroups.size(); ++i2) {
                JRDesignCrosstabRowGroup rowGroup = (JRDesignCrosstabRowGroup)rowGroups.get(i2);
                CrosstabTotalVariable var = new CrosstabTotalVariable((JRCrosstabMeasure)measure, (JRCrosstabRowGroup)rowGroup, null);
                list.add(CompletionItem.create((String)var.getExpression(), (String)("<font color=\"#ababab\">" + this.getPrintableTypeName(var.getClassType())), null, (CompletionItem.Type)CompletionItem.Type.CONSTANT, (int)0));
                for (int j = 0; j < columnGroups.size(); ++j) {
                    JRDesignCrosstabColumnGroup columnGroup = (JRDesignCrosstabColumnGroup)columnGroups.get(j);
                    if (j == 0) {
                        CrosstabTotalVariable var2 = new CrosstabTotalVariable((JRCrosstabMeasure)measure, null, (JRCrosstabColumnGroup)columnGroup);
                        list.add(CompletionItem.create((String)var2.getExpression(), (String)("<font color=\"#ababab\">" + this.getPrintableTypeName(var2.getClassType())), null, (CompletionItem.Type)CompletionItem.Type.CONSTANT, (int)0));
                    }
                    CrosstabTotalVariable var3 = new CrosstabTotalVariable((JRCrosstabMeasure)measure, (JRCrosstabRowGroup)rowGroup, (JRCrosstabColumnGroup)columnGroup);
                    list.add(CompletionItem.create((String)var3.getExpression(), (String)("<font color=\"#ababab\">" + this.getPrintableTypeName(var3.getClassType())), null, (CompletionItem.Type)CompletionItem.Type.CONSTANT, (int)0));
                }
            }
        }
        for (i = 0; i < rowGroups.size(); ++i) {
            JRDesignCrosstabRowGroup rowGroup = (JRDesignCrosstabRowGroup)rowGroups.get(i);
            list.add(CompletionItem.create((String)("$V{" + rowGroup.getVariable().getName() + "}"), (String)("<font color=\"#ababab\">" + this.getPrintableTypeName(rowGroup.getVariable().getValueClassName())), null, (CompletionItem.Type)CompletionItem.Type.CONSTANT, (int)0));
        }
        for (i = 0; i < columnGroups.size(); ++i) {
            JRDesignCrosstabColumnGroup columnGroup = (JRDesignCrosstabColumnGroup)columnGroups.get(i);
            list.add(CompletionItem.create((String)("$V{" + columnGroup.getVariable().getName() + "}"), (String)("<font color=\"#ababab\">" + this.getPrintableTypeName(columnGroup.getVariable().getValueClassName())), null, (CompletionItem.Type)CompletionItem.Type.CONSTANT, (int)0));
        }
    }
}

