/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.undo;

import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;

public class AddDatasetUndoableEdit
extends AggregatedUndoableEdit {
    private JRDesignDataset dataset = null;
    private JasperDesign jasperDesign = null;
    private int index = -1;

    public AddDatasetUndoableEdit(JRDesignDataset dataset, JasperDesign jasperDesign) {
        this.dataset = dataset;
        this.jasperDesign = jasperDesign;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        this.index = this.jasperDesign.getDatasetsList().indexOf(this.getDataset());
        this.jasperDesign.removeDataset((JRDataset)this.getDataset());
    }

    public void redo() throws CannotRedoException {
        super.redo();
        if (this.index > -1) {
            this.jasperDesign.getDatasetsList().add(this.index, this.getDataset());
        } else {
            this.jasperDesign.getDatasetsList().add(this.getDataset());
        }
        this.jasperDesign.getEventSupport().firePropertyChange("datasets", null, null);
    }

    public String getPresentationName() {
        return "Add Dataset " + this.getDataset().getName();
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }

    public JRDesignDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRDesignDataset dataset) {
        this.dataset = dataset;
    }
}

