/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.layers;

import com.jaspersoft.ireport.addons.layers.Layer;
import com.jaspersoft.ireport.addons.layers.LayersChangedEvent;
import com.jaspersoft.ireport.addons.layers.LayersChangedListener;
import com.jaspersoft.ireport.addons.layers.LayersListPanel;
import com.jaspersoft.ireport.addons.layers.LayersSupport;
import com.jaspersoft.ireport.designer.IReportManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class LayersTopComponent
extends TopComponent {
    private static LayersTopComponent instance;
    private static final String PREFERRED_ID = "LayersTopComponent";
    private JButton jButtonDeleteLayers;
    private JButton jButtonNewLayer;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private LayersListPanel layersListPanel1;

    private LayersTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(LayersTopComponent.class, (String)"CTL_LayersTopComponent"));
        this.setToolTipText(NbBundle.getMessage(LayersTopComponent.class, (String)"HINT_LayersTopComponent"));
        this.layersListPanel1.addPropertyChangeListener("PROPERTY_SELECTED_ITEMS", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                List<Layer> selectedLayers = LayersTopComponent.this.layersListPanel1.getSelectedLayers();
                for (Layer l : selectedLayers) {
                    if (!l.isBackgroundLayer()) continue;
                    selectedLayers.remove(l);
                    break;
                }
                LayersTopComponent.this.jButtonDeleteLayers.setEnabled(!selectedLayers.isEmpty());
            }
        });
        LayersSupport.getInstance().addLayersChangedListener(new LayersChangedListener(){

            public void layersChanged(LayersChangedEvent event) {
                LayersTopComponent.this.jButtonNewLayer.setEnabled(event.getJasperDesign() != null);
            }
        });
        this.jButtonNewLayer.setEnabled(IReportManager.getInstance().getActiveReport() != null);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.layersListPanel1 = new LayersListPanel();
        this.jToolBar1 = new JToolBar();
        this.jButtonNewLayer = new JButton();
        this.jButtonDeleteLayers = new JButton();
        this.jScrollPane1.setViewportView(this.layersListPanel1);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButtonNewLayer.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/jaspersoft/ireport/addons/layers/new.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonNewLayer, (String)NbBundle.getMessage(LayersTopComponent.class, (String)"LayersTopComponent.jButtonNewLayer.text"));
        this.jButtonNewLayer.setToolTipText(NbBundle.getMessage(LayersTopComponent.class, (String)"LayersTopComponent.jButtonNewLayer.toolTipText"));
        this.jButtonNewLayer.setEnabled(false);
        this.jButtonNewLayer.setFocusable(false);
        this.jButtonNewLayer.setHorizontalTextPosition(0);
        this.jButtonNewLayer.setVerticalTextPosition(3);
        this.jButtonNewLayer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayersTopComponent.this.jButtonNewLayerActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNewLayer);
        this.jButtonDeleteLayers.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/jaspersoft/ireport/addons/layers/delete.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonDeleteLayers, (String)NbBundle.getMessage(LayersTopComponent.class, (String)"LayersTopComponent.jButtonDeleteLayers.text"));
        this.jButtonDeleteLayers.setToolTipText(NbBundle.getMessage(LayersTopComponent.class, (String)"LayersTopComponent.jButtonDeleteLayers.toolTipText"));
        this.jButtonDeleteLayers.setEnabled(false);
        this.jButtonDeleteLayers.setFocusable(false);
        this.jButtonDeleteLayers.setHorizontalTextPosition(0);
        this.jButtonDeleteLayers.setVerticalTextPosition(3);
        this.jButtonDeleteLayers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayersTopComponent.this.jButtonDeleteLayersActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonDeleteLayers);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jToolBar1, -1, 238, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 238, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 257, Short.MAX_VALUE).add(0, 0, 0).add((Component)this.jToolBar1, -2, 25, -2)));
    }

    private void jButtonNewLayerActionPerformed(ActionEvent evt) {
        Layer layer = new Layer();
        List<Layer> existingLayers = LayersSupport.getInstance().getLayers();
        ArrayList<String> names = new ArrayList<String>();
        int maxid = 0;
        for (Layer l : existingLayers) {
            names.add(l.getName());
            if (maxid > l.getId()) continue;
            maxid = l.getId() + 1;
        }
        String s = "Layer 1";
        int i = 1;
        while (names.contains(s)) {
            s = "Layer " + ++i;
        }
        layer.setId(maxid);
        layer.setName(s);
        LayersSupport.getInstance().addLayer(layer);
    }

    private void jButtonDeleteLayersActionPerformed(ActionEvent evt) {
        LayersSupport.getInstance().removeLayers(this.layersListPanel1.getSelectedLayers());
    }

    public static synchronized LayersTopComponent getDefault() {
        if (instance == null) {
            instance = new LayersTopComponent();
        }
        return instance;
    }

    public static synchronized LayersTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(LayersTopComponent.class.getName()).warning("Cannot find LayersTopComponent component. It will not be located properly in the window system.");
            return LayersTopComponent.getDefault();
        }
        if (win instanceof LayersTopComponent) {
            return (LayersTopComponent)win;
        }
        Logger.getLogger(LayersTopComponent.class.getName()).warning("There seem to be multiple components with the 'LayersTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return LayersTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return LayersTopComponent.getDefault();
        }
    }
}

