/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.nodes.dnd;

import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.ui.nodes.FolderNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ResourceNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.dnd.CopyReplaceDialog;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.PasteType;

public class FolderPasteType
extends PasteType {
    private FolderNode destinationNode;
    private Node originNode;
    private int dropAction = 0;

    public static FolderPasteType createFolderPasteType(int dropAction, FolderNode toFolderNode, Node originNode) {
        if (toFolderNode == null || originNode == null) {
            return null;
        }
        if (originNode instanceof ResourceNode) {
            if (toFolderNode.getFolder().getServer() != ((ResourceNode)originNode).getRepositoryObject().getServer()) {
                return null;
            }
            String origin_uri = ((ResourceNode)originNode).getResourceDescriptor().getUriString();
            String destination_uri = toFolderNode.getResourceDescriptor().getUriString();
            if (origin_uri.equals("/")) {
                return null;
            }
            if (destination_uri.equals(origin_uri)) {
                return null;
            }
            return new FolderPasteType(dropAction, toFolderNode, originNode);
        }
        return null;
    }

    protected FolderPasteType(int dropAction, FolderNode toFolderNode, Node originNode) {
        this.destinationNode = toFolderNode;
        this.originNode = originNode;
        this.dropAction = dropAction;
    }

    public Transferable paste() throws IOException {
        ResourceNode origin = (ResourceNode)this.getOriginNode();
        ResourceDescriptor origin_rd = origin.getResourceDescriptor();
        Node originParent = this.getOriginNode().getParentNode();
        String origin_uri = origin.getResourceDescriptor().getUriString();
        String destination_uri = this.getDestinationNode().getResourceDescriptor().getUriString();
        HashMap<String, ResourceDescriptor> existingLabelsMap = new HashMap<String, ResourceDescriptor>();
        try {
            List newFolderChildrens = origin.getRepositoryObject().getServer().getWSClient().list(this.getDestinationNode().getResourceDescriptor());
            for (ResourceDescriptor rd : newFolderChildrens) {
                existingLabelsMap.put(rd.getLabel(), rd);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if ((this.getDropAction() & 6) != 0) {
            try {
                String label = origin_rd.getLabel();
                String newResName = origin_rd.getName();
                newResName = destination_uri.endsWith("/") ? destination_uri + newResName : destination_uri + "/" + newResName;
                if (!origin_rd.getUriString().equals(newResName) && existingLabelsMap.containsKey(origin_rd.getLabel())) {
                    int idx = 0;
                    while (existingLabelsMap.containsKey(label)) {
                        label = origin_rd.getLabel() + " copy";
                        if (idx > 0) {
                            label = label + " " + (idx + 1);
                        }
                        ++idx;
                    }
                    ResourceDescriptor rd = (ResourceDescriptor)existingLabelsMap.get(origin_rd.getLabel());
                    CopyReplaceDialog d = new CopyReplaceDialog(Misc.getMainFrame(), true);
                    d.setResourceDescriptors(origin_rd, rd, label, true);
                    d.setVisible(true);
                    if (d.getDialogResult() == 1) {
                        return null;
                    }
                    if (d.getDialogResult() == 0) {
                        origin.getRepositoryObject().getServer().getWSClient().delete(rd);
                        origin.getRepositoryObject().getServer().getWSClient().move(origin_rd, destination_uri);
                        existingLabelsMap.clear();
                        label = origin_rd.getLabel();
                    } else if (d.getDialogResult() == 2) {
                        ResourceDescriptor oldResource = new ResourceDescriptor();
                        oldResource.setWsType(origin_rd.getWsType());
                        oldResource.setName(origin_rd.getName());
                        oldResource.setParentFolder(origin_rd.getParentFolder());
                        oldResource.setUriString(origin_rd.getUriString());
                        ResourceDescriptor newRd = origin.getRepositoryObject().getServer().getWSClient().copy(origin_rd, newResName);
                        origin_rd.setParentFolder(destination_uri);
                        origin_rd.setName(newRd.getName());
                        origin_rd.setUriString(destination_uri + "/" + origin_rd.getName());
                        origin.getRepositoryObject().getServer().getWSClient().delete(oldResource);
                    }
                } else {
                    origin.getRepositoryObject().getServer().getWSClient().move(origin_rd, destination_uri);
                }
                if (originParent != null && originParent instanceof FolderNode) {
                    ((FolderNode)originParent).refreshChildrens(true);
                }
                origin_rd.setParentFolder(destination_uri);
                origin_rd.setUriString(destination_uri + "/" + origin_rd.getName());
                this.getDestinationNode().getResourceDescriptor().getChildren().add(origin_rd);
                if (!label.equals(origin_rd.getLabel())) {
                    origin_rd.setLabel(label);
                    try {
                        origin.getRepositoryObject().getServer().getWSClient().putResource(origin_rd, null);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.getDestinationNode().refreshChildrens(false);
            }
            catch (Exception ex) {
                Misc.showErrorMessage((String)("Unable to move the resource: " + ex.getMessage()), (String)"Move error");
                ex.printStackTrace();
            }
        } else {
            try {
                System.out.println("Pasting resource... " + ((ResourceNode)this.originNode).getResourceDescriptor().getUriString() + " to " + destination_uri);
                System.out.flush();
                String newResName = origin_rd.getName();
                newResName = destination_uri.endsWith("/") ? destination_uri + newResName : destination_uri + "/" + newResName;
                String label = origin_rd.getLabel();
                int idx = 0;
                while (existingLabelsMap.containsKey(label)) {
                    label = origin_rd.getLabel() + " copy";
                    if (idx > 0) {
                        label = label + " " + (idx + 1);
                    }
                    ++idx;
                }
                if (!origin_rd.getUriString().equals(newResName) && existingLabelsMap.containsKey(origin_rd.getLabel())) {
                    ResourceDescriptor rd = (ResourceDescriptor)existingLabelsMap.get(origin_rd.getLabel());
                    CopyReplaceDialog d = new CopyReplaceDialog(Misc.getMainFrame(), true);
                    d.setResourceDescriptors(origin_rd, rd, label, false);
                    d.setVisible(true);
                    if (d.getDialogResult() == 1) {
                        return null;
                    }
                    if (d.getDialogResult() == 0) {
                        origin.getRepositoryObject().getServer().getWSClient().delete(rd);
                        List list = this.getDestinationNode().getResourceDescriptor().getChildren();
                        for (ResourceDescriptor rdd : list) {
                            if (!rdd.getName().equals(rd.getName())) continue;
                            this.getDestinationNode().getResourceDescriptor().getChildren().remove(rdd);
                            break;
                        }
                        existingLabelsMap.clear();
                        label = origin_rd.getLabel();
                    }
                }
                ResourceDescriptor newRd = origin.getRepositoryObject().getServer().getWSClient().copy(origin_rd, newResName);
                String definitive_uri_string = "";
                definitive_uri_string = destination_uri.endsWith("/") ? destination_uri + newRd.getName() : destination_uri + "/" + newRd.getName();
                newRd.setUriString(definitive_uri_string);
                if (!label.equals(newRd.getLabel())) {
                    newRd.setLabel(label);
                    try {
                        origin.getRepositoryObject().getServer().getWSClient().putResource(newRd, null);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.getDestinationNode().getResourceDescriptor().getChildren().add(newRd);
                this.getDestinationNode().refreshChildrens(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Misc.showErrorMessage((String)("Unable to copy the resource: " + ex.getMessage()), (String)"Move error");
            }
        }
        return null;
    }

    public FolderNode getDestinationNode() {
        return this.destinationNode;
    }

    public void setDestinationNode(FolderNode destinationNode) {
        this.destinationNode = destinationNode;
    }

    public Node getOriginNode() {
        return this.originNode;
    }

    public void setOriginNode(Node originNode) {
        this.originNode = originNode;
    }

    public int getDropAction() {
        return this.dropAction;
    }

    public void setDropAction(int dropAction) {
        this.dropAction = dropAction;
    }
}

