/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.define;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.content.UpdateModel;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.QueryModel;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class TableMetaData {
    private String keycah;
    private String schema;
    private String name;
    private String type;
    private ArrayList alColumns;
    private ArrayList alPrimaryKeys;
    private ArrayList alImportedKeys;
    private ArrayList alExportedKeys;
    public static final int IDX_COL_TABLE_CAT = 0;
    public static final int IDX_COL_TABLE_SCHEM = 1;
    public static final int IDX_COL_TABLE_NAME = 2;
    public static final int IDX_COL_COLUMN_NAME = 3;
    public static final int IDX_COL_DATA_TYPE = 4;
    public static final int IDX_COL_TYPE_NAME = 5;
    public static final int IDX_COL_COLUMN_SIZE = 6;
    public static final int IDX_COL_BUFFER_LENGTH = 7;
    public static final int IDX_COL_DECIMAL_DIGITS = 8;
    public static final int IDX_COL_NUM_PREC_RADIX = 9;
    public static final int IDX_COL_NULLABLE = 10;
    public static final int IDX_COL_REMARKS = 11;
    public static final int IDX_COL_COLUMN_DEF = 12;
    public static final int IDX_COL_SQL_DATA_TYPE = 13;
    public static final int IDX_COL_SQL_DATETIME_SUB = 14;
    public static final int IDX_COL_CHAR_OCTET_LENGTH = 15;
    public static final int IDX_COL_ORDINAL_POSITION = 16;
    public static final int IDX_COL_IS_NULLABLE = 17;
    public static final int IDX_PK_TABLE_CAT = 0;
    public static final int IDX_PK_TABLE_SCHEM = 1;
    public static final int IDX_PK_TABLE_NAME = 2;
    public static final int IDX_PK_COLUMN_NAME = 3;
    public static final int IDX_PK_KEY_SEQ = 4;
    public static final int IDX_PK_PK_NAME = 5;
    public static final int IDX_REL_PKTABLE_CAT = 0;
    public static final int IDX_REL_PKTABLE_SCHEM = 1;
    public static final int IDX_REL_PKTABLE_NAME = 2;
    public static final int IDX_REL_PKCOLUMN_NAME = 3;
    public static final int IDX_REL_FKTABLE_CAT = 4;
    public static final int IDX_REL_FKTABLE_SCHEM = 5;
    public static final int IDX_REL_FKTABLE_NAME = 6;
    public static final int IDX_REL_FKCOLUMN_NAME = 7;
    public static final int IDX_REL_KEY_SEQ = 8;
    public static final int IDX_REL_UPDATE_RULE = 9;
    public static final int IDX_REL_DELETE_RULE = 10;
    public static final int IDX_REL_FK_NAME = 11;
    public static final int IDX_REL_PK_NAME = 12;
    public static final int IDX_REL_DEFERRABILITY = 13;

    public TableMetaData(String keycah, String schema, String name) {
        this(keycah, schema, name, null);
    }

    public TableMetaData(String keycah, String schema, String name, String type) {
        this.keycah = keycah;
        this.schema = schema;
        this.name = name;
        this.type = type;
    }

    public QueryModel createQueryModel() {
        QueryModel qm = new QueryModel();
        QueryTokens.Table table = new QueryTokens.Table(this.schema, this.name);
        qm.getQueryExpression().getQuerySpecification().addFromClause(table);
        ArrayList al = this.getColumns();
        for (int i = 0; i < al.size(); ++i) {
            QueryTokens.Column column = new QueryTokens.Column(null, this.getColumnProperty(i, 3));
            qm.getQueryExpression().getQuerySpecification().addSelectList(column);
        }
        return qm;
    }

    public UpdateModel createUpdateModel() {
        ArrayList al = this.getPrimaryKeys();
        QueryTokens.Column[] pk = new QueryTokens.Column[al.size()];
        QueryTokens.Table table = new QueryTokens.Table(this.schema, this.name);
        for (int i = 0; i < al.size(); ++i) {
            pk[i] = new QueryTokens.Column(null, this.getColumnProperty(i, 3));
        }
        UpdateModel um = new UpdateModel();
        um.setTable(table);
        um.setRowIdentifier(pk);
        return um;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getHandlerKey() {
        if (ConnectionAssistant.hasHandler(this.keycah)) {
            QueryBuilder.identifierQuoteString = ConnectionAssistant.getHandler(this.keycah).getObject("$identifierQuoteString").toString();
            QueryBuilder.maxColumnNameLength = (Integer)ConnectionAssistant.getHandler(this.keycah).getObject("$maxColumnNameLength");
        }
        return this.keycah;
    }

    public boolean isPrimaryKey(String column) {
        for (int i = 0; i < this.getPrimaryKeys().size(); ++i) {
            if (!this.getPrimaryKeyProperty(i, 3).equals(column)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getColumns() {
        if (this.alColumns == null) {
            this.alColumns = new ArrayList();
            try {
                ConnectionHandler ch = ConnectionAssistant.getHandler(this.getHandlerKey());
                DatabaseMetaData dbmd = ch.get().getMetaData();
                String catalog = this.schema == null ? null : ch.get().getCatalog();
                TableMetaData.copy(dbmd.getColumns(catalog, this.schema, this.name, "%"), this.alColumns);
            }
            catch (SQLException e) {
                Application.println("[ TableMetaData::getColumns() ]\n" + e);
            }
        }
        return this.alColumns;
    }

    public String getColumnProperty(int row, int idx) {
        return ((String[])this.getColumns().get(row))[idx];
    }

    public String getPrimaryKeyProperty(int row, int idx) {
        return ((String[])this.getPrimaryKeys().get(row))[idx];
    }

    public ArrayList getPrimaryKeys() {
        if (this.alPrimaryKeys == null) {
            this.alPrimaryKeys = new ArrayList();
            try {
                ConnectionHandler ch = ConnectionAssistant.getHandler(this.getHandlerKey());
                DatabaseMetaData dbmd = ch.get().getMetaData();
                String catalog = this.schema == null ? null : ch.get().getCatalog();
                TableMetaData.copy(dbmd.getPrimaryKeys(catalog, this.schema, this.name), this.alPrimaryKeys);
            }
            catch (SQLException e) {
                Application.println("[ TableMetaData::getPrimaryKeys() ]\n" + e);
            }
        }
        return this.alPrimaryKeys;
    }

    public String getImportedKeyProperty(int row, int idx) {
        return ((String[])this.getImportedKeys().get(row))[idx];
    }

    public ArrayList getImportedKeys() {
        if (this.alImportedKeys == null) {
            this.alImportedKeys = new ArrayList();
            try {
                ConnectionHandler ch = ConnectionAssistant.getHandler(this.getHandlerKey());
                DatabaseMetaData dbmd = ch.get().getMetaData();
                String catalog = this.schema == null ? null : ch.get().getCatalog();
                TableMetaData.copy(dbmd.getImportedKeys(catalog, this.schema, this.name), this.alImportedKeys);
            }
            catch (SQLException e) {
                Application.println("[ TableMetaData::getImportedKeys() ]\n" + e);
            }
        }
        return this.alImportedKeys;
    }

    public String getExportedKeyProperty(int row, int idx) {
        return ((String[])this.getExportedKeys().get(row))[idx];
    }

    public ArrayList getExportedKeys() {
        if (this.alExportedKeys == null) {
            this.alExportedKeys = new ArrayList();
            try {
                ConnectionHandler ch = ConnectionAssistant.getHandler(this.getHandlerKey());
                DatabaseMetaData dbmd = ch.get().getMetaData();
                String catalog = this.schema == null ? null : ch.get().getCatalog();
                TableMetaData.copy(dbmd.getExportedKeys(catalog, this.schema, this.name), this.alExportedKeys);
            }
            catch (SQLException e) {
                Application.println("[ TableMetaData::getExportedKeys() ]\n" + e);
            }
        }
        return this.alExportedKeys;
    }

    public String getType() {
        if (this.type == null) {
            try {
                ConnectionHandler ch = ConnectionAssistant.getHandler(this.getHandlerKey());
                DatabaseMetaData dbmd = ch.get().getMetaData();
                String catalog = this.schema == null ? null : ch.get().getCatalog();
                ResultSet rs = dbmd.getTables(catalog, this.schema, this.name, null);
                if (rs.next()) {
                    this.type = rs.getString(4);
                }
            }
            catch (SQLException e) {
                Application.println("[ TableMetaData::getExportedKeys() ]\n" + e);
            }
        }
        return this.type;
    }

    public String toString() {
        return this.schema != null ? this.schema + '.' + this.getName() : this.getName();
    }

    private static void copy(ResultSet rs, ArrayList al) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        while (rs.next()) {
            String[] row = new String[rsmd.getColumnCount()];
            al.add(row);
            for (int i = 0; i < row.length; ++i) {
                row[i] = rs.getString(i + 1);
            }
        }
        rs.close();
    }
}

