/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExistsFunDef
extends FunDefBase {
    static final Resolver resolver = new ReflectiveMultiResolver("Exists", "Exists(<Set1>, <Set2>])", "Returns the the set of tuples of the first set that exist with one or more tuples of the second set.", new String[]{"fxxx"}, ExistsFunDef.class);

    public ExistsFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc1 = compiler.compileList(call.getArg(0));
        final ListCalc listCalc2 = compiler.compileList(call.getArg(1));
        return new AbstractListCalc(call, new Calc[]{listCalc1, listCalc2}){

            public List evaluateList(Evaluator evaluator) {
                List left = listCalc1.evaluateList(evaluator);
                if (left == null || left.isEmpty()) {
                    return Collections.EMPTY_LIST;
                }
                List right = listCalc2.evaluateList(evaluator);
                if (right == null || right.isEmpty()) {
                    return Collections.EMPTY_LIST;
                }
                ArrayList result = new ArrayList();
                Object leftHead = left.get(0);
                Object rightHead = right.get(0);
                List leftDims = ExistsFunDef.getDimensions(leftHead);
                List rightDims = ExistsFunDef.getDimensions(rightHead);
                int rightSize = rightDims.size();
                int[] idxmap = new int[rightSize];
                for (int i = 0; i < rightSize; ++i) {
                    Dimension d = (Dimension)rightDims.get(i);
                    if (!leftDims.contains(d)) {
                        return Collections.EMPTY_LIST;
                    }
                    idxmap[i] = leftDims.indexOf(d);
                }
                block1: for (Object leftObject : left) {
                    if (leftObject instanceof Object[]) {
                        boolean exist = true;
                        for (Object rightObject : right) {
                            for (int i = 0; i < rightSize; ++i) {
                                Member rightMem;
                                Object[] leftObjs = (Object[])leftObject;
                                Member leftMem = (Member)leftObjs[idxmap[i]];
                                if (!(rightObject instanceof Object[])) {
                                    rightMem = (Member)rightObject;
                                } else {
                                    Object[] rightObjs = (Object[])rightObject;
                                    rightMem = (Member)rightObjs[i];
                                }
                                if (ExistsFunDef.isOnSameHierarchyChain(leftMem, rightMem)) continue;
                                exist = false;
                                break;
                            }
                            if (!exist) continue;
                            result.add(leftObject);
                            continue block1;
                        }
                        continue;
                    }
                    for (Object rightObject : right) {
                        if (!ExistsFunDef.isOnSameHierarchyChain((Member)leftObject, (Member)rightObject)) continue;
                        result.add(leftObject);
                        continue block1;
                    }
                }
                return result;
            }
        };
    }

    private static boolean isOnSameHierarchyChain(Member mA, Member mB) {
        return FunUtil.isAncestorOf(mA, mB, false) || FunUtil.isAncestorOf(mB, mA, false);
    }

    private static List<Dimension> getDimensions(Object obj) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        if (obj instanceof Object[]) {
            for (Object dim : (Object[])obj) {
                dimensions.add(((Member)dim).getDimension());
            }
        } else {
            dimensions.add(((Member)obj).getDimension());
        }
        return dimensions;
    }
}

