/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.io.IOException;
import java.util.LinkedList;
import javax.swing.Action;
import org.netbeans.editor.AnnotationType;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderInstance;

public class AnnotationTypeActionsFolder
extends FolderInstance {
    private static final String FOLDER = "Editors/AnnotationTypes/";
    private AnnotationType type;

    private AnnotationTypeActionsFolder(AnnotationType annotationType, DataFolder dataFolder) {
        super(dataFolder);
        this.type = annotationType;
        this.recreate();
        this.instanceFinished();
    }

    public static boolean readActions(AnnotationType annotationType, String string) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(FOLDER + string);
        if (fileObject == null) {
            return false;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            DataFolder dataFolder = (DataFolder)dataObject.getCookie(DataFolder.class);
            if (dataFolder != null) {
                AnnotationTypeActionsFolder annotationTypeActionsFolder = new AnnotationTypeActionsFolder(annotationType, dataFolder);
                return true;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
            return false;
        }
        return false;
    }

    protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        for (int i = 0; i < instanceCookieArray.length; ++i) {
            Object object = instanceCookieArray[i].instanceCreate();
            if (!(object instanceof Action)) continue;
            Action action = (Action)object;
            linkedList.add(action);
        }
        this.type.setActions(linkedList.toArray(new Action[0]));
        return null;
    }
}

