/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.formatting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.structure.formatting.JoinedTokenSequence;
import org.netbeans.modules.editor.structure.formatting.TextBounds;
import org.netbeans.modules.editor.structure.formatting.TransferData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TagBasedLexerFormatter {
    private static final Logger logger = Logger.getLogger(TagBasedLexerFormatter.class.getName());

    protected abstract boolean isClosingTag(JoinedTokenSequence var1, int var2);

    protected abstract boolean isUnformattableToken(JoinedTokenSequence var1, int var2);

    protected abstract boolean isUnformattableTag(String var1);

    protected abstract boolean isOpeningTag(JoinedTokenSequence var1, int var2);

    protected abstract String extractTagName(JoinedTokenSequence var1, int var2);

    protected abstract boolean areTagNamesEqual(String var1, String var2);

    protected abstract boolean isClosingTagRequired(BaseDocument var1, String var2);

    protected abstract int getOpeningSymbolOffset(JoinedTokenSequence var1, int var2);

    protected abstract int getTagEndingAtPosition(JoinedTokenSequence var1, int var2) throws BadLocationException;

    protected abstract int getTagEndOffset(JoinedTokenSequence var1, int var2);

    protected abstract LanguagePath supportedLanguagePath();

    public void process(Context context) throws BadLocationException {
        if (context.isIndent()) {
            this.enterPressed(context);
        } else {
            this.reformat(context);
        }
    }

    public void reformat(Context context) throws BadLocationException {
        this.reformat(context, context.startOffset(), context.endOffset());
    }

    public void reformat(Context context, int n, int n2) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)context.document();
        baseDocument.runAtomic((Runnable)new FormattingTask(context, n, n2));
    }

    public boolean isJustAfterClosingTag(BaseDocument baseDocument, int n) {
        IsJustAfterClosingTagTask isJustAfterClosingTagTask = new IsJustAfterClosingTagTask(baseDocument, n);
        baseDocument.runAtomic((Runnable)isJustAfterClosingTagTask);
        return isJustAfterClosingTagTask.getResult();
    }

    private static int getTxtLengthWithoutWhitespaceSuffix(CharSequence charSequence) {
        for (int i = charSequence.length(); i > 0; --i) {
            if (Character.isWhitespace(charSequence.charAt(i - 1))) continue;
            return i;
        }
        return 0;
    }

    protected int getMatchingOpeningTagStart(JoinedTokenSequence joinedTokenSequence, int n) {
        int n2 = joinedTokenSequence.offset();
        joinedTokenSequence.move(n);
        joinedTokenSequence.moveNext();
        String string = this.extractTagName(joinedTokenSequence, n);
        int n3 = 0;
        while (joinedTokenSequence.movePrevious()) {
            int n4 = joinedTokenSequence.offset();
            if (!this.areTagNamesEqual(string, this.extractTagName(joinedTokenSequence, n4))) continue;
            if (this.isOpeningTag(joinedTokenSequence, n4)) {
                if (n3 == 0) {
                    joinedTokenSequence.move(n2);
                    joinedTokenSequence.moveNext();
                    return n4;
                }
                --n3;
                continue;
            }
            if (!this.isClosingTag(joinedTokenSequence, n4)) continue;
            ++n3;
        }
        joinedTokenSequence.move(n2);
        joinedTokenSequence.moveNext();
        return -1;
    }

    protected boolean isWSToken(Token token) {
        return this.isOnlyWhiteSpaces(token.text());
    }

    protected int getIndentForTagParameter(BaseDocument baseDocument, JoinedTokenSequence joinedTokenSequence, int n) throws BadLocationException {
        int n2 = joinedTokenSequence.offset();
        int n3 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
        joinedTokenSequence.move(n);
        boolean bl = false;
        int n4 = baseDocument.getShiftWidth();
        while (joinedTokenSequence.moveNext()) {
            Token token = joinedTokenSequence.token();
            int n5 = joinedTokenSequence.offset();
            boolean bl2 = this.isWSToken(token);
            if (bl && (!bl2 || n3 != Utilities.getLineOffset((BaseDocument)baseDocument, (int)n5))) {
                if (bl2 || n3 != Utilities.getLineOffset((BaseDocument)baseDocument, (int)n5)) break;
                n4 = n5 - Utilities.getRowIndent((BaseDocument)baseDocument, (int)n5) - Utilities.getRowStart((BaseDocument)baseDocument, (int)n5);
                break;
            }
            if (!bl2) continue;
            bl = true;
        }
        joinedTokenSequence.move(n2);
        joinedTokenSequence.moveNext();
        return n4;
    }

    private boolean calcIndents_processOpeningTag(BaseDocument baseDocument, JoinedTokenSequence joinedTokenSequence, String string, Collection<TagIndentationData> collection, int[] nArray) throws BadLocationException {
        boolean bl = true;
        int n = Utilities.getLineOffset((BaseDocument)baseDocument, (int)joinedTokenSequence.offset());
        int n2 = this.getTagEndOffset(joinedTokenSequence, joinedTokenSequence.offset());
        if (n2 == -1) {
            return true;
        }
        int n3 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2);
        TagIndentationData tagIndentationData = new TagIndentationData(string, n3);
        collection.add(tagIndentationData);
        if (n < n3) {
            int n4 = this.getIndentForTagParameter(baseDocument, joinedTokenSequence, joinedTokenSequence.offset());
            for (int i = n + 1; i <= n3; ++i) {
                nArray[i] = n4;
            }
        }
        return bl;
    }

    private void calcIndents_processClosingTag(String string, int n, TransferData transferData, LinkedList<TagIndentationData> linkedList, Collection<TagIndentationData> collection) throws BadLocationException {
        LinkedList<TagIndentationData> linkedList2 = new LinkedList<TagIndentationData>();
        while (!linkedList.isEmpty()) {
            TagIndentationData tagIndentationData = linkedList.removeLast();
            if (this.areTagNamesEqual(string, tagIndentationData.getTagName())) {
                tagIndentationData.setClosedOnLine(n);
                collection.add(tagIndentationData);
                if (this.isUnformattableTag(string)) {
                    for (int i = n - 1; i > tagIndentationData.getLine(); --i) {
                        transferData.setNonFormattable(i);
                    }
                }
                linkedList2.clear();
                break;
            }
            linkedList2.add(tagIndentationData);
        }
        linkedList.addAll(linkedList2);
    }

    protected int getInitialIndentFromPreviousLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2;
        int n3;
        int n4 = 0;
        if (n > 0 && (n3 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)(n2 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n)))) > 0) {
            n4 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n3);
        }
        return n4;
    }

    protected static int getNumberOfLines(BaseDocument baseDocument) throws BadLocationException {
        return Utilities.getLineOffset((BaseDocument)baseDocument, (int)baseDocument.getLength()) + 1;
    }

    protected int getNextClosingTagOffset(JoinedTokenSequence joinedTokenSequence, int n) throws BadLocationException {
        int n2 = joinedTokenSequence.offset();
        joinedTokenSequence.move(n);
        int n3 = -1;
        while (joinedTokenSequence.moveNext()) {
            n3 = joinedTokenSequence.offset();
            if (!this.isClosingTag(joinedTokenSequence, n3)) continue;
            joinedTokenSequence.move(n2);
            joinedTokenSequence.moveNext();
            return n3;
        }
        joinedTokenSequence.move(n2);
        joinedTokenSequence.moveNext();
        return -1;
    }

    protected boolean isJustBeforeClosingTag(JoinedTokenSequence joinedTokenSequence, int n) throws BadLocationException {
        return this.isClosingTag(joinedTokenSequence, n);
    }

    protected Token getTokenAtOffset(JoinedTokenSequence joinedTokenSequence, int n) {
        if (joinedTokenSequence != null && n >= 0) {
            int n2 = joinedTokenSequence.offset();
            joinedTokenSequence.move(n);
            if (joinedTokenSequence.moveNext()) {
                Token token = joinedTokenSequence.token();
                joinedTokenSequence.move(n2);
                joinedTokenSequence.moveNext();
                return token;
            }
        }
        return null;
    }

    private TextBounds findTokenSequenceBounds(BaseDocument baseDocument, TokenSequence tokenSequence) throws BadLocationException {
        tokenSequence.moveStart();
        tokenSequence.moveNext();
        int n = tokenSequence.offset();
        tokenSequence.moveEnd();
        tokenSequence.movePrevious();
        int n2 = tokenSequence.offset() + tokenSequence.token().length();
        while (this.isWSToken(tokenSequence.token())) {
            if (tokenSequence.movePrevious()) continue;
            return new TextBounds(n, n2);
        }
        int n3 = 0;
        while (Character.isWhitespace(tokenSequence.token().text().charAt(tokenSequence.token().length() - 1 - n3))) {
            ++n3;
        }
        int n4 = tokenSequence.offset() + tokenSequence.token().length() - n3;
        tokenSequence.moveStart();
        do {
            tokenSequence.moveNext();
        } while (this.isWSToken(tokenSequence.token()));
        int n5 = 0;
        while (Character.isWhitespace(tokenSequence.token().text().charAt(n5))) {
            ++n5;
        }
        int n6 = tokenSequence.offset() + n5;
        int n7 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n6);
        int n8 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n4);
        return new TextBounds(n, n2, n6, n4, n7, n8);
    }

    private void markCurrentLanguageLines(BaseDocument baseDocument, TextBounds textBounds, EmbeddingType[] embeddingTypeArray) throws BadLocationException {
        if (textBounds.getStartPos() == -1) {
            return;
        }
        int n = textBounds.getStartLine();
        int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n);
        if (Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n2) < textBounds.getStartPos()) {
            ++n;
        }
        for (int i = n; i <= textBounds.getEndLine(); ++i) {
            embeddingTypeArray[i] = EmbeddingType.CURRENT_LANG;
        }
    }

    protected boolean isTopLevelLanguage(BaseDocument baseDocument) {
        return this.supportedLanguagePath().size() == 1;
    }

    protected static int getExistingIndent(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n);
        return IndentUtils.lineIndent((Document)baseDocument, (int)n2);
    }

    public void enterPressed(Context context) {
        BaseDocument baseDocument = (BaseDocument)context.document();
        baseDocument.runAtomic((Runnable)new EnterPressedTask(context));
    }

    private boolean indexWithinCurrentLanguage(BaseDocument baseDocument, int n) throws BadLocationException {
        TokenSequence[] tokenSequenceArray;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        for (TokenSequence tokenSequence : tokenSequenceArray = tokenHierarchy.tokenSequenceList(this.supportedLanguagePath(), 0, Integer.MAX_VALUE).toArray(new TokenSequence[0])) {
            TextBounds textBounds = this.findTokenSequenceBounds(baseDocument, tokenSequence);
            if (textBounds.getAbsoluteStart() > n || textBounds.getAbsoluteEnd() < n) continue;
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) continue;
            if (this.isWSToken(tokenSequence.token())) {
                tokenSequence.movePrevious();
            }
            return tokenSequence.embedded() == null && !this.isWSToken(tokenSequence.token());
        }
        return false;
    }

    public boolean handleSmartEnter(Context context) throws BadLocationException {
        int n;
        boolean bl = false;
        BaseDocument baseDocument = (BaseDocument)context.document();
        bl = this.isSmartEnter(baseDocument, n = context.caretOffset());
        if (bl) {
            int n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
            assert (n2 > 0);
            int n3 = TagBasedLexerFormatter.getExistingIndent(baseDocument, n2 - 1);
            baseDocument.insertString(n, "\n", null);
            Position position = baseDocument.createPosition(n);
            context.modifyIndent(Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n2), n3 + baseDocument.getShiftWidth());
            context.modifyIndent(Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n2 + 1)), n3);
            context.setCaretOffset(position.getOffset());
        }
        return bl;
    }

    public boolean isSmartEnter(BaseDocument baseDocument, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        TokenSequence[] tokenSequenceArray = tokenHierarchy.tokenSequenceList(this.supportedLanguagePath(), 0, Integer.MAX_VALUE).toArray(new TokenSequence[0]);
        TextBounds[] textBoundsArray = new TextBounds[tokenSequenceArray.length];
        try {
            for (int i = 0; i < textBoundsArray.length; ++i) {
                textBoundsArray[i] = this.findTokenSequenceBounds(baseDocument, tokenSequenceArray[i]);
            }
            JoinedTokenSequence joinedTokenSequence = new JoinedTokenSequence(tokenSequenceArray, textBoundsArray);
            if (joinedTokenSequence.move(n) != Integer.MIN_VALUE) {
                joinedTokenSequence.moveNext();
                if (this.isJustBeforeClosingTag(joinedTokenSequence, n)) {
                    int n2 = this.getNextClosingTagOffset(joinedTokenSequence, n);
                    int n3 = this.getMatchingOpeningTagStart(joinedTokenSequence, n2);
                    int n4 = this.getTagEndOffset(joinedTokenSequence, n3);
                    return n4 + 1 == n;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            logger.log(Level.WARNING, badLocationException.getMessage(), badLocationException);
        }
        return false;
    }

    protected boolean isOnlyWhiteSpaces(CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            if (Character.isWhitespace(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private String formatterName() {
        return this.getClass().getSimpleName();
    }

    protected static class TagIndentationData {
        private final String tagName;
        private final int line;
        private int closedOnLine;

        public TagIndentationData(String string, int n) {
            this.tagName = string;
            this.line = n;
        }

        public String getTagName() {
            return this.tagName;
        }

        public int getLine() {
            return this.line;
        }

        public int getClosedOnLine() {
            return this.closedOnLine;
        }

        public void setClosedOnLine(int n) {
            this.closedOnLine = n;
        }
    }

    private class FormattingTask
    implements Runnable {
        private Context context;
        private int startOffset;
        private int endOffset;

        public FormattingTask(Context context, int n, int n2) {
            this.context = context;
            this.startOffset = n;
            this.endOffset = n2;
        }

        public void run() {
            try {
                this.reformat();
            }
            catch (BadLocationException badLocationException) {
                logger.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
        }

        private void reformat() throws BadLocationException {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            BaseDocument baseDocument = (BaseDocument)this.context.document();
            LinkedList linkedList = new LinkedList();
            ArrayList arrayList = new ArrayList();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            if (tokenHierarchy == null) {
                logger.severe("Could not retrieve TokenHierarchy for document " + baseDocument);
                return;
            }
            TransferData transferData = null;
            if (TagBasedLexerFormatter.this.isTopLevelLanguage(baseDocument)) {
                transferData = new TransferData();
                transferData.init(baseDocument);
            } else {
                transferData = TransferData.readFromDocument(baseDocument);
                assert (transferData != null);
            }
            int n9 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)this.startOffset);
            int n10 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)this.endOffset);
            int n11 = -1;
            EmbeddingType[] embeddingTypeArray = new EmbeddingType[transferData.getNumberOfLines()];
            Arrays.fill((Object[])embeddingTypeArray, (Object)EmbeddingType.OUTER);
            int[] nArray = new int[transferData.getNumberOfLines()];
            TokenSequence[] tokenSequenceArray = tokenHierarchy.tokenSequenceList(TagBasedLexerFormatter.this.supportedLanguagePath(), 0, Integer.MAX_VALUE).toArray(new TokenSequence[0]);
            TextBounds[] textBoundsArray = new TextBounds[tokenSequenceArray.length];
            for (n8 = 0; n8 < textBoundsArray.length; ++n8) {
                textBoundsArray[n8] = TagBasedLexerFormatter.this.findTokenSequenceBounds(baseDocument, tokenSequenceArray[n8]);
                if (textBoundsArray[n8].getStartLine() <= -1) continue;
                TagBasedLexerFormatter.this.markCurrentLanguageLines(baseDocument, textBoundsArray[n8], embeddingTypeArray);
            }
            if (tokenSequenceArray.length > 0) {
                JoinedTokenSequence joinedTokenSequence = new JoinedTokenSequence(tokenSequenceArray, textBoundsArray);
                joinedTokenSequence.moveStart();
                boolean bl = joinedTokenSequence.moveNext();
                do {
                    int n12;
                    int n13;
                    boolean bl2 = TagBasedLexerFormatter.this.isOpeningTag(joinedTokenSequence, joinedTokenSequence.offset());
                    n7 = TagBasedLexerFormatter.this.isClosingTag(joinedTokenSequence, joinedTokenSequence.offset());
                    if (bl2 || n7 != 0) {
                        String string = TagBasedLexerFormatter.this.extractTagName(joinedTokenSequence, joinedTokenSequence.offset());
                        if (bl2) {
                            bl &= TagBasedLexerFormatter.this.calcIndents_processOpeningTag(baseDocument, joinedTokenSequence, string, linkedList, nArray);
                        } else {
                            n13 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)joinedTokenSequence.offset());
                            TagBasedLexerFormatter.this.calcIndents_processClosingTag(string, n13, transferData, linkedList, arrayList);
                        }
                    }
                    int n14 = n6 = n11 != -1 && TagBasedLexerFormatter.this.isWSToken(joinedTokenSequence.token()) && !joinedTokenSequence.isJustAfterGap() || TagBasedLexerFormatter.this.isUnformattableToken(joinedTokenSequence, joinedTokenSequence.offset()) ? 1 : 0;
                    if (n6 != 0 && n11 == -1) {
                        n11 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)joinedTokenSequence.offset());
                    }
                    if (!(n11 <= -1 || n6 != 0 && bl)) {
                        n13 = bl ? Utilities.getLineOffset((BaseDocument)baseDocument, (int)(joinedTokenSequence.offset() - 1)) : transferData.getNumberOfLines() - 1;
                        for (n12 = n11 + 1; n12 < n13; ++n12) {
                            transferData.setNonFormattable(n12);
                        }
                        n11 = -1;
                    }
                    if (joinedTokenSequence.embedded() == null || TagBasedLexerFormatter.this.isWSToken(joinedTokenSequence.token())) continue;
                    n13 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)joinedTokenSequence.offset());
                    n12 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)(joinedTokenSequence.offset() + TagBasedLexerFormatter.getTxtLengthWithoutWhitespaceSuffix(joinedTokenSequence.token().text())));
                    if (Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n13)) < Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)joinedTokenSequence.offset())) {
                        // empty if block
                    }
                    for (n5 = ++n13; n5 <= n12; ++n5) {
                        embeddingTypeArray[n5] = EmbeddingType.INNER;
                    }
                } while (bl &= joinedTokenSequence.moveNext());
            }
            for (n8 = 0; n8 < transferData.getNumberOfLines(); ++n8) {
                if (embeddingTypeArray[n8] == EmbeddingType.CURRENT_LANG) {
                    transferData.setProcessedByNativeFormatter(n8);
                    continue;
                }
                if (embeddingTypeArray[n8] != EmbeddingType.OUTER || transferData.wasProcessedByNativeFormatter(n8)) continue;
                embeddingTypeArray[n8] = EmbeddingType.INNER;
            }
            int[] nArray2 = new int[transferData.getNumberOfLines()];
            Arrays.fill(nArray2, 0);
            for (TagIndentationData tagIndentationData : arrayList) {
                n7 = tagIndentationData.getLine() + 1;
                while (n7 <= tagIndentationData.getClosedOnLine() - 1) {
                    int n15 = n7++;
                    nArray2[n15] = nArray2[n15] + 1;
                }
            }
            Object object = transferData.getTransformedOffsets();
            int[] nArray3 = new int[transferData.getNumberOfLines()];
            for (n7 = 0; n7 < transferData.getNumberOfLines(); ++n7) {
                nArray3[n7] = nArray2[n7] * baseDocument.getShiftWidth() + nArray[n7];
            }
            n7 = 0;
            n6 = 0;
            EmbeddingType embeddingType = null;
            int[] nArray4 = new int[transferData.getNumberOfLines()];
            n5 = TagBasedLexerFormatter.this.isTopLevelLanguage(baseDocument);
            for (n4 = 0; n4 < transferData.getNumberOfLines(); ++n4) {
                if (embeddingType != embeddingTypeArray[n4]) {
                    n7 = n4;
                    if (embeddingType == EmbeddingType.OUTER) {
                        n6 = n4;
                    }
                    embeddingType = embeddingTypeArray[n4];
                }
                if (!transferData.isFormattable(n4)) {
                    nArray4[n4] = transferData.getOriginalIndent(n4);
                    continue;
                }
                if (embeddingTypeArray[n4] == EmbeddingType.OUTER) {
                    nArray4[n4] = (int)(object[n4] + nArray3[n4]);
                    continue;
                }
                if (embeddingTypeArray[n4] == EmbeddingType.INNER) {
                    if (n7 == n4) {
                        n3 = n4 > 0 ? nArray4[n7 - 1] : 0;
                        n2 = nArray3[n4] - (n4 > 0 ? nArray3[n4 - 1] : 0);
                        nArray4[n4] = n3 + n2;
                        continue;
                    }
                    n3 = n5 != 0 ? transferData.getOriginalIndent(n4) - transferData.getOriginalIndent(n7) : (int)(object[n4] - object[n7]);
                    nArray4[n4] = nArray4[n7] + n3;
                    continue;
                }
                nArray4[n4] = (int)(object[n6] + nArray3[n4]);
            }
            n4 = 0;
            if (n9 > 0) {
                n4 = transferData.getOriginalIndent(n9 - 1) - nArray4[n9 - 1];
            }
            for (n3 = n9; n3 <= n10; ++n3) {
                n2 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n3);
                n = nArray4[n3] + n4;
                this.context.modifyIndent(n2, n > 0 ? n : 0);
            }
            transferData.setTransformedOffsets(nArray4);
            if (logger.isLoggable(Level.FINE)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (n2 = 0; n2 < transferData.getNumberOfLines(); ++n2) {
                    n = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n2);
                    char c = '\u0000';
                    c = !transferData.isFormattable(n2) ? (char)'-' : (embeddingTypeArray[n2] == EmbeddingType.INNER ? (char)'I' : (embeddingTypeArray[n2] == EmbeddingType.OUTER ? (char)'O' : 'C'));
                    char c2 = n2 >= n9 && n2 <= n10 ? (char)'*' : ' ';
                    stringBuilder.append(n2 + ":" + c2 + ":" + nArray2[n2] + ":" + c + ":" + baseDocument.getText(n, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) - n) + ".\n");
                }
                stringBuilder.append("\n-------------\n");
                logger.fine(TagBasedLexerFormatter.this.formatterName() + ":\n" + stringBuilder);
            }
        }
    }

    private class EnterPressedTask
    implements Runnable {
        private Context context;

        public EnterPressedTask(Context context) {
            this.context = context;
        }

        public void run() {
            try {
                this.enterPressed();
            }
            catch (BadLocationException badLocationException) {
                logger.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
        }

        private void enterPressed() throws BadLocationException {
            int n;
            Integer n2;
            BaseDocument baseDocument = (BaseDocument)this.context.document();
            if (TagBasedLexerFormatter.this.isTopLevelLanguage(baseDocument)) {
                baseDocument.putProperty((Object)"TagBasedFormatter.org_caret_offset", (Object)new Integer(this.context.caretOffset()));
            }
            if ((n2 = (Integer)baseDocument.getProperty((Object)"TagBasedFormatter.org_caret_offset")) == null) {
                n2 = this.context.caretOffset();
            }
            if (TagBasedLexerFormatter.this.indexWithinCurrentLanguage(baseDocument, (n = n2 - 1) - 1)) {
                if (TagBasedLexerFormatter.this.isSmartEnter(baseDocument, n2)) {
                    TagBasedLexerFormatter.this.handleSmartEnter(this.context);
                } else {
                    int n3 = 0;
                    int n4 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2);
                    boolean bl = false;
                    if (Utilities.getRowStart((BaseDocument)baseDocument, (int)n) == n) {
                        n3 = TagBasedLexerFormatter.getExistingIndent(baseDocument, n4);
                        bl = true;
                    } else if (n4 > 0) {
                        n3 = TagBasedLexerFormatter.getExistingIndent(baseDocument, n4 - 1);
                    }
                    TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                    TokenSequence[] tokenSequenceArray = tokenHierarchy.tokenSequenceList(TagBasedLexerFormatter.this.supportedLanguagePath(), 0, Integer.MAX_VALUE).toArray(new TokenSequence[0]);
                    TextBounds[] textBoundsArray = new TextBounds[tokenSequenceArray.length];
                    for (int i = 0; i < textBoundsArray.length; ++i) {
                        textBoundsArray[i] = TagBasedLexerFormatter.this.findTokenSequenceBounds(baseDocument, tokenSequenceArray[i]);
                    }
                    JoinedTokenSequence joinedTokenSequence = new JoinedTokenSequence(tokenSequenceArray, textBoundsArray);
                    joinedTokenSequence.moveStart();
                    joinedTokenSequence.moveNext();
                    int n5 = TagBasedLexerFormatter.this.getTagEndingAtPosition(joinedTokenSequence, n - 1);
                    if (TagBasedLexerFormatter.this.isOpeningTag(joinedTokenSequence, n5)) {
                        n3 += baseDocument.getShiftWidth();
                    }
                    this.context.modifyIndent(Utilities.getRowStart((BaseDocument)baseDocument, (int)n2), n3);
                    if (bl) {
                        this.context.setCaretOffset(this.context.caretOffset() - n3);
                    }
                }
            }
        }
    }

    private class IsJustAfterClosingTagTask
    implements Runnable {
        private BaseDocument doc;
        private int pos;
        private boolean result = false;

        public IsJustAfterClosingTagTask(BaseDocument baseDocument, int n) {
            this.doc = baseDocument;
            this.pos = n;
        }

        public void run() {
            try {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
                TokenSequence[] tokenSequenceArray = tokenHierarchy.tokenSequenceList(TagBasedLexerFormatter.this.supportedLanguagePath(), 0, Integer.MAX_VALUE).toArray(new TokenSequence[0]);
                TextBounds[] textBoundsArray = new TextBounds[tokenSequenceArray.length];
                for (int i = 0; i < textBoundsArray.length; ++i) {
                    textBoundsArray[i] = TagBasedLexerFormatter.this.findTokenSequenceBounds(this.doc, tokenSequenceArray[i]);
                }
                if (tokenSequenceArray.length > 0) {
                    JoinedTokenSequence joinedTokenSequence = new JoinedTokenSequence(tokenSequenceArray, textBoundsArray);
                    joinedTokenSequence.moveStart();
                    joinedTokenSequence.moveNext();
                    int n = TagBasedLexerFormatter.this.getTagEndingAtPosition(joinedTokenSequence, this.pos);
                    this.result = n >= 0 && TagBasedLexerFormatter.this.isClosingTag(joinedTokenSequence, n);
                }
            }
            catch (BadLocationException badLocationException) {
                logger.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
        }

        public boolean getResult() {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EmbeddingType {
        CURRENT_LANG,
        INNER,
        OUTER;

    }
}

