/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.output.svg;

import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.DOMOutputter;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.TextAlignment;
import org.krysalis.barcode4j.output.BarcodeCanvasSetupException;
import org.krysalis.barcode4j.output.svg.AbstractSVGGeneratingCanvasProvider;
import org.w3c.dom.DocumentFragment;

public class JDOMSVGCanvasProvider
extends AbstractSVGGeneratingCanvasProvider {
    private Namespace ns;
    private Document doc;
    private Element detailGroup;

    public JDOMSVGCanvasProvider(String namespacePrefix, int orientation) throws BarcodeCanvasSetupException {
        super(namespacePrefix, orientation);
    }

    public JDOMSVGCanvasProvider(boolean useNamespace, int orientation) throws BarcodeCanvasSetupException {
        super(useNamespace, orientation);
        this.init();
    }

    public JDOMSVGCanvasProvider(int orientation) throws BarcodeCanvasSetupException {
        super(orientation);
        this.init();
    }

    private void init() {
        this.ns = this.isNamespaceEnabled() ? (this.getNamespacePrefix() != null ? Namespace.getNamespace((String)this.getNamespacePrefix(), (String)"http://www.w3.org/2000/svg") : Namespace.getNamespace((String)"http://www.w3.org/2000/svg")) : null;
        Element svg = new Element("svg", this.ns);
        this.doc = new Document(svg);
        this.detailGroup = new Element("g", this.ns);
        svg.addContent((Content)this.detailGroup);
        this.detailGroup.setAttribute("style", "fill:black; stroke:none");
    }

    public Document getDocument() {
        return this.doc;
    }

    public org.w3c.dom.Document getDOM() {
        DOMOutputter output = new DOMOutputter();
        try {
            return output.output(this.doc);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return null;
        }
    }

    public DocumentFragment getDOMFragment() {
        org.w3c.dom.Document doc = this.getDOM();
        DocumentFragment frag = doc.createDocumentFragment();
        frag.appendChild(doc.getDocumentElement());
        return frag;
    }

    public void establishDimensions(BarcodeDimension dim) {
        super.establishDimensions(dim);
        Element svg = this.doc.getRootElement();
        svg.setAttribute("width", this.getDecimalFormat().format(dim.getWidthPlusQuiet()));
        svg.setAttribute("height", this.getDecimalFormat().format(dim.getHeightPlusQuiet()));
        svg.setAttribute("viewBox", "0 0 " + this.getDecimalFormat().format(dim.getWidthPlusQuiet()) + " " + this.getDecimalFormat().format(dim.getHeightPlusQuiet()));
    }

    public void deviceFillRect(double x, double y, double w, double h) {
        Element el = new Element("rect", this.ns);
        el.setAttribute("x", this.getDecimalFormat().format(x));
        el.setAttribute("y", this.getDecimalFormat().format(y));
        el.setAttribute("width", this.getDecimalFormat().format(w));
        el.setAttribute("height", this.getDecimalFormat().format(h));
        this.detailGroup.addContent((Content)el);
    }

    public void deviceText(String text, double x1, double x2, double y1, String fontName, double fontSize, TextAlignment textAlign) {
        double tx;
        String anchor;
        Element el = new Element("text", this.ns);
        if (textAlign == TextAlignment.TA_LEFT) {
            anchor = "start";
            tx = x1;
        } else if (textAlign == TextAlignment.TA_RIGHT) {
            anchor = "end";
            tx = x2;
        } else {
            anchor = "middle";
            tx = x1 + (x2 - x1) / 2.0;
        }
        el.setAttribute("style", "font-family:" + fontName + "; font-size:" + this.getDecimalFormat().format(fontSize) + "; text-anchor:" + anchor);
        el.setAttribute("x", this.getDecimalFormat().format(tx));
        el.setAttribute("y", this.getDecimalFormat().format(y1));
        if (textAlign == TextAlignment.TA_JUSTIFY) {
            el.setAttribute("textLength", this.getDecimalFormat().format(x2 - x1));
        }
        el.addContent(text);
        this.detailGroup.addContent((Content)el);
    }
}

