/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.wizards.AddServerLocationVisualPanel;
import org.netbeans.modules.glassfish.common.wizards.ServerWizardIterator;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.glassfish.spi.TreeParser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AddServerLocationPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private static final String DOMAIN_XML_PATH = "config/domain.xml";
    private final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private final String PROP_WARNING_MESSAGE = "WizardPanel_warningMessage";
    private final String PROP_INFO_MESSAGE = "WizardPanel_infoMessage";
    private ServerWizardIterator wizardIterator;
    private AddServerLocationVisualPanel component;
    private WizardDescriptor wizard;
    private transient List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private AtomicBoolean isValidating = new AtomicBoolean();
    private static Pattern ILLEGAL_WINDOWS_CHARS = Pattern.compile("<|>|\\\"");

    public AddServerLocationPanel(ServerWizardIterator serverWizardIterator) {
        this.wizardIterator = serverWizardIterator;
        this.wizard = null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent(changeEvent);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AddServerLocationVisualPanel();
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("registering_app_server_hk2_location");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        if (this.isValidating.compareAndSet(false, true)) {
            try {
                this.wizardIterator.setHttpPort(-1);
                AddServerLocationVisualPanel addServerLocationVisualPanel = (AddServerLocationVisualPanel)this.getComponent();
                AddServerLocationVisualPanel.DownloadState downloadState = addServerLocationVisualPanel.getDownloadState();
                if (downloadState == AddServerLocationVisualPanel.DownloadState.DOWNLOADING) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)addServerLocationVisualPanel.getStatusText());
                    boolean bl = false;
                    return bl;
                }
                String string = addServerLocationVisualPanel.getHk2HomeLocation();
                String string2 = string = string != null ? string.trim() : null;
                if (string == null || string.length() == 0) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_BlankInstallDir"));
                    boolean bl = false;
                    return bl;
                }
                File file = new File(string).getAbsoluteFile();
                File file2 = this.getGlassfishRoot(file);
                File file3 = this.getDefaultDomain(file2);
                if (!file.exists()) {
                    if (!AddServerLocationPanel.isLegalFolder(file)) {
                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallDirInvalid", (Object)string));
                        boolean bl = false;
                        return bl;
                    }
                    if (AddServerLocationPanel.canCreate(file)) {
                        if (downloadState == AddServerLocationVisualPanel.DownloadState.AVAILABLE) {
                            addServerLocationVisualPanel.updateMessageText(NbBundle.getMessage(AddServerLocationPanel.class, (String)"LBL_InstallDirWillBeUsed", (Object)AddServerLocationPanel.getSanitizedPath(file)));
                            this.wizard.putProperty("WizardPanel_errorMessage", (Object)addServerLocationVisualPanel.getStatusText());
                            boolean bl = false;
                            return bl;
                        }
                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallDirDoesNotExist", (Object)AddServerLocationPanel.getSanitizedPath(file)));
                        boolean bl = false;
                        return bl;
                    }
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_CannotCreate", (Object)AddServerLocationPanel.getSanitizedPath(file)));
                    boolean bl = false;
                    return bl;
                }
                if (!this.isValidV3Install(file, file2)) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallationInvalid", (Object)AddServerLocationPanel.getSanitizedPath(file)));
                    boolean bl = false;
                    return bl;
                }
                if (!AddServerLocationPanel.isRegisterableV3Domain(file3)) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_DefaultDomainInvalid", (Object)AddServerLocationPanel.getSanitizedPath(file)));
                } else {
                    AddServerLocationPanel.readServerConfiguration(file3, this.wizardIterator);
                    String string3 = CommonServerSupport.formatUri(file2.getAbsolutePath(), "localhost", this.wizardIterator.getHttpPort());
                    if (GlassfishInstanceProvider.getDefault().hasServer(string3)) {
                        this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"MSG_DefaultDomainExists", (Object)AddServerLocationPanel.getSanitizedPath(file), (Object)"domain1"));
                        this.wizardIterator.setHttpPort(-1);
                    } else {
                        String string4 = addServerLocationVisualPanel.getStatusText();
                        if (string4 != null && string4.length() > 0) {
                            this.wizard.putProperty("WizardPanel_errorMessage", (Object)string4);
                            boolean bl = false;
                            return bl;
                        }
                        this.wizard.putProperty("WizardPanel_errorMessage", null);
                    }
                }
                this.wizardIterator.setInstallRoot(file.getAbsolutePath());
                this.wizardIterator.setGlassfishRoot(file2.getAbsolutePath());
                this.wizardIterator.setDomainLocation(file3.getAbsolutePath());
                boolean bl = true;
                return bl;
            }
            finally {
                this.isValidating.set(false);
            }
        }
        return true;
    }

    private static String getSanitizedPath(File file) {
        return FileUtil.normalizeFile((File)file).getPath();
    }

    private static boolean isLegalFolder(File file) {
        return AddServerLocationPanel.getCanonicalFile(file) != null && (!Utilities.isWindows() || !ILLEGAL_WINDOWS_CHARS.matcher(file.getPath()).find());
    }

    private static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static boolean canCreate(File file) {
        if (file.exists()) {
            return false;
        }
        while (file != null && !file.exists()) {
            file = file.getParentFile();
        }
        return file != null ? file.canRead() && file.canWrite() : false;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void readSettings(Object object) {
        if (this.wizard == null) {
            this.wizard = (WizardDescriptor)object;
        }
    }

    public void storeSettings(Object object) {
    }

    public boolean isFinishPanel() {
        return this.wizardIterator.getHttpPort() != -1;
    }

    private boolean isValidV3Install(File file, File file2) {
        File file3 = ServerUtilities.getJarName(file2.getAbsolutePath(), "glassfish(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (file3 == null || !file3.exists()) {
            return false;
        }
        File file4 = new File(file2, "config" + File.separator + "glassfish.container");
        return file4.exists();
    }

    static boolean isRegisterableV3Domain(File file) {
        File file2 = new File(file, "logs");
        if (!file2.exists()) {
            file2 = file;
        }
        return file2.canWrite() && AddServerLocationPanel.readServerConfiguration(file, null);
    }

    private File getGlassfishRoot(File file) {
        File file2 = new File(file, "glassfish");
        if (!file2.exists()) {
            file2 = file;
        }
        return file2;
    }

    private File getDefaultDomain(File file) {
        File file2;
        File[] fileArray;
        File file3 = new File(file, "domains" + File.separator + "domain1");
        if (!AddServerLocationPanel.isRegisterableV3Domain(file3) && null != (fileArray = (file2 = new File(file, "domains")).listFiles()) && fileArray.length > 0) {
            for (File file4 : fileArray) {
                if (!AddServerLocationPanel.isRegisterableV3Domain(file3)) continue;
                file3 = file4;
                break;
            }
        }
        return file3;
    }

    static boolean readServerConfiguration(File file, ServerWizardIterator serverWizardIterator) {
        boolean bl = false;
        File file2 = new File(file, DOMAIN_XML_PATH);
        final LinkedHashMap linkedHashMap = new LinkedHashMap();
        if (file2.exists()) {
            ArrayList<TreeParser.Path> arrayList = new ArrayList<TreeParser.Path>();
            arrayList.add(new TreeParser.Path("/domain/configs/config/http-service/http-listener", new TreeParser.NodeReader(){

                public void readAttributes(String string, Attributes attributes) throws SAXException {
                    try {
                        String string2 = attributes.getValue("id");
                        if (string2 != null && string2.length() > 0) {
                            boolean bl;
                            int n = Integer.parseInt(attributes.getValue("port"));
                            boolean bl2 = "true".equals(attributes.getValue("security-enabled"));
                            boolean bl3 = bl = !"false".equals(attributes.getValue("enabled"));
                            if (bl) {
                                HttpData httpData = new HttpData(string2, n, bl2);
                                Logger.getLogger("glassfish").log(Level.FINER, " Adding " + httpData);
                                linkedHashMap.put(string2, httpData);
                            } else {
                                Logger.getLogger("glassfish").log(Level.FINER, "http-listener " + string2 + " is not enabled and won't be used.");
                            }
                        } else {
                            Logger.getLogger("glassfish").log(Level.FINEST, "http-listener found with no name");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SAXException(numberFormatException);
                    }
                }
            }));
            try {
                int n;
                TreeParser.readXml(file2, arrayList);
                HttpData httpData = (HttpData)linkedHashMap.remove("admin-listener");
                if (null != serverWizardIterator) {
                    serverWizardIterator.setAdminPort(httpData != null ? httpData.getPort() : -1);
                }
                HttpData httpData2 = null;
                HttpData httpData3 = null;
                for (HttpData httpData4 : linkedHashMap.values()) {
                    if (httpData4.isSecure()) {
                        if (httpData3 == null) {
                            httpData3 = httpData4;
                        }
                    } else if (httpData2 == null) {
                        httpData2 = httpData4;
                    }
                    if (httpData2 == null || httpData3 == null) continue;
                    break;
                }
                int n2 = n = httpData2 != null ? httpData2.getPort() : -1;
                if (null != serverWizardIterator) {
                    serverWizardIterator.setHttpPort(n);
                    serverWizardIterator.setHttpsPort(httpData3 != null ? httpData3.getPort() : -1);
                }
                bl = n != -1;
            }
            catch (IllegalStateException illegalStateException) {
                Logger.getLogger("glassfish").log(Level.INFO, illegalStateException.getLocalizedMessage(), illegalStateException);
            }
        }
        return bl;
    }

    private static class HttpData {
        private final String id;
        private final int port;
        private final boolean secure;

        public HttpData(String string, int n, boolean bl) {
            this.id = string;
            this.port = n;
            this.secure = bl;
        }

        public String getId() {
            return this.id;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String toString() {
            return "{ " + this.id + ", " + this.port + ", " + this.secure + " }";
        }
    }
}

