/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.transaction.IsolatedWork;
import org.hibernate.exception.JDBCExceptionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Isolater {
    private static final Logger log = LoggerFactory.getLogger((Class)Isolater.class);

    public static void doIsolatedWork(IsolatedWork work, SessionImplementor session) throws HibernateException {
        boolean isJta;
        boolean bl = isJta = session.getFactory().getTransactionManager() != null;
        if (isJta) {
            new JtaDelegate(session).delegateWork(work, true);
        } else {
            new JdbcDelegate(session).delegateWork(work, true);
        }
    }

    public static void doNonTransactedWork(IsolatedWork work, SessionImplementor session) throws HibernateException {
        boolean isJta;
        boolean bl = isJta = session.getFactory().getTransactionManager() != null;
        if (isJta) {
            new JtaDelegate(session).delegateWork(work, false);
        } else {
            new JdbcDelegate(session).delegateWork(work, false);
        }
    }

    public static class JdbcDelegate
    implements Delegate {
        private final SessionImplementor session;

        public JdbcDelegate(SessionImplementor session) {
            this.session = session;
        }

        public void delegateWork(IsolatedWork work, boolean transacted) throws HibernateException {
            Connection connection = null;
            boolean wasAutoCommit = false;
            try {
                connection = this.session.getBatcher().openConnection();
                if (transacted && connection.getAutoCommit()) {
                    wasAutoCommit = true;
                    connection.setAutoCommit(false);
                }
                work.doWork(connection);
                if (transacted) {
                    connection.commit();
                }
            }
            catch (Throwable t) {
                try {
                    if (transacted && connection != null && !connection.isClosed()) {
                        connection.rollback();
                    }
                }
                catch (Throwable ignore) {
                    log.trace("unable to release connection on exception [" + ignore + "]");
                }
                if (t instanceof HibernateException) {
                    throw (HibernateException)t;
                }
                if (t instanceof SQLException) {
                    throw JDBCExceptionHelper.convert(this.session.getFactory().getSQLExceptionConverter(), (SQLException)t, "error performing isolated work");
                }
                throw new HibernateException("error performing isolated work", t);
            }
            finally {
                if (connection != null) {
                    if (transacted && wasAutoCommit) {
                        try {
                            connection.setAutoCommit(true);
                        }
                        catch (Throwable ignore) {
                            log.trace("was unable to reset connection back to auto-commit");
                        }
                    }
                    this.session.getBatcher().closeConnection(connection);
                }
            }
        }
    }

    public static class JtaDelegate
    implements Delegate {
        private final SessionImplementor session;

        public JtaDelegate(SessionImplementor session) {
            this.session = session;
        }

        public void delegateWork(IsolatedWork work, boolean transacted) throws HibernateException {
            TransactionManager transactionManager = this.session.getFactory().getTransactionManager();
            Transaction surroundingTransaction = null;
            Connection connection = null;
            boolean caughtException = false;
            try {
                surroundingTransaction = transactionManager.suspend();
                if (log.isDebugEnabled()) {
                    log.debug("surrounding JTA transaction suspended [" + surroundingTransaction + "]");
                }
                if (transacted) {
                    transactionManager.begin();
                }
                connection = this.session.getBatcher().openConnection();
                work.doWork(connection);
                this.session.getBatcher().closeConnection(connection);
                if (transacted) {
                    transactionManager.commit();
                }
            }
            catch (Throwable t) {
                caughtException = true;
                try {
                    if (connection != null && !connection.isClosed()) {
                        this.session.getBatcher().closeConnection(connection);
                    }
                }
                catch (Throwable ignore) {
                    log.trace("unable to release connection on exception [" + ignore + "]");
                }
                if (transacted) {
                    try {
                        transactionManager.rollback();
                    }
                    catch (Throwable ignore) {
                        log.trace("unable to rollback new transaction on exception [" + ignore + "]");
                    }
                }
                if (t instanceof HibernateException) {
                    throw (HibernateException)t;
                }
                throw new HibernateException("error performing isolated work", t);
            }
            finally {
                block22: {
                    if (surroundingTransaction != null) {
                        try {
                            transactionManager.resume(surroundingTransaction);
                            if (log.isDebugEnabled()) {
                                log.debug("surrounding JTA transaction resumed [" + surroundingTransaction + "]");
                            }
                        }
                        catch (Throwable t) {
                            if (caughtException) break block22;
                            throw new HibernateException("unable to resume previously suspended transaction", t);
                        }
                    }
                }
            }
        }
    }

    private static interface Delegate {
        public void delegateWork(IsolatedWork var1, boolean var2) throws HibernateException;
    }
}

