/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.TextMeasurer;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdkGlyphFixTextMeasurer
extends TextMeasurer {
    private static final Log log = LogFactory.getLog(JdkGlyphFixTextMeasurer.class);
    protected static final String JDK_EXCEPTION_CLASS_PREFIX = "sun.font.GlyphLayout";
    public static final int DEFAULT_ATTEMPTS = 20;
    public static final int DEFAULT_ATTEMPT_SLEEP = 0;
    public static final String PROPERTY_ATTEMPTS = "net.sf.jasperreports.jdk.glyph.fix.text.measurer.attempts";
    public static final String PROPERTY_ATTEMPT_SLEEP = "net.sf.jasperreports.jdk.glyph.fix.text.measurer.sleep";
    public static final String PROPERTY_CATCH_EMPTY_STACKTRACE = "net.sf.jasperreports.jdk.glyph.fix.text.measurer.catch.empty.stakctrace";
    private final int attempts = JRProperties.getIntegerProperty("net.sf.jasperreports.jdk.glyph.fix.text.measurer.attempts", 20);
    private final int sleep = JRProperties.getIntegerProperty("net.sf.jasperreports.jdk.glyph.fix.text.measurer.sleep", 0);
    private final boolean catchEmptyStacktrace = JRProperties.getBooleanProperty("net.sf.jasperreports.jdk.glyph.fix.text.measurer.catch.empty.stakctrace");

    public JdkGlyphFixTextMeasurer(JRCommonText textElement) {
        super(textElement);
    }

    public JRMeasuredText measure(JRStyledText styledText, int remainingTextStart, int availableStretchHeight, boolean canOverflow) {
        int count = 0;
        while (true) {
            try {
                ++count;
                return super.measure(styledText, remainingTextStart, availableStretchHeight, canOverflow);
            }
            catch (NullPointerException e) {
                if (this.isJdkGlyphError(e)) {
                    if (count >= this.attempts) {
                        log.error((Object)("JDK Glyph exception caught " + this.attempts + " times, giving up attempts"));
                        throw e;
                    }
                } else {
                    throw e;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Caught JDK Glyph exception " + e + " at attempt #" + count));
                }
                if (this.sleep <= 0) continue;
                try {
                    Thread.sleep(this.sleep);
                }
                catch (InterruptedException ie) {
                    throw new JRRuntimeException(ie);
                }
            }
        }
    }

    protected boolean isJdkGlyphError(NullPointerException e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caught exception with no stacktrace; " + (this.catchEmptyStacktrace ? "" : "not ") + "treating as JDK Glyph exception"));
            }
            return this.catchEmptyStacktrace;
        }
        StackTraceElement top = stackTrace[0];
        return top.getClassName().startsWith(JDK_EXCEPTION_CLASS_PREFIX);
    }
}

