/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mondrian.calc.ResultStyle;
import mondrian.olap.MondrianProperties;
import mondrian.rolap.HighCardSqlTupleReader;
import mondrian.rolap.MemberCache;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Target {
    private final HighCardSqlTupleReader sqlTupleReader;
    private final RolapLevel level;
    private final MemberCache cache;
    private final TupleConstraint constraint;
    private final TupleReader.MemberBuilder memberBuilder;
    private final List<RolapMember> srcMembers;
    boolean parentChild;
    private RolapLevel[] levels;
    private RolapMember currMember;
    private List<List<RolapMember>> siblings;
    private List<RolapMember> members;
    private int levelDepth;
    private List<RolapMember> list;

    public Target(RolapLevel level, TupleReader.MemberBuilder memberBuilder, List<RolapMember> srcMembers, TupleConstraint constraint, HighCardSqlTupleReader sqlTupleReader) {
        this.sqlTupleReader = sqlTupleReader;
        this.level = level;
        this.constraint = constraint;
        this.cache = memberBuilder.getMemberCache();
        this.memberBuilder = memberBuilder;
        this.srcMembers = srcMembers;
    }

    public List<RolapMember> getSrcMembers() {
        return this.srcMembers;
    }

    public RolapMember getCurrMember() {
        return this.currMember;
    }

    public void removeCurrMember() {
        this.currMember = null;
    }

    public void setCurrMember(RolapMember m) {
        this.currMember = m;
    }

    public void add(RolapMember member) {
        this.list.add(member);
    }

    public void open() {
        int i;
        this.levels = (RolapLevel[])this.level.getHierarchy().getLevels();
        this.list = new LinkedList<RolapMember>();
        this.levelDepth = this.level.getDepth();
        this.parentChild = this.level.isParentChild();
        this.members = new ArrayList<RolapMember>();
        for (i = 0; i < this.levels.length; ++i) {
            this.members.add(null);
        }
        this.siblings = new ArrayList<List<RolapMember>>();
        for (i = 0; i < this.levels.length + 1; ++i) {
            this.siblings.add(new ArrayList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRow(ResultSet resultSet, int column) throws SQLException {
        MemberCache memberCache = this.cache;
        synchronized (memberCache) {
            return this.internalAddRow(resultSet, column);
        }
    }

    private int internalAddRow(ResultSet resultSet, int column) throws SQLException {
        RolapMember member = null;
        if (this.currMember != null) {
            member = this.currMember;
        } else {
            boolean checkCacheStatus = true;
            for (int i = 0; i <= this.levelDepth; ++i) {
                Object value;
                RolapLevel childLevel = this.levels[i];
                if (childLevel.isAll()) {
                    member = this.level.getHierarchy().getAllMember();
                    continue;
                }
                if ((value = resultSet.getObject(++column)) == null) {
                    value = RolapUtil.sqlNullValue;
                }
                Object captionValue = childLevel.hasCaptionColumn() ? resultSet.getObject(++column) : null;
                RolapMember parentMember = member;
                Object key = this.cache.makeKey(parentMember, value);
                member = this.cache.getMember(key, checkCacheStatus);
                checkCacheStatus = false;
                if (member == null) {
                    member = this.memberBuilder.makeMember(parentMember, childLevel, value, captionValue, this.parentChild, resultSet, key, column);
                }
                if (!childLevel.getOrdinalExp().equals((Object)childLevel.getKeyExp())) {
                    ++column;
                }
                column += childLevel.getProperties().length;
            }
            this.currMember = member;
        }
        this.list.add(member);
        return column;
    }

    public List<RolapMember> close() {
        final boolean asList = this.constraint.getEvaluator() != null && this.constraint.getEvaluator().getQuery().getResultStyle() == ResultStyle.LIST;
        final int limit = MondrianProperties.instance().ResultLimit.get();
        AbstractList<RolapMember> l = new AbstractList<RolapMember>(){
            private boolean moreRows = true;
            private int offset = 0;
            private RolapMember first = null;
            private boolean firstMemberAssigned = false;

            @Override
            public int size() {
                while (this.moreRows) {
                    this.moreRows = Target.this.sqlTupleReader.readNextTuple();
                    if (limit <= 0 || asList || Target.this.list.size() <= limit) continue;
                    System.out.println("Target: 199, Ouch! Toooo big array..." + this.hashCode());
                    new Throwable().printStackTrace();
                }
                return Target.this.list.size();
            }

            @Override
            public RolapMember get(int idx) {
                if (asList) {
                    return (RolapMember)Target.this.list.get(idx);
                }
                if (idx == 0 && this.firstMemberAssigned) {
                    return this.first;
                }
                int index = idx - this.offset;
                if (0 < limit && index < 0) {
                    throw new RuntimeException("Element " + idx + " has been forgotten");
                }
                while (index >= Target.this.list.size() && this.moreRows) {
                    this.moreRows = Target.this.sqlTupleReader.readNextTuple();
                    if (asList || limit <= 0 || Target.this.list.size() <= limit) continue;
                    while (Target.this.list.size() > limit) {
                        --index;
                        ++this.offset;
                        ((LinkedList)Target.this.list).removeFirst();
                    }
                }
                if (idx == 0) {
                    this.first = (RolapMember)Target.this.list.get(index);
                    this.firstMemberAssigned = true;
                    return this.first;
                }
                return (RolapMember)Target.this.list.get(index);
            }

            @Override
            public RolapMember set(int i, RolapMember e) {
                if (asList) {
                    return Target.this.list.set(i, e);
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isEmpty() {
                try {
                    this.get(0);
                    return false;
                }
                catch (IndexOutOfBoundsException e) {
                    return true;
                }
            }

            @Override
            public int hashCode() {
                return Target.this.hashCode();
            }

            @Override
            public Iterator<RolapMember> iterator() {
                return new Iterator<RolapMember>(){
                    private int cursor = 0;

                    @Override
                    public boolean hasNext() {
                        try {
                            this.get(this.cursor);
                            return true;
                        }
                        catch (IndexOutOfBoundsException ioobe) {
                            return false;
                        }
                    }

                    @Override
                    public RolapMember next() {
                        return this.get(this.cursor++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        if (asList) {
            l.size();
        }
        return l;
    }

    private List<RolapMember> internalClose() {
        for (int i = 0; i < this.members.size(); ++i) {
            MemberChildrenConstraint mcc;
            RolapMember member = this.members.get(i);
            List<RolapMember> children = this.siblings.get(i + 1);
            if (member == null || children == null || member.getDepth() < this.level.getDepth() || (mcc = this.constraint.getMemberChildrenConstraint(member)) == null) continue;
            this.cache.putChildren(member, mcc, children);
        }
        return this.list;
    }

    private void addAsOldestSibling(List<RolapMember> list, RolapMember member) {
        RolapMember sibling;
        int i = list.size();
        while (--i >= 0 && (sibling = list.get(i)).getParentMember() == member.getParentMember()) {
        }
        list.add(i + 1, member);
    }

    public RolapLevel getLevel() {
        return this.level;
    }

    public String toString() {
        return this.level.getUniqueName();
    }
}

