/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.builtin.DiffPresenter;
import org.netbeans.modules.diff.builtin.visualizer.TextDiffEditorSupport;
import org.netbeans.modules.diff.builtin.visualizer.UnifiedDiff;
import org.netbeans.spi.diff.DiffVisualizer;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableOpenSupport;

public class TextDiffVisualizer
extends DiffVisualizer
implements Serializable {
    private boolean contextMode = true;
    private int contextNumLines = 3;
    static final long serialVersionUID = -2481513747957146261L;

    public String getDisplayName() {
        return NbBundle.getMessage(TextDiffVisualizer.class, (String)"TextDiffVisualizer.displayName");
    }

    public String getShortDescription() {
        return NbBundle.getMessage(TextDiffVisualizer.class, (String)"TextDiffVisualizer.shortDescription");
    }

    public boolean isContextMode() {
        return this.contextMode;
    }

    public void setContextMode(boolean bl) {
        this.contextMode = bl;
    }

    public int getContextNumLines() {
        return this.contextNumLines;
    }

    public void setContextNumLines(int n) {
        this.contextNumLines = n;
    }

    public Component createView(Difference[] differenceArray, String string, String string2, Reader reader, String string3, String string4, Reader reader2, String string5) throws IOException {
        TextDiffInfo textDiffInfo = new TextDiffInfo(string, string3, string2, string4, reader, reader2, differenceArray);
        textDiffInfo.setContextMode(this.contextMode, this.contextNumLines);
        return ((TextDiffEditorSupport)textDiffInfo.getOpenSupport()).createCloneableTopComponentForMe();
    }

    static InputStream differenceToLineDiffText(Difference[] differenceArray) {
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < differenceArray.length; ++i) {
            Difference difference = differenceArray[i];
            switch (difference.getType()) {
                case 1: {
                    int n4 = difference.getSecondStart();
                    int n2 = difference.getSecondEnd();
                    if (n4 == n2) {
                        stringBuffer.append(difference.getFirstStart() + "a" + n4 + "\n");
                    } else {
                        stringBuffer.append(difference.getFirstStart() + "a" + n4 + "," + n2 + "\n");
                    }
                    TextDiffVisualizer.appendText(stringBuffer, "> ", difference.getSecondText());
                    continue block5;
                }
                case 0: {
                    int n = difference.getFirstStart();
                    int n3 = difference.getFirstEnd();
                    if (n == n3) {
                        stringBuffer.append(n + "d" + difference.getSecondStart() + "\n");
                    } else {
                        stringBuffer.append(n + "," + n3 + "d" + difference.getSecondStart() + "\n");
                    }
                    TextDiffVisualizer.appendText(stringBuffer, "< ", difference.getFirstText());
                    continue block5;
                }
                case 2: {
                    int n = difference.getFirstStart();
                    int n3 = difference.getFirstEnd();
                    int n4 = difference.getSecondStart();
                    int n2 = difference.getSecondEnd();
                    if (n == n3 && n4 == n2) {
                        stringBuffer.append(n + "c" + n4 + "\n");
                    } else if (n == n3) {
                        stringBuffer.append(n + "c" + n4 + "," + n2 + "\n");
                    } else if (n4 == n2) {
                        stringBuffer.append(n + "," + n3 + "c" + n4 + "\n");
                    } else {
                        stringBuffer.append(n + "," + n3 + "c" + n4 + "," + n2 + "\n");
                    }
                    TextDiffVisualizer.appendText(stringBuffer, "< ", difference.getFirstText());
                    stringBuffer.append("---\n");
                    TextDiffVisualizer.appendText(stringBuffer, "> ", difference.getSecondText());
                }
            }
        }
        return new ByteArrayInputStream(stringBuffer.toString().getBytes());
    }

    private static void appendText(StringBuffer stringBuffer, String string, String string2) {
        int n;
        if (string2 == null) {
            return;
        }
        int n2 = 0;
        do {
            if ((n = string2.indexOf(10, n2)) < 0) {
                n = string2.length();
            }
            stringBuffer.append(string + string2.substring(n2, n) + "\n");
        } while ((n2 = n + 1) < string2.length());
    }

    public static String differenceToUnifiedDiffText(TextDiffInfo textDiffInfo) throws IOException {
        UnifiedDiff unifiedDiff = new UnifiedDiff(textDiffInfo);
        return unifiedDiff.computeDiff();
    }

    public static String differenceToNormalDiffText(TextDiffInfo textDiffInfo) throws IOException {
        InputStream inputStream = TextDiffVisualizer.differenceToLineDiffText(textDiffInfo.diffs);
        StringWriter stringWriter = new StringWriter();
        TextDiffVisualizer.copyStreamsCloseAll(stringWriter, new InputStreamReader(inputStream));
        return stringWriter.toString();
    }

    private static void copyStreamsCloseAll(Writer writer, Reader reader) throws IOException {
        int n;
        char[] cArray = new char[4096];
        while ((n = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n);
        }
        writer.close();
        reader.close();
    }

    public static class TextDiffInfo
    extends DiffPresenter.Info {
        private Reader r1;
        private Reader r2;
        private Difference[] diffs;
        private CloneableOpenSupport openSupport;
        private boolean contextMode;
        private int contextNumLines;

        public TextDiffInfo(String string, String string2, String string3, String string4, Reader reader, Reader reader2, Difference[] differenceArray) {
            super(string, string2, string3, string4, null, false, false);
            this.r1 = reader;
            this.r2 = reader2;
            this.diffs = differenceArray;
        }

        public String getName() {
            String string = this.getName1();
            String string2 = this.getName2();
            if (string2 != null && string2.length() > 0) {
                string = string + " <> " + string2;
            }
            return string;
        }

        public String getTitle() {
            return this.getTitle1() + " <> " + this.getTitle2();
        }

        public Reader createFirstReader() {
            return this.r1;
        }

        public Reader createSecondReader() {
            return this.r2;
        }

        public Difference[] getDifferences() {
            return this.diffs;
        }

        public CloneableOpenSupport getOpenSupport() {
            if (this.openSupport == null) {
                this.openSupport = new TextDiffEditorSupport(this);
            }
            return this.openSupport;
        }

        public void setContextMode(boolean bl, int n) {
            this.contextMode = bl;
            this.contextNumLines = n;
        }

        public boolean isContextMode() {
            return this.contextMode;
        }

        public int getContextNumLines() {
            return this.contextNumLines;
        }
    }
}

