/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.editor.functions;

import com.jaspersoft.ireport.designer.editor.ExpObjectCellRenderer;
import com.jaspersoft.ireport.designer.editor.functions.Function;
import com.jaspersoft.ireport.designer.editor.functions.Parameter;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class FunctionAndExpObjectCellRenderer
extends ExpObjectCellRenderer {
    private Color selectionBackground;
    private Color background;
    Style methodStyle = null;
    Style returnTypeStyle = null;

    public FunctionAndExpObjectCellRenderer(JList list) {
        this.selectionBackground = list.getSelectionBackground();
        this.background = list.getBackground();
        DefaultStyledDocument doc = new DefaultStyledDocument();
        this.setDocument(doc);
        this.methodStyle = doc.addStyle("methodStyle", null);
        StyleConstants.setBold(this.methodStyle, true);
        this.returnTypeStyle = doc.addStyle("returnType", null);
        StyleConstants.setForeground(this.returnTypeStyle, Color.gray);
    }

    public Component getListCellRendererComponent(JList list, Object object, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, object, index, isSelected, cellHasFocus);
        this.updateText(object, isSelected);
        return this;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.updateText(value, isSelected);
        return this;
    }

    private void updateText(Object object, boolean isSelected) {
        if (object instanceof Function) {
            Function f = (Function)object;
            String s = f.getName() + "(";
            List<Parameter> params = f.getParameters();
            boolean first = true;
            for (Parameter p : params) {
                if (!first) {
                    s = s + ", ";
                }
                first = false;
                s = s + p.getLabel();
            }
            s = s + ") " + f.getReturnType();
            this.setText("");
            StyledDocument doc = (StyledDocument)this.getDocument();
            try {
                doc.insertString(doc.getLength(), s.substring(0, s.indexOf("(")), this.methodStyle);
                doc.insertString(doc.getLength(), s.substring(s.indexOf("("), s.lastIndexOf(")") + 1), null);
                doc.insertString(doc.getLength(), s.substring(s.lastIndexOf(")") + 1), this.returnTypeStyle);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.setBackground(isSelected ? this.selectionBackground : this.background);
        }
    }
}

