/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;

public abstract class JRBaseElementDataset
implements JRElementDataset,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected ResetTypeEnum resetTypeValue = ResetTypeEnum.REPORT;
    protected IncrementTypeEnum incrementTypeValue = IncrementTypeEnum.NONE;
    protected JRGroup resetGroup;
    protected JRGroup incrementGroup;
    protected JRDatasetRun datasetRun;
    protected JRExpression incrementWhenExpression;
    private int PSEUDO_SERIAL_VERSION_UID = 30702;
    private byte resetType;
    private byte incrementType;

    protected JRBaseElementDataset() {
    }

    protected JRBaseElementDataset(JRElementDataset dataset) {
        if (dataset != null) {
            this.resetTypeValue = dataset.getResetTypeValue();
            this.incrementTypeValue = dataset.getIncrementTypeValue();
            this.resetGroup = dataset.getResetGroup();
            this.incrementGroup = dataset.getIncrementGroup();
            this.datasetRun = dataset.getDatasetRun();
            this.incrementWhenExpression = dataset.getIncrementWhenExpression();
        }
    }

    protected JRBaseElementDataset(JRElementDataset dataset, JRBaseObjectFactory factory) {
        factory.put(dataset, this);
        this.resetTypeValue = dataset.getResetTypeValue();
        this.incrementTypeValue = dataset.getIncrementTypeValue();
        this.resetGroup = factory.getGroup(dataset.getResetGroup());
        this.incrementGroup = factory.getGroup(dataset.getIncrementGroup());
        this.datasetRun = factory.getDatasetRun(dataset.getDatasetRun());
        this.incrementWhenExpression = factory.getExpression(dataset.getIncrementWhenExpression());
    }

    public byte getResetType() {
        return this.getResetTypeValue().getValue();
    }

    public byte getIncrementType() {
        return this.getIncrementTypeValue().getValue();
    }

    public ResetTypeEnum getResetTypeValue() {
        return this.resetTypeValue;
    }

    public IncrementTypeEnum getIncrementTypeValue() {
        return this.incrementTypeValue;
    }

    public JRGroup getResetGroup() {
        return this.resetGroup;
    }

    public JRGroup getIncrementGroup() {
        return this.incrementGroup;
    }

    public JRDatasetRun getDatasetRun() {
        return this.datasetRun;
    }

    public JRExpression getIncrementWhenExpression() {
        return this.incrementWhenExpression;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.resetTypeValue = ResetTypeEnum.getByValue(this.resetType);
            this.incrementTypeValue = IncrementTypeEnum.getByValue(this.incrementType);
        }
    }

    public Object clone() {
        JRBaseElementDataset clone = null;
        try {
            clone = (JRBaseElementDataset)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        if (this.incrementWhenExpression != null) {
            clone.incrementWhenExpression = (JRExpression)this.incrementWhenExpression.clone();
        }
        if (this.datasetRun != null) {
            clone.datasetRun = (JRDatasetRun)this.datasetRun.clone();
        }
        return clone;
    }
}

