/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.sql;

import java.util.ArrayList;
import mondrian.olap.MondrianProperties;
import mondrian.rolap.BatchTestCase;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.Dialect;
import mondrian.test.SqlPattern;
import mondrian.test.TestContext;

public class SqlQueryTest
extends BatchTestCase {
    private String origWarnIfNoPatternForDialect;
    private MondrianProperties prop = MondrianProperties.instance();

    protected void setUp() throws Exception {
        super.setUp();
        this.origWarnIfNoPatternForDialect = this.prop.WarnIfNoPatternForDialect.get();
        Dialect dialect = this.getTestContext().getDialect();
        if (this.prop.WarnIfNoPatternForDialect.get().equals("ANY") || dialect.getDatabaseProduct() == Dialect.DatabaseProduct.ACCESS || dialect.getDatabaseProduct() == Dialect.DatabaseProduct.MYSQL) {
            this.prop.WarnIfNoPatternForDialect.set(dialect.getDatabaseProduct().toString());
        } else {
            this.prop.WarnIfNoPatternForDialect.set("NONE");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.prop.WarnIfNoPatternForDialect.set(this.origWarnIfNoPatternForDialect);
    }

    public void testToStringForSingleGroupingSetSql() {
        if (!this.isGroupingSetsSupported()) {
            return;
        }
        for (boolean b : new boolean[]{false, true}) {
            Dialect dialect = this.getTestContext().getDialect();
            SqlQuery sqlQuery = new SqlQuery(dialect, b);
            sqlQuery.addSelect("c1");
            sqlQuery.addSelect("c2");
            sqlQuery.addGroupingFunction("gf0");
            sqlQuery.addFromTable("s", "t1", "t1alias", null, true);
            sqlQuery.addWhere("a=b");
            ArrayList<String> groupingsetsList = new ArrayList<String>();
            groupingsetsList.add("gs1");
            groupingsetsList.add("gs2");
            groupingsetsList.add("gs3");
            sqlQuery.addGroupingSet(groupingsetsList);
            String lineSep = System.getProperty("line.separator");
            String expected = !b ? "select c1 as \"c0\", c2 as \"c1\", grouping(gf0) as \"g0\" from \"s\".\"t1\" =as= \"t1alias\" where a=b group by grouping sets ((gs1,gs2,gs3))" : "select " + lineSep + "    c1 as \"c0\", " + lineSep + "    c2 as \"c1\"" + lineSep + "    , grouping(gf0) as \"g0\"" + lineSep + "from " + lineSep + "    \"s\".\"t1\" =as= \"t1alias\"" + lineSep + "where " + lineSep + "    a=b" + lineSep + " group by grouping sets ((" + lineSep + "    gs1," + lineSep + "    gs2," + lineSep + "    gs3" + lineSep + "))";
            SqlQueryTest.assertEquals((String)this.dialectize(dialect.getDatabaseProduct(), expected), (String)sqlQuery.toString());
        }
    }

    public void testPredicatesAreOptimizedWhenPropertyIsTrue() {
        if (this.prop.ReadAggregates.get() && this.prop.UseAggregates.get()) {
            return;
        }
        String mdx = "select {[Time].[1997].[Q1],[Time].[1997].[Q2],[Time].[1997].[Q3]} on 0 from sales";
        String accessSql = "select `time_by_day`.`the_year` as `c0`, `time_by_day`.`quarter` as `c1`, sum(`sales_fact_1997`.`unit_sales`) as `m0` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 group by `time_by_day`.`the_year`, `time_by_day`.`quarter`";
        String mysqlSql = "select `time_by_day`.`the_year` as `c0`, `time_by_day`.`quarter` as `c1`, sum(`sales_fact_1997`.`unit_sales`) as `m0` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 group by `time_by_day`.`the_year`, `time_by_day`.`quarter`";
        SqlPattern[] sqlPatterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ACCESS, accessSql, accessSql), new SqlPattern(Dialect.DatabaseProduct.MYSQL, mysqlSql, mysqlSql)};
        this.assertSqlEqualsOptimzePredicates(true, mdx, sqlPatterns);
    }

    public void testPredicatesAreNotOptimizedWhenPropertyIsFalse() {
        if (this.prop.ReadAggregates.get() && this.prop.UseAggregates.get()) {
            return;
        }
        String mdx = "select {[Time].[1997].[Q1],[Time].[1997].[Q2],[Time].[1997].[Q3]} on 0 from sales";
        String accessSql = "select `time_by_day`.`the_year` as `c0`, `time_by_day`.`quarter` as `c1`, sum(`sales_fact_1997`.`unit_sales`) as `m0` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `time_by_day`.`quarter` in ('Q1', 'Q2', 'Q3') group by `time_by_day`.`the_year`, `time_by_day`.`quarter`";
        String mysqlSql = "select `time_by_day`.`the_year` as `c0`, `time_by_day`.`quarter` as `c1`, sum(`sales_fact_1997`.`unit_sales`) as `m0` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `time_by_day`.`quarter` in ('Q1', 'Q2', 'Q3') group by `time_by_day`.`the_year`, `time_by_day`.`quarter`";
        SqlPattern[] sqlPatterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ACCESS, accessSql, accessSql), new SqlPattern(Dialect.DatabaseProduct.MYSQL, mysqlSql, mysqlSql)};
        this.assertSqlEqualsOptimzePredicates(false, mdx, sqlPatterns);
    }

    public void testPredicatesAreOptimizedWhenAllTheMembersAreIncluded() {
        if (this.prop.ReadAggregates.get() && this.prop.UseAggregates.get()) {
            return;
        }
        String mdx = "select {[Time].[1997].[Q1],[Time].[1997].[Q2],[Time].[1997].[Q3],[Time].[1997].[Q4]} on 0 from sales";
        String accessSql = "select `time_by_day`.`the_year` as `c0`, `time_by_day`.`quarter` as `c1`, sum(`sales_fact_1997`.`unit_sales`) as `m0` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 group by `time_by_day`.`the_year`, `time_by_day`.`quarter`";
        String mysqlSql = "select `time_by_day`.`the_year` as `c0`, `time_by_day`.`quarter` as `c1`, sum(`sales_fact_1997`.`unit_sales`) as `m0` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 group by `time_by_day`.`the_year`, `time_by_day`.`quarter`";
        SqlPattern[] sqlPatterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ACCESS, accessSql, accessSql), new SqlPattern(Dialect.DatabaseProduct.MYSQL, mysqlSql, mysqlSql)};
        this.assertSqlEqualsOptimzePredicates(true, mdx, sqlPatterns);
        this.assertSqlEqualsOptimzePredicates(false, mdx, sqlPatterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertSqlEqualsOptimzePredicates(boolean optimizePredicatesValue, String inputMdx, SqlPattern[] sqlPatterns) {
        boolean intialValueOptimize = this.prop.OptimizePredicates.get();
        try {
            this.prop.OptimizePredicates.set(optimizePredicatesValue);
            this.assertQuerySql(inputMdx, sqlPatterns);
        }
        finally {
            this.prop.OptimizePredicates.set(intialValueOptimize);
        }
    }

    public void testToStringForGroupingSetSqlWithEmptyGroup() {
        if (!this.isGroupingSetsSupported()) {
            return;
        }
        Dialect dialect = this.getTestContext().getDialect();
        for (boolean b : new boolean[]{false, true}) {
            SqlQuery sqlQuery = new SqlQuery(this.getTestContext().getDialect(), b);
            sqlQuery.addSelect("c1");
            sqlQuery.addSelect("c2");
            sqlQuery.addFromTable("s", "t1", "t1alias", null, true);
            sqlQuery.addWhere("a=b");
            sqlQuery.addGroupingFunction("g1");
            sqlQuery.addGroupingFunction("g2");
            ArrayList<String> groupingsetsList = new ArrayList<String>();
            groupingsetsList.add("gs1");
            groupingsetsList.add("gs2");
            groupingsetsList.add("gs3");
            sqlQuery.addGroupingSet(new ArrayList<String>());
            sqlQuery.addGroupingSet(groupingsetsList);
            String expected = b ? "select \n    c1 as \"c0\", \n    c2 as \"c1\"\n    , grouping(g1) as \"g0\"\n    , grouping(g2) as \"g1\"\nfrom \n    \"s\".\"t1\" =as= \"t1alias\"\nwhere \n    a=b\n group by grouping sets ((),(\n    gs1,\n    gs2,\n    gs3\n))" : "select c1 as \"c0\", c2 as \"c1\", grouping(g1) as \"g0\", grouping(g2) as \"g1\" from \"s\".\"t1\" =as= \"t1alias\" where a=b group by grouping sets ((),(gs1,gs2,gs3))";
            SqlQueryTest.assertEquals((String)this.dialectize(dialect.getDatabaseProduct(), expected), (String)sqlQuery.toString());
        }
    }

    public void testToStringForMultipleGroupingSetsSql() {
        if (!this.isGroupingSetsSupported()) {
            return;
        }
        Dialect dialect = this.getTestContext().getDialect();
        for (boolean b : new boolean[]{false, true}) {
            SqlQuery sqlQuery = new SqlQuery(dialect, b);
            sqlQuery.addSelect("c0");
            sqlQuery.addSelect("c1");
            sqlQuery.addSelect("c2");
            sqlQuery.addSelect("m1", "m1");
            sqlQuery.addFromTable("s", "t1", "t1alias", null, true);
            sqlQuery.addWhere("a=b");
            sqlQuery.addGroupingFunction("c0");
            sqlQuery.addGroupingFunction("c1");
            sqlQuery.addGroupingFunction("c2");
            ArrayList<String> groupingSetlist1 = new ArrayList<String>();
            groupingSetlist1.add("c0");
            groupingSetlist1.add("c1");
            groupingSetlist1.add("c2");
            sqlQuery.addGroupingSet(groupingSetlist1);
            ArrayList<String> groupingsetsList2 = new ArrayList<String>();
            groupingsetsList2.add("c1");
            groupingsetsList2.add("c2");
            sqlQuery.addGroupingSet(groupingsetsList2);
            String expected = b ? "select \n    c0 as \"c0\", \n    c1 as \"c1\", \n    c2 as \"c2\", \n    m1 as \"m1\"\n    , grouping(c0) as \"g0\"\n    , grouping(c1) as \"g1\"\n    , grouping(c2) as \"g2\"\nfrom \n    \"s\".\"t1\" =as= \"t1alias\"\nwhere \n    a=b\n group by grouping sets ((\n    c0,\n    c1,\n    c2\n),(\n    c1,\n    c2\n))" : "select c0 as \"c0\", c1 as \"c1\", c2 as \"c2\", m1 as \"m1\", grouping(c0) as \"g0\", grouping(c1) as \"g1\", grouping(c2) as \"g2\" from \"s\".\"t1\" =as= \"t1alias\" where a=b group by grouping sets ((c0,c1,c2),(c1,c2))";
            SqlQueryTest.assertEquals((String)this.dialectize(dialect.getDatabaseProduct(), expected), (String)sqlQuery.toString());
        }
    }

    public void testDoubleInList() {
        Dialect dialect = this.getTestContext().getDialect();
        if (dialect.getDatabaseProduct() != Dialect.DatabaseProduct.LUCIDDB) {
            return;
        }
        this.propSaver.set(this.prop.IgnoreInvalidMembers, true);
        this.propSaver.set(this.prop.IgnoreInvalidMembersDuringQuery, true);
        String dimensionSqlExpression = "cast(cast(\"salary\" as double)*cast(1000.0 as double)/cast(3.1234567890123456 as double) as double)\n";
        String cubeFirstPart = "<Cube name=\"Sales 3\">\n  <Table name=\"sales_fact_1997\"/>\n  <Dimension name=\"StoreEmpSalary\" foreignKey=\"store_id\">\n    <Hierarchy hasAll=\"true\" allMemberName=\"All Salary\" primaryKey=\"store_id\">\n      <Table name=\"employee\"/>\n      <Level name=\"Salary\" column=\"salary\" type=\"Numeric\" uniqueMembers=\"true\" approxRowCount=\"10000000\">\n        <KeyExpression>\n          <SQL dialect=\"luciddb\">\n";
        String cubeSecondPart = "          </SQL>\n        </KeyExpression>\n      </Level>\n    </Hierarchy>\n  </Dimension>  <Measure name=\"Store Cost\" column=\"store_cost\" aggregator=\"sum\"/>\n</Cube>";
        String cube = cubeFirstPart + dimensionSqlExpression + cubeSecondPart;
        String query = "select {[StoreEmpSalary].[All Salary].[6403.162057613773],[StoreEmpSalary].[All Salary].[1184584.980658548],[StoreEmpSalary].[All Salary].[1344664.0320988924],  [StoreEmpSalary].[All Salary].[1376679.8423869612],[StoreEmpSalary].[All Salary].[1408695.65267503],[StoreEmpSalary].[All Salary].[1440711.462963099],  [StoreEmpSalary].[All Salary].[1456719.3681071333],[StoreEmpSalary].[All Salary].[1472727.2732511677],[StoreEmpSalary].[All Salary].[1488735.1783952022],  [StoreEmpSalary].[All Salary].[1504743.0835392366],[StoreEmpSalary].[All Salary].[1536758.8938273056],[StoreEmpSalary].[All Salary].[1600790.5144034433],  [StoreEmpSalary].[All Salary].[1664822.134979581],[StoreEmpSalary].[All Salary].[1888932.806996063],[StoreEmpSalary].[All Salary].[1952964.4275722008],  [StoreEmpSalary].[All Salary].[1984980.2378602696],[StoreEmpSalary].[All Salary].[2049011.8584364073],[StoreEmpSalary].[All Salary].[2081027.6687244761],  [StoreEmpSalary].[All Salary].[2113043.479012545],[StoreEmpSalary].[All Salary].[2145059.289300614],[StoreEmpSalary].[All Salary].[2.5612648230455093E7]}  on rows, {[Measures].[Store Cost]} on columns from [Sales 3]";
        String loadSqlLucidDB = "select cast(cast(\"salary\" as double)*cast(1000.0 as double)/cast(3.1234567890123456 as double) as double) as \"c0\", sum(\"sales_fact_1997\".\"store_cost\") as \"m0\" from \"employee\" as \"employee\", \"sales_fact_1997\" as \"sales_fact_1997\" where \"sales_fact_1997\".\"store_id\" = \"employee\".\"store_id\" and cast(cast(\"salary\" as double)*cast(1000.0 as double)/cast(3.1234567890123456 as double) as double) in (6403.162057613773E0, 1184584.980658548E0, 1344664.0320988924E0, 1376679.8423869612E0, 1408695.65267503E0, 1440711.462963099E0, 1456719.3681071333E0, 1488735.1783952022E0, 1504743.0835392366E0, 1536758.8938273056E0, 1664822.134979581E0, 1888932.806996063E0, 1952964.4275722008E0, 1984980.2378602696E0, 2049011.8584364073E0, 2113043.479012545E0, 2145059.289300614E0, 2.5612648230455093E7) group by cast(cast(\"salary\" as double)*cast(1000.0 as double)/cast(3.1234567890123456 as double) as double)";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.LUCIDDB, loadSqlLucidDB, loadSqlLucidDB)};
        TestContext testContext = TestContext.create(null, cube, null, null, null, null);
        this.assertQuerySql(testContext, query, patterns);
    }

    public void testInvalidSQLMemberLookup() {
        String sqlMySql = "select `store`.`store_type` as `c0` from `store` as `store` where UPPER(`store`.`store_type`) = UPPER('Time.Weekly') group by `store`.`store_type` order by ISNULL(`store`.`store_type`), `store`.`store_type` ASC";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.MYSQL, sqlMySql, sqlMySql)};
        this.assertNoQuerySql("select {[Time.Weekly].[All Time.Weeklys]} ON COLUMNS from [Sales]", patterns);
    }
}

