/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.util.Arrays;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.querybuilder.syntax.SQLFormatter;

public class UpdateModel {
    private QueryTokens.Table table = null;
    private QueryTokens.Column[] rowid = null;

    public boolean isUpdatable(QueryTokens._Expression e) {
        if (!(e instanceof QueryTokens.Column)) {
            return false;
        }
        QueryTokens.Column c = (QueryTokens.Column)e;
        String owner = c.getTable() != null ? c.getTable().getReference() : null;
        return owner == null || this.table.getReference().equalsIgnoreCase(owner);
    }

    public QueryTokens.Table getTable() {
        return this.table;
    }

    public void setTable(QueryTokens.Table table) {
        this.table = table;
    }

    public QueryTokens.Column getRowIdentifier(int idx) {
        return this.rowid[idx];
    }

    public int getRowIdentifierCount() {
        return this.rowid.length;
    }

    public void setRowIdentifier(QueryTokens.Column[] where) {
        this.rowid = where;
    }

    public String getDeleteSyntax() {
        Object[] whereValues = new Object[this.rowid.length];
        Arrays.fill(whereValues, "?");
        return this.getDeleteSyntax(whereValues);
    }

    public String getDeleteSyntax(Object[] whereValues) {
        return "DELETE FROM " + this.table.getIdentifier() + ' ' + this.getWhereSyntax(whereValues);
    }

    public String getInsertSyntax(String[] columns) {
        Object[] fieldValues = new Object[columns.length];
        Arrays.fill(fieldValues, "?");
        return this.getInsertSyntax(columns, fieldValues);
    }

    public String getInsertSyntax(String[] columns, Object[] fieldValues) {
        return "INSERT INTO " + this.table.getIdentifier() + " (" + SQLFormatter.concatCommaDelimited(columns, false) + ") VALUES (" + SQLFormatter.concatCommaDelimited(fieldValues, false) + ")";
    }

    public String getUpdateSyntax(String[] columns) {
        Object[] whereValues = new Object[this.rowid.length];
        Arrays.fill(whereValues, "?");
        return this.getUpdateSyntax(columns, whereValues);
    }

    public String getUpdateSyntax(String[] columns, Object[] whereValues) {
        Object[] fieldValues = new Object[columns.length];
        Arrays.fill(fieldValues, "?");
        return this.getUpdateSyntax(columns, fieldValues, whereValues);
    }

    public String getUpdateSyntax(String[] columns, Object[] fieldValues, Object[] whereValues) {
        String changes = new String();
        for (int i = 0; i < fieldValues.length; ++i) {
            changes = changes + columns[i] + " = " + fieldValues[i] + ",";
        }
        return "UPDATE " + this.table.getIdentifier() + " SET " + changes.substring(0, changes.length() - 1) + ' ' + this.getWhereSyntax(whereValues);
    }

    private String getWhereSyntax(Object[] params) {
        if (this.rowid == null || params == null) {
            return new String();
        }
        QueryTokens.Condition[] c = new QueryTokens.Condition[this.rowid.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = new QueryTokens.Condition("AND", this.rowid[i], "=", new QueryTokens.DefaultExpression(params[i].toString()));
        }
        c[0].setAppend(null);
        return "WHERE " + SQLFormatter.concat(c, false);
    }
}

