/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.tools;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ConfigurationUtil {
    protected ConfigurationUtil() {
        throw new UnsupportedOperationException();
    }

    public static Configuration buildConfiguration(Node node) {
        return ConfigurationUtil.processNode(node);
    }

    private static Element findDocumentElement(Document document) {
        try {
            return document.getDocumentElement();
        }
        catch (Exception e) {
            Node nd = null;
            for (int i = 0; i < document.getChildNodes().getLength(); ++i) {
                nd = document.getChildNodes().item(i);
                if (nd.getNodeType() != 1) continue;
                return (Element)nd;
            }
            return null;
        }
    }

    private static DefaultConfiguration processNode(Node node) {
        if (node.getNodeType() == 1) {
            return ConfigurationUtil.processElement((Element)node);
        }
        if (node.getNodeType() == 9) {
            return ConfigurationUtil.processElement(ConfigurationUtil.findDocumentElement((Document)node));
        }
        if (node.getNodeType() == 11) {
            DocumentFragment df = (DocumentFragment)node;
            return ConfigurationUtil.processNode(df.getFirstChild());
        }
        return null;
    }

    private static DefaultConfiguration processElement(Element el) {
        int i;
        String name = el.getLocalName();
        if (name == null) {
            name = el.getTagName();
        }
        DefaultConfiguration cfg = new DefaultConfiguration(name);
        NamedNodeMap atts = el.getAttributes();
        for (i = 0; i < atts.getLength(); ++i) {
            Attr attr = (Attr)atts.item(i);
            cfg.setAttribute(attr.getName(), attr.getValue());
        }
        for (i = 0; i < el.getChildNodes().getLength(); ++i) {
            Node node = el.getChildNodes().item(i);
            if (node.getNodeType() == 2) {
                Attr attr = (Attr)node;
                cfg.setAttribute(attr.getName(), attr.getNodeValue());
                continue;
            }
            if (node.getNodeType() == 1) {
                cfg.addChild((Configuration)ConfigurationUtil.processElement((Element)node));
                continue;
            }
            if (node.getNodeType() != 3) continue;
            String s = cfg.getValue("") + ((Text)node).getData();
            cfg.setValue(s.trim());
        }
        return cfg;
    }
}

