/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer.editable;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffContentPanel;
import org.netbeans.modules.diff.builtin.visualizer.editable.EditableDiffView;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;

class DecoratedEditorPane
extends JEditorPane
implements PropertyChangeListener {
    private Difference[] currentDiff;
    private DiffContentPanel master;
    private final RequestProcessor.Task repaintTask = RequestProcessor.getDefault().create((Runnable)new RepaintPaneTask());
    private int fontHeight;
    private int charWidth;

    public DecoratedEditorPane(DiffContentPanel diffContentPanel) {
        this.setBorder(null);
        this.master = diffContentPanel;
        diffContentPanel.getMaster().addPropertyChangeListener(this);
    }

    public boolean isFirst() {
        return this.master.isFirst();
    }

    public DiffContentPanel getMaster() {
        return this.master;
    }

    void setDifferences(Difference[] differenceArray) {
        this.currentDiff = differenceArray;
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setFontHeightWidth(this.getFont());
    }

    private void setFontHeightWidth(Font font) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.fontHeight = fontMetrics.getHeight();
        this.charWidth = fontMetrics.charWidth('m');
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return this.fontHeight;
            }
            case 0: {
                return this.charWidth;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics graphics) {
        block24: {
            super.paintComponent(graphics);
            if (this.currentDiff == null) {
                return;
            }
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            Rectangle rectangle = graphics2D.getClipBounds();
            Stroke stroke = graphics2D.getStroke();
            --rectangle.y;
            ++rectangle.height;
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)editorUI.getComponent());
            JTextComponent jTextComponent = editorUI.getComponent();
            if (jTextComponent == null) {
                return;
            }
            View view = Utilities.getDocumentView((JTextComponent)jTextComponent);
            if (view == null) {
                return;
            }
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
            abstractDocument.readLock();
            try {
                foldHierarchy.lock();
                try {
                    int n = baseTextUI.getPosFromY(rectangle.y);
                    int n2 = view.getViewIndex(n, Position.Bias.Forward);
                    int n3 = view.getViewCount();
                    if (n2 < 0 || n2 >= n3) break block24;
                    Rectangle rectangle2 = baseTextUI.modelToView(jTextComponent, view.getView(n2).getStartOffset());
                    int n4 = rectangle2 == null ? 0 : rectangle2.y;
                    int n5 = rectangle.y + rectangle.height;
                    Element element = baseTextUI.getRootView(jTextComponent).getElement();
                    View view2 = view.getView(n2);
                    int n6 = element.getElementIndex(view2.getStartOffset());
                    ++n6;
                    int n7 = this.master.getMaster().getCurrentDifference();
                    graphics2D.setColor(this.master.getMaster().getColorLines());
                    if (this.master.isFirst()) {
                        for (int i = n2; i < n3; ++i) {
                            Difference difference;
                            view2 = view.getView(i);
                            n6 = element.getElementIndex(view2.getStartOffset());
                            if ((difference = EditableDiffView.getFirstDifference(this.currentDiff, ++n6)) != null) {
                                graphics2D.setStroke(n7 >= 0 && n7 < this.currentDiff.length && this.currentDiff[n7] == difference ? this.master.getMaster().getBoldStroke() : stroke);
                                int n8 = n4 + editorUI.getLineHeight();
                                if (difference.getType() == 1) {
                                    graphics2D.drawLine(0, n8, this.getWidth(), n8);
                                    difference = null;
                                } else {
                                    if (difference.getFirstStart() == n6) {
                                        graphics2D.drawLine(0, n4, this.getWidth(), n4);
                                    }
                                    if (difference.getFirstEnd() == n6) {
                                        graphics2D.drawLine(0, n8, this.getWidth(), n8);
                                    }
                                }
                            }
                            if ((n4 += editorUI.getLineHeight()) < n5) continue;
                            break block24;
                        }
                        break block24;
                    }
                    for (int i = n2; i < n3; ++i) {
                        Difference difference;
                        view2 = view.getView(i);
                        n6 = element.getElementIndex(view2.getStartOffset());
                        if ((difference = EditableDiffView.getSecondDifference(this.currentDiff, ++n6)) != null) {
                            graphics2D.setStroke(n7 >= 0 && n7 < this.currentDiff.length && this.currentDiff[n7] == difference ? this.master.getMaster().getBoldStroke() : stroke);
                            int n9 = n4 + editorUI.getLineHeight();
                            if (difference.getType() == 0) {
                                graphics2D.drawLine(0, n9, this.getWidth(), n9);
                                difference = null;
                            } else {
                                if (difference.getSecondStart() == n6) {
                                    graphics2D.drawLine(0, n4, this.getWidth(), n4);
                                }
                                if (difference.getSecondEnd() == n6) {
                                    graphics2D.drawLine(0, n9, this.getWidth(), n9);
                                }
                            }
                        }
                        if ((n4 += editorUI.getLineHeight()) < n5) continue;
                        break;
                    }
                }
                finally {
                    foldHierarchy.unlock();
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            finally {
                abstractDocument.readUnlock();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.repaintTask.schedule(150);
    }

    private class RepaintPaneTask
    implements Runnable {
        private RepaintPaneTask() {
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DecoratedEditorPane.this.repaint();
                }
            });
        }
    }
}

