/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.locale.I18n;
import java.awt.EventQueue;
import java.io.InputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.openide.filesystems.FileObject;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JrxmlLoader
implements ErrorHandler {
    FileObject file = null;

    public JrxmlLoader(FileObject f) {
        this.file = f;
    }

    public JrxmlLoader() {
        this(null);
    }

    public JasperDesign reloadJasperDesign() throws JRException {
        if (this.file == null) {
            throw new JRException(I18n.getString("JrxmlLoader.Error.FileNF"));
        }
        try {
            InputStream in = this.file.getInputStream();
            return this.reloadJasperDesign(in);
        }
        catch (JRException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new JRException(ex);
        }
    }

    public JasperDesign reloadJasperDesign(InputStream in) throws JRException {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalStateException(I18n.getString("JrxmlLoader.Error.Warning"));
        }
        try {
            JasperDesign jd;
            JasperDesign jasperDesign = jd = JRXmlLoader.load((InputStream)in);
            return jasperDesign;
        }
        catch (JRException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new JRException(ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ex2) {}
            }
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }
}

