/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.util.JRImageLoader;

public class JRResultSetDataSource
implements JRDataSource {
    private static final String INDEXED_COLUMN_PREFIX = "COLUMN_";
    private static final int INDEXED_COLUMN_PREFIX_LENGTH = "COLUMN_".length();
    private ResultSet resultSet;
    private Map<String, Integer> columnIndexMap = new HashMap<String, Integer>();

    public JRResultSetDataSource(ResultSet rs) {
        this.resultSet = rs;
    }

    public boolean next() throws JRException {
        boolean hasNext = false;
        if (this.resultSet != null) {
            try {
                hasNext = this.resultSet.next();
            }
            catch (SQLException e) {
                throw new JRException("Unable to get next record.", e);
            }
        }
        return hasNext;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object objValue;
        block42: {
            objValue = null;
            if (field != null && this.resultSet != null) {
                Integer columnIndex = this.getColumnIndex(field.getName());
                Class<?> clazz = field.getValueClass();
                try {
                    if (clazz.equals(Boolean.class)) {
                        objValue = this.resultSet.getBoolean(columnIndex) ? Boolean.TRUE : Boolean.FALSE;
                        break block42;
                    }
                    if (clazz.equals(Byte.class)) {
                        objValue = new Byte(this.resultSet.getByte(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(java.util.Date.class) || clazz.equals(Date.class)) {
                        objValue = this.resultSet.getDate(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(Timestamp.class)) {
                        objValue = this.resultSet.getTimestamp(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(Time.class)) {
                        objValue = this.resultSet.getTime(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(Double.class)) {
                        objValue = new Double(this.resultSet.getDouble(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(Float.class)) {
                        objValue = new Float(this.resultSet.getFloat(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(Integer.class)) {
                        objValue = this.resultSet.getInt(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(InputStream.class)) {
                        byte[] bytes = this.readBytes(columnIndex);
                        objValue = bytes == null ? null : new ByteArrayInputStream(bytes);
                        break block42;
                    }
                    if (clazz.equals(Long.class)) {
                        objValue = new Long(this.resultSet.getLong(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(Short.class)) {
                        objValue = new Short(this.resultSet.getShort(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(BigDecimal.class)) {
                        objValue = this.resultSet.getBigDecimal(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(String.class)) {
                        int columnType = this.resultSet.getMetaData().getColumnType(columnIndex);
                        switch (columnType) {
                            case 2005: {
                                Clob clob = this.resultSet.getClob(columnIndex);
                                if (this.resultSet.wasNull()) {
                                    objValue = null;
                                    break;
                                }
                                objValue = this.clobToString(clob);
                                break;
                            }
                            default: {
                                objValue = this.resultSet.getString(columnIndex);
                                if (this.resultSet.wasNull()) {
                                    objValue = null;
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block42;
                    }
                    if (clazz.equals(Clob.class)) {
                        objValue = this.resultSet.getClob(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                    } else if (clazz.equals(Reader.class)) {
                        Reader reader = null;
                        long size = -1L;
                        int columnType = this.resultSet.getMetaData().getColumnType(columnIndex);
                        switch (columnType) {
                            case 2005: {
                                Clob clob = this.resultSet.getClob(columnIndex);
                                if (this.resultSet.wasNull()) break;
                                reader = clob.getCharacterStream();
                                size = clob.length();
                                break;
                            }
                            default: {
                                reader = this.resultSet.getCharacterStream(columnIndex);
                                if (!this.resultSet.wasNull()) break;
                                reader = null;
                            }
                        }
                        objValue = reader == null ? null : this.getArrayReader(reader, size);
                    } else if (clazz.equals(Blob.class)) {
                        objValue = this.resultSet.getBlob(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                    } else {
                        byte[] bytes;
                        objValue = clazz.equals(Image.class) ? ((bytes = this.readBytes(columnIndex)) == null ? null : JRImageLoader.loadImage(bytes)) : this.resultSet.getObject(columnIndex);
                    }
                }
                catch (Exception e) {
                    throw new JRException("Unable to get value for field '" + field.getName() + "' of class '" + clazz.getName() + "'", e);
                }
            }
        }
        return objValue;
    }

    private Integer getColumnIndex(String fieldName) throws JRException {
        Integer columnIndex = this.columnIndexMap.get(fieldName);
        if (columnIndex == null) {
            try {
                columnIndex = this.searchColumnByName(fieldName);
                if (columnIndex == null) {
                    columnIndex = this.searchColumnByLabel(fieldName);
                }
                if (columnIndex == null && fieldName.startsWith(INDEXED_COLUMN_PREFIX) && ((columnIndex = Integer.valueOf(fieldName.substring(INDEXED_COLUMN_PREFIX_LENGTH))) <= 0 || columnIndex > this.resultSet.getMetaData().getColumnCount())) {
                    throw new JRException("Column index out of range : " + columnIndex);
                }
                if (columnIndex == null) {
                    throw new JRException("Unknown column name : " + fieldName);
                }
            }
            catch (SQLException e) {
                throw new JRException("Unable to retrieve result set metadata.", e);
            }
            this.columnIndexMap.put(fieldName, columnIndex);
        }
        return columnIndex;
    }

    protected Integer searchColumnByName(String fieldName) throws SQLException {
        Integer columnIndex = null;
        ResultSetMetaData metadata = this.resultSet.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String columnName = metadata.getColumnName(i);
            if (!fieldName.equalsIgnoreCase(columnName)) continue;
            columnIndex = i;
            break;
        }
        return columnIndex;
    }

    protected Integer searchColumnByLabel(String fieldName) throws SQLException {
        Integer columnIndex = null;
        ResultSetMetaData metadata = this.resultSet.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String columnLabel = metadata.getColumnLabel(i);
            if (columnLabel == null || !fieldName.equalsIgnoreCase(columnLabel)) continue;
            columnIndex = i;
            break;
        }
        return columnIndex;
    }

    protected String clobToString(Clob clob) throws JRException {
        try {
            int bufSize = 8192;
            char[] buf = new char[bufSize];
            BufferedReader reader = new BufferedReader(clob.getCharacterStream(), bufSize);
            StringBuffer str = new StringBuffer((int)clob.length());
            int read = reader.read(buf);
            while (read > 0) {
                str.append(buf, 0, read);
                read = reader.read(buf);
            }
            return str.toString();
        }
        catch (SQLException e) {
            throw new JRException("Unable to read clob value", e);
        }
        catch (IOException e) {
            throw new JRException("Unable to read clob value", e);
        }
    }

    protected CharArrayReader getArrayReader(Reader reader, long size) throws IOException {
        char[] buf = new char[8192];
        CharArrayWriter bufWriter = new CharArrayWriter(size > 0L ? (int)size : 8192);
        BufferedReader bufReader = new BufferedReader(reader, 8192);
        int read = bufReader.read(buf);
        while (read > 0) {
            bufWriter.write(buf, 0, read);
            read = bufReader.read(buf);
        }
        bufWriter.flush();
        return new CharArrayReader(bufWriter.toCharArray());
    }

    protected byte[] readBytes(Integer columnIndex) throws SQLException, IOException {
        InputStream is = null;
        long size = -1L;
        int columnType = this.resultSet.getMetaData().getColumnType(columnIndex);
        switch (columnType) {
            case 2004: {
                Blob blob = this.resultSet.getBlob(columnIndex);
                if (this.resultSet.wasNull()) break;
                is = blob.getBinaryStream();
                size = blob.length();
                break;
            }
            default: {
                is = this.resultSet.getBinaryStream(columnIndex);
                if (!this.resultSet.wasNull()) break;
                is = null;
            }
        }
        byte[] bytes = null;
        if (is != null) {
            bytes = this.readBytes(is, size);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readBytes(InputStream is, long size) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size > 0L ? (int)size : 1000);
        byte[] bytes = new byte[1000];
        int ln = 0;
        try {
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {}
        }
        return baos.toByteArray();
    }
}

