/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRClauseTokens;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;

public class JRSqlBetweenClause
implements JRClauseFunction {
    protected static final int POSITION_CLAUSE_ID = 0;
    protected static final int POSITION_DB_COLUMN = 1;
    protected static final int POSITION_LEFT_PARAMETER = 2;
    protected static final int POSITION_RIGHT_PARAMETER = 3;
    protected static final String CLAUSE_TRUISM = "0 = 0";
    protected static final JRSqlBetweenClause singleton = new JRSqlBetweenClause();

    public static JRSqlBetweenClause instance() {
        return singleton;
    }

    public void apply(JRClauseTokens clauseTokens, JRQueryClauseContext queryContext) {
        String clauseId = clauseTokens.getToken(0);
        String col = clauseTokens.getToken(1);
        String leftParam = clauseTokens.getToken(2);
        String rightParam = clauseTokens.getToken(3);
        if (clauseId == null) {
            throw new JRRuntimeException("Missing clause name token");
        }
        if (col == null) {
            throw new JRRuntimeException("SQL LESS/GREATER clause missing DB column token");
        }
        if (leftParam == null) {
            throw new JRRuntimeException("SQL LESS/GREATER clause missing left parameter token");
        }
        if (rightParam == null) {
            throw new JRRuntimeException("SQL LESS/GREATER clause missing right parameter token");
        }
        Object leftParamValue = queryContext.getValueParameter(leftParam).getValue();
        Object rightParamValue = queryContext.getValueParameter(rightParam).getValue();
        StringBuffer sbuffer = queryContext.queryBuffer();
        if (leftParamValue != null && rightParamValue != null) {
            sbuffer.append("( ");
            this.handleGreaterClause(sbuffer, clauseId, col, leftParam, queryContext);
            sbuffer.append(" AND ");
            this.handleLessClause(sbuffer, clauseId, col, rightParam, queryContext);
            sbuffer.append(" )");
        } else if (leftParamValue == null) {
            if (rightParamValue == null) {
                sbuffer.append(CLAUSE_TRUISM);
            } else {
                this.handleLessClause(sbuffer, clauseId, col, rightParam, queryContext);
            }
        } else {
            this.handleGreaterClause(sbuffer, clauseId, col, leftParam, queryContext);
        }
    }

    protected String getGreaterOperator(String clauseId) {
        return clauseId.startsWith("[") ? ">=" : ">";
    }

    protected String getLessOperator(String clauseId) {
        return clauseId.endsWith("]") ? "<=" : "<";
    }

    protected void handleGreaterClause(StringBuffer sbuffer, String clauseId, String col, String leftParam, JRQueryClauseContext queryContext) {
        sbuffer.append(col);
        sbuffer.append(' ');
        sbuffer.append(this.getGreaterOperator(clauseId));
        sbuffer.append(' ');
        sbuffer.append('?');
        queryContext.addQueryParameter(leftParam);
    }

    protected void handleLessClause(StringBuffer sbuffer, String clauseId, String col, String rightParam, JRQueryClauseContext queryContext) {
        sbuffer.append(col);
        sbuffer.append(' ');
        sbuffer.append(this.getLessOperator(clauseId));
        sbuffer.append(' ');
        sbuffer.append('?');
        queryContext.addQueryParameter(rightParam);
    }
}

