/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.ColumnFactory;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.ColumnVisitor;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.engine.util.JRCloneUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardColumnGroup
extends StandardBaseColumn
implements ColumnGroup {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_COLUMNS = "columns";
    private List<BaseColumn> children;

    public StandardColumnGroup() {
        this.children = new ArrayList<BaseColumn>();
    }

    public StandardColumnGroup(ColumnGroup columnGroup, ColumnFactory factory) {
        super(columnGroup, factory);
        this.children = factory.createColumns(columnGroup.getColumns());
    }

    @Override
    public List<BaseColumn> getColumns() {
        return this.children;
    }

    public void setColumns(List<BaseColumn> columns) {
        List<BaseColumn> old = this.children;
        this.children = columns;
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMNS, old, this.children);
    }

    public void addColumn(BaseColumn column) {
        this.children.add(column);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_COLUMNS, column, this.children.size() - 1);
    }

    public void addColumn(int index, BaseColumn column) {
        this.children.add(index, column);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_COLUMNS, column, index);
    }

    public boolean removeColumn(BaseColumn column) {
        int idx = this.children.indexOf(column);
        if (idx >= 0) {
            this.children.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_COLUMNS, column, idx);
        }
        return idx >= 0;
    }

    @Override
    public <R> R visitColumn(ColumnVisitor<R> visitor) {
        return visitor.visitColumnGroup(this);
    }

    @Override
    public Object clone() {
        StandardColumnGroup clone = (StandardColumnGroup)super.clone();
        clone.children = JRCloneUtils.cloneList(this.children);
        return clone;
    }
}

