/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.templates;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.wizards.CustomTemplateWizard;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;

/**
 *
 * @author gtoffoli
 */
public class TemplatesFrame extends javax.swing.JDialog {

    Rectangle minimizeBounds = null;
    boolean adjustingValueSlider = false;
    /** Creates new form TemplatesDialog */
    public TemplatesFrame(java.awt.Frame parent, boolean modal) {
        super(parent,modal);
        setTitle(I18n.getString("TemplatesFrame.title"));
        initComponents();
        
        jListTemplateItems.setModel(new DefaultListModel());
        jListTemplateItems.setCellRenderer(new TemplateItemActionCellRenderer());

        jSlider1.setMinimum(80);
        jSlider1.setMaximum(700);
        jSlider1.setValue(120);
        jSlider1.getModel().addChangeListener(new ChangeListener() {

            public void stateChanged(ChangeEvent e) {
                
            }
        });

        getContentPane().setBackground(Color.WHITE);
        this.pack();
        this.setMinimumSize(getSize());

        loadItems();

        if (jListTemplateItems.getModel().getSize() > 0)
        {
            jListTemplateItems.setSelectedIndex(0);
        }

        Dimension d = getSize();
        d.width = IReportManager.getPreferences().getInt("templates_window_width",d.width);
        d.height = IReportManager.getPreferences().getInt("templates_window_height",d.height);
        setSize(d);
        setLocationRelativeTo(null);

        addWindowListener(new WindowAdapter() {

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
            }
        });


    }

    private synchronized void loadItems() {

        ((DefaultListModel)jListTemplateItems.getModel()).removeAllElements();

        List<TemplateItemAction> actions = TemplateItemAction.getActions();
        for (TemplateItemAction a : actions)
        {
            ((DefaultListModel)jListTemplateItems.getModel()).addElement(a);
        }
    }

    private void storeWindowSize()
    {
        Dimension d = getSize();
        IReportManager.getPreferences().putInt("templates_window_width",d.width);
        IReportManager.getPreferences().putInt("templates_window_height",d.height);
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        templatesPanel1 = new com.jaspersoft.ireport.designer.templates.TemplatesPanel();
        jPanel1 = new javax.swing.JPanel();
        jLabelSize = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        jPanelSlider = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jSlider1 = new javax.swing.JSlider();
        jLabel2 = new javax.swing.JLabel();
        jButtonOpenTemplate = new javax.swing.JButton();
        jButtonLaunchWizard = new javax.swing.JButton();
        jButtonFinish = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();
        jLabelDescription = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jListTemplateItems = new javax.swing.JList();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(TemplatesFrame.class, "TemplatesFrame.title")); // NOI18N

        templatesPanel1.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                templatesPanel1ComponentResized(evt);
            }
        });

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jLabelSize.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/resources/maximize_win.png"))); // NOI18N
        jLabelSize.setText(org.openide.util.NbBundle.getMessage(TemplatesFrame.class, "TemplatesFrame.jLabelSize.text_1")); // NOI18N
        jLabelSize.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabelSizeMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanel1.add(jLabelSize, gridBagConstraints);

        jPanelSlider.setLayout(new java.awt.BorderLayout());

        jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/resources/template/small.png"))); // NOI18N
        jLabel3.setText(org.openide.util.NbBundle.getMessage(TemplatesFrame.class, "TemplatesFrame.jLabel3.text")); // NOI18N
        jLabel3.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel3MouseClicked(evt);
            }
        });
        jPanelSlider.add(jLabel3, java.awt.BorderLayout.WEST);

        jSlider1.setMaximum(1000);
        jSlider1.setMinimum(80);
        jSlider1.setFocusable(false);
        jSlider1.setMinimumSize(new java.awt.Dimension(120, 23));
        jSlider1.setPreferredSize(new java.awt.Dimension(150, 23));
        jSlider1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSlider1StateChanged(evt);
            }
        });
        jSlider1.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                jSlider1PropertyChange(evt);
            }
        });
        jPanelSlider.add(jSlider1, java.awt.BorderLayout.CENTER);

        jLabel2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/resources/template/big.png"))); // NOI18N
        jLabel2.setText(org.openide.util.NbBundle.getMessage(TemplatesFrame.class, "TemplatesFrame.jLabel2.text")); // NOI18N
        jLabel2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel2MouseClicked(evt);
            }
        });
        jPanelSlider.add(jLabel2, java.awt.BorderLayout.EAST);

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 150, Short.MAX_VALUE)
            .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(jPanel3Layout.createSequentialGroup()
                    .add(0, 0, Short.MAX_VALUE)
                    .add(jPanelSlider, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 150, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(0, 0, Short.MAX_VALUE)))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 23, Short.MAX_VALUE)
            .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(jPanel3Layout.createSequentialGroup()
                    .add(0, 0, Short.MAX_VALUE)
                    .add(jPanelSlider, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(0, 0, Short.MAX_VALUE)))
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jPanel3, gridBagConstraints);

        jButtonOpenTemplate.setText(org.openide.util.NbBundle.getMessage(TemplatesFrame.class, "TemplatesFrame.jButtonOpenTemplate.text")); // NOI18N
        jButtonOpenTemplate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOpenTemplateActionPerformed(evt);
            }
        });
        jPanel1.add(jButtonOpenTemplate, new java.awt.GridBagConstraints());

        jButtonLaunchWizard.setText(org.openide.util.NbBundle.getMessage(TemplatesFrame.class, "TemplatesFrame.jButtonLaunchWizard.text")); // NOI18N
        jButtonLaunchWizard.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonLaunchWizardActionPerformed(evt);
            }
        });
        jPanel1.add(jButtonLaunchWizard, new java.awt.GridBagConstraints());

        jButtonFinish.setText(org.openide.util.NbBundle.getMessage(TemplatesFrame.class, "TemplatesFrame.jButtonFinish.text")); // NOI18N
        jButtonFinish.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFinishActionPerformed(evt);
            }
        });
        jPanel1.add(jButtonFinish, new java.awt.GridBagConstraints());

        jButton1.setText(org.openide.util.NbBundle.getMessage(TemplatesFrame.class, "TemplatesFrame.jButton1.text")); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(jButton1, gridBagConstraints);

        jLabelDescription.setBackground(new java.awt.Color(255, 255, 255));
        jLabelDescription.setFont(new java.awt.Font("Tahoma", 0, 12));
        jLabelDescription.setText(org.openide.util.NbBundle.getMessage(TemplatesFrame.class, "TemplatesFrame.jLabelDescription.text")); // NOI18N
        jLabelDescription.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jLabelDescription.setOpaque(true);

        jScrollPane1.setBorder(null);
        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);

        jListTemplateItems.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jListTemplateItems.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListTemplateItemsValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(jListTemplateItems);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 726, Short.MAX_VALUE)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 240, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(templatesPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 470, Short.MAX_VALUE)
                    .add(jLabelDescription, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 470, Short.MAX_VALUE)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .add(jLabelDescription, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 45, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(templatesPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 430, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 470, Short.MAX_VALUE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 30, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonOpenTemplateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOpenTemplateActionPerformed
        
        TemplateItemAction action = (TemplateItemAction) jListTemplateItems.getSelectedValue();
        if (action != null)
        {
            action.performAction(this,TemplateItemAction.BUTTON_OPEN_TEMPLATE);
        }
}//GEN-LAST:event_jButtonOpenTemplateActionPerformed

    private void jButtonLaunchWizardActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonLaunchWizardActionPerformed
        TemplateItemAction action = (TemplateItemAction) jListTemplateItems.getSelectedValue();
        if (action != null)
        {
            action.performAction(this,TemplateItemAction.BUTTON_LAUNCH_REPORT_WIZARD);
        }
}//GEN-LAST:event_jButtonLaunchWizardActionPerformed

    private void jSlider1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSlider1StateChanged

            if (adjustingValueSlider || jSlider1.getValue() == templatesPanel1.getIconsSize()) return;
            templatesPanel1.setIconsSize( jSlider1.getValue());
                
        
    }//GEN-LAST:event_jSlider1StateChanged

    private void jButtonFinishActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFinishActionPerformed

        TemplateItemAction action = (TemplateItemAction) jListTemplateItems.getSelectedValue();
        if (action != null)
        {
            action.performAction(this,TemplateItemAction.BUTTON_FINISH);
        }


    }//GEN-LAST:event_jButtonFinishActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        setVisible(false);
        this.dispose();
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jLabel3MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel3MouseClicked
        jSlider1.setValue(jSlider1.getMinimum());

    }//GEN-LAST:event_jLabel3MouseClicked

    private void jLabel2MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel2MouseClicked
        //jSlider1.setValue(jSlider1.getMaximum());
        templatesPanel1.setFullPageView(true);

        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                adjustingValueSlider = true;
                jSlider1.setValue(templatesPanel1.getIconsSize());
                adjustingValueSlider = false;
            }
        });
        
    }//GEN-LAST:event_jLabel2MouseClicked


    private void jSlider1PropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_jSlider1PropertyChange

    }//GEN-LAST:event_jSlider1PropertyChange

    private void templatesPanel1ComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_templatesPanel1ComponentResized
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                adjustingValueSlider = true;
                jSlider1.setValue(templatesPanel1.getIconsSize());
                adjustingValueSlider = false;
            }
        });
    }//GEN-LAST:event_templatesPanel1ComponentResized

    private void jListTemplateItemsValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListTemplateItemsValueChanged
        updateSelection();
    }//GEN-LAST:event_jListTemplateItemsValueChanged

    private void jLabelSizeMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabelSizeMouseClicked

        int index = -1;
        if (templatesPanel1.isFullPageView()) {
            index = templatesPanel1.getList().getFirstVisibleIndex();
        }

        if (minimizeBounds == null) {
            minimizeBounds = new Rectangle(getBounds());

            // Use the parent size...
            setBounds(getParent().getBounds());
            jLabelSize.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/resources/minimize_window.png"))); // NOI18N
        } else {
            setBounds(minimizeBounds);
            minimizeBounds = null;
            jLabelSize.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/resources/maximize_win.png"))); // NOI18N
        }

        if (templatesPanel1.isFullPageView() && index >= 0) {
            templatesPanel1.getList().ensureIndexIsVisible(index);
        }

        jLabelSize.updateUI();
}//GEN-LAST:event_jLabelSizeMouseClicked

    /**
     * Just create a new file from the template selected.
     * If useWizard is true, the standard iReport wizard is launched.
     * The implementation put in the created wizardDescriptor the td.getFileObject()
     * in the propery reportTemplate.
     * which will be used by the wizard as template for the new report.
     * 
     * @param td
     * @param useWizard
     */
    public void runTemplateWizard(TemplateDescriptor td, boolean useWizard) {

        TemplateWizard wizardDescriptor = new CustomTemplateWizard();
        
        //wizardDescriptor.putProperty("useCustomChooserPanel", "true"); // NOI18N
        File targetFolder = Misc.findStartingDirectory();
        if (targetFolder == null || !targetFolder.exists())
        {
            System.out.println("Target folder: " + targetFolder);
            System.out.flush();
        }
        DataFolder df = DataFolder.findFolder(FileUtil.toFileObject(targetFolder));
        wizardDescriptor.setTargetFolder(df);
        wizardDescriptor.setTargetName("Report"); // NOI18N

        if (!useWizard)
        {
            wizardDescriptor.putProperty("noFields", "true");
        }

        wizardDescriptor.putProperty("reportTemplate", td.getFileObject());
        
        try {
           FileObject templateFileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("Templates/Report/Report");
           wizardDescriptor.setTemplate(DataObject.find(templateFileObject));
        } catch (DataObjectNotFoundException ex) {
        }


        wizardDescriptor.setTitle("New");
        setVisible(false);
        this.dispose();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();

    }
    
    public void runTemplateWizard(String targetName, String templateName) {

            TemplateWizard wizardDescriptor = new CustomTemplateWizard();
            wizardDescriptor.putProperty("WizardPanel_contentDisplayed", Boolean.FALSE);
                        // Turn on numbering of all steps
            wizardDescriptor.putProperty("WizardPanel_contentNumbered", Boolean.FALSE);



            //wizardDescriptor.putProperty("useCustomChooserPanel", "true"); // NOI18N
            File targetFolder = Misc.findStartingDirectory();
            DataFolder df = DataFolder.findFolder(FileUtil.toFileObject(targetFolder));
            wizardDescriptor.setTargetFolder(df);

            if (targetName != null)
            {
                wizardDescriptor.setTargetName(targetName); // NOI18N
            }

            if (templateName != null)
            {
                try {
                   FileObject templateFileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject(templateName);
                   wizardDescriptor.setTemplate(DataObject.find(templateFileObject));
                } catch (DataObjectNotFoundException ex) {
                }
            }

//            EmptyReportWizardIterator wIterator = new EmptyReportWizardIterator();
//            wIterator.initialize(wizardDescriptor);
//            wizardDescriptor.setPanelsAndSettings(wIterator, wizardDescriptor);

            // {0} will be replaced by WizardDesriptor.Panel.getComponent().getName()
//            wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));

            wizardDescriptor.setTitle("New");
            setVisible(false);
            this.dispose();
            Dialog dialog = DialogDisplayer.getDefault().createDialog(wizardDescriptor);
            dialog.setVisible(true);
            dialog.toFront();

    }




    public void updateSelection()
    {
            TemplateItemAction action = (TemplateItemAction) jListTemplateItems.getSelectedValue();
            if (action == null) return;
            templatesPanel1.setVisible(action.getProperty(TemplateItemAction.PROP_SHOW_TEMPLATES) == Boolean.TRUE);
            jLabelDescription.setText(action.getDescription() == null ? "" : action.getDescription());
            jButtonFinish.setVisible(action.getProperty(TemplateItemAction.PROP_SHOW_FINISH_BUTTON) == Boolean.TRUE);
            jButtonLaunchWizard.setVisible(action.getProperty(TemplateItemAction.PROP_SHOW_LAUNCH_REPORT_WIZARD_BUTTON) == Boolean.TRUE);
            jButtonOpenTemplate.setVisible(action.getProperty(TemplateItemAction.PROP_SHOW_OPEN_TEMPLATE_BUTTON) == Boolean.TRUE);
            jPanelSlider.setVisible(action.getProperty(TemplateItemAction.PROP_SHOW_TEMPLATES) == Boolean.TRUE);
    }
    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                TemplatesFrame dialog = new TemplatesFrame(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    /**
     * Return the selected template descriptor in the templates panel.
     * Return null is no template is selected
     * @return
     */
    public TemplateDescriptor getSelectedTemplateDescriptor()
    {
        return templatesPanel1.getSelectedTamplate();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButtonFinish;
    private javax.swing.JButton jButtonLaunchWizard;
    private javax.swing.JButton jButtonOpenTemplate;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabelDescription;
    private javax.swing.JLabel jLabelSize;
    private javax.swing.JList jListTemplateItems;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanelSlider;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSlider jSlider1;
    private com.jaspersoft.ireport.designer.templates.TemplatesPanel templatesPanel1;
    // End of variables declaration//GEN-END:variables


    public void setVisible(boolean b)
    {
        storeWindowSize();
        super.setVisible(b);
    }
    

}
