/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.hadoop.hive;

import com.jaspersoft.hadoop.hive.HiveConnection;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.design.JRDesignField;

public class HiveFieldsProvider {
    private static HiveFieldsProvider instance;
    private static final Lock lock;

    private HiveFieldsProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HiveFieldsProvider getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new HiveFieldsProvider();
            }
            HiveFieldsProvider hiveFieldsProvider = instance;
            return hiveFieldsProvider;
        }
        finally {
            lock.unlock();
        }
    }

    public JRField[] getFields(HiveConnection connection, JRDataset reportDataset, Map<String, JRValueParameter> parameters) throws JRException, UnsupportedOperationException {
        String query = "";
        Statement prepareStatement = null;
        if (reportDataset.getQuery() == null || reportDataset.getQuery().getText() == null || reportDataset.getQuery().getText().length() == 0) {
            return new JRField[0];
        }
        try {
            StringBuffer queryBuf = new StringBuffer("");
            JRQueryChunk[] chunks = reportDataset.getQuery().getChunks();
            ArrayList<Object> queryParams = new ArrayList<Object>();
            ArrayList queryParamsClass = new ArrayList();
            block22: for (int i = 0; i < chunks.length; ++i) {
                switch (chunks[i].getType()) {
                    case 1: {
                        queryBuf.append(chunks[i].getText());
                        continue block22;
                    }
                    case 3: {
                        String paramName = chunks[i].getText();
                        if (!parameters.containsKey(paramName)) {
                            throw new IllegalArgumentException("The parameter '" + paramName + "' is not defined.");
                        }
                        JRValueParameter defValue = parameters.get(paramName);
                        if (defValue == null) {
                            throw new IllegalArgumentException("Please set a default value for the parameter '" + paramName + "'");
                        }
                        queryBuf.append(defValue.toString());
                        continue block22;
                    }
                    case 2: {
                        String paramName = chunks[i].getText();
                        if (!parameters.containsKey(paramName)) {
                            throw new IllegalArgumentException("The parameter '" + paramName + "' is not defined.");
                        }
                        JRValueParameter defValue = parameters.get(paramName);
                        queryBuf.append("?");
                        queryParams.add(defValue);
                        queryParamsClass.add(this.findParameterClass(paramName, reportDataset));
                        continue block22;
                    }
                    case 4: {
                        String[] tokens = chunks[i].getTokens();
                        if (tokens.length == 3) {
                            String clauseText = "";
                            clauseText = tokens[1].trim() + " " + tokens[0].trim() + " (";
                            String paramName = tokens[2].trim();
                            if (parameters.containsKey(paramName)) {
                                JRValueParameter defValue = parameters.get(paramName);
                                if (defValue == null) {
                                    clauseText = "0 = 0";
                                } else {
                                    List<Object> items = new ArrayList<JRValueParameter>();
                                    if (defValue.getClass().isArray()) {
                                        items = Arrays.asList((Object[])defValue);
                                    } else if (defValue instanceof Collection) {
                                        items.addAll((Collection)defValue);
                                    } else {
                                        items.add(defValue);
                                    }
                                    Iterator<Object> iter = items.iterator();
                                    if (iter.hasNext()) {
                                        Object itemVal = iter.next();
                                        queryBuf.append("?");
                                        queryParams.add(itemVal);
                                        queryParamsClass.add(null);
                                        while (iter.hasNext()) {
                                            itemVal = iter.next();
                                            clauseText = clauseText + ",?";
                                            queryParams.add(itemVal);
                                            queryParamsClass.add(null);
                                        }
                                        clauseText = clauseText + ")";
                                    } else {
                                        clauseText = "0 = 0";
                                    }
                                }
                                queryBuf.append(clauseText);
                                continue block22;
                            }
                            throw new IllegalArgumentException("The parameter '" + paramName + "' is not defined.");
                        }
                        throw new IllegalArgumentException("Invalid $X{} clause");
                    }
                }
            }
            query = queryBuf.toString();
            prepareStatement = connection.getSqlConnection().prepareStatement(query);
            for (int pc = 0; pc < queryParams.size(); ++pc) {
                Class<?> parameterType;
                Class<?> clazz = parameterType = queryParams.get(pc) == null ? (Class<?>)queryParamsClass.get(pc) : queryParams.get(pc).getClass();
                if (Boolean.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        prepareStatement.setNull(pc + 1, -7);
                        continue;
                    }
                    prepareStatement.setBoolean(pc + 1, (Boolean)queryParams.get(pc));
                    continue;
                }
                if (Byte.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        prepareStatement.setNull(pc + 1, -6);
                        continue;
                    }
                    prepareStatement.setByte(pc + 1, (Byte)queryParams.get(pc));
                    continue;
                }
                if (Double.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        prepareStatement.setNull(pc + 1, 8);
                        continue;
                    }
                    prepareStatement.setDouble(pc + 1, (Double)queryParams.get(pc));
                    continue;
                }
                if (Float.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        prepareStatement.setNull(pc + 1, 6);
                        continue;
                    }
                    prepareStatement.setFloat(pc + 1, ((Float)queryParams.get(pc)).floatValue());
                    continue;
                }
                if (Integer.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        prepareStatement.setNull(pc + 1, 4);
                        continue;
                    }
                    prepareStatement.setInt(pc + 1, (Integer)queryParams.get(pc));
                    continue;
                }
                if (Long.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        prepareStatement.setNull(pc + 1, -5);
                        continue;
                    }
                    prepareStatement.setLong(pc + 1, (Long)queryParams.get(pc));
                    continue;
                }
                if (Short.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        prepareStatement.setNull(pc + 1, 5);
                        continue;
                    }
                    prepareStatement.setShort(pc + 1, (Short)queryParams.get(pc));
                    continue;
                }
                if (BigDecimal.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        prepareStatement.setNull(pc + 1, 3);
                        continue;
                    }
                    prepareStatement.setBigDecimal(pc + 1, (BigDecimal)queryParams.get(pc));
                    continue;
                }
                if (String.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        prepareStatement.setNull(pc + 1, 12);
                        continue;
                    }
                    prepareStatement.setString(pc + 1, queryParams.get(pc).toString());
                    continue;
                }
                if (Timestamp.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        prepareStatement.setNull(pc + 1, 93);
                        continue;
                    }
                    prepareStatement.setTimestamp(pc + 1, (Timestamp)queryParams.get(pc));
                    continue;
                }
                if (Time.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        prepareStatement.setNull(pc + 1, 92);
                        continue;
                    }
                    prepareStatement.setTime(pc + 1, (Time)queryParams.get(pc));
                    continue;
                }
                if (java.util.Date.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        prepareStatement.setNull(pc + 1, 91);
                        continue;
                    }
                    prepareStatement.setDate(pc + 1, new Date(((java.util.Date)queryParams.get(pc)).getTime()));
                    continue;
                }
                if (queryParams.get(pc) == null) {
                    prepareStatement.setNull(pc + 1, 2000);
                    continue;
                }
                prepareStatement.setObject(pc + 1, queryParams.get(pc));
            }
            try {
                prepareStatement.setFetchSize(0);
            }
            catch (Exception e) {
                // empty catch block
            }
            ResultSet rs = prepareStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            ArrayList<JRDesignField> columns = new ArrayList<JRDesignField>();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                JRDesignField field = new JRDesignField();
                field.setName(resultSetMetaData.getColumnLabel(i));
                field.setValueClassName(HiveConnection.getJdbcTypeClass(resultSetMetaData, i));
                field.setDescription(null);
                columns.add(field);
            }
            JRField[] finalFields = new JRField[columns.size()];
            for (int i = 0; i < finalFields.length; ++i) {
                finalFields[i] = (JRField)columns.get(i);
            }
            JRField[] jRFieldArray = finalFields;
            return jRFieldArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JRException(ex.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new JRException(t.getMessage());
        }
        finally {
            if (prepareStatement != null) {
                try {
                    prepareStatement.close();
                }
                catch (Exception e) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private Class<?> findParameterClass(String parameterName, JRDataset reportDataset) {
        JRParameter[] parameters;
        for (JRParameter parameter : parameters = reportDataset.getParameters()) {
            if (!parameter.getName().equals(parameterName)) continue;
            try {
                return parameter.getValueClass();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        lock = new ReentrantLock();
    }
}

