/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.util.StringUtils;

public class StatsTask
extends Task<StatsWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Table table;
    private List<LinkedHashMap<String, String>> dpPartSpecs = null;

    @Override
    protected void receiveFeed(Task.FeedType feedType, Object feedValue) {
        if (feedType == Task.FeedType.DYNAMIC_PARTITIONS) {
            assert (feedValue instanceof List);
            this.dpPartSpecs = (List)feedValue;
        }
    }

    @Override
    public int execute(DriverContext driverContext) {
        assert (((StatsWork)this.work).getLoadTableDesc() != null && ((StatsWork)this.work).getTableSpecs() == null || ((StatsWork)this.work).getLoadTableDesc() == null && ((StatsWork)this.work).getTableSpecs() != null);
        String tableName = "";
        try {
            tableName = ((StatsWork)this.work).getLoadTableDesc() != null ? ((StatsWork)this.work).getLoadTableDesc().getTable().getTableName() : ((StatsWork)this.work).getTableSpecs().tableName;
            this.table = this.db.getTable(tableName);
        }
        catch (HiveException e) {
            this.LOG.error((Object)("Cannot get table " + tableName), (Throwable)e);
            this.console.printError("Cannot get table " + tableName, e.toString());
        }
        return this.aggregateStats();
    }

    @Override
    public StageType getType() {
        return StageType.STATS;
    }

    @Override
    public String getName() {
        return "STATS";
    }

    @Override
    protected void localizeMRTmpFilesImpl(Context ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int aggregateStats() {
        String statsImplementationClass = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVESTATSDBCLASS);
        StatsFactory.setImplementation(statsImplementationClass, this.conf);
        StatsAggregator statsAggregator = StatsFactory.getStatsAggregator();
        try {
            List<Partition> partitions;
            Warehouse wh = new Warehouse((Configuration)this.conf);
            if (!statsAggregator.connect(this.conf)) {
                throw new HiveException("StatsAggregator connect failed " + statsImplementationClass);
            }
            TableStatistics tblStats = new TableStatistics();
            if (this.table.isPartitioned()) {
                org.apache.hadoop.hive.metastore.api.Table tTable = this.table.getTTable();
                Map parameters = tTable.getParameters();
                if (parameters.containsKey("numRows")) {
                    tblStats.setNumRows(Long.parseLong((String)parameters.get("numRows")));
                }
                if (parameters.containsKey("numPartitions")) {
                    tblStats.setNumPartitions(Integer.parseInt((String)parameters.get("numPartitions")));
                }
                if (parameters.containsKey("numFiles")) {
                    tblStats.setNumFiles(Integer.parseInt((String)parameters.get("numFiles")));
                }
                if (parameters.containsKey("totalSize")) {
                    tblStats.setSize(Long.parseLong((String)parameters.get("totalSize")));
                }
            }
            if ((partitions = this.getPartitionsList()) == null) {
                Path tablePath = wh.getDefaultTablePath(this.table.getDbName(), this.table.getTableName());
                FileSystem fileSys = tablePath.getFileSystem((Configuration)this.conf);
                FileStatus[] fileStatus = Utilities.getFileStatusRecurse(tablePath, 1, fileSys);
                tblStats.setNumFiles(fileStatus.length);
                long tableSize = 0L;
                for (int i = 0; i < fileStatus.length; ++i) {
                    tableSize += fileStatus[i].getLen();
                }
                tblStats.setSize(tableSize);
                String rows = statsAggregator.aggregateStats(((StatsWork)this.work).getAggKey(), "numRows");
                if (rows != null) {
                    tblStats.setNumRows(Long.parseLong(rows));
                } else if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_STATS_ATOMIC)) {
                    throw new HiveException("StatsAggregator failed to get numRows.");
                }
            } else {
                for (Partition partn : partitions) {
                    long sz;
                    PartitionStatistics newPartStats = new PartitionStatistics();
                    String partitionID = ((StatsWork)this.work).getAggKey() + Warehouse.makePartPath(partn.getSpec());
                    String rows = statsAggregator.aggregateStats(partitionID, "numRows");
                    if (rows != null) {
                        newPartStats.setNumRows(Long.parseLong(rows));
                    } else if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_STATS_ATOMIC)) {
                        throw new HiveException("StatsAggregator failed to get numRows.");
                    }
                    FileSystem fileSys = partn.getPartitionPath().getFileSystem((Configuration)this.conf);
                    FileStatus[] fileStatus = Utilities.getFileStatusRecurse(partn.getPartitionPath(), 1, fileSys);
                    newPartStats.setNumFiles(fileStatus.length);
                    long partitionSize = 0L;
                    for (int i = 0; i < fileStatus.length; ++i) {
                        partitionSize += fileStatus[i].getLen();
                    }
                    newPartStats.setSize(partitionSize);
                    org.apache.hadoop.hive.metastore.api.Partition tPart = partn.getTPartition();
                    Map parameters = tPart.getParameters();
                    boolean hasStats = parameters.containsKey("numFiles") || parameters.containsKey("numRows") || parameters.containsKey("totalSize");
                    int nf = parameters.containsKey("numFiles") ? Integer.parseInt((String)parameters.get("numFiles")) : 0;
                    long nr = parameters.containsKey("numRows") ? Long.parseLong((String)parameters.get("numRows")) : 0L;
                    long l = sz = parameters.containsKey("totalSize") ? Long.parseLong((String)parameters.get("totalSize")) : 0L;
                    if (hasStats) {
                        PartitionStatistics oldPartStats = new PartitionStatistics(nf, nr, sz);
                        tblStats.updateStats(oldPartStats, newPartStats);
                    } else {
                        tblStats.addPartitionStats(newPartStats);
                    }
                    parameters.put("numRows", Long.toString(newPartStats.getNumRows()));
                    parameters.put("numFiles", Integer.toString(newPartStats.getNumFiles()));
                    parameters.put("totalSize", Long.toString(newPartStats.getSize()));
                    tPart.setParameters(parameters);
                    String tableFullName = this.table.getDbName() + "." + this.table.getTableName();
                    this.db.alterPartition(tableFullName, new Partition(this.table, tPart));
                    this.console.printInfo("Partition " + tableFullName + partn.getSpec() + " stats: [" + newPartStats.toString() + ']');
                }
            }
            org.apache.hadoop.hive.metastore.api.Table tTable = this.table.getTTable();
            Map parameters = tTable.getParameters();
            parameters.put("numRows", Long.toString(tblStats.getNumRows()));
            parameters.put("numPartitions", Integer.toString(tblStats.getNumPartitions()));
            parameters.put("numFiles", Integer.toString(tblStats.getNumFiles()));
            parameters.put("totalSize", Long.toString(tblStats.getSize()));
            tTable.setParameters(parameters);
            String tableFullName = this.table.getDbName() + "." + this.table.getTableName();
            this.db.alterTable(tableFullName, new Table(tTable));
            this.console.printInfo("Table " + tableFullName + " stats: [" + tblStats.toString() + ']');
        }
        catch (Exception e) {
            this.console.printInfo("[Warning] could not update stats.", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
        }
        finally {
            statsAggregator.closeConnection();
        }
        return 0;
    }

    private List<Partition> getPartitionsList() throws HiveException {
        ArrayList<Partition> list = new ArrayList<Partition>();
        if (((StatsWork)this.work).getTableSpecs() != null) {
            BaseSemanticAnalyzer.tableSpec tblSpec = ((StatsWork)this.work).getTableSpecs();
            this.table = tblSpec.tableHandle;
            if (!this.table.isPartitioned()) {
                return null;
            }
            List<Partition> partitions = tblSpec.partitions;
            if (partitions != null) {
                for (Partition partn : partitions) {
                    list.add(partn);
                }
            }
        } else if (((StatsWork)this.work).getLoadTableDesc() != null) {
            LoadTableDesc tbd = ((StatsWork)this.work).getLoadTableDesc();
            this.table = this.db.getTable(tbd.getTable().getTableName());
            if (!this.table.isPartitioned()) {
                return null;
            }
            DynamicPartitionCtx dpCtx = tbd.getDPCtx();
            if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
                for (LinkedHashMap<String, String> partSpec : this.dpPartSpecs) {
                    Partition partn = this.db.getPartition(this.table, partSpec, false);
                    list.add(partn);
                }
            } else {
                Partition partn = this.db.getPartition(this.table, tbd.getPartitionSpec(), false);
                list.add(partn);
            }
        }
        return list;
    }

    public static void cleanUp(String jobID, Configuration config) {
        String statsImplementationClass = HiveConf.getVar(config, HiveConf.ConfVars.HIVESTATSDBCLASS);
        StatsFactory.setImplementation(statsImplementationClass, config);
        StatsAggregator statsAggregator = StatsFactory.getStatsAggregator();
        if (statsAggregator.connect(config)) {
            statsAggregator.cleanUp(jobID + "/");
        }
    }

    class TableStatistics
    extends PartitionStatistics {
        int numPartitions;

        public TableStatistics() {
            this.numPartitions = 0;
        }

        public void setNumPartitions(int np) {
            this.numPartitions = np;
        }

        public int getNumPartitions() {
            return this.numPartitions;
        }

        public void updateStats(PartitionStatistics oldStats, PartitionStatistics newStats) {
            this.deletePartitionStats(oldStats);
            this.addPartitionStats(newStats);
        }

        public void addPartitionStats(PartitionStatistics newStats) {
            this.numFiles += newStats.getNumFiles();
            this.numRows += newStats.getNumRows();
            this.size += newStats.getSize();
            ++this.numPartitions;
        }

        public void deletePartitionStats(PartitionStatistics oldStats) {
            this.numFiles -= oldStats.getNumFiles();
            this.numRows -= oldStats.getNumRows();
            this.size -= oldStats.getSize();
            --this.numPartitions;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("num_partitions: ").append(this.numPartitions).append(", ");
            sb.append(super.toString());
            return sb.toString();
        }
    }

    class PartitionStatistics {
        int numFiles;
        long numRows;
        long size;

        public PartitionStatistics() {
            this.numFiles = 0;
            this.numRows = 0L;
            this.size = 0L;
        }

        public PartitionStatistics(int nf, long nr, long sz) {
            this.numFiles = nf;
            this.numRows = nr;
            this.size = sz;
        }

        public int getNumFiles() {
            return this.numFiles;
        }

        public long getNumRows() {
            return this.numRows;
        }

        public long getSize() {
            return this.size;
        }

        public void setNumFiles(int nf) {
            this.numFiles = nf;
        }

        public void setNumRows(long nr) {
            this.numRows = nr;
        }

        public void setSize(long sz) {
            this.size = sz;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("num_files: ").append(this.numFiles).append(", ");
            sb.append("num_rows: ").append(this.numRows).append(", ");
            sb.append("total_size: ").append(this.size);
            return sb.toString();
        }
    }
}

